/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.imprt.svc;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.importpull.models.Batch2BulkImportPullJobParameters;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.bulk.imprt.api.IBulkDataImportSvc;
import ca.uhn.fhir.jpa.bulk.imprt.model.ActivateJobResult;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobFileJson;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobJson;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobStatusEnum;
import ca.uhn.fhir.jpa.dao.data.IBulkImportJobDao;
import ca.uhn.fhir.jpa.dao.data.IBulkImportJobFileDao;
import ca.uhn.fhir.jpa.entity.BulkImportJobEntity;
import ca.uhn.fhir.jpa.entity.BulkImportJobFileEntity;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.ValidateUtil;
import com.apicatalog.jsonld.StringUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

public class BulkDataImportSvcImpl
implements IBulkDataImportSvc,
IHasScheduledJobs {
    private static final Logger ourLog = LoggerFactory.getLogger(BulkDataImportSvcImpl.class);
    private final Semaphore myRunningJobSemaphore = new Semaphore(1);
    @Autowired
    private IBulkImportJobDao myJobDao;
    @Autowired
    private IBulkImportJobFileDao myJobFileDao;
    @Autowired
    private PlatformTransactionManager myTxManager;
    private TransactionTemplate myTxTemplate;
    @Autowired
    private IJobCoordinator myJobCoordinator;
    @Autowired
    private JpaStorageSettings myStorageSettings;

    @PostConstruct
    public void start() {
        this.myTxTemplate = new TransactionTemplate(this.myTxManager);
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(ActivationJob.class.getName());
        jobDetail.setJobClass(ActivationJob.class);
        theSchedulerService.scheduleLocalJob(10000L, jobDetail);
    }

    @Transactional
    public String createNewJob(BulkImportJobJson theJobDescription, @Nonnull List<BulkImportJobFileJson> theInitialFiles) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theJobDescription, (String)"Job must not be null", (Object[])new Object[0]);
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theJobDescription.getProcessingMode(), (String)"Job File Processing mode must not be null", (Object[])new Object[0]);
        ValidateUtil.isTrueOrThrowInvalidRequest((theJobDescription.getBatchSize() > 0 ? 1 : 0) != 0, (String)"Job File Batch Size must be > 0", (Object[])new Object[0]);
        String biJobId = UUID.randomUUID().toString();
        ourLog.info("Creating new Bulk Import job with {} files, assigning bijob ID: {}", (Object)theInitialFiles.size(), (Object)biJobId);
        BulkImportJobEntity job = new BulkImportJobEntity();
        job.setJobId(biJobId);
        job.setFileCount(theInitialFiles.size());
        job.setStatus(BulkImportJobStatusEnum.STAGING);
        job.setJobDescription(theJobDescription.getJobDescription());
        job.setBatchSize(theJobDescription.getBatchSize());
        job.setRowProcessingMode(theJobDescription.getProcessingMode());
        job = (BulkImportJobEntity)this.myJobDao.save(job);
        int nextSequence = 0;
        this.addFilesToJob(theInitialFiles, job, nextSequence);
        return biJobId;
    }

    @Transactional
    public void addFilesToJob(String theBiJobId, List<BulkImportJobFileJson> theFiles) {
        ourLog.info("Adding {} files to bulk import job with bijob id {}", (Object)theFiles.size(), (Object)theBiJobId);
        BulkImportJobEntity job = this.findJobByBiJobId(theBiJobId);
        ValidateUtil.isTrueOrThrowInvalidRequest((job.getStatus() == BulkImportJobStatusEnum.STAGING ? 1 : 0) != 0, (String)"bijob id %s has status %s and can not be added to", (Object[])new Object[]{theBiJobId, job.getStatus()});
        this.addFilesToJob(theFiles, job, job.getFileCount());
        job.setFileCount(job.getFileCount() + theFiles.size());
        this.myJobDao.save(job);
    }

    private BulkImportJobEntity findJobByBiJobId(String theBiJobId) {
        BulkImportJobEntity job = this.myJobDao.findByJobId(theBiJobId).orElseThrow(() -> new InvalidRequestException("Unknown bijob id: " + theBiJobId));
        return job;
    }

    @Transactional
    public void markJobAsReadyForActivation(String theBiJobId) {
        ourLog.info("Activating bulk import bijob {}", (Object)theBiJobId);
        BulkImportJobEntity job = this.findJobByBiJobId(theBiJobId);
        ValidateUtil.isTrueOrThrowInvalidRequest((job.getStatus() == BulkImportJobStatusEnum.STAGING ? 1 : 0) != 0, (String)"Bulk import bijob %s can not be activated in status: %s", (Object[])new Object[]{theBiJobId, job.getStatus()});
        job.setStatus(BulkImportJobStatusEnum.READY);
        this.myJobDao.save(job);
    }

    @Transactional(propagation=Propagation.NEVER)
    public ActivateJobResult activateNextReadyJob() {
        if (!this.myStorageSettings.isEnableTaskBulkImportJobExecution()) {
            Logs.getBatchTroubleshootingLog().trace("Bulk import job execution is not enabled on this server. No action taken.");
            return new ActivateJobResult(false, null);
        }
        if (!this.myRunningJobSemaphore.tryAcquire()) {
            Logs.getBatchTroubleshootingLog().trace("Already have a running batch job, not going to check for more");
            return new ActivateJobResult(false, null);
        }
        try {
            ActivateJobResult retval = this.doActivateNextReadyJob();
            if (!StringUtils.isBlank((String)retval.jobId)) {
                ourLog.info("Batch job submitted with batch job id {}", (Object)retval.jobId);
            }
            ActivateJobResult activateJobResult = retval;
            return activateJobResult;
        }
        finally {
            this.myRunningJobSemaphore.release();
        }
    }

    private ActivateJobResult doActivateNextReadyJob() {
        Optional jobToProcessOpt = Objects.requireNonNull((Optional)this.myTxTemplate.execute(t -> {
            PageRequest page = PageRequest.of((int)0, (int)1);
            Slice<BulkImportJobEntity> submittedJobs = this.myJobDao.findByStatus((Pageable)page, BulkImportJobStatusEnum.READY);
            if (submittedJobs.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((BulkImportJobEntity)submittedJobs.getContent().get(0));
        }));
        if (!jobToProcessOpt.isPresent()) {
            return new ActivateJobResult(false, null);
        }
        BulkImportJobEntity bulkImportJobEntity = (BulkImportJobEntity)jobToProcessOpt.get();
        String jobUuid = bulkImportJobEntity.getJobId();
        String biJobId = null;
        try {
            biJobId = this.processJob(bulkImportJobEntity);
        }
        catch (Exception e) {
            ourLog.error("Failure while preparing bulk export extract", (Throwable)e);
            this.myTxTemplate.execute(t -> {
                Optional<BulkImportJobEntity> submittedJobs = this.myJobDao.findByJobId(jobUuid);
                if (submittedJobs.isPresent()) {
                    BulkImportJobEntity jobEntity = submittedJobs.get();
                    jobEntity.setStatus(BulkImportJobStatusEnum.ERROR);
                    jobEntity.setStatusMessage(e.getMessage());
                    this.myJobDao.save(jobEntity);
                }
                return new ActivateJobResult(false, null);
            });
        }
        return new ActivateJobResult(true, biJobId);
    }

    @Transactional
    public void setJobToStatus(String theBiJobId, BulkImportJobStatusEnum theStatus) {
        this.setJobToStatus(theBiJobId, theStatus, null);
    }

    public void setJobToStatus(String theBiJobId, BulkImportJobStatusEnum theStatus, String theStatusMessage) {
        BulkImportJobEntity job = this.findJobByBiJobId(theBiJobId);
        job.setStatus(theStatus);
        job.setStatusMessage(theStatusMessage);
        this.myJobDao.save(job);
    }

    @Transactional
    public BulkImportJobJson fetchJob(String theBiJobId) {
        BulkImportJobEntity job = this.findJobByBiJobId(theBiJobId);
        return job.toJson();
    }

    public IBulkDataImportSvc.JobInfo getJobStatus(String theBiJobId) {
        BulkImportJobEntity theJob = this.findJobByBiJobId(theBiJobId);
        return new IBulkDataImportSvc.JobInfo().setStatus(theJob.getStatus()).setStatusMessage(theJob.getStatusMessage()).setStatusTime(theJob.getStatusTime());
    }

    @Transactional
    public BulkImportJobFileJson fetchFile(String theBiJobId, int theFileIndex) {
        BulkImportJobEntity job = this.findJobByBiJobId(theBiJobId);
        return this.myJobFileDao.findForJob(job, theFileIndex).map(t -> t.toJson()).orElseThrow(() -> new IllegalArgumentException("Invalid index " + theFileIndex + " for bijob " + theBiJobId));
    }

    @Transactional
    public String getFileDescription(String theBiJobId, int theFileIndex) {
        BulkImportJobEntity job = this.findJobByBiJobId(theBiJobId);
        return this.myJobFileDao.findFileDescriptionForJob(job, theFileIndex).orElse("");
    }

    @Transactional
    public void deleteJobFiles(String theBiJobId) {
        BulkImportJobEntity job = this.findJobByBiJobId(theBiJobId);
        List<Long> files = this.myJobFileDao.findAllIdsForJob(theBiJobId);
        for (Long next : files) {
            this.myJobFileDao.deleteById(next);
        }
        this.myJobDao.delete(job);
    }

    private String processJob(BulkImportJobEntity theBulkExportJobEntity) {
        String biJobId = theBulkExportJobEntity.getJobId();
        int batchSize = theBulkExportJobEntity.getBatchSize();
        Batch2BulkImportPullJobParameters jobParameters = new Batch2BulkImportPullJobParameters();
        jobParameters.setJobId(biJobId);
        jobParameters.setBatchSize((long)batchSize);
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setJobDefinitionId("bulkImportJob");
        request.setParameters((IModelJson)jobParameters);
        ourLog.info("Submitting bulk import with bijob id {} to job scheduler", (Object)biJobId);
        return this.myJobCoordinator.startInstance(request).getInstanceId();
    }

    private void addFilesToJob(@Nonnull List<BulkImportJobFileJson> theInitialFiles, BulkImportJobEntity job, int nextSequence) {
        for (BulkImportJobFileJson nextFile : theInitialFiles) {
            ValidateUtil.isNotBlankOrThrowUnprocessableEntity((String)nextFile.getContents(), (String)"Job File Contents mode must not be null");
            BulkImportJobFileEntity jobFile = new BulkImportJobFileEntity();
            jobFile.setJob(job);
            jobFile.setContents(nextFile.getContents());
            jobFile.setTenantName(nextFile.getTenantName());
            jobFile.setFileDescription(nextFile.getDescription());
            jobFile.setFileSequence(nextSequence++);
            this.myJobFileDao.save(jobFile);
        }
    }

    public static class ActivationJob
    implements HapiJob {
        @Autowired
        private IBulkDataImportSvc myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.activateNextReadyJob();
        }
    }
}

