/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.cache;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.cache.IResourceVersionSvc;
import ca.uhn.fhir.jpa.cache.ResourcePersistentIdMap;
import ca.uhn.fhir.jpa.cache.ResourceVersionMap;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceVersionSvcDaoImpl
implements IResourceVersionSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceVersionSvcDaoImpl.class);
    @Autowired
    DaoRegistry myDaoRegistry;
    @Autowired
    IResourceTableDao myResourceTableDao;
    @Autowired
    IIdHelperService<JpaPid> myIdHelperService;

    @Nonnull
    public ResourceVersionMap getVersionMap(RequestPartitionId theRequestPartitionId, String theResourceName, SearchParameterMap theSearchParamMap) {
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("About to retrieve version map for resource type: {}", (Object)theResourceName);
        }
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceName);
        SystemRequestDetails request = new SystemRequestDetails().setRequestPartitionId(theRequestPartitionId);
        List fhirIds = dao.searchForResourceIds(theSearchParamMap, (RequestDetails)request);
        return ResourceVersionMap.fromIdsWithVersions((List)fhirIds);
    }

    public ResourcePersistentIdMap getLatestVersionIdsForResourceIds(RequestPartitionId theRequestPartitionId, List<IIdType> theIds) {
        ResourcePersistentIdMap idToPID = new ResourcePersistentIdMap();
        HashMap resourceTypeToIds = new HashMap();
        for (IIdType id : theIds) {
            String resourceType = id.getResourceType();
            if (!resourceTypeToIds.containsKey(resourceType)) {
                resourceTypeToIds.put(resourceType, new ArrayList());
            }
            ((List)resourceTypeToIds.get(resourceType)).add(id);
        }
        for (List nextIds : resourceTypeToIds.values()) {
            ResourcePersistentIdMap idAndPID = this.getIdsOfExistingResources(theRequestPartitionId, nextIds);
            idToPID.putAll(idAndPID);
        }
        return idToPID;
    }

    private ResourcePersistentIdMap getIdsOfExistingResources(RequestPartitionId thePartitionId, Collection<IIdType> theIds) {
        ResourcePersistentIdMap retval = new ResourcePersistentIdMap();
        if (theIds == null || theIds.isEmpty()) {
            return retval;
        }
        List jpaPids = this.myIdHelperService.resolveResourcePersistentIdsWithCache(thePartitionId, new ArrayList<IIdType>(theIds));
        HashMap<Long, JpaPid> pidsToVersionToResourcePid = new HashMap<Long, JpaPid>();
        for (JpaPid pid : jpaPids) {
            if (pid.getVersion() == null) {
                pidsToVersionToResourcePid.put(pid.getId(), pid);
            }
            Optional<IIdType> idOp = theIds.stream().filter(i -> i.getIdPart().equals(pid.getAssociatedResourceId().getIdPart())).findFirst();
            idOp.ifPresent(id -> retval.put(id, (IResourcePersistentId)pid));
        }
        if (!pidsToVersionToResourcePid.isEmpty()) {
            Collection<Object[]> resourceEntries = this.myResourceTableDao.getResourceVersionsForPid(new ArrayList<Long>(pidsToVersionToResourcePid.keySet()));
            for (Object[] nextRecord : resourceEntries) {
                Long retPid = (Long)nextRecord[0];
                String resType = (String)nextRecord[1];
                Long version = (Long)nextRecord[2];
                ((JpaPid)pidsToVersionToResourcePid.get(retPid)).setVersion(version);
            }
        }
        return retval;
    }
}

