/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.config.HapiFhirHibernateJpaDialect;
import ca.uhn.fhir.jpa.config.HapiFhirLocalContainerEntityManagerFactoryBean;
import ca.uhn.fhir.jpa.util.ISequenceValueMassager;
import ca.uhn.fhir.util.ReflectionUtil;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.Map;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.service.Service;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public final class HapiEntityManagerFactoryUtil {
    private HapiEntityManagerFactoryUtil() {
    }

    public static LocalContainerEntityManagerFactoryBean newEntityManagerFactory(ConfigurableListableBeanFactory myConfigurableListableBeanFactory, FhirContext theFhirContext, JpaStorageSettings theStorageSettings) {
        HapiFhirLocalContainerEntityManagerFactoryBean retVal = new HapiFhirLocalContainerEntityManagerFactoryBean(myConfigurableListableBeanFactory);
        HapiEntityManagerFactoryUtil.configureEntityManagerFactory((LocalContainerEntityManagerFactoryBean)retVal, theFhirContext, theStorageSettings);
        return retVal;
    }

    public static void configureEntityManagerFactory(LocalContainerEntityManagerFactoryBean theFactory, FhirContext theFhirContext, JpaStorageSettings theStorageSettings) {
        theFactory.setJpaDialect((JpaDialect)new HapiFhirHibernateJpaDialect(theFhirContext.getLocalizer()));
        theFactory.setPackagesToScan(new String[]{"ca.uhn.fhir.jpa.model.entity", "ca.uhn.fhir.jpa.entity"});
        theFactory.setPersistenceProvider((PersistenceProvider)new MyHibernatePersistenceProvider(theStorageSettings));
    }

    private static class MyHibernatePersistenceProvider
    extends HibernatePersistenceProvider {
        private final JpaStorageSettings myStorageSettings;

        public MyHibernatePersistenceProvider(JpaStorageSettings theStorageSettings) {
            this.myStorageSettings = theStorageSettings;
        }

        protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitInfo info, Map<?, ?> integration) {
            return new MyEntityManagerFactoryBuilderImpl(info, integration);
        }

        private class MyEntityManagerFactoryBuilderImpl
        extends EntityManagerFactoryBuilderImpl {
            public MyEntityManagerFactoryBuilderImpl(PersistenceUnitInfo theInfo, Map<?, ?> theIntegration) {
                super((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor(theInfo), theIntegration);
            }

            protected StandardServiceRegistryBuilder getStandardServiceRegistryBuilder(BootstrapServiceRegistry bsr) {
                StandardServiceRegistryBuilder retVal = super.getStandardServiceRegistryBuilder(bsr);
                ISequenceValueMassager sequenceValueMassager = (ISequenceValueMassager)ReflectionUtil.newInstance((Class)MyHibernatePersistenceProvider.this.myStorageSettings.getSequenceValueMassagerClass());
                retVal.addService(ISequenceValueMassager.class, (Service)sequenceValueMassager);
                return retVal;
            }
        }
    }
}

