/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildResourceDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IJpaDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.api.svc.ISearchCoordinatorSvc;
import ca.uhn.fhir.jpa.dao.BaseStorageResourceDao;
import ca.uhn.fhir.jpa.dao.CodingSpy;
import ca.uhn.fhir.jpa.dao.EncodedResource;
import ca.uhn.fhir.jpa.dao.GZipUtil;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IJpaStorageResourceParser;
import ca.uhn.fhir.jpa.dao.ResourceHistoryCalculator;
import ca.uhn.fhir.jpa.dao.ResourceHistoryState;
import ca.uhn.fhir.jpa.dao.data.IResourceHistoryTableDao;
import ca.uhn.fhir.jpa.dao.data.IResourceLinkDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.dao.expunge.ExpungeService;
import ca.uhn.fhir.jpa.dao.index.DaoSearchParamSynchronizer;
import ca.uhn.fhir.jpa.dao.index.SearchParamWithInlineReferencesExtractor;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.delete.DeleteConflictService;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.esr.ExternallyStoredResourceAddress;
import ca.uhn.fhir.jpa.esr.ExternallyStoredResourceAddressMetadataKey;
import ca.uhn.fhir.jpa.esr.ExternallyStoredResourceServiceRegistry;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.model.search.ExtendedHSearchIndexData;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.partition.IPartitionLookupSvc;
import ca.uhn.fhir.jpa.searchparam.extractor.LogicalReferenceHelper;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.jpa.sp.ISearchParamPresenceSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.util.AddRemoveCount;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.MetaUtil;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.XmlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Repository
public abstract class BaseHapiFhirDao<T extends IBaseResource>
extends BaseStorageResourceDao<T>
implements IDao,
IJpaDao<T>,
ApplicationContextAware {
    public static final long INDEX_STATUS_INDEXED = 1L;
    public static final long INDEX_STATUS_INDEXING_FAILED = 2L;
    public static final String NS_JPA_PROFILE = "https://github.com/hapifhir/hapi-fhir/ns/jpa/profile";
    private static final int TOTAL_TAG_READ_ATTEMPTS = 10;
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiFhirDao.class);
    private static boolean ourValidationDisabledForUnitTest;
    private static boolean ourDisableIncrementOnUpdateForUnitTest;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    protected IIdHelperService<JpaPid> myIdHelperService;
    @Autowired
    protected ISearchCoordinatorSvc<JpaPid> mySearchCoordinatorSvc;
    @Autowired
    protected ITermReadSvc myTerminologySvc;
    @Autowired
    protected IResourceHistoryTableDao myResourceHistoryTableDao;
    @Autowired
    protected IResourceTableDao myResourceTableDao;
    @Autowired
    protected IResourceLinkDao myResourceLinkDao;
    @Autowired
    protected IResourceTagDao myResourceTagDao;
    @Autowired
    protected DeleteConflictService myDeleteConflictService;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected InMemoryResourceMatcher myInMemoryResourceMatcher;
    @Autowired
    protected IJpaStorageResourceParser myJpaStorageResourceParser;
    @Autowired
    protected PartitionSettings myPartitionSettings;
    @Autowired
    ExpungeService myExpungeService;
    @Autowired
    private ExternallyStoredResourceServiceRegistry myExternallyStoredResourceServiceRegistry;
    @Autowired
    private ISearchParamPresenceSvc mySearchParamPresenceSvc;
    @Autowired
    private SearchParamWithInlineReferencesExtractor mySearchParamWithInlineReferencesExtractor;
    @Autowired
    private DaoSearchParamSynchronizer myDaoSearchParamSynchronizer;
    private FhirContext myContext;
    private ApplicationContext myApplicationContext;
    @Autowired
    private IPartitionLookupSvc myPartitionLookupSvc;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearchSvc;
    @Autowired
    private PlatformTransactionManager myTransactionManager;
    @Autowired
    protected ResourceHistoryCalculator myResourceHistoryCalculator;
    protected final CodingSpy myCodingSpy = new CodingSpy();

    @VisibleForTesting
    public void setExternallyStoredResourceServiceRegistryForUnitTest(ExternallyStoredResourceServiceRegistry theExternallyStoredResourceServiceRegistry) {
        this.myExternallyStoredResourceServiceRegistry = theExternallyStoredResourceServiceRegistry;
    }

    @VisibleForTesting
    public void setSearchParamPresenceSvc(ISearchParamPresenceSvc theSearchParamPresenceSvc) {
        this.mySearchParamPresenceSvc = theSearchParamPresenceSvc;
    }

    @VisibleForTesting
    public void setResourceHistoryCalculator(ResourceHistoryCalculator theResourceHistoryCalculator) {
        this.myResourceHistoryCalculator = theResourceHistoryCalculator;
    }

    protected IInterceptorBroadcaster getInterceptorBroadcaster() {
        return this.myInterceptorBroadcaster;
    }

    protected ApplicationContext getApplicationContext() {
        return this.myApplicationContext;
    }

    public void setApplicationContext(@Nonnull ApplicationContext theApplicationContext) throws BeansException {
        if (this.myApplicationContext == null) {
            this.myApplicationContext = theApplicationContext;
        }
    }

    private void extractHapiTags(TransactionDetails theTransactionDetails, IResource theResource, ResourceTable theEntity, Set<ResourceTag> allDefs) {
        List profiles;
        List securityLabels;
        TagList tagList = (TagList)ResourceMetadataKeyEnum.TAG_LIST.get((IBaseResource)theResource);
        if (tagList != null) {
            for (Object next : tagList) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.TAG, next.getScheme(), next.getTerm(), next.getLabel(), next.getVersion(), this.myCodingSpy.getBooleanObject((IBaseCoding)next));
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                allDefs.add(tag);
                theEntity.setHasTags(true);
            }
        }
        if ((securityLabels = (List)ResourceMetadataKeyEnum.SECURITY_LABELS.get((IBaseResource)theResource)) != null) {
            for (BaseCodingDt next : securityLabels) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.SECURITY_LABEL, (String)next.getSystemElement().getValue(), (String)next.getCodeElement().getValue(), (String)next.getDisplayElement().getValue(), (String)next.getVersionElement().getValue(), (Boolean)next.getUserSelectedElement().getValue());
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                allDefs.add(tag);
                theEntity.setHasTags(true);
            }
        }
        if ((profiles = (List)ResourceMetadataKeyEnum.PROFILES.get((IBaseResource)theResource)) != null) {
            for (IIdType next : profiles) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.PROFILE, NS_JPA_PROFILE, next.getValue(), null, null, null);
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                allDefs.add(tag);
                theEntity.setHasTags(true);
            }
        }
    }

    private void extractRiTags(TransactionDetails theTransactionDetails, IAnyResource theResource, ResourceTable theEntity, Set<ResourceTag> theAllTags) {
        List profiles;
        List securityLabels;
        List tagList = theResource.getMeta().getTag();
        if (tagList != null) {
            for (IBaseCoding next : tagList) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.TAG, next.getSystem(), next.getCode(), next.getDisplay(), next.getVersion(), this.myCodingSpy.getBooleanObject(next));
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                theAllTags.add(tag);
                theEntity.setHasTags(true);
            }
        }
        if ((securityLabels = theResource.getMeta().getSecurity()) != null) {
            for (IBaseCoding next : securityLabels) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.SECURITY_LABEL, next.getSystem(), next.getCode(), next.getDisplay(), next.getVersion(), this.myCodingSpy.getBooleanObject(next));
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                theAllTags.add(tag);
                theEntity.setHasTags(true);
            }
        }
        if ((profiles = theResource.getMeta().getProfile()) != null) {
            for (IPrimitiveType next : profiles) {
                TagDefinition def = this.getTagOrNull(theTransactionDetails, TagTypeEnum.PROFILE, NS_JPA_PROFILE, (String)next.getValue(), null, null, null);
                if (def == null) continue;
                ResourceTag tag = theEntity.addTag(def);
                theAllTags.add(tag);
                theEntity.setHasTags(true);
            }
        }
    }

    private void extractProfileTags(TransactionDetails theTransactionDetails, IBaseResource theResource, ResourceTable theEntity, Set<ResourceTag> theAllTags) {
        String profile;
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        if (!def.isStandardType() && StringUtils.isNotBlank((CharSequence)(profile = def.getResourceProfile("")))) {
            TagDefinition profileDef = this.getTagOrNull(theTransactionDetails, TagTypeEnum.PROFILE, NS_JPA_PROFILE, profile, null, null, null);
            ResourceTag tag = theEntity.addTag(profileDef);
            theAllTags.add(tag);
            theEntity.setHasTags(true);
        }
    }

    private Set<ResourceTag> getAllTagDefinitions(ResourceTable theEntity) {
        HashSet retVal = Sets.newHashSet();
        if (theEntity.isHasTags()) {
            retVal.addAll(theEntity.getTags());
        }
        return retVal;
    }

    public JpaStorageSettings getStorageSettings() {
        return this.myStorageSettings;
    }

    public FhirContext getContext() {
        return this.myContext;
    }

    @Autowired
    public void setContext(FhirContext theContext) {
        this.myFhirContext = theContext;
        this.myContext = theContext;
    }

    protected TagDefinition getTagOrNull(TransactionDetails theTransactionDetails, TagTypeEnum theTagType, String theScheme, String theTerm, String theLabel, String theVersion, Boolean theUserSelected) {
        HashMap resolvedTagDefinitions;
        if (StringUtils.isBlank((CharSequence)theScheme) && StringUtils.isBlank((CharSequence)theTerm) && StringUtils.isBlank((CharSequence)theLabel)) {
            return null;
        }
        MemoryCacheService.TagDefinitionCacheKey key = BaseHapiFhirDao.toTagDefinitionMemoryCacheKey(theTagType, theScheme, theTerm, theVersion, theUserSelected);
        TagDefinition retVal = (TagDefinition)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.TAG_DEFINITION, (Object)key);
        if (retVal == null && (retVal = (TagDefinition)(resolvedTagDefinitions = (HashMap)theTransactionDetails.getOrCreateUserData(HapiTransactionService.XACT_USERDATA_KEY_RESOLVED_TAG_DEFINITIONS, HashMap::new)).get(key)) == null) {
            retVal = this.getOrCreateTag(theTagType, theScheme, theTerm, theLabel, theVersion, theUserSelected);
            AddTagDefinitionToCacheAfterCommitSynchronization sync = new AddTagDefinitionToCacheAfterCommitSynchronization(key, retVal);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)sync);
            resolvedTagDefinitions.put(key, retVal);
        }
        return retVal;
    }

    private TagDefinition getOrCreateTag(final TagTypeEnum theTagType, final String theScheme, final String theTerm, final String theLabel, final String theVersion, final Boolean theUserSelected) {
        TagDefinition retVal;
        final TypedQuery<TagDefinition> q = this.buildTagQuery(theTagType, theScheme, theTerm, theVersion, theUserSelected);
        q.setMaxResults(1);
        TransactionTemplate template = new TransactionTemplate(this.myTransactionManager);
        template.setPropagationBehavior(3);
        int count = 0;
        final HashSet throwables = new HashSet();
        do {
            try {
                retVal = (TagDefinition)template.execute((TransactionCallback)new TransactionCallback<TagDefinition>(){

                    private TagDefinition readOrCreate() {
                        TagDefinition val;
                        try {
                            val = (TagDefinition)q.getSingleResult();
                        }
                        catch (NoResultException e) {
                            val = new TagDefinition(theTagType, theScheme, theTerm, theLabel);
                            val.setVersion(theVersion);
                            val.setUserSelected(theUserSelected);
                            BaseHapiFhirDao.this.myEntityManager.persist((Object)val);
                        }
                        return val;
                    }

                    public TagDefinition doInTransaction(TransactionStatus status) {
                        TagDefinition tag = null;
                        try {
                            tag = this.readOrCreate();
                        }
                        catch (Exception ex) {
                            ourLog.warn("Tag read/write failed: " + ex.getMessage() + ". This is not a failure on its own, but could be useful information in the result of an actual failure.", (Throwable)ex);
                            throwables.add(ex);
                        }
                        return tag;
                    }
                });
            }
            catch (Exception ex) {
                ourLog.warn("Transaction failed with: {}. Transaction will rollback and be reattempted.", (Object)ex.getMessage());
                retVal = null;
            }
        } while (retVal == null && ++count < 10);
        if (retVal == null) {
            String msg = throwables.stream().map(Throwable::getMessage).collect(Collectors.joining(", "));
            throw new InternalErrorException(Msg.code((int)2023) + "Tag get/create failed after 10 attempts with error(s): " + msg);
        }
        return retVal;
    }

    private TypedQuery<TagDefinition> buildTagQuery(TagTypeEnum theTagType, String theScheme, String theTerm, String theVersion, Boolean theUserSelected) {
        CriteriaBuilder builder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(TagDefinition.class);
        Root from = cq.from(TagDefinition.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.and((Expression)builder.equal((Expression)from.get("myTagType"), (Object)theTagType), (Expression)builder.equal((Expression)from.get("myCode"), (Object)theTerm)));
        predicates.add(StringUtils.isBlank((CharSequence)theScheme) ? builder.isNull((Expression)from.get("mySystem")) : builder.equal((Expression)from.get("mySystem"), (Object)theScheme));
        predicates.add(StringUtils.isBlank((CharSequence)theVersion) ? builder.isNull((Expression)from.get("myVersion")) : builder.equal((Expression)from.get("myVersion"), (Object)theVersion));
        predicates.add(Objects.isNull(theUserSelected) ? builder.isNull((Expression)from.get("myUserSelected")) : builder.equal((Expression)from.get("myUserSelected"), (Object)theUserSelected));
        cq.where(predicates.toArray(new Predicate[0]));
        return this.myEntityManager.createQuery(cq);
    }

    void incrementId(T theResource, ResourceTable theSavedEntity, IIdType theResourceId) {
        if (theResourceId == null || theResourceId.getVersionIdPart() == null) {
            theSavedEntity.initializeVersion();
        } else {
            theSavedEntity.markVersionUpdatedInCurrentTransaction();
        }
        assert (theResourceId != null);
        String newVersion = Long.toString(theSavedEntity.getVersion());
        IIdType newId = theResourceId.withVersion(newVersion);
        theResource.getIdElement().setValue(newId.getValue());
    }

    public boolean isLogicalReference(IIdType theId) {
        return LogicalReferenceHelper.isLogicalReference((StorageSettings)this.myStorageSettings, (IIdType)theId);
    }

    protected EncodedResource populateResourceIntoEntity(TransactionDetails theTransactionDetails, RequestDetails theRequest, IBaseResource theResource, ResourceTable theEntity, boolean thePerformIndexing) {
        Object resourceText;
        byte[] resourceBinary;
        ResourceEncodingEnum encoding;
        if (theEntity.getResourceType() == null) {
            theEntity.setResourceType(this.toResourceName(theResource));
        }
        boolean changed = false;
        if (theEntity.getDeleted() == null) {
            if (thePerformIndexing) {
                ExternallyStoredResourceAddress address = null;
                if (this.myExternallyStoredResourceServiceRegistry.hasProviders()) {
                    address = (ExternallyStoredResourceAddress)ExternallyStoredResourceAddressMetadataKey.INSTANCE.get(theResource);
                }
                if (address != null) {
                    encoding = ResourceEncodingEnum.ESR;
                    resourceBinary = null;
                    resourceText = address.getProviderId() + ":" + address.getLocation();
                    changed = true;
                } else {
                    encoding = this.myStorageSettings.getResourceEncoding();
                    String resourceType = theEntity.getResourceType();
                    ArrayList<String> excludeElements = new ArrayList<String>(8);
                    IBaseMetaType meta = theResource.getMeta();
                    IBaseExtension<?, ?> sourceExtension = this.getExcludedElements(resourceType, excludeElements, meta);
                    theEntity.setFhirVersion(this.myContext.getVersion().getVersion());
                    ResourceHistoryState calculate = this.myResourceHistoryCalculator.calculateResourceHistoryState(theResource, encoding, excludeElements);
                    resourceText = calculate.getResourceText();
                    resourceBinary = calculate.getResourceBinary();
                    encoding = calculate.getEncoding();
                    HashCode hashCode = calculate.getHashCode();
                    String hashSha256 = hashCode.toString();
                    if (!hashSha256.equals(theEntity.getHashSha256())) {
                        changed = true;
                    }
                    theEntity.setHashSha256(hashSha256);
                    if (sourceExtension != null) {
                        IBaseExtension newSourceExtension = ((IBaseHasExtensions)meta).addExtension();
                        newSourceExtension.setUrl(sourceExtension.getUrl());
                        newSourceExtension.setValue(sourceExtension.getValue());
                    }
                }
            } else {
                encoding = null;
                resourceBinary = null;
                resourceText = null;
            }
            boolean skipUpdatingTags = this.myStorageSettings.isMassIngestionMode() && theEntity.isHasTags();
            if (!(skipUpdatingTags |= this.myStorageSettings.getTagStorageMode() == JpaStorageSettings.TagStorageModeEnum.INLINE)) {
                changed |= this.updateTags(theTransactionDetails, theRequest, theResource, theEntity);
            }
        } else {
            if (Objects.nonNull(theEntity.getHashSha256())) {
                theEntity.setHashSha256(null);
                changed = true;
            }
            resourceBinary = null;
            resourceText = null;
            encoding = ResourceEncodingEnum.DEL;
        }
        if (thePerformIndexing && !changed) {
            if (theEntity.getId() == null) {
                changed = true;
            } else if (!(this.myStorageSettings.isMassIngestionMode() || theEntity.getVersion() == 1L && theEntity.getCurrentVersionEntity() == null)) {
                ResourceHistoryTable currentHistoryVersion = theEntity.getCurrentVersionEntity();
                if (currentHistoryVersion == null) {
                    currentHistoryVersion = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(theEntity.getId(), theEntity.getVersion());
                }
                changed = currentHistoryVersion == null || !currentHistoryVersion.hasResource() ? true : this.myResourceHistoryCalculator.isResourceHistoryChanged(currentHistoryVersion, resourceBinary, (String)resourceText);
            }
        }
        EncodedResource retVal = new EncodedResource();
        retVal.setEncoding(encoding);
        retVal.setResourceBinary(resourceBinary);
        retVal.setResourceText((String)resourceText);
        retVal.setChanged(changed);
        return retVal;
    }

    private IBaseExtension<?, ?> getExcludedElements(String theResourceType, List<String> theExcludeElements, IBaseMetaType theMeta) {
        boolean inlineTagMode;
        List extensions;
        boolean hasExtensions = false;
        IBaseExtension sourceExtension = null;
        if (theMeta instanceof IBaseHasExtensions && !(extensions = ((IBaseHasExtensions)theMeta).getExtension()).isEmpty()) {
            boolean allExtensionsRemoved;
            hasExtensions = true;
            if (this.myFhirContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3)) {
                for (int i = 0; i < extensions.size(); ++i) {
                    if (!((IBaseExtension)extensions.get(i)).getUrl().equals("http://hapifhir.io/fhir/StructureDefinition/resource-meta-source")) continue;
                    sourceExtension = (IBaseExtension)extensions.remove(i);
                    --i;
                }
            }
            if (allExtensionsRemoved = extensions.isEmpty()) {
                hasExtensions = false;
            }
        }
        theExcludeElements.add("id");
        boolean bl = inlineTagMode = this.getStorageSettings().getTagStorageMode() == JpaStorageSettings.TagStorageModeEnum.INLINE;
        if (hasExtensions || inlineTagMode) {
            if (!inlineTagMode) {
                theExcludeElements.add(theResourceType + ".meta.profile");
                theExcludeElements.add(theResourceType + ".meta.tag");
                theExcludeElements.add(theResourceType + ".meta.security");
            }
            theExcludeElements.add(theResourceType + ".meta.versionId");
            theExcludeElements.add(theResourceType + ".meta.lastUpdated");
            theExcludeElements.add(theResourceType + ".meta.source");
        } else {
            theExcludeElements.add(theResourceType + ".meta");
        }
        return sourceExtension;
    }

    private boolean updateTags(TransactionDetails theTransactionDetails, RequestDetails theRequest, IBaseResource theResource, ResourceTable theEntity) {
        HashSet<ResourceTag> allResourceTagsFromTheResource = new HashSet<ResourceTag>();
        Set<ResourceTag> allOriginalResourceTagsFromTheEntity = this.getAllTagDefinitions(theEntity);
        if (theResource instanceof IResource) {
            this.extractHapiTags(theTransactionDetails, (IResource)theResource, theEntity, allResourceTagsFromTheResource);
        } else {
            this.extractRiTags(theTransactionDetails, (IAnyResource)theResource, theEntity, allResourceTagsFromTheResource);
        }
        this.extractProfileTags(theTransactionDetails, theResource, theEntity, allResourceTagsFromTheResource);
        Set<ResourceTag> allResourceTagsNewAndOldFromTheEntity = this.getAllTagDefinitions(theEntity);
        HashSet allTagDefinitionsPresent = new HashSet();
        allResourceTagsNewAndOldFromTheEntity.forEach(tag -> {
            if (!allTagDefinitionsPresent.add(tag.getTag())) {
                theEntity.getTags().remove(tag);
            }
            if (!allResourceTagsFromTheResource.contains(tag)) {
                if (this.shouldDroppedTagBeRemovedOnUpdate(theRequest, (ResourceTag)tag)) {
                    theEntity.getTags().remove(tag);
                } else if ("http://hapifhir.io/fhir/StructureDefinition/subscription-matching-strategy".equals(tag.getTag().getSystem())) {
                    theEntity.getTags().remove(tag);
                }
            }
        });
        Set<ResourceTag> allUpdatedResourceTagsNewAndOldMinusRemovalsFromTheEntity = this.getAllTagDefinitions(theEntity);
        allUpdatedResourceTagsNewAndOldMinusRemovalsFromTheEntity.forEach(aResourcetag -> {
            if (!allResourceTagsFromTheResource.contains(aResourcetag)) {
                IBaseCoding iBaseCoding = theResource.getMeta().addTag().setCode(aResourcetag.getTag().getCode()).setSystem(aResourcetag.getTag().getSystem()).setVersion(aResourcetag.getTag().getVersion());
                allResourceTagsFromTheResource.add((ResourceTag)aResourcetag);
                if (aResourcetag.getTag().getUserSelected() != null) {
                    iBaseCoding.setUserSelected(aResourcetag.getTag().getUserSelected().booleanValue());
                }
            }
        });
        theEntity.setHasTags(!allUpdatedResourceTagsNewAndOldMinusRemovalsFromTheEntity.isEmpty());
        return !CollectionUtils.isEqualCollection(allOriginalResourceTagsFromTheEntity, allResourceTagsFromTheResource);
    }

    protected void postDelete(ResourceTable theEntity) {
    }

    protected void postPersist(ResourceTable theEntity, T theResource, RequestDetails theRequestDetails) {
    }

    protected void postUpdate(ResourceTable theEntity, T theResource, RequestDetails theRequestDetails) {
    }

    @CoverageIgnore
    public BaseHasResource readEntity(IIdType theValueId, RequestDetails theRequest) {
        throw new NotImplementedException(Msg.code((int)927));
    }

    protected boolean shouldDroppedTagBeRemovedOnUpdate(RequestDetails theRequest, ResourceTag theTag) {
        List metaSnapshotMode;
        Set<TagTypeEnum> metaSnapshotModeTokens = null;
        if (theRequest != null && (metaSnapshotMode = theRequest.getHeaders("X-Meta-Snapshot-Mode")) != null && !metaSnapshotMode.isEmpty()) {
            metaSnapshotModeTokens = new HashSet<TagTypeEnum>();
            for (String nextHeaderValue : metaSnapshotMode) {
                StringTokenizer tok = new StringTokenizer(nextHeaderValue, ",");
                while (tok.hasMoreTokens()) {
                    switch (StringUtils.trim((String)tok.nextToken())) {
                        case "TAG": {
                            metaSnapshotModeTokens.add(TagTypeEnum.TAG);
                            break;
                        }
                        case "PROFILE": {
                            metaSnapshotModeTokens.add(TagTypeEnum.PROFILE);
                            break;
                        }
                        case "SECURITY_LABEL": {
                            metaSnapshotModeTokens.add(TagTypeEnum.SECURITY_LABEL);
                        }
                    }
                }
            }
        }
        if (metaSnapshotModeTokens == null) {
            metaSnapshotModeTokens = Collections.singleton(TagTypeEnum.PROFILE);
        }
        return metaSnapshotModeTokens.contains(theTag.getTag().getTagType());
    }

    String toResourceName(IBaseResource theResource) {
        return this.myContext.getResourceType(theResource);
    }

    @VisibleForTesting
    public void setEntityManager(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    @VisibleForTesting
    public void setSearchParamWithInlineReferencesExtractor(SearchParamWithInlineReferencesExtractor theSearchParamWithInlineReferencesExtractor) {
        this.mySearchParamWithInlineReferencesExtractor = theSearchParamWithInlineReferencesExtractor;
    }

    @VisibleForTesting
    public void setResourceHistoryTableDao(IResourceHistoryTableDao theResourceHistoryTableDao) {
        this.myResourceHistoryTableDao = theResourceHistoryTableDao;
    }

    @VisibleForTesting
    public void setDaoSearchParamSynchronizer(DaoSearchParamSynchronizer theDaoSearchParamSynchronizer) {
        this.myDaoSearchParamSynchronizer = theDaoSearchParamSynchronizer;
    }

    private void verifyMatchUrlForConditionalCreateOrUpdate(CreateOrUpdateByMatch theCreateOrUpdate, IBaseResource theResource, String theIfNoneExist, ResourceIndexedSearchParams theParams, RequestDetails theRequestDetails) {
        InMemoryMatchResult outcome = this.myInMemoryResourceMatcher.match(theIfNoneExist, theResource, theParams, theRequestDetails);
        if (outcome.supported() && !outcome.matched()) {
            String errorMsg = this.getConditionalCreateOrUpdateErrorMsg(theCreateOrUpdate);
            throw new InvalidRequestException(Msg.code((int)929) + errorMsg);
        }
    }

    private String getConditionalCreateOrUpdateErrorMsg(CreateOrUpdateByMatch theCreateOrUpdate) {
        return String.format("Failed to process conditional %s. The supplied resource did not satisfy the conditional URL.", theCreateOrUpdate.name().toLowerCase());
    }

    public ResourceTable updateEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        HookParams params;
        StorageProcessingMessage message;
        AddRemoveCount presenceCount;
        EncodedResource changed;
        Validate.notNull((Object)theEntity);
        Validate.isTrue((theDeletedTimestampOrNull != null || theResource != null ? 1 : 0) != 0, (String)"Must have either a resource[%s] or a deleted timestamp[%s] for resource PID[%s]", (Object[])new Object[]{theDeletedTimestampOrNull != null, theResource != null, theEntity.getPersistentId()});
        ourLog.debug("Starting entity update");
        ResourceTable entity = (ResourceTable)theEntity;
        if (theResource != null) {
            if (thePerformIndexing && theDeletedTimestampOrNull == null && !ourValidationDisabledForUnitTest) {
                this.validateResourceForStorage(theResource, entity);
            }
            if (!StringUtils.isBlank((CharSequence)entity.getResourceType())) {
                this.validateIncomingResourceTypeMatchesExisting(theResource, (BaseHasResource)entity);
            }
        }
        if (entity.getPublished() == null) {
            ourLog.debug("Entity has published time: {}", (Object)theTransactionDetails.getTransactionDate());
            entity.setPublished(theTransactionDetails.getTransactionDate());
        }
        ResourceIndexedSearchParams existingParams = null;
        ResourceIndexedSearchParams newParams = null;
        if (theDeletedTimestampOrNull != null) {
            entity.setDeleted(theDeletedTimestampOrNull);
            entity.setUpdated(theDeletedTimestampOrNull);
            entity.setNarrativeText(null);
            entity.setContentText(null);
            entity.setIndexStatus(Long.valueOf(1L));
            changed = this.populateResourceIntoEntity(theTransactionDetails, theRequest, theResource, entity, true);
        } else {
            IdentityHashMap existingSearchParams = (IdentityHashMap)theTransactionDetails.getOrCreateUserData(HapiTransactionService.XACT_USERDATA_KEY_EXISTING_SEARCH_PARAMS, () -> new IdentityHashMap());
            existingParams = (ResourceIndexedSearchParams)existingSearchParams.get(entity);
            if (existingParams == null) {
                existingParams = ResourceIndexedSearchParams.withLists((ResourceTable)entity);
                if (existingParams.getResourceLinks().size() >= 10) {
                    List pids = existingParams.getResourceLinks().stream().map(t -> t.getId()).collect(Collectors.toList());
                    new QueryChunker().chunk(pids, t -> {
                        List<ResourceLink> targets = this.myResourceLinkDao.findByPidAndFetchTargetDetails((List<Long>)t);
                        ourLog.trace("Prefetched targets: {}", targets);
                    });
                }
                existingSearchParams.put(entity, existingParams);
            }
            entity.setDeleted(null);
            if (thePerformIndexing || theEntity.getVersion() == 1L) {
                newParams = ResourceIndexedSearchParams.withSets();
                RequestPartitionId requestPartitionId = !this.myPartitionSettings.isPartitioningEnabled() ? RequestPartitionId.allPartitions() : (entity.getPartitionId() != null ? entity.getPartitionId().toPartitionId() : RequestPartitionId.defaultPartition());
                this.failIfPartitionMismatch(theRequest, entity);
                this.mySearchParamWithInlineReferencesExtractor.populateFromResource(requestPartitionId, newParams, theTransactionDetails, entity, theResource, existingParams, theRequest, thePerformIndexing);
                changed = this.populateResourceIntoEntity(theTransactionDetails, theRequest, theResource, entity, true);
                if (theForceUpdate) {
                    changed.setChanged(true);
                }
                if (changed.isChanged()) {
                    this.checkConditionalMatch(entity, theUpdateVersion, theResource, thePerformIndexing, newParams, theRequest);
                    if (CURRENTLY_REINDEXING.get(theResource) != Boolean.TRUE) {
                        entity.setUpdated(theTransactionDetails.getTransactionDate());
                    }
                    newParams.populateResourceTableSearchParamsPresentFlags(entity);
                    entity.setIndexStatus(Long.valueOf(1L));
                }
                if (this.myFulltextSearchSvc != null && !this.myFulltextSearchSvc.isDisabled()) {
                    this.populateFullTextFields(this.myContext, theResource, entity, newParams);
                }
            } else {
                entity.setUpdated(theTransactionDetails.getTransactionDate());
                entity.setIndexStatus(null);
                changed = this.populateResourceIntoEntity(theTransactionDetails, theRequest, theResource, entity, false);
            }
        }
        if (thePerformIndexing && changed != null && !changed.isChanged() && !theForceUpdate && this.myStorageSettings.isSuppressUpdatesWithNoChange() && (entity.getVersion() > 1L || theUpdateVersion)) {
            ourLog.debug("Resource {} has not changed", (Object)entity.getIdDt().toUnqualified().getValue());
            if (theResource != null) {
                this.myJpaStorageResourceParser.updateResourceMetadata((IBaseResourceEntity)entity, theResource);
            }
            entity.setUnchangedInCurrentOperation(true);
            return entity;
        }
        if (entity.getId() != null && theUpdateVersion) {
            entity.markVersionUpdatedInCurrentTransaction();
        }
        if (entity.getId() == null) {
            this.myEntityManager.persist((Object)entity);
            this.postPersist(entity, theResource, theRequest);
        } else if (entity.getDeleted() != null) {
            entity = (ResourceTable)this.myEntityManager.merge((Object)entity);
            this.postDelete(entity);
        } else {
            entity = (ResourceTable)this.myEntityManager.merge((Object)entity);
            this.postUpdate(entity, theResource, theRequest);
        }
        if (theCreateNewHistoryEntry) {
            this.createHistoryEntry(theRequest, theResource, entity, changed);
        }
        if (thePerformIndexing && newParams != null && !(presenceCount = this.mySearchParamPresenceSvc.updatePresence(entity, newParams.mySearchParamPresentEntities)).isEmpty() && CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_INFO, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
            message = new StorageProcessingMessage();
            message.setMessage("For " + entity.getIdDt().toUnqualifiedVersionless().getValue() + " added " + presenceCount.getAddCount() + " and removed " + presenceCount.getRemoveCount() + " resource search parameter presence entries");
            params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)message);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
        }
        if (thePerformIndexing) {
            if (newParams == null) {
                this.myExpungeService.deleteAllSearchParams((IResourcePersistentId)JpaPid.fromId((Long)entity.getId()));
                entity.clearAllParamsPopulated();
            } else {
                AddRemoveCount searchParamAddRemoveCount = this.myDaoSearchParamSynchronizer.synchronizeSearchParamsToDatabase(newParams, entity, existingParams);
                newParams.populateResourceTableParamCollections(entity);
                if (!searchParamAddRemoveCount.isEmpty() && CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_INFO, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
                    message = new StorageProcessingMessage();
                    message.setMessage("For " + entity.getIdDt().toUnqualifiedVersionless().getValue() + " added " + searchParamAddRemoveCount.getAddCount() + " and removed " + searchParamAddRemoveCount.getRemoveCount() + " resource search parameter index entries");
                    params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)message);
                    CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
                }
            }
        }
        if (theResource != null) {
            this.myJpaStorageResourceParser.updateResourceMetadata((IBaseResourceEntity)entity, theResource);
        }
        return entity;
    }

    private void checkConditionalMatch(ResourceTable theEntity, boolean theUpdateVersion, IBaseResource theResource, boolean thePerformIndexing, ResourceIndexedSearchParams theNewParams, RequestDetails theRequest) {
        if (!thePerformIndexing) {
            return;
        }
        if (theEntity.getCreatedByMatchUrl() == null && theEntity.getUpdatedByMatchUrl() == null) {
            return;
        }
        long pendingVersion = theEntity.getVersion();
        if (theUpdateVersion && !theEntity.isVersionUpdatedInCurrentTransaction()) {
            ++pendingVersion;
        }
        if (this.myStorageSettings.isPreventInvalidatingConditionalMatchCriteria() || pendingVersion <= 1L) {
            CreateOrUpdateByMatch createOrUpdate;
            String createOrUpdateUrl;
            if (theEntity.getCreatedByMatchUrl() != null) {
                createOrUpdateUrl = theEntity.getCreatedByMatchUrl();
                createOrUpdate = CreateOrUpdateByMatch.CREATE;
            } else {
                createOrUpdateUrl = theEntity.getUpdatedByMatchUrl();
                createOrUpdate = CreateOrUpdateByMatch.UPDATE;
            }
            this.verifyMatchUrlForConditionalCreateOrUpdate(createOrUpdate, theResource, createOrUpdateUrl, theNewParams, theRequest);
        }
    }

    public IBasePersistedResource updateHistoryEntity(RequestDetails theRequest, T theResource, IBasePersistedResource theEntity, IBasePersistedResource theHistoryEntity, IIdType theResourceId, TransactionDetails theTransactionDetails, boolean isUpdatingCurrent) {
        ResourceHistoryTable historyEntity;
        Validate.notNull((Object)theEntity);
        Validate.isTrue((theResource != null ? 1 : 0) != 0, (String)"Must have either a resource[%s] for resource PID[%s]", (Object[])new Object[]{theResource != null, theEntity.getPersistentId()});
        ourLog.debug("Starting history entity update");
        EncodedResource encodedResource = new EncodedResource();
        if (isUpdatingCurrent) {
            ResourceTable entity = (ResourceTable)theEntity;
            IBaseResource oldResource = this.getStorageSettings().isMassIngestionMode() ? null : this.myJpaStorageResourceParser.toResource((IBasePersistedResource)entity, false);
            this.notifyInterceptors(theRequest, theResource, oldResource, theTransactionDetails, true);
            ResourceTable savedEntity = this.updateEntity(theRequest, (IBaseResource)theResource, (IBasePersistedResource)entity, null, true, false, theTransactionDetails, false, false);
            encodedResource = this.populateResourceIntoEntity(theTransactionDetails, theRequest, (IBaseResource)theResource, entity, true);
            historyEntity = ((ResourceTable)this.readEntity(theResourceId, theRequest)).getCurrentVersionEntity();
            this.myJpaStorageResourceParser.updateResourceMetadata((IBaseResourceEntity)savedEntity, (IBaseResource)theResource);
            this.addPidToResource((IResourceLookup<JpaPid>)savedEntity, (IBaseResource)theResource);
            if (!savedEntity.isUnchangedInCurrentOperation()) {
                this.notifyInterceptors(theRequest, theResource, oldResource, theTransactionDetails, false);
            }
        } else {
            historyEntity = (ResourceHistoryTable)theHistoryEntity;
            if (!StringUtils.isBlank((CharSequence)historyEntity.getResourceType())) {
                this.validateIncomingResourceTypeMatchesExisting((IBaseResource)theResource, (BaseHasResource)historyEntity);
            }
            historyEntity.setDeleted(null);
            ResourceEncodingEnum encoding = this.myStorageSettings.getResourceEncoding();
            ArrayList<String> excludeElements = new ArrayList<String>(8);
            this.getExcludedElements(historyEntity.getResourceType(), excludeElements, theResource.getMeta());
            String encodedResourceString = this.myResourceHistoryCalculator.encodeResource((IBaseResource)theResource, encoding, (List<String>)excludeElements);
            byte[] resourceBinary = ResourceHistoryCalculator.getResourceBinary(encoding, encodedResourceString);
            boolean changed = this.myResourceHistoryCalculator.isResourceHistoryChanged(historyEntity, resourceBinary, encodedResourceString);
            historyEntity.setUpdated(theTransactionDetails.getTransactionDate());
            if (!changed && this.myStorageSettings.isSuppressUpdatesWithNoChange() && historyEntity.getVersion() > 1L) {
                ourLog.debug("Resource {} has not changed", (Object)historyEntity.getIdDt().toUnqualified().getValue());
                this.myJpaStorageResourceParser.updateResourceMetadata((IBaseResourceEntity)historyEntity, (IBaseResource)theResource);
                return historyEntity;
            }
            this.myResourceHistoryCalculator.populateEncodedResource(encodedResource, encodedResourceString, resourceBinary, encoding);
        }
        historyEntity = (ResourceHistoryTable)this.myEntityManager.merge((Object)historyEntity);
        historyEntity.setEncoding(encodedResource.getEncoding());
        historyEntity.setResource(encodedResource.getResourceBinary());
        historyEntity.setResourceTextVc(encodedResource.getResourceText());
        this.myResourceHistoryTableDao.save(historyEntity);
        this.myJpaStorageResourceParser.updateResourceMetadata((IBaseResourceEntity)historyEntity, (IBaseResource)theResource);
        return historyEntity;
    }

    private void populateEncodedResource(EncodedResource encodedResource, String encodedResourceString, byte[] theResourceBinary, ResourceEncodingEnum theEncoding) {
        encodedResource.setResourceText(encodedResourceString);
        encodedResource.setResourceBinary(theResourceBinary);
        encodedResource.setEncoding(theEncoding);
    }

    private void failIfPartitionMismatch(RequestDetails theRequest, ResourceTable entity) {
        PartitionEntity partitionEntity;
        if (this.myPartitionSettings.isPartitioningEnabled() && theRequest != null && theRequest.getTenantId() != null && entity.getPartitionId() != null && (partitionEntity = this.myPartitionLookupSvc.getPartitionByName(theRequest.getTenantId())) != null && !partitionEntity.getId().equals(entity.getPartitionId().getPartitionId())) {
            throw new InvalidRequestException(Msg.code((int)2079) + "Resource " + entity.getResourceType() + "/" + entity.getId() + " is not known");
        }
    }

    private void createHistoryEntry(RequestDetails theRequest, IBaseResource theResource, ResourceTable theEntity, EncodedResource theChanged) {
        boolean haveRequestId;
        boolean versionedTags = this.getStorageSettings().getTagStorageMode() == JpaStorageSettings.TagStorageModeEnum.VERSIONED;
        ResourceHistoryTable historyEntry = null;
        long resourceVersion = theEntity.getVersion();
        boolean reusingHistoryEntity = false;
        if (!this.myStorageSettings.isResourceDbHistoryEnabled() && resourceVersion > 1L && (historyEntry = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(theEntity.getResourceId(), resourceVersion - 1L)) != null) {
            reusingHistoryEntity = true;
            theEntity.populateHistoryEntityVersionAndDates(historyEntry);
            if (versionedTags && theEntity.isHasTags()) {
                for (ResourceTag next : theEntity.getTags()) {
                    historyEntry.addTag(next.getTag());
                }
            }
        }
        if (historyEntry == null) {
            historyEntry = theEntity.toHistory(versionedTags);
        }
        historyEntry.setEncoding(theChanged.getEncoding());
        historyEntry.setResource(theChanged.getResourceBinary());
        historyEntry.setResourceTextVc(theChanged.getResourceText());
        ourLog.debug("Saving history entry ID[{}] for RES_ID[{}]", (Object)historyEntry.getId(), (Object)historyEntry.getResourceId());
        this.myResourceHistoryTableDao.save(historyEntry);
        theEntity.setCurrentVersionEntity(historyEntry);
        String source = null;
        if (theResource != null) {
            if (this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
                IBaseMetaType meta = theResource.getMeta();
                source = MetaUtil.getSource((FhirContext)this.myContext, (IBaseMetaType)meta);
            }
            if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3)) {
                source = ((IBaseHasExtensions)theResource.getMeta()).getExtension().stream().filter(t -> "http://hapifhir.io/fhir/StructureDefinition/resource-meta-source".equals(t.getUrl())).filter(t -> t.getValue() instanceof IPrimitiveType).map(t -> ((IPrimitiveType)t.getValue()).getValueAsString()).findFirst().orElse(null);
            }
        }
        String requestId = this.getRequestId(theRequest, source);
        source = MetaUtil.cleanProvenanceSourceUriOrEmpty(source);
        boolean shouldStoreSource = this.myStorageSettings.getStoreMetaSourceInformation().isStoreSourceUri();
        boolean shouldStoreRequestId = this.myStorageSettings.getStoreMetaSourceInformation().isStoreRequestId();
        boolean haveSource = StringUtils.isNotBlank((CharSequence)source) && shouldStoreSource;
        boolean bl = haveRequestId = StringUtils.isNotBlank((CharSequence)requestId) && shouldStoreRequestId;
        if (haveSource || haveRequestId) {
            ResourceHistoryProvenanceEntity provenance = null;
            if (reusingHistoryEntity) {
                provenance = historyEntry.getProvenance();
            }
            if (provenance == null) {
                provenance = historyEntry.toProvenance();
            }
            provenance.setResourceHistoryTable(historyEntry);
            provenance.setResourceTable(theEntity);
            provenance.setPartitionId(theEntity.getPartitionId());
            if (haveRequestId) {
                String persistedRequestId = StringUtils.left((String)requestId, (int)16);
                provenance.setRequestId(persistedRequestId);
                historyEntry.setRequestId(persistedRequestId);
            }
            if (haveSource) {
                String persistedSource = StringUtils.left((String)source, (int)100);
                provenance.setSourceUri(persistedSource);
                historyEntry.setSourceUri(persistedSource);
            }
            if (theResource != null) {
                MetaUtil.populateResourceSource((FhirContext)this.myFhirContext, (String)(shouldStoreSource ? source : null), (String)(shouldStoreRequestId ? requestId : null), (IBaseResource)theResource);
            }
            this.myEntityManager.persist((Object)provenance);
        }
    }

    private String getRequestId(RequestDetails theRequest, String theSource) {
        if (this.myStorageSettings.isPreserveRequestIdInResourceBody()) {
            return StringUtils.substringAfter((String)theSource, (String)"#");
        }
        return theRequest != null ? theRequest.getRequestId() : null;
    }

    private void validateIncomingResourceTypeMatchesExisting(IBaseResource theResource, BaseHasResource entity) {
        String resourceType = this.myContext.getResourceType(theResource);
        if (!resourceType.equals(entity.getResourceType())) {
            throw new UnprocessableEntityException(Msg.code((int)930) + "Existing resource ID[" + entity.getIdDt().toUnqualifiedVersionless() + "] is of type[" + entity.getResourceType() + "] - Cannot update with [" + resourceType + "]");
        }
    }

    public DaoMethodOutcome updateInternal(RequestDetails theRequestDetails, T theResource, String theMatchUrl, boolean thePerformIndexing, boolean theForceUpdateVersion, IBasePersistedResource theEntity, IIdType theResourceId, @Nullable IBaseResource theOldResource, RestOperationTypeEnum theOperationType, TransactionDetails theTransactionDetails) {
        ResourceTable entity = (ResourceTable)theEntity;
        theResource.setId((IIdType)entity.getIdDt());
        this.notifyInterceptors(theRequestDetails, theResource, theOldResource, theTransactionDetails, true);
        entity.setUpdatedByMatchUrl(theMatchUrl);
        ResourceTable savedEntity = this.updateEntity(theRequestDetails, (IBaseResource)theResource, (IBasePersistedResource)entity, null, thePerformIndexing, thePerformIndexing, theTransactionDetails, theForceUpdateVersion, thePerformIndexing);
        if (!(thePerformIndexing || savedEntity.isUnchangedInCurrentOperation() || ourDisableIncrementOnUpdateForUnitTest)) {
            if (!theResourceId.hasVersionIdPart()) {
                theResourceId = theResourceId.withVersion(Long.toString(savedEntity.getVersion()));
            }
            this.incrementId(theResource, savedEntity, theResourceId);
        }
        this.myJpaStorageResourceParser.updateResourceMetadata((IBaseResourceEntity)savedEntity, (IBaseResource)theResource);
        this.addPidToResource((IResourceLookup<JpaPid>)savedEntity, (IBaseResource)theResource);
        if (!savedEntity.isUnchangedInCurrentOperation()) {
            this.notifyInterceptors(theRequestDetails, theResource, theOldResource, theTransactionDetails, false);
        }
        Collection<Object> tagList = Collections.emptyList();
        if (entity.isHasTags()) {
            tagList = entity.getTags();
        }
        long version = entity.getVersion();
        this.myJpaStorageResourceParser.populateResourceMetadata((IBaseResourceEntity)entity, false, (Collection<? extends BaseTag>)tagList, version, theResource);
        boolean wasDeleted = false;
        if (theOldResource != null) {
            wasDeleted = theOldResource.isDeleted();
        }
        DaoMethodOutcome outcome = this.toMethodOutcome(theRequestDetails, (IBasePersistedResource)savedEntity, (IBaseResource)theResource, theMatchUrl, theOperationType).setCreated(Boolean.valueOf(wasDeleted));
        if (!thePerformIndexing) {
            IIdType id = this.getContext().getVersion().newIdType();
            id.setValue(entity.getIdDt().getValue());
            outcome.setId(id);
        }
        StopWatch w = null;
        if (theRequestDetails != null && !theRequestDetails.isSubRequest() && theTransactionDetails != null && !theTransactionDetails.isFhirTransaction()) {
            w = new StopWatch(theTransactionDetails.getTransactionDate());
        }
        this.populateOperationOutcomeForUpdate(w, outcome, theMatchUrl, outcome.getOperationType());
        return outcome;
    }

    private void notifyInterceptors(RequestDetails theRequestDetails, T theResource, IBaseResource theOldResource, TransactionDetails theTransactionDetails, boolean isUnchanged) {
        Pointcut interceptorPointcut = Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED;
        HookParams hookParams = new HookParams().add(IBaseResource.class, (Object)theOldResource).add(IBaseResource.class, theResource).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails);
        if (!isUnchanged) {
            hookParams.add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED));
            interceptorPointcut = Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED;
        }
        this.doCallHooks(theTransactionDetails, theRequestDetails, interceptorPointcut, hookParams);
    }

    protected void addPidToResource(IResourceLookup<JpaPid> theEntity, IBaseResource theResource) {
        if (theResource instanceof IAnyResource) {
            IDao.RESOURCE_PID.put(theResource, (Object)((JpaPid)theEntity.getPersistentId()).getId());
        } else if (theResource instanceof IResource) {
            IDao.RESOURCE_PID.put(theResource, (Object)((JpaPid)theEntity.getPersistentId()).getId());
        }
    }

    private void validateChildReferenceTargetTypes(IBase theElement, String thePath) {
        if (theElement == null) {
            return;
        }
        BaseRuntimeElementDefinition def = this.myContext.getElementDefinition(theElement.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            return;
        }
        BaseRuntimeElementCompositeDefinition cdef = (BaseRuntimeElementCompositeDefinition)def;
        for (BaseRuntimeChildDefinition nextChildDef : cdef.getChildren()) {
            List values = nextChildDef.getAccessor().getValues(theElement);
            if (values == null || values.isEmpty()) continue;
            String newPath = thePath + "." + nextChildDef.getElementName();
            for (IBase nextChild : values) {
                this.validateChildReferenceTargetTypes(nextChild, newPath);
            }
            if (!(nextChildDef instanceof RuntimeChildResourceDefinition)) continue;
            RuntimeChildResourceDefinition nextChildDefRes = (RuntimeChildResourceDefinition)nextChildDef;
            HashSet<String> validTypes = new HashSet<String>();
            boolean allowAny = false;
            for (Class nextValidType : nextChildDefRes.getResourceTypes()) {
                if (nextValidType.isInterface()) {
                    allowAny = true;
                    break;
                }
                validTypes.add(this.getContext().getResourceType(nextValidType));
            }
            if (allowAny || !this.getStorageSettings().isEnforceReferenceTargetTypes()) continue;
            for (IBase nextChild : values) {
                IBaseReference nextRef = (IBaseReference)nextChild;
                IIdType referencedId = nextRef.getReferenceElement();
                if (StringUtils.isBlank((CharSequence)referencedId.getResourceType()) || this.isLogicalReference(referencedId) || referencedId.getValue().contains("?") || validTypes.contains(referencedId.getResourceType())) continue;
                throw new UnprocessableEntityException(Msg.code((int)931) + "Invalid reference found at path '" + newPath + "'. Resource type '" + referencedId.getResourceType() + "' is not valid for this path");
            }
        }
    }

    protected void validateMetaCount(int theMetaCount) {
        if (this.myStorageSettings.getResourceMetaCountHardLimit() != null && theMetaCount > this.myStorageSettings.getResourceMetaCountHardLimit()) {
            throw new UnprocessableEntityException(Msg.code((int)932) + "Resource contains " + theMetaCount + " meta entries (tag/profile/security label), maximum is " + this.myStorageSettings.getResourceMetaCountHardLimit());
        }
    }

    protected void validateResourceForStorage(T theResource, ResourceTable theEntityToSave) {
        IResource res;
        IBaseCoding tag = null;
        int totalMetaCount = 0;
        if (theResource instanceof IResource) {
            List profileList;
            res = (IResource)theResource;
            TagList tagList = (TagList)ResourceMetadataKeyEnum.TAG_LIST.get((IBaseResource)res);
            if (tagList != null) {
                tag = tagList.getTag("http://hl7.org/fhir/v3/ObservationValue", "SUBSETTED");
                totalMetaCount += tagList.size();
            }
            if ((profileList = (List)ResourceMetadataKeyEnum.PROFILES.get((IBaseResource)res)) != null) {
                totalMetaCount += profileList.size();
            }
        } else {
            res = (IAnyResource)theResource;
            tag = res.getMeta().getTag("http://hl7.org/fhir/v3/ObservationValue", "SUBSETTED");
            totalMetaCount += res.getMeta().getTag().size();
            totalMetaCount += res.getMeta().getProfile().size();
            totalMetaCount += res.getMeta().getSecurity().size();
        }
        if (tag != null) {
            throw new UnprocessableEntityException(Msg.code((int)933) + "Resource contains the 'subsetted' tag, and must not be stored as it may contain a subset of available data");
        }
        if (this.getStorageSettings().isEnforceReferenceTargetTypes()) {
            String resName = this.getContext().getResourceType(theResource);
            this.validateChildReferenceTargetTypes((IBase)theResource, resName);
        }
        this.validateMetaCount(totalMetaCount);
    }

    @PostConstruct
    public void start() {
    }

    @VisibleForTesting
    public void setStorageSettingsForUnitTest(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    public void populateFullTextFields(FhirContext theContext, IBaseResource theResource, ResourceTable theEntity, ResourceIndexedSearchParams theNewParams) {
        if (theEntity.getDeleted() != null) {
            theEntity.setNarrativeText(null);
            theEntity.setContentText(null);
        } else {
            theEntity.setNarrativeText(BaseHapiFhirDao.parseNarrativeTextIntoWords(theResource));
            theEntity.setContentText(BaseHapiFhirDao.parseContentTextIntoWords(theContext, theResource));
            if (this.myStorageSettings.isAdvancedHSearchIndexing()) {
                ExtendedHSearchIndexData hSearchIndexData = this.myFulltextSearchSvc.extractLuceneIndexData(theResource, theNewParams);
                theEntity.setLuceneIndexData(hSearchIndexData);
            }
        }
    }

    @VisibleForTesting
    public void setPartitionSettingsForUnitTest(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    @VisibleForTesting
    public void setJpaStorageResourceParserForUnitTest(IJpaStorageResourceParser theJpaStorageResourceParser) {
        this.myJpaStorageResourceParser = theJpaStorageResourceParser;
    }

    @Nonnull
    public static MemoryCacheService.TagDefinitionCacheKey toTagDefinitionMemoryCacheKey(TagTypeEnum theTagType, String theScheme, String theTerm, String theVersion, Boolean theUserSelected) {
        return new MemoryCacheService.TagDefinitionCacheKey(theTagType, theScheme, theTerm, theVersion, theUserSelected);
    }

    public static String parseContentTextIntoWords(FhirContext theContext, IBaseResource theResource) {
        Class stringType = theContext.getElementDefinition("string").getImplementingClass();
        StringBuilder retVal = new StringBuilder();
        List childElements = theContext.newTerser().getAllPopulatedChildElementsOfType(theResource, stringType);
        for (IPrimitiveType nextType : childElements) {
            String nextValue;
            if (!stringType.equals(nextType.getClass()) || !StringUtils.isNotBlank((CharSequence)(nextValue = nextType.getValueAsString()))) continue;
            retVal.append(nextValue.replace("\n", " ").replace("\r", " "));
            retVal.append("\n");
        }
        return retVal.toString();
    }

    public static String decodeResource(byte[] theResourceBytes, ResourceEncodingEnum theResourceEncoding) {
        String resourceText = null;
        switch (theResourceEncoding) {
            case JSON: {
                resourceText = new String(theResourceBytes, Charsets.UTF_8);
                break;
            }
            case JSONC: {
                resourceText = GZipUtil.decompress((byte[])theResourceBytes);
                break;
            }
        }
        return resourceText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parseNarrativeTextIntoWords(IBaseResource theResource) {
        StringBuilder b = new StringBuilder();
        if (theResource instanceof IResource) {
            IResource resource = (IResource)theResource;
            List xmlEvents = XmlUtil.parse((String)resource.getText().getDiv().getValue());
            if (xmlEvents == null) return b.toString();
            for (XMLEvent next : xmlEvents) {
                if (!next.isCharacters()) continue;
                Characters characters = next.asCharacters();
                b.append(characters.getData()).append(" ");
            }
            return b.toString();
        } else {
            if (!(theResource instanceof IDomainResource)) return b.toString();
            IDomainResource resource = (IDomainResource)theResource;
            try {
                String divAsString = resource.getText().getDivAsString();
                List xmlEvents = XmlUtil.parse((String)divAsString);
                if (xmlEvents == null) return b.toString();
                for (XMLEvent next : xmlEvents) {
                    if (!next.isCharacters()) continue;
                    Characters characters = next.asCharacters();
                    b.append(characters.getData()).append(" ");
                }
                return b.toString();
            }
            catch (Exception e) {
                throw new DataFormatException(Msg.code((int)934) + "Unable to convert DIV to string", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public static void setDisableIncrementOnUpdateForUnitTest(boolean theDisableIncrementOnUpdateForUnitTest) {
        ourDisableIncrementOnUpdateForUnitTest = theDisableIncrementOnUpdateForUnitTest;
    }

    @VisibleForTesting
    public static void setValidationDisabledForUnitTest(boolean theValidationDisabledForUnitTest) {
        ourValidationDisabledForUnitTest = theValidationDisabledForUnitTest;
    }

    static {
        ourDisableIncrementOnUpdateForUnitTest = false;
    }

    private class AddTagDefinitionToCacheAfterCommitSynchronization
    implements TransactionSynchronization {
        private final TagDefinition myTagDefinition;
        private final MemoryCacheService.TagDefinitionCacheKey myKey;

        public AddTagDefinitionToCacheAfterCommitSynchronization(MemoryCacheService.TagDefinitionCacheKey theKey, TagDefinition theTagDefinition) {
            this.myTagDefinition = theTagDefinition;
            this.myKey = theKey;
        }

        public void afterCommit() {
            BaseHapiFhirDao.this.myMemoryCacheService.put(MemoryCacheService.CacheEnum.TAG_DEFINITION, (Object)this.myKey, (Object)this.myTagDefinition);
        }
    }

    private static enum CreateOrUpdateByMatch {
        CREATE,
        UPDATE;

    }
}

