/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.param.HistorySearchStyleEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoryBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(HistoryBuilder.class);
    private final String myResourceType;
    private final Long myResourceId;
    private final Date myRangeStartInclusive;
    private final Date myRangeEndInclusive;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private IIdHelperService myIdHelperService;

    public HistoryBuilder(@Nullable String theResourceType, @Nullable Long theResourceId, @Nullable Date theRangeStartInclusive, @Nullable Date theRangeEndInclusive) {
        this.myResourceType = theResourceType;
        this.myResourceId = theResourceId;
        this.myRangeStartInclusive = theRangeStartInclusive;
        this.myRangeEndInclusive = theRangeEndInclusive;
    }

    public Long fetchCount(RequestPartitionId thePartitionId) {
        CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(Long.class);
        Root from = criteriaQuery.from(ResourceHistoryTable.class);
        criteriaQuery.select((Selection)cb.count((Expression)from));
        this.addPredicatesToQuery(cb, thePartitionId, criteriaQuery, (Root<ResourceHistoryTable>)from, null);
        TypedQuery query = this.myEntityManager.createQuery(criteriaQuery);
        return (Long)query.getSingleResult();
    }

    public List<ResourceHistoryTable> fetchEntities(RequestPartitionId thePartitionId, Integer theOffset, int theFromIndex, int theToIndex, HistorySearchStyleEnum theHistorySearchStyle) {
        CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(ResourceHistoryTable.class);
        Root from = criteriaQuery.from(ResourceHistoryTable.class);
        this.addPredicatesToQuery(cb, thePartitionId, criteriaQuery, (Root<ResourceHistoryTable>)from, theHistorySearchStyle);
        from.fetch("myProvenance", JoinType.LEFT);
        criteriaQuery.orderBy(new Order[]{cb.desc((Expression)from.get("myUpdated")), cb.desc((Expression)from.get("myResourceId"))});
        TypedQuery query = this.myEntityManager.createQuery(criteriaQuery);
        int startIndex = theFromIndex;
        if (theOffset != null) {
            startIndex += theOffset.intValue();
        }
        query.setFirstResult(startIndex);
        query.setMaxResults(theToIndex - theFromIndex);
        List tables = query.getResultList();
        if (tables.size() > 0) {
            ImmutableListMultimap resourceIdToHistoryEntries = Multimaps.index((Iterable)tables, ResourceHistoryTable::getResourceId);
            Set pids = resourceIdToHistoryEntries.keySet().stream().map(JpaPid::fromId).collect(Collectors.toSet());
            PersistentIdToForcedIdMap pidToForcedId = this.myIdHelperService.translatePidsToForcedIds(pids);
            ourLog.trace("Translated IDs: {}", (Object)pidToForcedId.getResourcePersistentIdOptionalMap());
            for (Long nextResourceId : resourceIdToHistoryEntries.keySet()) {
                String resourceId;
                ImmutableList historyTables = resourceIdToHistoryEntries.get((Object)nextResourceId);
                Optional forcedId = pidToForcedId.get((IResourcePersistentId)JpaPid.fromId((Long)nextResourceId));
                if (forcedId.isPresent()) {
                    resourceId = (String)forcedId.get();
                    if (resourceId.startsWith(this.myResourceType + "/")) {
                        resourceId = resourceId.substring(this.myResourceType.length() + 1);
                    }
                } else {
                    resourceId = nextResourceId.toString();
                }
                for (ResourceHistoryTable nextHistoryTable : historyTables) {
                    nextHistoryTable.setTransientForcedId(resourceId);
                }
            }
        }
        return tables;
    }

    private void addPredicatesToQuery(CriteriaBuilder theCriteriaBuilder, RequestPartitionId thePartitionId, CriteriaQuery<?> theQuery, Root<ResourceHistoryTable> theFrom, HistorySearchStyleEnum theHistorySearchStyle) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!thePartitionId.isAllPartitions()) {
            if (thePartitionId.isDefaultPartition()) {
                predicates.add(theCriteriaBuilder.isNull((Expression)theFrom.get("myPartitionIdValue")));
            } else if (thePartitionId.hasDefaultPartitionId()) {
                predicates.add(theCriteriaBuilder.or((Expression)theCriteriaBuilder.isNull((Expression)theFrom.get("myPartitionIdValue")), (Expression)theFrom.get("myPartitionIdValue").in((Collection)thePartitionId.getPartitionIdsWithoutDefault())));
            } else {
                predicates.add(theFrom.get("myPartitionIdValue").in((Collection)thePartitionId.getPartitionIds()));
            }
        }
        if (this.myResourceId != null) {
            predicates.add(theCriteriaBuilder.equal((Expression)theFrom.get("myResourceId"), (Object)this.myResourceId));
        } else if (this.myResourceType != null) {
            this.validateNotSearchingAllPartitions(thePartitionId);
            predicates.add(theCriteriaBuilder.equal((Expression)theFrom.get("myResourceType"), (Object)this.myResourceType));
        } else {
            this.validateNotSearchingAllPartitions(thePartitionId);
        }
        if (this.myRangeStartInclusive != null) {
            if (HistorySearchStyleEnum.AT == theHistorySearchStyle && this.myResourceId != null) {
                this.addPredicateForAtQueryParameter(theCriteriaBuilder, theQuery, theFrom, predicates);
            } else {
                predicates.add(theCriteriaBuilder.greaterThanOrEqualTo((Expression)theFrom.get("myUpdated"), (Comparable)this.myRangeStartInclusive));
            }
        }
        if (this.myRangeEndInclusive != null) {
            predicates.add(theCriteriaBuilder.lessThanOrEqualTo((Expression)theFrom.get("myUpdated"), (Comparable)this.myRangeEndInclusive));
        }
        if (predicates.size() > 0) {
            theQuery.where(QueryParameterUtils.toPredicateArray(predicates));
        }
    }

    private void addPredicateForAtQueryParameter(CriteriaBuilder theCriteriaBuilder, CriteriaQuery<?> theQuery, Root<ResourceHistoryTable> theFrom, List<Predicate> thePredicates) {
        Subquery pastDateSubQuery = theQuery.subquery(Date.class);
        Root subQueryResourceHistory = pastDateSubQuery.from(ResourceHistoryTable.class);
        Expression myUpdatedMostRecent = theCriteriaBuilder.max((Expression)subQueryResourceHistory.get("myUpdated"));
        Expression myUpdatedMostRecentOrDefault = theCriteriaBuilder.coalesce(myUpdatedMostRecent, theCriteriaBuilder.literal((Object)this.myRangeStartInclusive));
        pastDateSubQuery.select(myUpdatedMostRecentOrDefault).where(new Predicate[]{theCriteriaBuilder.lessThanOrEqualTo((Expression)subQueryResourceHistory.get("myUpdated"), (Comparable)this.myRangeStartInclusive), theCriteriaBuilder.equal((Expression)subQueryResourceHistory.get("myResourceId"), (Object)this.myResourceId)});
        Predicate updatedDatePredicate = theCriteriaBuilder.greaterThanOrEqualTo((Expression)theFrom.get("myUpdated"), (Expression)pastDateSubQuery);
        thePredicates.add(updatedDatePredicate);
    }

    private void validateNotSearchingAllPartitions(RequestPartitionId thePartitionId) {
        if (this.myPartitionSettings.isPartitioningEnabled() && thePartitionId.isAllPartitions()) {
            String msg = this.myCtx.getLocalizer().getMessage(HistoryBuilder.class, "noSystemOrTypeHistoryForPartitionAwareServer", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)953) + msg);
        }
    }
}

