/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoPatient;
import ca.uhn.fhir.jpa.api.dao.PatientEverythingParameters;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JpaResourceDaoPatient<T extends IBaseResource>
extends BaseHapiFhirResourceDao<T>
implements IFhirResourceDaoPatient<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(JpaResourceDaoPatient.class);
    @Autowired
    private IRequestPartitionHelperSvc myPartitionHelperSvc;

    private IBundleProvider doEverythingOperation(TokenOrListParam theIds, IPrimitiveType<Integer> theCount, IPrimitiveType<Integer> theOffset, DateRangeParam theLastUpdated, SortSpec theSort, StringAndListParam theContent, StringAndListParam theNarrative, StringAndListParam theFilter, StringAndListParam theTypes, boolean theMdmExpand, RequestDetails theRequest) {
        SearchParameterMap paramMap = new SearchParameterMap();
        if (theCount != null) {
            paramMap.setCount((Integer)theCount.getValue());
        }
        if (theOffset != null) {
            paramMap.setOffset((Integer)theOffset.getValue());
        }
        if (theContent != null) {
            paramMap.add("_content", (IQueryParameterAnd)theContent);
        }
        if (theNarrative != null) {
            paramMap.add("_text", (IQueryParameterAnd)theNarrative);
        }
        if (theTypes != null) {
            paramMap.add("_type", (IQueryParameterAnd)theTypes);
        } else {
            paramMap.setIncludes(Collections.singleton(IResource.INCLUDE_ALL.asRecursive()));
        }
        paramMap.setEverythingMode(theIds != null && theIds.getValuesAsQueryTokens().size() == 1 ? SearchParameterMap.EverythingModeEnum.PATIENT_INSTANCE : SearchParameterMap.EverythingModeEnum.PATIENT_TYPE);
        paramMap.setSort(theSort);
        paramMap.setLastUpdated(theLastUpdated);
        if (theIds != null) {
            if (theMdmExpand) {
                theIds.getValuesAsQueryTokens().forEach(param -> param.setMdmExpand(true));
            }
            paramMap.add("_id", (IQueryParameterOr)theIds);
        }
        if (!this.isPagingProviderDatabaseBacked(theRequest)) {
            paramMap.setLoadSynchronous(true);
        }
        RequestPartitionId requestPartitionId = this.myPartitionHelperSvc.determineReadPartitionForRequestForSearchType(theRequest, this.getResourceName(), paramMap);
        this.adjustCount(theRequest, paramMap);
        return this.mySearchCoordinatorSvc.registerSearch((IFhirResourceDao)this, paramMap, this.getResourceName(), new CacheControlDirective().parse(theRequest.getHeaders("Cache-Control")), theRequest, requestPartitionId);
    }

    private void adjustCount(RequestDetails theRequest, SearchParameterMap theParamMap) {
        if (theRequest.getServer() == null) {
            return;
        }
        if (theParamMap.getCount() == null && theRequest.getServer().getDefaultPageSize() != null) {
            theParamMap.setCount(theRequest.getServer().getDefaultPageSize());
            return;
        }
        Integer maxPageSize = theRequest.getServer().getMaximumPageSize();
        if (maxPageSize != null && theParamMap.getCount() > maxPageSize) {
            ourLog.info("Reducing {} from {} to {} which is the maximum allowable page size.", new Object[]{"_count", theParamMap.getCount(), maxPageSize});
            theParamMap.setCount(maxPageSize);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IBundleProvider patientInstanceEverything(HttpServletRequest theServletRequest, RequestDetails theRequestDetails, PatientEverythingParameters theQueryParams, IIdType theId) {
        TokenOrListParam id = (TokenOrListParam)new TokenOrListParam().add((IQueryParameterType)new TokenParam(theId.getIdPart()));
        return this.doEverythingOperation(id, (IPrimitiveType<Integer>)theQueryParams.getCount(), (IPrimitiveType<Integer>)theQueryParams.getOffset(), theQueryParams.getLastUpdated(), theQueryParams.getSort(), theQueryParams.getContent(), theQueryParams.getNarrative(), theQueryParams.getFilter(), theQueryParams.getTypes(), theQueryParams.getMdmExpand(), theRequestDetails);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IBundleProvider patientTypeEverything(HttpServletRequest theServletRequest, RequestDetails theRequestDetails, PatientEverythingParameters theQueryParams, TokenOrListParam theId) {
        return this.doEverythingOperation(theId, (IPrimitiveType<Integer>)theQueryParams.getCount(), (IPrimitiveType<Integer>)theQueryParams.getOffset(), theQueryParams.getLastUpdated(), theQueryParams.getSort(), theQueryParams.getContent(), theQueryParams.getNarrative(), theQueryParams.getFilter(), theQueryParams.getTypes(), theQueryParams.getMdmExpand(), theRequestDetails);
    }
}

