/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.dao.IJpaStorageResourceParser;
import ca.uhn.fhir.jpa.dao.TolerantJsonParser;
import ca.uhn.fhir.jpa.dao.data.IResourceHistoryTableDao;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.entity.ResourceSearchView;
import ca.uhn.fhir.jpa.esr.ExternallyStoredResourceServiceRegistry;
import ca.uhn.fhir.jpa.esr.IExternallyStoredResourceService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.partition.IPartitionLookupSvc;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.util.IMetaTagSorter;
import ca.uhn.fhir.util.MetaUtil;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JpaStorageResourceParser
implements IJpaStorageResourceParser {
    public static final LenientErrorHandler LENIENT_ERROR_HANDLER = new LenientErrorHandler(false).disableAllErrors();
    private static final Logger ourLog = LoggerFactory.getLogger(JpaStorageResourceParser.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private IResourceHistoryTableDao myResourceHistoryTableDao;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private IPartitionLookupSvc myPartitionLookupSvc;
    @Autowired
    private ExternallyStoredResourceServiceRegistry myExternallyStoredResourceServiceRegistry;
    @Autowired
    IMetaTagSorter myMetaTagSorter;

    public IBaseResource toResource(IBasePersistedResource theEntity, boolean theForHistoryOperation) {
        RuntimeResourceDefinition type = this.myFhirContext.getResourceDefinition(theEntity.getResourceType());
        Class resourceType = type.getImplementingClass();
        return this.toResource(resourceType, (IBaseResourceEntity)theEntity, null, theForHistoryOperation);
    }

    @Override
    public <R extends IBaseResource> R toResource(Class<R> theResourceType, IBaseResourceEntity theEntity, Collection<ResourceTag> theTagList, boolean theForHistoryOperation) {
        long version;
        ResourceEncodingEnum resourceEncoding;
        String resourceText;
        byte[] resourceBytes;
        Collection<Object> tagList = Collections.emptyList();
        String provenanceSourceUri = null;
        String provenanceRequestId = null;
        if (theEntity instanceof ResourceHistoryTable) {
            ResourceHistoryTable history = (ResourceHistoryTable)theEntity;
            resourceBytes = history.getResource();
            resourceText = history.getResourceTextVc();
            resourceEncoding = history.getEncoding();
            switch (this.myStorageSettings.getTagStorageMode()) {
                default: {
                    if (!history.isHasTags()) break;
                    tagList = history.getTags();
                    break;
                }
                case NON_VERSIONED: {
                    if (!history.getResourceTable().isHasTags()) break;
                    tagList = history.getResourceTable().getTags();
                    break;
                }
                case INLINE: {
                    tagList = null;
                }
            }
            version = history.getVersion();
            if (history.getProvenance() != null) {
                provenanceRequestId = history.getProvenance().getRequestId();
                provenanceSourceUri = history.getProvenance().getSourceUri();
            }
        } else if (theEntity instanceof ResourceTable) {
            ResourceHistoryTable history;
            ResourceTable resource = (ResourceTable)theEntity;
            if (resource.getCurrentVersionEntity() != null) {
                history = resource.getCurrentVersionEntity();
            } else {
                version = theEntity.getVersion();
                history = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(theEntity.getId(), version);
                ((ResourceTable)theEntity).setCurrentVersionEntity(history);
                while (history == null) {
                    if (version > 1L) {
                        history = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(theEntity.getId(), --version);
                        continue;
                    }
                    return null;
                }
            }
            resourceBytes = history.getResource();
            resourceEncoding = history.getEncoding();
            resourceText = history.getResourceTextVc();
            switch (this.myStorageSettings.getTagStorageMode()) {
                case VERSIONED: 
                case NON_VERSIONED: {
                    if (!resource.isHasTags()) break;
                    tagList = resource.getTags();
                    break;
                }
                case INLINE: {
                    tagList = null;
                }
            }
            version = history.getVersion();
            if (history.getProvenance() != null) {
                provenanceRequestId = history.getProvenance().getRequestId();
                provenanceSourceUri = history.getProvenance().getSourceUri();
            }
        } else if (theEntity instanceof ResourceSearchView) {
            ResourceSearchView view = (ResourceSearchView)theEntity;
            resourceBytes = view.getResource();
            resourceText = view.getResourceTextVc();
            resourceEncoding = view.getEncoding();
            version = view.getVersion();
            provenanceRequestId = view.getProvenanceRequestId();
            provenanceSourceUri = view.getProvenanceSourceUri();
            switch (this.myStorageSettings.getTagStorageMode()) {
                case VERSIONED: 
                case NON_VERSIONED: {
                    if (theTagList == null) break;
                    tagList = theTagList;
                    break;
                }
                case INLINE: {
                    tagList = null;
                }
            }
        } else {
            return null;
        }
        String decodedResourceText = JpaStorageResourceParser.decodedResourceText(resourceBytes, resourceText, resourceEncoding);
        Class<R> resourceType = this.determineTypeToParse(theResourceType, tagList);
        R retVal = this.parseResource(theEntity, resourceEncoding, decodedResourceText, resourceType);
        retVal = this.populateResourceMetadata(theEntity, theForHistoryOperation, (Collection<? extends BaseTag>)tagList, version, retVal);
        MetaUtil.populateResourceSource((FhirContext)this.myFhirContext, (String)provenanceSourceUri, (String)provenanceRequestId, retVal);
        this.populateResourcePartitionInformation(theEntity, retVal);
        this.myMetaTagSorter.sort(retVal.getMeta());
        return retVal;
    }

    private <R extends IBaseResource> void populateResourcePartitionInformation(IBaseResourceEntity theEntity, R retVal) {
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            PartitionablePartitionId partitionId = theEntity.getPartitionId();
            if (partitionId != null && partitionId.getPartitionId() != null) {
                PartitionEntity persistedPartition = this.myPartitionLookupSvc.getPartitionById(partitionId.getPartitionId());
                retVal.setUserData(Constants.RESOURCE_PARTITION_ID, (Object)persistedPartition.toRequestPartitionId());
            } else {
                retVal.setUserData(Constants.RESOURCE_PARTITION_ID, (Object)RequestPartitionId.defaultPartition());
            }
        }
    }

    private <R extends IBaseResource> R parseResource(IBaseResourceEntity theEntity, ResourceEncodingEnum theResourceEncoding, String theDecodedResourceText, Class<R> theResourceType) {
        IBaseResource retVal;
        if (theResourceEncoding == ResourceEncodingEnum.ESR) {
            int colonIndex = theDecodedResourceText.indexOf(58);
            Validate.isTrue((colonIndex > 0 ? 1 : 0) != 0, (String)"Invalid ESR address: %s", (Object[])new Object[]{theDecodedResourceText});
            String providerId = theDecodedResourceText.substring(0, colonIndex);
            String address = theDecodedResourceText.substring(colonIndex + 1);
            Validate.notBlank((CharSequence)providerId, (String)"No provider ID in ESR address: %s", (Object[])new Object[]{theDecodedResourceText});
            Validate.notBlank((CharSequence)address, (String)"No address in ESR address: %s", (Object[])new Object[]{theDecodedResourceText});
            IExternallyStoredResourceService provider = this.myExternallyStoredResourceServiceRegistry.getProvider(providerId);
            retVal = provider.fetchResource(address);
        } else if (theResourceEncoding != ResourceEncodingEnum.DEL) {
            TolerantJsonParser parser = new TolerantJsonParser(this.getContext(theEntity.getFhirVersion()), (IParserErrorHandler)LENIENT_ERROR_HANDLER, theEntity.getId());
            try {
                retVal = parser.parseResource(theResourceType, theDecodedResourceText);
            }
            catch (Exception e) {
                StringBuilder b = new StringBuilder();
                b.append("Failed to parse database resource[");
                b.append(this.myFhirContext.getResourceType(theResourceType));
                b.append("/");
                b.append(theEntity.getIdDt().getIdPart());
                b.append(" (pid ");
                b.append(theEntity.getId());
                b.append(", version ");
                b.append(theEntity.getFhirVersion().name());
                b.append("): ");
                b.append(e.getMessage());
                String msg = b.toString();
                ourLog.error(msg, (Throwable)e);
                throw new DataFormatException(Msg.code((int)928) + msg, (Throwable)e);
            }
        } else {
            retVal = (IBaseResource)this.myFhirContext.getResourceDefinition(theEntity.getResourceType()).newInstance();
        }
        return (R)retVal;
    }

    private <R extends IBaseResource> Class<R> determineTypeToParse(Class<R> theResourceType, @Nullable Collection<? extends BaseTag> tagList) {
        Class resourceType = theResourceType;
        if (tagList != null && this.myFhirContext.hasDefaultTypeForProfile()) {
            for (BaseTag baseTag : tagList) {
                Class newType;
                String profile;
                if (baseTag.getTag().getTagType() != TagTypeEnum.PROFILE || !StringUtils.isNotBlank((CharSequence)(profile = baseTag.getTag().getCode())) || (newType = this.myFhirContext.getDefaultTypeForProfile(profile)) == null || !theResourceType.isAssignableFrom(newType)) continue;
                ourLog.debug("Using custom type {} for profile: {}", (Object)newType.getName(), (Object)profile);
                resourceType = newType;
                break;
            }
        }
        return resourceType;
    }

    @Override
    public <R extends IBaseResource> R populateResourceMetadata(IBaseResourceEntity theEntitySource, boolean theForHistoryOperation, @Nullable Collection<? extends BaseTag> tagList, long theVersion, R theResourceTarget) {
        if (theResourceTarget instanceof IResource) {
            IResource res = (IResource)theResourceTarget;
            theResourceTarget = this.populateResourceMetadataHapi(theEntitySource, tagList, theForHistoryOperation, res, theVersion);
        } else {
            IAnyResource res = (IAnyResource)theResourceTarget;
            theResourceTarget = this.populateResourceMetadataRi(theEntitySource, tagList, theForHistoryOperation, res, theVersion);
        }
        return theResourceTarget;
    }

    private <R extends IResource> R populateResourceMetadataHapi(IBaseResourceEntity theEntity, @Nullable Collection<? extends BaseTag> theTagList, boolean theForHistoryOperation, R res, Long theVersion) {
        Object retVal = res;
        if (theEntity.getDeleted() != null) {
            retVal = res = (IResource)this.myFhirContext.getResourceDefinition((IBaseResource)res).newInstance();
            ResourceMetadataKeyEnum.DELETED_AT.put((IBaseResource)res, (Object)new InstantDt(theEntity.getDeleted()));
            if (theForHistoryOperation) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put((IBaseResource)res, (Object)BundleEntryTransactionMethodEnum.DELETE);
            }
        } else if (theForHistoryOperation) {
            Date updated;
            Date published = (Date)theEntity.getPublished().getValue();
            if (published.equals(updated = (Date)theEntity.getUpdated().getValue())) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put((IBaseResource)res, (Object)BundleEntryTransactionMethodEnum.POST);
            } else {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put((IBaseResource)res, (Object)BundleEntryTransactionMethodEnum.PUT);
            }
        }
        res.setId(theEntity.getIdDt().withVersion(theVersion.toString()));
        ResourceMetadataKeyEnum.VERSION.put((IBaseResource)res, (Object)Long.toString(theEntity.getVersion()));
        ResourceMetadataKeyEnum.PUBLISHED.put((IBaseResource)res, (Object)theEntity.getPublished());
        ResourceMetadataKeyEnum.UPDATED.put((IBaseResource)res, (Object)theEntity.getUpdated());
        IDao.RESOURCE_PID.put((IBaseResource)res, (Object)theEntity.getResourceId());
        if (theTagList != null && theEntity.isHasTags()) {
            TagList tagList = new TagList();
            ArrayList<IBaseCoding> securityLabels = new ArrayList<IBaseCoding>();
            ArrayList<IdDt> profiles = new ArrayList<IdDt>();
            for (BaseTag baseTag : theTagList) {
                TagDefinition nextTag = baseTag.getTag();
                switch (nextTag.getTagType()) {
                    case PROFILE: {
                        profiles.add(new IdDt(nextTag.getCode()));
                        break;
                    }
                    case SECURITY_LABEL: {
                        IBaseCoding secLabel = (IBaseCoding)this.myFhirContext.getVersion().newCodingDt();
                        secLabel.setSystem(nextTag.getSystem());
                        secLabel.setCode(nextTag.getCode());
                        secLabel.setDisplay(nextTag.getDisplay());
                        secLabel.setVersion(nextTag.getVersion());
                        Boolean userSelected = nextTag.getUserSelected();
                        if (userSelected != null) {
                            secLabel.setUserSelected(userSelected.booleanValue());
                        }
                        securityLabels.add(secLabel);
                        break;
                    }
                    case TAG: {
                        Tag e = new Tag(nextTag.getSystem(), nextTag.getCode(), nextTag.getDisplay());
                        e.setVersion(nextTag.getVersion());
                        e.setUserSelectedBoolean(nextTag.getUserSelected());
                        tagList.add(e);
                    }
                }
            }
            if (tagList.size() > 0) {
                ResourceMetadataKeyEnum.TAG_LIST.put((IBaseResource)res, (Object)tagList);
            }
            if (securityLabels.size() > 0) {
                ResourceMetadataKeyEnum.SECURITY_LABELS.put((IBaseResource)res, JpaStorageResourceParser.toBaseCodingList(securityLabels));
            }
            if (profiles.size() > 0) {
                ResourceMetadataKeyEnum.PROFILES.put((IBaseResource)res, profiles);
            }
        }
        return (R)retVal;
    }

    private <R extends IBaseResource> R populateResourceMetadataRi(IBaseResourceEntity theEntity, @Nullable Collection<? extends BaseTag> theTagList, boolean theForHistoryOperation, IAnyResource res, Long theVersion) {
        IAnyResource retVal = res;
        if (theEntity.getDeleted() != null) {
            retVal = res = (IAnyResource)this.myFhirContext.getResourceDefinition((IBaseResource)res).newInstance();
            ResourceMetadataKeyEnum.DELETED_AT.put((IBaseResource)res, (Object)new InstantDt(theEntity.getDeleted()));
            if (theForHistoryOperation) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put((IBaseResource)res, (Object)BundleEntryTransactionMethodEnum.DELETE);
            }
        } else if (theForHistoryOperation) {
            Date date;
            Date published = (Date)theEntity.getPublished().getValue();
            if (published.equals(date = (Date)theEntity.getUpdated().getValue())) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put((IBaseResource)res, (Object)BundleEntryTransactionMethodEnum.POST);
            } else {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put((IBaseResource)res, (Object)BundleEntryTransactionMethodEnum.PUT);
            }
        }
        res.getMeta().setLastUpdated(null);
        res.getMeta().setVersionId(null);
        this.updateResourceMetadata(theEntity, (IBaseResource)res);
        res.setId(res.getIdElement().withVersion(theVersion.toString()));
        res.getMeta().setLastUpdated(theEntity.getUpdatedDate());
        IDao.RESOURCE_PID.put((IBaseResource)res, (Object)theEntity.getResourceId());
        if (CollectionUtils.isNotEmpty(theTagList)) {
            res.getMeta().getTag().clear();
            res.getMeta().getProfile().clear();
            res.getMeta().getSecurity().clear();
            for (BaseTag baseTag : theTagList) {
                switch (baseTag.getTag().getTagType()) {
                    case PROFILE: {
                        res.getMeta().addProfile(baseTag.getTag().getCode());
                        break;
                    }
                    case SECURITY_LABEL: {
                        IBaseCoding sec = res.getMeta().addSecurity();
                        sec.setSystem(baseTag.getTag().getSystem());
                        sec.setCode(baseTag.getTag().getCode());
                        sec.setDisplay(baseTag.getTag().getDisplay());
                        break;
                    }
                    case TAG: {
                        IBaseCoding tag = res.getMeta().addTag();
                        tag.setSystem(baseTag.getTag().getSystem());
                        tag.setCode(baseTag.getTag().getCode());
                        tag.setDisplay(baseTag.getTag().getDisplay());
                        tag.setVersion(baseTag.getTag().getVersion());
                        Boolean userSelected = baseTag.getTag().getUserSelected();
                        if (!Objects.nonNull(userSelected)) break;
                        tag.setUserSelected(userSelected.booleanValue());
                    }
                }
            }
        }
        return (R)retVal;
    }

    @Override
    public void updateResourceMetadata(IBaseResourceEntity theEntitySource, IBaseResource theResourceTarget) {
        IdDt id = theEntitySource.getIdDt();
        if (this.myFhirContext.getVersion().getVersion().isRi()) {
            id = this.myFhirContext.getVersion().newIdType().setValue(id.getValue());
        }
        if (!id.hasResourceType()) {
            id = id.withResourceType(theEntitySource.getResourceType());
        }
        theResourceTarget.setId((IIdType)id);
        if (theResourceTarget instanceof IResource) {
            ResourceMetadataKeyEnum.VERSION.put((IBaseResource)((IResource)theResourceTarget), (Object)id.getVersionIdPart());
            ResourceMetadataKeyEnum.UPDATED.put((IBaseResource)((IResource)theResourceTarget), (Object)theEntitySource.getUpdated());
        } else {
            IBaseMetaType meta = theResourceTarget.getMeta();
            meta.setVersionId(id.getVersionIdPart());
            meta.setLastUpdated(theEntitySource.getUpdatedDate());
        }
    }

    private FhirContext getContext(FhirVersionEnum theVersion) {
        Validate.notNull((Object)theVersion, (String)"theVersion must not be null", (Object[])new Object[0]);
        if (theVersion == this.myFhirContext.getVersion().getVersion()) {
            return this.myFhirContext;
        }
        return FhirContext.forCached((FhirVersionEnum)theVersion);
    }

    private static String decodedResourceText(byte[] resourceBytes, String resourceText, ResourceEncodingEnum resourceEncoding) {
        String decodedResourceText = resourceText != null ? resourceText : BaseHapiFhirDao.decodeResource(resourceBytes, resourceEncoding);
        return decodedResourceText;
    }

    private static List<BaseCodingDt> toBaseCodingList(List<IBaseCoding> theSecurityLabels) {
        ArrayList<BaseCodingDt> retVal = new ArrayList<BaseCodingDt>(theSecurityLabels.size());
        for (IBaseCoding next : theSecurityLabels) {
            retVal.add((BaseCodingDt)next);
        }
        return retVal;
    }
}

