/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.dao.EncodedResource;
import ca.uhn.fhir.jpa.dao.GZipUtil;
import ca.uhn.fhir.jpa.dao.ResourceHistoryState;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.parser.IParser;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHistoryCalculator {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceHistoryCalculator.class);
    private static final HashFunction SHA_256 = Hashing.sha256();
    private final FhirContext myFhirContext;
    private final boolean myIsOracleDialect;

    public ResourceHistoryCalculator(FhirContext theFhirContext, boolean theIsOracleDialect) {
        this.myFhirContext = theFhirContext;
        this.myIsOracleDialect = theIsOracleDialect;
    }

    ResourceHistoryState calculateResourceHistoryState(IBaseResource theResource, ResourceEncodingEnum theEncoding, List<String> theExcludeElements) {
        HashCode hashCode;
        ResourceEncodingEnum encoding;
        byte[] resourceBinary;
        String resourceText;
        String encodedResource = this.encodeResource(theResource, theEncoding, theExcludeElements);
        if (this.myIsOracleDialect) {
            resourceText = null;
            resourceBinary = ResourceHistoryCalculator.getResourceBinary(theEncoding, encodedResource);
            encoding = theEncoding;
            hashCode = SHA_256.hashBytes(resourceBinary);
        } else {
            resourceText = encodedResource;
            resourceBinary = null;
            encoding = ResourceEncodingEnum.JSON;
            hashCode = SHA_256.hashUnencodedChars((CharSequence)encodedResource);
        }
        return new ResourceHistoryState(resourceText, resourceBinary, encoding, hashCode);
    }

    boolean conditionallyAlterHistoryEntity(ResourceTable theEntity, ResourceHistoryTable theHistoryEntity, String theResourceText) {
        if (!this.myIsOracleDialect) {
            ourLog.debug("Storing text of resource {} version {} as inline VARCHAR", (Object)theEntity.getResourceId(), (Object)theHistoryEntity.getVersion());
            theHistoryEntity.setResourceTextVc(theResourceText);
            theHistoryEntity.setResource(null);
            theHistoryEntity.setEncoding(ResourceEncodingEnum.JSON);
            return true;
        }
        return false;
    }

    boolean isResourceHistoryChanged(ResourceHistoryTable theCurrentHistoryVersion, @Nullable byte[] theResourceBinary, @Nullable String resourceText) {
        if (this.myIsOracleDialect) {
            return !Arrays.equals(theCurrentHistoryVersion.getResource(), theResourceBinary);
        }
        return !StringUtils.equals((CharSequence)theCurrentHistoryVersion.getResourceTextVc(), (CharSequence)resourceText);
    }

    String encodeResource(IBaseResource theResource, ResourceEncodingEnum theEncoding, List<String> theExcludeElements) {
        IParser parser = theEncoding.newParser(this.myFhirContext);
        parser.setDontEncodeElements(theExcludeElements);
        return parser.encodeResourceToString(theResource);
    }

    @Nonnull
    static byte[] getResourceBinary(ResourceEncodingEnum theEncoding, String theEncodedResource) {
        switch (theEncoding) {
            case JSON: {
                return theEncodedResource.getBytes(StandardCharsets.UTF_8);
            }
            case JSONC: {
                return GZipUtil.compress((String)theEncodedResource);
            }
        }
        return new byte[0];
    }

    void populateEncodedResource(EncodedResource theEncodedResource, String theEncodedResourceString, @Nullable byte[] theResourceBinary, ResourceEncodingEnum theEncoding) {
        if (this.myIsOracleDialect) {
            this.populateEncodedResourceInner(theEncodedResource, null, theResourceBinary, theEncoding);
        } else {
            this.populateEncodedResourceInner(theEncodedResource, theEncodedResourceString, null, ResourceEncodingEnum.JSON);
        }
    }

    private void populateEncodedResourceInner(EncodedResource encodedResource, String encodedResourceString, byte[] theResourceBinary, ResourceEncodingEnum theEncoding) {
        encodedResource.setResourceText(encodedResourceString);
        encodedResource.setResourceBinary(theResourceBinary);
        encodedResource.setEncoding(theEncoding);
    }
}

