/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import com.google.common.hash.HashCode;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class ResourceHistoryState {
    @Nullable
    private final String myResourceText;
    @Nullable
    private final byte[] myResourceBinary;
    private final ResourceEncodingEnum myEncoding;
    private final HashCode myHashCode;

    public ResourceHistoryState(@Nullable String theResourceText, @Nullable byte[] theResourceBinary, ResourceEncodingEnum theEncoding, HashCode theHashCode) {
        this.myResourceText = theResourceText;
        this.myResourceBinary = theResourceBinary;
        this.myEncoding = theEncoding;
        this.myHashCode = theHashCode;
    }

    @Nullable
    public String getResourceText() {
        return this.myResourceText;
    }

    @Nullable
    public byte[] getResourceBinary() {
        return this.myResourceBinary;
    }

    public ResourceEncodingEnum getEncoding() {
        return this.myEncoding;
    }

    public HashCode getHashCode() {
        return this.myHashCode;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        ResourceHistoryState that = (ResourceHistoryState)theO;
        return Objects.equals(this.myResourceText, that.myResourceText) && Arrays.equals(this.myResourceBinary, that.myResourceBinary) && this.myEncoding == that.myEncoding && Objects.equals(this.myHashCode, that.myHashCode);
    }

    public int hashCode() {
        int result = Objects.hash(this.myResourceText, this.myEncoding, this.myHashCode);
        result = 31 * result + Arrays.hashCode(this.myResourceBinary);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", ResourceHistoryState.class.getSimpleName() + "[", "]").add("myResourceText='" + this.myResourceText + "'").add("myResourceBinary=" + Arrays.toString(this.myResourceBinary)).add("myEncoding=" + this.myEncoding).add("myHashCode=" + this.myHashCode).toString();
    }
}

