/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.JsonParser;
import ca.uhn.fhir.parser.LenientErrorHandler;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TolerantJsonParser
extends JsonParser {
    private static final Logger ourLog = LoggerFactory.getLogger(TolerantJsonParser.class);
    private final FhirContext myContext;
    private final Long myResourcePid;

    public TolerantJsonParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler, Long theResourcePid) {
        super(theContext, theParserErrorHandler);
        this.myContext = theContext;
        this.myResourcePid = theResourcePid;
    }

    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, String theMessageString) {
        try {
            return (T)super.parseResource(theResourceType, theMessageString);
        }
        catch (DataFormatException e) {
            String msg = StringUtils.defaultString((String)e.getMessage(), (String)"");
            if (msg.contains("Unexpected character ('.' (code 46))") || msg.contains("Invalid numeric value: Leading zeroes not allowed")) {
                Gson gson = new Gson();
                JsonObject object = (JsonObject)gson.fromJson(theMessageString, JsonObject.class);
                String corrected = gson.toJson((JsonElement)object);
                IBaseResource parsed = super.parseResource(theResourceType, corrected);
                this.myContext.newTerser().visit((IBase)parsed, (theElement, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath) -> {
                    BaseRuntimeElementDefinition def = (BaseRuntimeElementDefinition)theElementDefinitionPath.get(theElementDefinitionPath.size() - 1);
                    if (def.getName().equals("decimal")) {
                        IPrimitiveType decimal = (IPrimitiveType)theElement;
                        String oldValue = decimal.getValueAsString();
                        String newValue = ((BigDecimal)decimal.getValue()).toPlainString();
                        ourLog.warn("Correcting invalid previously saved decimal number for Resource[pid={}] - Was {} and now is {}", new Object[]{Objects.isNull(this.myResourcePid) ? "" : this.myResourcePid, oldValue, newValue});
                        decimal.setValueAsString(newValue);
                    }
                    return true;
                });
                return (T)parsed;
            }
            throw e;
        }
    }

    public static TolerantJsonParser createWithLenientErrorHandling(FhirContext theContext, @Nullable Long theResourcePid) {
        LenientErrorHandler errorHandler = new LenientErrorHandler(false).disableAllErrors();
        return new TolerantJsonParser(theContext, (IParserErrorHandler)errorHandler, theResourcePid);
    }
}

