/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.config.HapiFhirHibernateJpaDialect;
import ca.uhn.fhir.jpa.dao.BaseTransactionProcessor;
import ca.uhn.fhir.jpa.dao.EntriesToProcessMap;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.jpa.dao.IdSubstitutionMap;
import ca.uhn.fhir.jpa.dao.MatchResourceUrlService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.internal.SessionImpl;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class TransactionProcessor
extends BaseTransactionProcessor {
    public static final Pattern SINGLE_PARAMETER_MATCH_URL_PATTERN = Pattern.compile("^[^?]+[?][a-z0-9-]+=[^&,]+$");
    private static final Logger ourLog = LoggerFactory.getLogger(TransactionProcessor.class);
    @Autowired
    private ApplicationContext myApplicationContext;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired(required=false)
    private HapiFhirHibernateJpaDialect myHapiFhirHibernateJpaDialect;
    @Autowired
    private IIdHelperService<JpaPid> myIdHelperService;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private MatchResourceUrlService<JpaPid> myMatchResourceUrlService;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionSvc;

    public void setEntityManagerForUnitTest(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    protected void validateDependencies() {
        super.validateDependencies();
        Validate.notNull((Object)this.myEntityManager);
    }

    @VisibleForTesting
    public void setFhirContextForUnitTest(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public void setStorageSettings(StorageSettings theStorageSettings) {
        this.myStorageSettings = (JpaStorageSettings)theStorageSettings;
        super.setStorageSettings(theStorageSettings);
    }

    protected EntriesToProcessMap doTransactionWriteOperations(RequestDetails theRequest, String theActionName, TransactionDetails theTransactionDetails, Set<IIdType> theAllIds, IdSubstitutionMap theIdSubstitutions, Map<IIdType, DaoMethodOutcome> theIdToPersistedOutcome, IBaseBundle theResponse, IdentityHashMap<IBase, Integer> theOriginalRequestOrder, List<IBase> theEntries, StopWatch theTransactionStopWatch) {
        ITransactionProcessorVersionAdapter versionAdapter = this.getVersionAdapter();
        RequestPartitionId requestPartitionId = super.determineRequestPartitionIdForWriteEntries(theRequest, theEntries);
        if (requestPartitionId != null) {
            this.preFetch(theTransactionDetails, theEntries, versionAdapter, requestPartitionId);
        }
        return super.doTransactionWriteOperations(theRequest, theActionName, theTransactionDetails, theAllIds, theIdSubstitutions, theIdToPersistedOutcome, theResponse, theOriginalRequestOrder, theEntries, theTransactionStopWatch);
    }

    private void preFetch(TransactionDetails theTransactionDetails, List<IBase> theEntries, ITransactionProcessorVersionAdapter theVersionAdapter, RequestPartitionId theRequestPartitionId) {
        HashSet<String> foundIds = new HashSet<String>();
        ArrayList<Long> idsToPreFetch = new ArrayList<Long>();
        this.preFetchResourcesById(theTransactionDetails, theEntries, theVersionAdapter, theRequestPartitionId, foundIds, idsToPreFetch);
        this.preFetchConditionalUrls(theTransactionDetails, theEntries, theVersionAdapter, theRequestPartitionId, idsToPreFetch);
        IFhirSystemDao systemDao = (IFhirSystemDao)this.myApplicationContext.getBean(IFhirSystemDao.class);
        systemDao.preFetchResources(JpaPid.fromLongList(idsToPreFetch), true);
    }

    private void preFetchResourcesById(TransactionDetails theTransactionDetails, List<IBase> theEntries, ITransactionProcessorVersionAdapter theVersionAdapter, RequestPartitionId theRequestPartitionId, Set<String> foundIds, List<Long> idsToPreFetch) {
        ArrayList<IIdType> idsToPreResolve = new ArrayList<IIdType>();
        for (IBase nextEntry : theEntries) {
            String requestUrl;
            String verb;
            IBaseResource iBaseResource = theVersionAdapter.getResource(nextEntry);
            if (iBaseResource == null || !"PUT".equals(verb = theVersionAdapter.getEntryRequestVerb(this.myFhirContext, nextEntry)) && !"PATCH".equals(verb) || StringUtils.countMatches((CharSequence)(requestUrl = theVersionAdapter.getEntryRequestUrl(nextEntry)), (char)'/') != 1 || StringUtils.countMatches((CharSequence)requestUrl, (char)'?') != 0) continue;
            IIdType id = this.myFhirContext.getVersion().newIdType();
            id.setValue(requestUrl);
            idsToPreResolve.add(id);
        }
        List outcome = this.myIdHelperService.resolveResourcePersistentIdsWithCache(theRequestPartitionId, idsToPreResolve).stream().collect(Collectors.toList());
        for (JpaPid jpaPid : outcome) {
            foundIds.add(jpaPid.getAssociatedResourceId().toUnqualifiedVersionless().getValue());
            theTransactionDetails.addResolvedResourceId(jpaPid.getAssociatedResourceId(), (IResourcePersistentId)jpaPid);
            if (this.myStorageSettings.getResourceClientIdStrategy() == JpaStorageSettings.ClientIdStrategyEnum.ANY && jpaPid.getAssociatedResourceId().isIdPartValidLong()) continue;
            idsToPreFetch.add(jpaPid.getId());
        }
        for (IIdType iIdType : idsToPreResolve) {
            if (foundIds.contains(iIdType.toUnqualifiedVersionless().getValue())) continue;
            theTransactionDetails.addResolvedResourceId(iIdType.toUnqualifiedVersionless(), null);
        }
    }

    private void preFetchConditionalUrls(TransactionDetails theTransactionDetails, List<IBase> theEntries, ITransactionProcessorVersionAdapter theVersionAdapter, RequestPartitionId theRequestPartitionId, List<Long> idsToPreFetch) {
        ArrayList<MatchUrlToResolve> searchParameterMapsToResolve = new ArrayList<MatchUrlToResolve>();
        for (IBase nextEntry : theEntries) {
            IBaseResource resource = theVersionAdapter.getResource(nextEntry);
            if (resource == null) continue;
            String verb = theVersionAdapter.getEntryRequestVerb(this.myFhirContext, nextEntry);
            String requestUrl = theVersionAdapter.getEntryRequestUrl(nextEntry);
            String requestIfNoneExist = theVersionAdapter.getEntryIfNoneExist(nextEntry);
            String resourceType = UrlUtil.determineResourceTypeInResourceUrl((FhirContext)this.myFhirContext, (String)requestUrl);
            if (resourceType == null && resource != null) {
                resourceType = this.myFhirContext.getResourceType(resource);
            }
            if (("PUT".equals(verb) || "PATCH".equals(verb)) && requestUrl != null && requestUrl.contains("?")) {
                this.preFetchConditionalUrl(resourceType, requestUrl, true, idsToPreFetch, searchParameterMapsToResolve);
            } else if ("POST".equals(verb) && requestIfNoneExist != null && requestIfNoneExist.contains("?")) {
                this.preFetchConditionalUrl(resourceType, requestIfNoneExist, false, idsToPreFetch, searchParameterMapsToResolve);
            }
            if (!this.myStorageSettings.isAllowInlineMatchUrlReferences()) continue;
            List references = this.myFhirContext.newTerser().getAllResourceReferences(resource);
            for (ResourceReferenceInfo next : references) {
                String referenceUrl = next.getResourceReference().getReferenceElement().getValue();
                String refResourceType = UrlUtil.determineResourceTypeInResourceUrl((FhirContext)this.myFhirContext, (String)referenceUrl);
                if (refResourceType == null) continue;
                this.preFetchConditionalUrl(refResourceType, referenceUrl, false, idsToPreFetch, searchParameterMapsToResolve);
            }
        }
        new QueryChunker().chunk(searchParameterMapsToResolve, 100, map -> this.preFetchSearchParameterMaps(theTransactionDetails, theRequestPartitionId, (List<MatchUrlToResolve>)map, idsToPreFetch));
    }

    private void preFetchSearchParameterMaps(TransactionDetails theTransactionDetails, RequestPartitionId theRequestPartitionId, List<MatchUrlToResolve> theInputParameters, List<Long> theOutputPidsToLoadFully) {
        HashSet<Long> systemAndValueHashes = new HashSet<Long>();
        HashSet<Long> valueHashes = new HashSet<Long>();
        for (MatchUrlToResolve next : theInputParameters) {
            List andList;
            IQueryParameterType param;
            Collection values = next.myMatchUrlSearchMap.values();
            if (values.size() != 1 || !((param = (IQueryParameterType)((List)(andList = (List)values.iterator().next()).get(0)).get(0)) instanceof TokenParam)) continue;
            this.buildHashPredicateFromTokenParam((TokenParam)param, theRequestPartitionId, next, systemAndValueHashes, valueHashes);
        }
        this.preFetchSearchParameterMapsToken("myHashSystemAndValue", systemAndValueHashes, theTransactionDetails, theRequestPartitionId, theInputParameters, theOutputPidsToLoadFully);
        this.preFetchSearchParameterMapsToken("myHashValue", valueHashes, theTransactionDetails, theRequestPartitionId, theInputParameters, theOutputPidsToLoadFully);
        if (!valueHashes.isEmpty() || !systemAndValueHashes.isEmpty()) {
            theInputParameters.stream().filter(match -> !match.myResolved).forEach(match -> {
                ourLog.debug("Was unable to match url {} from database", (Object)match.myRequestUrl);
                theTransactionDetails.addResolvedMatchUrl(this.myFhirContext, match.myRequestUrl, TransactionDetails.NOT_FOUND);
            });
        }
    }

    private void preFetchSearchParameterMapsToken(String theIndexColumnName, Set<Long> theHashesForIndexColumn, TransactionDetails theTransactionDetails, RequestPartitionId theRequestPartitionId, List<MatchUrlToResolve> theInputParameters, List<Long> theOutputPidsToLoadFully) {
        if (!theHashesForIndexColumn.isEmpty()) {
            ListMultimap<Long, MatchUrlToResolve> hashToSearchMap = this.buildHashToSearchMap(theInputParameters, theIndexColumnName);
            CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
            CriteriaQuery cq = cb.createTupleQuery();
            Root from = cq.from(ResourceIndexedSearchParamToken.class);
            cq.multiselect(new Selection[]{from.get("myResourcePid"), from.get(theIndexColumnName)});
            Predicate masterPredicate = theHashesForIndexColumn.size() == 1 ? cb.equal((Expression)from.get(theIndexColumnName), (Object)theHashesForIndexColumn.iterator().next()) : from.get(theIndexColumnName).in(theHashesForIndexColumn);
            if (this.myPartitionSettings.isPartitioningEnabled() && !this.myPartitionSettings.isIncludePartitionInSearchHashes()) {
                Predicate partitionIdCriteria;
                if (theRequestPartitionId.isDefaultPartition()) {
                    partitionIdCriteria = cb.isNull((Expression)from.get("myPartitionIdValue"));
                    masterPredicate = cb.and((Expression)partitionIdCriteria, (Expression)masterPredicate);
                } else if (!theRequestPartitionId.isAllPartitions()) {
                    partitionIdCriteria = from.get("myPartitionIdValue").in((Collection)theRequestPartitionId.getPartitionIds());
                    masterPredicate = cb.and((Expression)partitionIdCriteria, (Expression)masterPredicate);
                }
            }
            cq.where((Expression)masterPredicate);
            TypedQuery query = this.myEntityManager.createQuery(cq);
            query.setMaxResults(theHashesForIndexColumn.size() + 1);
            List results = query.getResultList();
            for (Tuple nextResult : results) {
                Long nextResourcePid = (Long)nextResult.get(0, Long.class);
                Long nextHash = (Long)nextResult.get(1, Long.class);
                List matchedSearch = hashToSearchMap.get((Object)nextHash);
                matchedSearch.forEach(matchUrl -> {
                    ourLog.debug("Matched url {} from database", (Object)matchUrl.myRequestUrl);
                    if (matchUrl.myShouldPreFetchResourceBody) {
                        theOutputPidsToLoadFully.add(nextResourcePid);
                    }
                    this.myMatchResourceUrlService.matchUrlResolved(theTransactionDetails, matchUrl.myResourceDefinition.getName(), matchUrl.myRequestUrl, (IResourcePersistentId)JpaPid.fromId((Long)nextResourcePid));
                    theTransactionDetails.addResolvedMatchUrl(this.myFhirContext, matchUrl.myRequestUrl, (IResourcePersistentId)JpaPid.fromId((Long)nextResourcePid));
                    matchUrl.setResolved(true);
                });
            }
        }
    }

    private void preFetchConditionalUrl(String theResourceType, String theRequestUrl, boolean theShouldPreFetchResourceBody, List<Long> theOutputIdsToPreFetch, List<MatchUrlToResolve> theOutputSearchParameterMapsToResolve) {
        JpaPid cachedId = (JpaPid)this.myMatchResourceUrlService.processMatchUrlUsingCacheOnly(theResourceType, theRequestUrl);
        if (cachedId != null) {
            if (theShouldPreFetchResourceBody) {
                theOutputIdsToPreFetch.add(cachedId.getId());
            }
        } else if (SINGLE_PARAMETER_MATCH_URL_PATTERN.matcher(theRequestUrl).matches()) {
            RuntimeResourceDefinition resourceDefinition = this.myFhirContext.getResourceDefinition(theResourceType);
            SearchParameterMap matchUrlSearchMap = this.myMatchUrlService.translateMatchUrl(theRequestUrl, resourceDefinition, new MatchUrlService.Flag[0]);
            theOutputSearchParameterMapsToResolve.add(new MatchUrlToResolve(theRequestUrl, matchUrlSearchMap, resourceDefinition, theShouldPreFetchResourceBody));
        }
    }

    @Nullable
    private void buildHashPredicateFromTokenParam(TokenParam theTokenParam, RequestPartitionId theRequestPartitionId, MatchUrlToResolve theMatchUrl, Set<Long> theSysAndValuePredicates, Set<Long> theValuePredicates) {
        if (StringUtils.isNotBlank((CharSequence)theTokenParam.getValue()) && StringUtils.isNotBlank((CharSequence)theTokenParam.getSystem())) {
            theMatchUrl.myHashSystemAndValue = ResourceIndexedSearchParamToken.calculateHashSystemAndValue((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)theRequestPartitionId, (String)theMatchUrl.myResourceDefinition.getName(), (String)((String)theMatchUrl.myMatchUrlSearchMap.keySet().iterator().next()), (String)theTokenParam.getSystem(), (String)theTokenParam.getValue());
            theSysAndValuePredicates.add(theMatchUrl.myHashSystemAndValue);
        } else if (StringUtils.isNotBlank((CharSequence)theTokenParam.getValue())) {
            theMatchUrl.myHashValue = ResourceIndexedSearchParamToken.calculateHashValue((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)theRequestPartitionId, (String)theMatchUrl.myResourceDefinition.getName(), (String)((String)theMatchUrl.myMatchUrlSearchMap.keySet().iterator().next()), (String)theTokenParam.getValue());
            theValuePredicates.add(theMatchUrl.myHashValue);
        }
    }

    private ListMultimap<Long, MatchUrlToResolve> buildHashToSearchMap(List<MatchUrlToResolve> searchParameterMapsToResolve, String theIndex) {
        ArrayListMultimap hashToSearch = ArrayListMultimap.create();
        for (MatchUrlToResolve nextSearchParameterMap : searchParameterMapsToResolve) {
            if (nextSearchParameterMap.myHashSystemAndValue != null && theIndex.equals("myHashSystemAndValue")) {
                hashToSearch.put((Object)nextSearchParameterMap.myHashSystemAndValue, (Object)nextSearchParameterMap);
            }
            if (nextSearchParameterMap.myHashValue == null || !theIndex.equals("myHashValue")) continue;
            hashToSearch.put((Object)nextSearchParameterMap.myHashValue, (Object)nextSearchParameterMap);
        }
        return hashToSearch;
    }

    protected void flushSession(Map<IIdType, DaoMethodOutcome> theIdToPersistedOutcome) {
        try {
            int updateCount;
            int insertionCount;
            SessionImpl session = (SessionImpl)this.myEntityManager.unwrap(SessionImpl.class);
            if (session != null) {
                insertionCount = session.getActionQueue().numberOfInsertions();
                updateCount = session.getActionQueue().numberOfUpdates();
            } else {
                insertionCount = -1;
                updateCount = -1;
            }
            StopWatch sw = new StopWatch();
            this.myEntityManager.flush();
            ourLog.debug("Session flush took {}ms for {} inserts and {} updates", new Object[]{sw.getMillis(), insertionCount, updateCount});
        }
        catch (PersistenceException e) {
            if (this.myHapiFhirHibernateJpaDialect != null) {
                List types = theIdToPersistedOutcome.keySet().stream().filter(t -> t != null).map(t -> t.getResourceType()).collect(Collectors.toList());
                String message = "Error flushing transaction with resource types: " + types;
                throw this.myHapiFhirHibernateJpaDialect.translate(e, message);
            }
            throw e;
        }
    }

    @VisibleForTesting
    public void setIdHelperServiceForUnitTest(IIdHelperService theIdHelperService) {
        this.myIdHelperService = theIdHelperService;
    }

    @VisibleForTesting
    public void setApplicationContextForUnitTest(ApplicationContext theAppCtx) {
        this.myApplicationContext = theAppCtx;
    }

    private static class MatchUrlToResolve {
        private final String myRequestUrl;
        private final SearchParameterMap myMatchUrlSearchMap;
        private final RuntimeResourceDefinition myResourceDefinition;
        private final boolean myShouldPreFetchResourceBody;
        public boolean myResolved;
        private Long myHashValue;
        private Long myHashSystemAndValue;

        public MatchUrlToResolve(String theRequestUrl, SearchParameterMap theMatchUrlSearchMap, RuntimeResourceDefinition theResourceDefinition, boolean theShouldPreFetchResourceBody) {
            this.myRequestUrl = theRequestUrl;
            this.myMatchUrlSearchMap = theMatchUrlSearchMap;
            this.myResourceDefinition = theResourceDefinition;
            this.myShouldPreFetchResourceBody = theShouldPreFetchResourceBody;
        }

        public void setResolved(boolean theResolved) {
            this.myResolved = theResolved;
        }
    }
}

