/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data.custom;

import ca.uhn.fhir.jpa.dao.data.custom.IForcedIdQueries;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class IResourceTableDaoImpl
implements IForcedIdQueries {
    @PersistenceContext
    private EntityManager myEntityManager;

    @Override
    public Collection<Object[]> findAndResolveByForcedIdWithNoTypeIncludeDeleted(String theResourceType, Collection<String> theForcedIds) {
        return this.findAndResolveByForcedIdWithNoType(theResourceType, theForcedIds, false);
    }

    @Override
    public Collection<Object[]> findAndResolveByForcedIdWithNoType(String theResourceType, Collection<String> theForcedIds, boolean theExcludeDeleted) {
        Object query = "SELECT t.myResourceType, t.myId, t.myFhirId, t.myDeleted, t.myPartitionIdValue, t.myPartitionDateValue FROM ResourceTable t WHERE t.myResourceType = :resource_type AND t.myFhirId IN ( :forced_id )";
        if (theExcludeDeleted) {
            query = (String)query + " AND t.myDeleted IS NULL";
        }
        return this.myEntityManager.createQuery((String)query).setParameter("resource_type", (Object)theResourceType).setParameter("forced_id", theForcedIds).getResultList();
    }

    @Override
    public Collection<Object[]> findAndResolveByForcedIdWithNoTypeInPartition(String theResourceType, Collection<String> theForcedIds, Collection<Integer> thePartitionId, boolean theExcludeDeleted) {
        Object query = "SELECT t.myResourceType, t.myId, t.myFhirId, t.myDeleted, t.myPartitionIdValue, t.myPartitionDateValue FROM ResourceTable t WHERE t.myResourceType = :resource_type AND t.myFhirId IN ( :forced_id ) AND t.myPartitionIdValue IN ( :partition_id )";
        if (theExcludeDeleted) {
            query = (String)query + " AND t.myDeleted IS NULL";
        }
        return this.myEntityManager.createQuery((String)query).setParameter("resource_type", (Object)theResourceType).setParameter("forced_id", theForcedIds).setParameter("partition_id", thePartitionId).getResultList();
    }

    @Override
    public Collection<Object[]> findAndResolveByForcedIdWithNoTypeInPartitionNull(String theResourceType, Collection<String> theForcedIds, boolean theExcludeDeleted) {
        Object query = "SELECT t.myResourceType, t.myId, t.myFhirId, t.myDeleted, t.myPartitionIdValue, t.myPartitionDateValue FROM ResourceTable t WHERE t.myResourceType = :resource_type AND t.myFhirId IN ( :forced_id ) AND t.myPartitionIdValue IS NULL";
        if (theExcludeDeleted) {
            query = (String)query + " AND t.myDeleted IS NULL";
        }
        return this.myEntityManager.createQuery((String)query).setParameter("resource_type", (Object)theResourceType).setParameter("forced_id", theForcedIds).getResultList();
    }

    @Override
    public Collection<Object[]> findAndResolveByForcedIdWithNoTypeInPartitionIdOrNullPartitionId(String theResourceType, Collection<String> theForcedIds, List<Integer> thePartitionIdsWithoutDefault, boolean theExcludeDeleted) {
        Object query = "SELECT t.myResourceType, t.myId, t.myFhirId, t.myDeleted, t.myPartitionIdValue, t.myPartitionDateValue FROM ResourceTable t WHERE t.myResourceType = :resource_type AND t.myFhirId IN ( :forced_id ) AND (t.myPartitionIdValue IS NULL OR t.myPartitionIdValue IN ( :partition_id ))";
        if (theExcludeDeleted) {
            query = (String)query + " AND t.myDeleted IS NULL";
        }
        return this.myEntityManager.createQuery((String)query).setParameter("resource_type", (Object)theResourceType).setParameter("forced_id", theForcedIds).setParameter("partition_id", thePartitionIdsWithoutDefault).getResultList();
    }
}

