/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedComboStringUniqueDao;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndex;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.util.AddRemoveCount;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaoSearchParamSynchronizer {
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private IResourceIndexedComboStringUniqueDao myResourceIndexedCompositeStringUniqueDao;
    @Autowired
    private FhirContext myFhirContext;

    public AddRemoveCount synchronizeSearchParamsToDatabase(ResourceIndexedSearchParams theParams, ResourceTable theEntity, ResourceIndexedSearchParams existingParams) {
        AddRemoveCount retVal = new AddRemoveCount();
        this.synchronize(theEntity, retVal, theParams.myStringParams, existingParams.myStringParams, null);
        this.synchronize(theEntity, retVal, theParams.myTokenParams, existingParams.myTokenParams, null);
        this.synchronize(theEntity, retVal, theParams.myNumberParams, existingParams.myNumberParams, null);
        this.synchronize(theEntity, retVal, theParams.myQuantityParams, existingParams.myQuantityParams, null);
        this.synchronize(theEntity, retVal, theParams.myQuantityNormalizedParams, existingParams.myQuantityNormalizedParams, null);
        this.synchronize(theEntity, retVal, theParams.myDateParams, existingParams.myDateParams, null);
        this.synchronize(theEntity, retVal, theParams.myUriParams, existingParams.myUriParams, null);
        this.synchronize(theEntity, retVal, theParams.myCoordsParams, existingParams.myCoordsParams, null);
        this.synchronize(theEntity, retVal, theParams.myLinks, existingParams.myLinks, null);
        this.synchronize(theEntity, retVal, theParams.myComboTokenNonUnique, existingParams.myComboTokenNonUnique, null);
        this.synchronize(theEntity, retVal, theParams.myComboStringUniques, existingParams.myComboStringUniques, new UniqueIndexPreExistenceChecker());
        theEntity.setResourceLinks(theParams.myLinks);
        return retVal;
    }

    @VisibleForTesting
    public void setEntityManager(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    @VisibleForTesting
    public void setStorageSettings(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    private <T extends BaseResourceIndex> void synchronize(ResourceTable theEntity, AddRemoveCount theAddRemoveCount, Collection<T> theNewParams, Collection<T> theExistingParams, @Nullable IPreSaveHook<T> theAddParamPreSaveHook) {
        Collection<T> newParams = theNewParams;
        for (BaseResourceIndex next : newParams) {
            next.setPartitionId(theEntity.getPartitionId());
            next.calculateHashes();
        }
        HashSet<BaseResourceIndex> existingParamsAsSet = new HashSet<BaseResourceIndex>(theExistingParams.size());
        Iterator<T> iterator = theExistingParams.iterator();
        while (iterator.hasNext()) {
            BaseResourceIndex next = (BaseResourceIndex)iterator.next();
            next.setPlaceholderHashesIfMissing();
            if (existingParamsAsSet.add(next)) continue;
            iterator.remove();
            this.myEntityManager.remove((Object)next);
        }
        newParams = new HashSet<T>(newParams);
        List<BaseResourceIndex> paramsToRemove = DaoSearchParamSynchronizer.subtract(theExistingParams, newParams);
        List<BaseResourceIndex> paramsToAdd = DaoSearchParamSynchronizer.subtract(newParams, theExistingParams);
        if (theAddParamPreSaveHook != null) {
            theAddParamPreSaveHook.preSave(paramsToRemove, paramsToAdd);
        }
        this.tryToReuseIndexEntities(paramsToRemove, paramsToAdd);
        this.updateExistingParamsIfRequired(theExistingParams, paramsToAdd, newParams, paramsToRemove);
        for (BaseResourceIndex next : paramsToRemove) {
            if (!this.myEntityManager.contains((Object)next)) continue;
            this.myEntityManager.remove((Object)next);
        }
        for (BaseResourceIndex next : paramsToAdd) {
            this.myEntityManager.merge((Object)next);
        }
        theAddRemoveCount.addToAddCount(paramsToAdd.size());
        theAddRemoveCount.addToRemoveCount(paramsToRemove.size());
    }

    private <T extends BaseResourceIndex> void updateExistingParamsIfRequired(Collection<T> theExistingParams, List<T> theParamsToAdd, Collection<T> theNewParams, List<T> theParamsToRemove) {
        theExistingParams.stream().filter(BaseResourceIndexedSearchParam.class::isInstance).map(BaseResourceIndexedSearchParam.class::cast).filter(this::isSearchParameterUpdateRequired).filter(sp -> !theParamsToAdd.contains(sp)).filter(sp -> !theParamsToRemove.contains(sp)).forEach(sp -> {
            sp.setUpdated(new Date());
            this.recoverExistingSearchParameterIfRequired((BaseResourceIndexedSearchParam)sp, theNewParams);
            theParamsToAdd.add(sp);
        });
    }

    private <T extends BaseResourceIndex> void recoverExistingSearchParameterIfRequired(BaseResourceIndexedSearchParam theSearchParamToRecover, Collection<T> theNewParams) {
        if (!this.myStorageSettings.isIndexStorageOptimized()) {
            theNewParams.stream().filter(BaseResourceIndexedSearchParam.class::isInstance).map(BaseResourceIndexedSearchParam.class::cast).filter(paramToAdd -> paramToAdd.equals((Object)theSearchParamToRecover)).findFirst().ifPresent(newParam -> {
                theSearchParamToRecover.restoreParamName(newParam.getParamName());
                theSearchParamToRecover.setResourceType(newParam.getResourceType());
            });
        }
    }

    private boolean isSearchParameterUpdateRequired(BaseResourceIndexedSearchParam theSearchParameter) {
        return this.myStorageSettings.isIndexStorageOptimized() && !theSearchParameter.isIndexStorageOptimized() || !this.myStorageSettings.isIndexStorageOptimized() && theSearchParameter.isIndexStorageOptimized();
    }

    private <T extends BaseResourceIndex> void tryToReuseIndexEntities(List<T> theIndexesToRemove, List<T> theIndexesToAdd) {
        for (int addIndex = 0; addIndex < theIndexesToAdd.size() && !theIndexesToRemove.isEmpty(); ++addIndex) {
            BaseResourceIndex targetEntity = (BaseResourceIndex)theIndexesToAdd.get(addIndex);
            if (targetEntity.getId() != null) continue;
            BaseResourceIndex entityToReuse = (BaseResourceIndex)theIndexesToRemove.remove(theIndexesToRemove.size() - 1);
            entityToReuse.copyMutableValuesFrom(targetEntity);
            theIndexesToAdd.set(addIndex, entityToReuse);
        }
    }

    public static <T> List<T> subtract(Collection<T> theSubtractFrom, Collection<T> theToSubtract) {
        assert (theSubtractFrom != theToSubtract || theSubtractFrom.isEmpty());
        if (theSubtractFrom.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> retVal = new ArrayList<T>();
        for (T next : theSubtractFrom) {
            if (theToSubtract.contains(next)) continue;
            retVal.add(next);
        }
        return retVal;
    }

    private static interface IPreSaveHook<T> {
        public void preSave(Collection<T> var1, Collection<T> var2);
    }

    private class UniqueIndexPreExistenceChecker
    implements IPreSaveHook<ResourceIndexedComboStringUnique> {
        private UniqueIndexPreExistenceChecker() {
        }

        @Override
        public void preSave(Collection<ResourceIndexedComboStringUnique> theParamsToRemove, Collection<ResourceIndexedComboStringUnique> theParamsToAdd) {
            if (DaoSearchParamSynchronizer.this.myStorageSettings.isUniqueIndexesCheckedBeforeSave()) {
                for (ResourceIndexedComboStringUnique theIndex : theParamsToAdd) {
                    ResourceIndexedComboStringUnique existing = DaoSearchParamSynchronizer.this.myResourceIndexedCompositeStringUniqueDao.findByQueryString(theIndex.getIndexString());
                    if (existing == null) continue;
                    boolean existingIndexIsScheduledForRemoval = false;
                    for (ResourceIndexedComboStringUnique next : theParamsToRemove) {
                        if (existing != next) continue;
                        existingIndexIsScheduledForRemoval = true;
                        break;
                    }
                    if (existingIndexIsScheduledForRemoval) continue;
                    String searchParameterId = "(unknown)";
                    if (theIndex.getSearchParameterId() != null) {
                        searchParameterId = theIndex.getSearchParameterId().getValue();
                    }
                    String msg = DaoSearchParamSynchronizer.this.myFhirContext.getLocalizer().getMessage(BaseHapiFhirDao.class, "uniqueIndexConflictFailure", new Object[]{existing.getResource().getResourceType(), theIndex.getIndexString(), existing.getResource().getIdDt().toUnqualifiedVersionless().getValue(), searchParameterId});
                    throw new ResourceVersionConflictException(Msg.code((int)1093) + msg);
                }
            }
        }
    }
}

