/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.search.PathContext;
import ca.uhn.fhir.jpa.dao.search.TermHelper;
import ca.uhn.fhir.jpa.model.entity.NormalizedQuantitySearchLevel;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.util.DateUtils;
import ca.uhn.fhir.util.NumericParamRangeUtil;
import ca.uhn.fhir.util.StringUtil;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.WildcardPredicateOptionsStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedHSearchClauseBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(ExtendedHSearchClauseBuilder.class);
    private static final double QTY_APPROX_TOLERANCE_PERCENT = 0.1;
    public static final String PATH_JOINER = ".";
    final FhirContext myFhirContext;
    public final BooleanPredicateClausesStep<?> myRootClause;
    public final StorageSettings myStorageSettings;
    final PathContext myRootContext;
    final List<TemporalPrecisionEnum> ordinalSearchPrecisions = Arrays.asList(TemporalPrecisionEnum.YEAR, TemporalPrecisionEnum.MONTH, TemporalPrecisionEnum.DAY);

    public ExtendedHSearchClauseBuilder(FhirContext myFhirContext, StorageSettings theStorageSettings, BooleanPredicateClausesStep<?> theRootClause, SearchPredicateFactory thePredicateFactory) {
        this.myFhirContext = myFhirContext;
        this.myStorageSettings = theStorageSettings;
        this.myRootClause = theRootClause;
        this.myRootContext = PathContext.buildRootContext(theRootClause, thePredicateFactory);
    }

    public void addResourceTypeClause(String theResourceType) {
        this.myRootClause.must((PredicateFinalStep)this.myRootContext.match().field("myResourceType").matching((Object)theResourceType));
    }

    @Nonnull
    private Set<String> extractOrStringParams(String theSearchParamName, List<? extends IQueryParameterType> nextAnd) {
        HashSet<String> terms = new HashSet<String>();
        for (IQueryParameterType iQueryParameterType : nextAnd) {
            String nextValueTrimmed;
            if (ExtendedHSearchClauseBuilder.isStringParamOrEquivalent(theSearchParamName, iQueryParameterType)) {
                nextValueTrimmed = this.getTrimmedStringValue(iQueryParameterType);
            } else if (iQueryParameterType instanceof TokenParam) {
                TokenParam nextOrToken = (TokenParam)iQueryParameterType;
                nextValueTrimmed = nextOrToken.getValue();
            } else if (iQueryParameterType instanceof ReferenceParam) {
                ReferenceParam referenceParam = (ReferenceParam)iQueryParameterType;
                nextValueTrimmed = referenceParam.getValue();
                if (nextValueTrimmed.contains("/_history")) {
                    nextValueTrimmed = nextValueTrimmed.substring(0, nextValueTrimmed.indexOf("/_history"));
                }
            } else {
                throw new IllegalArgumentException(Msg.code((int)1088) + "Unsupported full-text param type: " + iQueryParameterType.getClass());
            }
            if (!StringUtils.isNotBlank((CharSequence)nextValueTrimmed)) continue;
            terms.add(nextValueTrimmed);
        }
        return terms;
    }

    private String getTrimmedStringValue(IQueryParameterType nextOr) {
        String value;
        if (nextOr instanceof StringParam) {
            value = ((StringParam)nextOr).getValue();
        } else if (nextOr instanceof SpecialParam) {
            value = ((SpecialParam)nextOr).getValue();
        } else {
            throw new IllegalArgumentException(Msg.code((int)2535) + "Failed to extract value for fulltext search from parameter. Needs to be a `string` parameter, or `_text` or `_content` special parameter." + nextOr);
        }
        return StringUtils.defaultString((String)value).trim();
    }

    private static boolean isStringParamOrEquivalent(String theSearchParamName, IQueryParameterType nextOr) {
        List<String> specialSearchParamsToTreatAsStrings = List.of("_text", "_content");
        return nextOr instanceof StringParam || nextOr instanceof SpecialParam && specialSearchParamsToTreatAsStrings.contains(theSearchParamName);
    }

    public void addTokenUnmodifiedSearch(String theSearchParamName, List<List<IQueryParameterType>> theAndOrTerms) {
        if (CollectionUtils.isEmpty(theAndOrTerms)) {
            return;
        }
        PathContext spContext = this.contextForFlatSP(theSearchParamName);
        for (List<IQueryParameterType> nextAnd : theAndOrTerms) {
            ourLog.debug("addTokenUnmodifiedSearch {} {}", (Object)theSearchParamName, nextAnd);
            List clauses = nextAnd.stream().map(orTerm -> this.buildTokenUnmodifiedMatchOn((IQueryParameterType)orTerm, spContext)).collect(Collectors.toList());
            PredicateFinalStep finalClause = spContext.orPredicateOrSingle(clauses);
            this.myRootClause.must(finalClause);
        }
    }

    private PathContext contextForFlatSP(String theSearchParamName) {
        String path = PathContext.joinPath("sp", theSearchParamName);
        return this.myRootContext.forAbsolutePath(path);
    }

    private PredicateFinalStep buildTokenUnmodifiedMatchOn(IQueryParameterType orTerm, PathContext thePathContext) {
        String pathPrefix = thePathContext.getContextPath();
        if (orTerm instanceof TokenParam) {
            TokenParam token = (TokenParam)orTerm;
            if (StringUtils.isBlank((CharSequence)token.getSystem())) {
                return thePathContext.match().field(PathContext.joinPath(pathPrefix, "token", "code")).matching((Object)token.getValue());
            }
            if (StringUtils.isBlank((CharSequence)token.getValue())) {
                return thePathContext.match().field(PathContext.joinPath(pathPrefix, "token", "system")).matching((Object)token.getSystem());
            }
            return thePathContext.match().field(PathContext.joinPath(pathPrefix, "token", "code-system")).matching((Object)token.getValueAsQueryToken(this.myFhirContext));
        }
        if (orTerm instanceof StringParam) {
            StringParam string = (StringParam)orTerm;
            return thePathContext.match().field(PathContext.joinPath(pathPrefix, "token", "code")).matching((Object)string.getValue());
        }
        throw new IllegalArgumentException(Msg.code((int)1089) + "Unexpected param type for token search-param: " + orTerm.getClass().getName());
    }

    public void addStringTextSearch(String theSearchParamName, List<List<IQueryParameterType>> stringAndOrTerms) {
        String fieldName;
        if (CollectionUtils.isEmpty(stringAndOrTerms)) {
            return;
        }
        switch (theSearchParamName) {
            case "_content": {
                fieldName = "myContentText";
                break;
            }
            case "_text": {
                fieldName = "myNarrativeText";
                break;
            }
            default: {
                fieldName = PathContext.joinPath("sp", theSearchParamName, "string", "text");
            }
        }
        if (this.isContainsSearch(theSearchParamName, stringAndOrTerms)) {
            for (List<IQueryParameterType> nextOrList : stringAndOrTerms) {
                this.addPreciseMatchClauses(theSearchParamName, nextOrList, fieldName);
            }
        } else {
            for (List<IQueryParameterType> nextOrList : stringAndOrTerms) {
                this.addSimpleQueryMatchClauses(theSearchParamName, nextOrList, fieldName);
            }
        }
    }

    private void addSimpleQueryMatchClauses(String theSearchParamName, List<? extends IQueryParameterType> nextOrList, String fieldName) {
        Set<String> orTerms = TermHelper.makePrefixSearchTerm(this.extractOrStringParams(theSearchParamName, nextOrList));
        ourLog.debug("addStringTextSearch {}, {}", (Object)theSearchParamName, orTerms);
        if (!orTerms.isEmpty()) {
            String query = orTerms.stream().map(s -> "( " + s + " )").collect(Collectors.joining(" | "));
            this.myRootClause.must((PredicateFinalStep)this.myRootContext.simpleQueryString().field(fieldName).matching(query).defaultOperator(BooleanOperator.AND));
        } else {
            ourLog.warn("No Terms found in query parameter {}", nextOrList);
        }
    }

    private void addPreciseMatchClauses(String theSearchParamName, List<? extends IQueryParameterType> nextOrList, String fieldName) {
        Set<String> orTerms = TermHelper.makePrefixSearchTerm(this.extractOrStringParams(theSearchParamName, nextOrList));
        for (String orTerm : orTerms) {
            this.myRootClause.must((PredicateFinalStep)this.myRootContext.match().field(fieldName).matching((Object)orTerm));
        }
    }

    public void addStringExactSearch(String theSearchParamName, List<List<IQueryParameterType>> theStringAndOrTerms) {
        String fieldPath = PathContext.joinPath("sp", theSearchParamName, "string", "exact");
        for (List<IQueryParameterType> nextAnd : theStringAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(theSearchParamName, nextAnd);
            ourLog.debug("addStringExactSearch {} {}", (Object)theSearchParamName, terms);
            List orTerms = terms.stream().map(s -> this.myRootContext.match().field(fieldPath).matching(s)).collect(Collectors.toList());
            this.myRootClause.must(this.myRootContext.orPredicateOrSingle(orTerms));
        }
    }

    public void addStringContainsSearch(String theSearchParamName, List<List<IQueryParameterType>> theStringAndOrTerms) {
        String fieldPath = PathContext.joinPath("sp", theSearchParamName, "string", "norm");
        for (List<IQueryParameterType> nextAnd : theStringAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(theSearchParamName, nextAnd);
            ourLog.debug("addStringContainsSearch {} {}", (Object)theSearchParamName, terms);
            List orTerms = terms.stream().map(this::normalize).map(s -> this.myRootContext.wildcard().field(fieldPath).matching("*" + s + "*")).collect(Collectors.toList());
            this.myRootClause.must(this.myRootContext.orPredicateOrSingle(orTerms));
        }
    }

    @Nonnull
    private String normalize(String theString) {
        return StringUtil.normalizeStringForSearchIndexing((String)theString).toLowerCase(Locale.ROOT);
    }

    public void addStringUnmodifiedSearch(String theSearchParamName, List<List<IQueryParameterType>> theStringAndOrTerms) {
        PathContext context = this.contextForFlatSP(theSearchParamName);
        for (List<IQueryParameterType> nextOrList : theStringAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(theSearchParamName, nextOrList);
            ourLog.debug("addStringUnmodifiedSearch {} {}", (Object)theSearchParamName, terms);
            List orTerms = terms.stream().map(s -> this.buildStringUnmodifiedClause((String)s, context)).collect(Collectors.toList());
            this.myRootClause.must(context.orPredicateOrSingle(orTerms));
        }
    }

    private WildcardPredicateOptionsStep<?> buildStringUnmodifiedClause(String theString, PathContext theContext) {
        return theContext.wildcard().field(PathContext.joinPath(theContext.getContextPath(), "string", "norm")).matching(this.normalize(theString) + "*");
    }

    public void addReferenceUnchainedSearch(String theSearchParamName, List<List<IQueryParameterType>> theReferenceAndOrTerms) {
        String fieldPath = PathContext.joinPath("sp", theSearchParamName, "reference", "value");
        for (List<IQueryParameterType> nextAnd : theReferenceAndOrTerms) {
            Set<String> terms = this.extractOrStringParams(theSearchParamName, nextAnd);
            ourLog.trace("reference unchained search {}", terms);
            List orTerms = terms.stream().map(s -> this.myRootContext.match().field(fieldPath).matching(s)).collect(Collectors.toList());
            this.myRootClause.must(this.myRootContext.orPredicateOrSingle(orTerms));
        }
    }

    public void addDateUnmodifiedSearch(String theSearchParamName, List<List<IQueryParameterType>> theDateAndOrTerms) {
        for (List<IQueryParameterType> nextOrList : theDateAndOrTerms) {
            PathContext spContext = this.contextForFlatSP(theSearchParamName);
            List clauses = nextOrList.stream().map(d -> this.buildDateTermClause((IQueryParameterType)d, spContext)).collect(Collectors.toList());
            this.myRootClause.must(this.myRootContext.orPredicateOrSingle(clauses));
        }
    }

    private PredicateFinalStep buildDateTermClause(IQueryParameterType theQueryParameter, PathContext theSpContext) {
        DateParam dateParam = (DateParam)theQueryParameter;
        boolean isOrdinalSearch = this.ordinalSearchPrecisions.contains(dateParam.getPrecision());
        return isOrdinalSearch ? this.generateDateOrdinalSearchTerms(dateParam, theSpContext) : this.generateDateInstantSearchTerms(dateParam, theSpContext);
    }

    private PredicateFinalStep generateDateOrdinalSearchTerms(DateParam theDateParam, PathContext theSpContext) {
        List<RangePredicateOptionsStep> predicateSteps;
        int upperBoundAsOrdinal;
        String lowerOrdinalField = PathContext.joinPath(theSpContext.getContextPath(), "dt", "lower-ord");
        String upperOrdinalField = PathContext.joinPath(theSpContext.getContextPath(), "dt", "upper-ord");
        ParamPrefixEnum prefix = theDateParam.getPrefix();
        int lowerBoundAsOrdinal = upperBoundAsOrdinal = DateUtils.convertDateToDayInteger((Date)theDateParam.getValue());
        TemporalPrecisionEnum precision = theDateParam.getPrecision();
        if (precision == TemporalPrecisionEnum.YEAR || precision == TemporalPrecisionEnum.MONTH) {
            Pair completedDate = DateUtils.getCompletedDate((String)theDateParam.getValueAsString());
            lowerBoundAsOrdinal = Integer.parseInt(((String)completedDate.getLeft()).replace("-", ""));
            upperBoundAsOrdinal = Integer.parseInt(((String)completedDate.getRight()).replace("-", ""));
        }
        if (Objects.isNull(prefix) || prefix == ParamPrefixEnum.EQUAL) {
            predicateSteps = Arrays.asList(theSpContext.range().field(lowerOrdinalField).atLeast((Object)lowerBoundAsOrdinal), theSpContext.range().field(upperOrdinalField).atMost((Object)upperBoundAsOrdinal));
            BooleanPredicateClausesStep<?> booleanStep = theSpContext.bool();
            predicateSteps.forEach(arg_0 -> booleanStep.must(arg_0));
            return booleanStep;
        }
        if (ParamPrefixEnum.GREATERTHAN == prefix || ParamPrefixEnum.STARTS_AFTER == prefix) {
            return theSpContext.range().field(upperOrdinalField).greaterThan((Object)upperBoundAsOrdinal);
        }
        if (ParamPrefixEnum.GREATERTHAN_OR_EQUALS == prefix) {
            return theSpContext.range().field(upperOrdinalField).atLeast((Object)upperBoundAsOrdinal);
        }
        if (ParamPrefixEnum.LESSTHAN == prefix || ParamPrefixEnum.ENDS_BEFORE == prefix) {
            return theSpContext.range().field(lowerOrdinalField).lessThan((Object)lowerBoundAsOrdinal);
        }
        if (ParamPrefixEnum.LESSTHAN_OR_EQUALS == prefix) {
            return theSpContext.range().field(lowerOrdinalField).atMost((Object)lowerBoundAsOrdinal);
        }
        if (ParamPrefixEnum.NOT_EQUAL == prefix) {
            predicateSteps = Arrays.asList(theSpContext.range().field(upperOrdinalField).lessThan((Object)lowerBoundAsOrdinal), theSpContext.range().field(lowerOrdinalField).greaterThan((Object)upperBoundAsOrdinal));
            BooleanPredicateClausesStep<?> booleanStep = theSpContext.bool();
            predicateSteps.forEach(arg_0 -> booleanStep.should(arg_0));
            booleanStep.minimumShouldMatchNumber(1);
            return booleanStep;
        }
        throw new IllegalArgumentException(Msg.code((int)2255) + "Date search param does not support prefix of type: " + prefix);
    }

    private PredicateFinalStep generateDateInstantSearchTerms(DateParam theDateParam, PathContext theSpContext) {
        String lowerInstantField = PathContext.joinPath(theSpContext.getContextPath(), "dt", "lower");
        String upperInstantField = PathContext.joinPath(theSpContext.getContextPath(), "dt", "upper");
        ParamPrefixEnum prefix = (ParamPrefixEnum)ObjectUtils.defaultIfNull((Object)theDateParam.getPrefix(), (Object)ParamPrefixEnum.EQUAL);
        if (ParamPrefixEnum.NOT_EQUAL == prefix) {
            Instant dateInstant = theDateParam.getValue().toInstant();
            List<RangePredicateOptionsStep> predicateSteps = Arrays.asList(theSpContext.range().field(upperInstantField).lessThan((Object)dateInstant), theSpContext.range().field(lowerInstantField).greaterThan((Object)dateInstant));
            BooleanPredicateClausesStep<?> booleanStep = theSpContext.bool();
            predicateSteps.forEach(arg_0 -> booleanStep.should(arg_0));
            booleanStep.minimumShouldMatchNumber(1);
            return booleanStep;
        }
        DateRangeParam dateRange = new DateRangeParam(theDateParam);
        Instant lowerBoundAsInstant = Optional.ofNullable(dateRange.getLowerBound()).map(param -> param.getValue().toInstant()).orElse(null);
        Instant upperBoundAsInstant = Optional.ofNullable(dateRange.getUpperBound()).map(param -> param.getValue().toInstant()).orElse(null);
        if (prefix == ParamPrefixEnum.EQUAL) {
            List<RangePredicateOptionsStep> predicateSteps = Arrays.asList(theSpContext.range().field(lowerInstantField).atLeast((Object)lowerBoundAsInstant), theSpContext.range().field(upperInstantField).atMost((Object)upperBoundAsInstant));
            BooleanPredicateClausesStep booleanStep = theSpContext.bool();
            predicateSteps.forEach(arg_0 -> ((BooleanPredicateClausesStep)booleanStep).must(arg_0));
            return booleanStep;
        }
        if (ParamPrefixEnum.GREATERTHAN == prefix || ParamPrefixEnum.STARTS_AFTER == prefix) {
            return theSpContext.range().field(upperInstantField).greaterThan((Object)lowerBoundAsInstant);
        }
        if (ParamPrefixEnum.GREATERTHAN_OR_EQUALS == prefix) {
            return theSpContext.range().field(upperInstantField).atLeast((Object)lowerBoundAsInstant);
        }
        if (ParamPrefixEnum.LESSTHAN == prefix || ParamPrefixEnum.ENDS_BEFORE == prefix) {
            return theSpContext.range().field(lowerInstantField).lessThan((Object)upperBoundAsInstant);
        }
        if (ParamPrefixEnum.LESSTHAN_OR_EQUALS == prefix) {
            return theSpContext.range().field(lowerInstantField).atMost((Object)upperBoundAsInstant);
        }
        throw new IllegalArgumentException(Msg.code((int)2256) + "Date search param does not support prefix of type: " + prefix);
    }

    public void addQuantityUnmodifiedSearch(String theSearchParamName, List<List<IQueryParameterType>> theQuantityAndOrTerms) {
        for (List<IQueryParameterType> nextOrList : theQuantityAndOrTerms) {
            PredicateFinalStep nestedClause = this.myRootContext.buildPredicateInNestedContext(theSearchParamName, nextedContext -> {
                List orClauses = nextOrList.stream().map(quantityTerm -> this.buildQuantityTermClause((IQueryParameterType)quantityTerm, (PathContext)nextedContext)).collect(Collectors.toList());
                return nextedContext.orPredicateOrSingle(orClauses);
            });
            this.myRootClause.must(nestedClause);
        }
    }

    private BooleanPredicateClausesStep<?> buildQuantityTermClause(IQueryParameterType theQueryParameter, PathContext thePathContext) {
        QuantityParam canonicalQty;
        BooleanPredicateClausesStep quantityClause = thePathContext.bool();
        QuantityParam qtyParam = QuantityParam.toQuantityParam((IQueryParameterType)theQueryParameter);
        ParamPrefixEnum activePrefix = qtyParam.getPrefix() == null ? ParamPrefixEnum.EQUAL : qtyParam.getPrefix();
        String quantityElement = PathContext.joinPath(thePathContext.getContextPath(), "quantity");
        if (this.myStorageSettings.getNormalizedQuantitySearchLevel() == NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_SEARCH_SUPPORTED && (canonicalQty = UcumServiceUtil.toCanonicalQuantityOrNull((QuantityParam)qtyParam)) != null) {
            String valueFieldPath = PathContext.joinPath(quantityElement, "value-norm");
            quantityClause.must(this.buildNumericClause(valueFieldPath, activePrefix, canonicalQty.getValue(), thePathContext));
            quantityClause.must((PredicateFinalStep)thePathContext.match().field(PathContext.joinPath(quantityElement, "code-norm")).matching((Object)canonicalQty.getUnits()));
            return quantityClause;
        }
        String valueFieldPath = PathContext.joinPath(quantityElement, "value");
        quantityClause.must(this.buildNumericClause(valueFieldPath, activePrefix, qtyParam.getValue(), thePathContext));
        if (StringUtils.isNotBlank((CharSequence)qtyParam.getSystem())) {
            quantityClause.must((PredicateFinalStep)thePathContext.match().field(PathContext.joinPath(quantityElement, "system")).matching((Object)qtyParam.getSystem()));
        }
        if (StringUtils.isNotBlank((CharSequence)qtyParam.getUnits())) {
            quantityClause.must((PredicateFinalStep)thePathContext.match().field(PathContext.joinPath(quantityElement, "code")).matching((Object)qtyParam.getUnits()));
        }
        return quantityClause;
    }

    @Nonnull
    private PredicateFinalStep buildNumericClause(String valueFieldPath, ParamPrefixEnum thePrefix, BigDecimal theNumberValue, PathContext thePathContext) {
        RangePredicateOptionsStep predicate = null;
        double value = theNumberValue.doubleValue();
        Pair range = NumericParamRangeUtil.getRange((BigDecimal)theNumberValue);
        double approxTolerance = value * 0.1;
        ParamPrefixEnum activePrefix = thePrefix == null ? ParamPrefixEnum.EQUAL : thePrefix;
        switch (activePrefix) {
            case APPROXIMATE: {
                predicate = thePathContext.range().field(valueFieldPath).between((Object)(value - approxTolerance), (Object)(value + approxTolerance));
                break;
            }
            case EQUAL: {
                predicate = thePathContext.range().field(valueFieldPath).between((Object)((BigDecimal)range.getLeft()).doubleValue(), (Object)((BigDecimal)range.getRight()).doubleValue());
                break;
            }
            case GREATERTHAN: 
            case STARTS_AFTER: {
                predicate = thePathContext.range().field(valueFieldPath).greaterThan((Object)value);
                break;
            }
            case GREATERTHAN_OR_EQUALS: {
                predicate = thePathContext.range().field(valueFieldPath).atLeast((Object)value);
                break;
            }
            case LESSTHAN: 
            case ENDS_BEFORE: {
                predicate = thePathContext.range().field(valueFieldPath).lessThan((Object)value);
                break;
            }
            case LESSTHAN_OR_EQUALS: {
                predicate = thePathContext.range().field(valueFieldPath).atMost((Object)value);
                break;
            }
            case NOT_EQUAL: {
                RangePredicateOptionsStep negRange = thePathContext.range().field(valueFieldPath).between((Object)((BigDecimal)range.getLeft()).doubleValue(), (Object)((BigDecimal)range.getRight()).doubleValue());
                predicate = (PredicateFinalStep)thePathContext.bool().mustNot((PredicateFinalStep)negRange);
            }
        }
        Validate.notNull((Object)predicate, (String)"Unsupported prefix: %s", (Object[])new Object[]{thePrefix});
        return predicate;
    }

    public void addUriUnmodifiedSearch(String theParamName, List<List<IQueryParameterType>> theUriUnmodifiedAndOrTerms) {
        PathContext spContext = this.contextForFlatSP(theParamName);
        for (List<IQueryParameterType> nextOrList : theUriUnmodifiedAndOrTerms) {
            PredicateFinalStep orListPredicate = this.buildURIClause(nextOrList, spContext);
            this.myRootClause.must(orListPredicate);
        }
    }

    private PredicateFinalStep buildURIClause(List<IQueryParameterType> theOrList, PathContext thePathContext) {
        List orTerms = theOrList.stream().map(p -> ((UriParam)p).getValue()).collect(Collectors.toList());
        return thePathContext.terms().field(PathContext.joinPath(thePathContext.getContextPath(), "uri-value")).matchingAny(orTerms);
    }

    public void addNumberUnmodifiedSearch(String theParamName, List<List<IQueryParameterType>> theNumberUnmodifiedAndOrTerms) {
        PathContext pathContext = this.contextForFlatSP(theParamName);
        String fieldPath = PathContext.joinPath("sp", theParamName, "number-value");
        for (List<IQueryParameterType> nextOrList : theNumberUnmodifiedAndOrTerms) {
            List orTerms = nextOrList.stream().map(NumberParam.class::cast).map(orTerm -> this.buildNumericClause(fieldPath, orTerm.getPrefix(), orTerm.getValue(), pathContext)).collect(Collectors.toList());
            this.myRootClause.must(pathContext.orPredicateOrSingle(orTerms));
        }
    }

    private PredicateFinalStep buildNumericClause(IQueryParameterType theValue, PathContext thePathContext) {
        NumberParam p = (NumberParam)theValue;
        return this.buildNumericClause(PathContext.joinPath(thePathContext.getContextPath(), "number-value"), p.getPrefix(), p.getValue(), thePathContext);
    }

    public void addCompositeUnmodifiedSearch(RuntimeSearchParam theSearchParam, List<RuntimeSearchParam> theSubSearchParams, List<List<IQueryParameterType>> theCompositeAndOrTerms) {
        for (List<IQueryParameterType> nextOrList : theCompositeAndOrTerms) {
            PredicateFinalStep nestedClause = this.myRootContext.buildPredicateInNestedContext(theSearchParam.getName(), nestedContext -> {
                List orClauses = nextOrList.stream().map(term -> this.computeCompositeTermClause(theSearchParam, theSubSearchParams, (CompositeParam<?, ?>)((CompositeParam)term), (PathContext)nestedContext)).collect(Collectors.toList());
                return nestedContext.orPredicateOrSingle(orClauses);
            });
            this.myRootClause.must(nestedClause);
        }
    }

    private PredicateFinalStep computeCompositeTermClause(RuntimeSearchParam theSearchParam, List<RuntimeSearchParam> theSubSearchParams, CompositeParam<?, ?> theCompositeQueryParam, PathContext theCompositeContext) {
        Validate.notNull((Object)theSearchParam);
        Validate.notNull(theSubSearchParams);
        Validate.notNull(theCompositeQueryParam);
        Validate.isTrue((theSubSearchParams.size() == 2 ? 1 : 0) != 0, (String)"Hapi only supports composite search parameters with 2 components. %s %d", (Object[])new Object[]{theSearchParam.getName(), theSubSearchParams.size()});
        List values = theCompositeQueryParam.getValues();
        Validate.isTrue((theSubSearchParams.size() == values.size() ? 1 : 0) != 0, (String)"Different number of query components than defined. %s %d %d", (Object[])new Object[]{theSearchParam.getName(), theSubSearchParams.size(), values.size()});
        BooleanPredicateClausesStep compositeClause = theCompositeContext.bool();
        for (int i = 0; i < theSubSearchParams.size(); ++i) {
            RuntimeSearchParam component = theSubSearchParams.get(i);
            IQueryParameterType value = (IQueryParameterType)values.get(i);
            WildcardPredicateOptionsStep<?> subMatch = null;
            PathContext componentContext = theCompositeContext.getSubComponentContext(component.getName());
            switch (component.getParamType()) {
                case DATE: {
                    subMatch = this.buildDateTermClause(value, componentContext);
                    break;
                }
                case STRING: {
                    subMatch = this.buildStringUnmodifiedClause(value.getValueAsQueryToken(this.myFhirContext), componentContext);
                    break;
                }
                case TOKEN: {
                    subMatch = this.buildTokenUnmodifiedMatchOn(value, componentContext);
                    break;
                }
                case QUANTITY: {
                    subMatch = this.buildQuantityTermClause(value, componentContext);
                    break;
                }
                case URI: {
                    subMatch = this.buildURIClause(List.of(value), componentContext);
                    break;
                }
                case NUMBER: {
                    subMatch = this.buildNumericClause(value, componentContext);
                    break;
                }
            }
            Validate.notNull(subMatch, (String)"Unsupported composite type in %s: %s %s", (Object[])new Object[]{theSearchParam.getName(), component.getName(), component.getParamType()});
            compositeClause.must(subMatch);
        }
        return compositeClause;
    }

    private boolean hasAContainsModifier(List<List<IQueryParameterType>> stringAndOrTerms) {
        return stringAndOrTerms.stream().flatMap(Collection::stream).anyMatch(next -> ":contains".equalsIgnoreCase(next.getQueryParameterQualifier()));
    }

    private boolean isContainsSearch(String theSearchParamName, List<List<IQueryParameterType>> stringAndOrTerms) {
        return ("_text".equalsIgnoreCase(theSearchParamName) || "_content".equalsIgnoreCase(theSearchParamName)) && this.hasAContainsModifier(stringAndOrTerms);
    }
}

