/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.ExistsPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchAllPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchIdPredicateMatchingStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchNonePredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.NamedPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.NestedPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.NestedPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.NestedPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.NotPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.RegexpPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtensionIfSupportedStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleBooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleBooleanPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.SpatialPredicateInitialStep;
import org.hibernate.search.engine.search.predicate.dsl.TermsPredicateFieldStep;
import org.hibernate.search.engine.search.predicate.dsl.WildcardPredicateFieldStep;
import org.hibernate.search.util.common.annotation.Incubating;

class PathContext
implements SearchPredicateFactory {
    private final String myPathPrefix;
    private final BooleanPredicateClausesStep<?> myRootClause;
    private final SearchPredicateFactory myPredicateFactory;

    PathContext(String thePrefix, BooleanPredicateClausesStep<?> theClause, SearchPredicateFactory thePredicateFactory) {
        this.myRootClause = theClause;
        this.myPredicateFactory = thePredicateFactory;
        this.myPathPrefix = thePrefix;
    }

    @Nonnull
    static PathContext buildRootContext(BooleanPredicateClausesStep<?> theRootClause, SearchPredicateFactory thePredicateFactory) {
        return new PathContext("", theRootClause, thePredicateFactory);
    }

    public String getContextPath() {
        return this.myPathPrefix;
    }

    public PathContext getSubComponentContext(String theName) {
        return new PathContext(PathContext.joinPath(this.myPathPrefix, theName), this.myRootClause, this.myPredicateFactory);
    }

    @Nonnull
    PathContext forAbsolutePath(String path) {
        return new PathContext(path, this.myRootClause, this.myPredicateFactory);
    }

    public PredicateFinalStep buildPredicateInNestedContext(String theSubPath, Function<PathContext, PredicateFinalStep> f) {
        String nestedRootPath = PathContext.joinPath("nsp", theSubPath);
        NestedPredicateOptionsStep orListPredicate = this.myPredicateFactory.nested().objectField(nestedRootPath).nest(nestedRootPredicateFactory -> {
            PathContext nestedCompositeSPContext = new PathContext(nestedRootPath, this.myRootClause, (SearchPredicateFactory)nestedRootPredicateFactory);
            return (PredicateFinalStep)f.apply(nestedCompositeSPContext);
        });
        return orListPredicate;
    }

    public PredicateFinalStep orPredicateOrSingle(List<? extends PredicateFinalStep> theOrList) {
        PredicateFinalStep finalClause;
        if (theOrList.size() == 1) {
            finalClause = theOrList.get(0);
        } else {
            BooleanPredicateClausesStep orClause = this.myPredicateFactory.bool();
            orClause.minimumShouldMatchNumber(1);
            theOrList.forEach(arg_0 -> ((BooleanPredicateClausesStep)orClause).should(arg_0));
            finalClause = orClause;
        }
        return finalClause;
    }

    public MatchAllPredicateOptionsStep<?> matchAll() {
        return this.myPredicateFactory.matchAll();
    }

    public MatchNonePredicateFinalStep matchNone() {
        return this.myPredicateFactory.matchNone();
    }

    public MatchIdPredicateMatchingStep<?> id() {
        return this.myPredicateFactory.id();
    }

    public BooleanPredicateClausesStep<?> bool() {
        return this.myPredicateFactory.bool();
    }

    public PredicateFinalStep bool(Consumer<? super BooleanPredicateClausesStep<?>> clauseContributor) {
        return this.myPredicateFactory.bool(clauseContributor);
    }

    public SimpleBooleanPredicateClausesStep<?> and() {
        return this.myPredicateFactory.and();
    }

    public SimpleBooleanPredicateOptionsStep<?> and(SearchPredicate theSearchPredicate, SearchPredicate ... theSearchPredicates) {
        return this.myPredicateFactory.and(theSearchPredicate, theSearchPredicates);
    }

    public SimpleBooleanPredicateOptionsStep<?> and(PredicateFinalStep thePredicateFinalStep, PredicateFinalStep ... thePredicateFinalSteps) {
        return this.myPredicateFactory.and(thePredicateFinalStep, thePredicateFinalSteps);
    }

    public SimpleBooleanPredicateClausesStep<?> or() {
        return this.myPredicateFactory.or();
    }

    public SimpleBooleanPredicateOptionsStep<?> or(SearchPredicate theSearchPredicate, SearchPredicate ... theSearchPredicates) {
        return this.myPredicateFactory.or(theSearchPredicate, theSearchPredicates);
    }

    public SimpleBooleanPredicateOptionsStep<?> or(PredicateFinalStep thePredicateFinalStep, PredicateFinalStep ... thePredicateFinalSteps) {
        return this.myPredicateFactory.or(thePredicateFinalStep, thePredicateFinalSteps);
    }

    public NotPredicateFinalStep not(SearchPredicate theSearchPredicate) {
        return this.myPredicateFactory.not(theSearchPredicate);
    }

    public NotPredicateFinalStep not(PredicateFinalStep thePredicateFinalStep) {
        return this.myPredicateFactory.not(thePredicateFinalStep);
    }

    public MatchPredicateFieldStep<?> match() {
        return this.myPredicateFactory.match();
    }

    public RangePredicateFieldStep<?> range() {
        return this.myPredicateFactory.range();
    }

    public PhrasePredicateFieldStep<?> phrase() {
        return this.myPredicateFactory.phrase();
    }

    public WildcardPredicateFieldStep<?> wildcard() {
        return this.myPredicateFactory.wildcard();
    }

    public RegexpPredicateFieldStep<?> regexp() {
        return this.myPredicateFactory.regexp();
    }

    public TermsPredicateFieldStep<?> terms() {
        return this.myPredicateFactory.terms();
    }

    public NestedPredicateFieldStep<?> nested() {
        return this.myPredicateFactory.nested();
    }

    public NestedPredicateClausesStep<?> nested(String theObjectFieldPath) {
        return this.myPredicateFactory.nested(theObjectFieldPath);
    }

    public SimpleQueryStringPredicateFieldStep<?> simpleQueryString() {
        return this.myPredicateFactory.simpleQueryString();
    }

    public ExistsPredicateFieldStep<?> exists() {
        return this.myPredicateFactory.exists();
    }

    public SpatialPredicateInitialStep spatial() {
        return this.myPredicateFactory.spatial();
    }

    @Incubating
    public NamedPredicateOptionsStep named(String path) {
        return this.myPredicateFactory.named(path);
    }

    public <T> T extension(SearchPredicateFactoryExtension<T> extension) {
        return (T)this.myPredicateFactory.extension(extension);
    }

    public SearchPredicateFactoryExtensionIfSupportedStep extension() {
        return this.myPredicateFactory.extension();
    }

    @Incubating
    public SearchPredicateFactory withRoot(String objectFieldPath) {
        return this.myPredicateFactory.withRoot(objectFieldPath);
    }

    @Incubating
    public String toAbsolutePath(String relativeFieldPath) {
        return this.myPredicateFactory.toAbsolutePath(relativeFieldPath);
    }

    @Nonnull
    public static String joinPath(String thePath0, String thePath1) {
        return thePath0 + "." + thePath1;
    }

    public static String joinPath(String thePath0, String thePath1, String thePath2) {
        return thePath0 + "." + thePath1 + "." + thePath2;
    }

    @Nonnull
    public static String joinPath(String thePath0, String thePath1, String thePath2, String thePath3) {
        return thePath0 + "." + thePath1 + "." + thePath2 + "." + thePath3;
    }
}

