/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TermHelper {
    private static final char[] simpleQuerySyntaxCharacters = new char[]{'+', '|', '\"', '(', ')', '~'};

    public static Set<String> makePrefixSearchTerm(Set<String> theStringSet) {
        return theStringSet.stream().map(s -> TermHelper.isToLeftUntouched(s) || TermHelper.isQuoted(s) ? s : TermHelper.suffixTokensWithStar(s)).collect(Collectors.toSet());
    }

    private static String suffixTokensWithStar(String theStr) {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(theStr.trim().split(" ")).forEach(s -> sb.append((String)s).append("* "));
        return sb.toString().trim();
    }

    private static boolean isQuoted(String theS) {
        return theS.startsWith("\"") && theS.endsWith("\"") || theS.startsWith("'") && theS.endsWith("'");
    }

    static boolean isToLeftUntouched(String theString) {
        if (theString.startsWith("-")) {
            return true;
        }
        if (theString.endsWith("*")) {
            return true;
        }
        return StringUtils.containsAny((CharSequence)theString, (char[])simpleQuerySyntaxCharacters);
    }
}

