/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete.batch2;

import ca.uhn.fhir.jpa.api.svc.IDeleteExpungeSvc;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.delete.batch2.DeleteExpungeSqlBuilder;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteExpungeSvcImpl
implements IDeleteExpungeSvc<JpaPid> {
    private static final Logger ourLog = LoggerFactory.getLogger(DeleteExpungeSvcImpl.class);
    private final EntityManager myEntityManager;
    private final DeleteExpungeSqlBuilder myDeleteExpungeSqlBuilder;
    private final IFulltextSearchSvc myFullTextSearchSvc;

    public DeleteExpungeSvcImpl(EntityManager theEntityManager, DeleteExpungeSqlBuilder theDeleteExpungeSqlBuilder, @Autowired(required=false) IFulltextSearchSvc theFullTextSearchSvc) {
        this.myEntityManager = theEntityManager;
        this.myDeleteExpungeSqlBuilder = theDeleteExpungeSqlBuilder;
        this.myFullTextSearchSvc = theFullTextSearchSvc;
    }

    public int deleteExpunge(List<JpaPid> theJpaPids, boolean theCascade, Integer theCascadeMaxRounds) {
        DeleteExpungeSqlBuilder.DeleteExpungeSqlResult sqlResult = this.myDeleteExpungeSqlBuilder.convertPidsToDeleteExpungeSql(theJpaPids, theCascade, theCascadeMaxRounds);
        List<String> sqlList = sqlResult.getSqlStatements();
        ourLog.debug("Executing {} delete expunge sql commands", (Object)sqlList.size());
        long totalDeleted = 0L;
        for (String sql : sqlList) {
            ourLog.trace("Executing sql " + sql);
            totalDeleted += (long)this.myEntityManager.createNativeQuery(sql).executeUpdate();
        }
        ourLog.info("{} records deleted", (Object)totalDeleted);
        this.clearHibernateSearchIndex(theJpaPids);
        return sqlResult.getRecordCount();
    }

    public boolean isCascadeSupported() {
        return true;
    }

    private void clearHibernateSearchIndex(List<JpaPid> thePersistentIds) {
        if (this.myFullTextSearchSvc != null && !this.myFullTextSearchSvc.isDisabled()) {
            List<Object> objectIds = thePersistentIds.stream().map(JpaPid::getId).collect(Collectors.toList());
            this.myFullTextSearchSvc.deleteIndexedDocumentsByTypeAndId(ResourceTable.class, objectIds);
            ourLog.info("Cleared Hibernate Search indexes.");
        }
    }
}

