/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import com.google.common.annotations.VisibleForTesting;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.r4.model.InstantType;

@Deprecated
@Entity
@Table(name="HFJ_RES_REINDEX_JOB")
public class ResourceReindexJobEntity
implements Serializable {
    @Id
    @SequenceGenerator(name="SEQ_RES_REINDEX_JOB", sequenceName="SEQ_RES_REINDEX_JOB")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_RES_REINDEX_JOB")
    @Column(name="PID")
    private Long myId;
    @Column(name="RES_TYPE", nullable=true, length=100)
    private String myResourceType;
    @Column(name="UPDATE_THRESHOLD_HIGH", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myThresholdHigh;
    @Column(name="JOB_DELETED", nullable=false)
    private boolean myDeleted;
    @Column(name="UPDATE_THRESHOLD_LOW", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myThresholdLow;
    @Column(name="SUSPENDED_UNTIL", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date mySuspendedUntil;
    @Column(name="REINDEX_COUNT", nullable=true)
    private Integer myReindexCount;

    public Integer getReindexCount() {
        return this.myReindexCount;
    }

    public void setReindexCount(Integer theReindexCount) {
        this.myReindexCount = theReindexCount;
    }

    public Date getSuspendedUntil() {
        return this.mySuspendedUntil;
    }

    public void setSuspendedUntil(Date theSuspendedUntil) {
        this.mySuspendedUntil = theSuspendedUntil;
    }

    public Date getThresholdLow() {
        Date retVal = this.myThresholdLow;
        if (retVal != null) {
            retVal = new Date(retVal.getTime());
        }
        return retVal;
    }

    public void setThresholdLow(Date theThresholdLow) {
        this.myThresholdLow = theThresholdLow;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public Date getThresholdHigh() {
        Date retVal = this.myThresholdHigh;
        if (retVal != null) {
            retVal = new Date(retVal.getTime());
        }
        return retVal;
    }

    public void setThresholdHigh(Date theThresholdHigh) {
        this.myThresholdHigh = theThresholdHigh;
    }

    public Long getId() {
        return this.myId;
    }

    @VisibleForTesting
    public void setIdForUnitTest(long theId) {
        this.myId = theId;
    }

    public void setDeleted(boolean theDeleted) {
        this.myDeleted = theDeleted;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.myId).append("resourceType", (Object)this.myResourceType).append("thresholdLow", (Object)new InstantType(this.myThresholdLow)).append("thresholdHigh", (Object)new InstantType(this.myThresholdHigh));
        if (this.myDeleted) {
            b.append("deleted", this.myDeleted);
        }
        if (this.mySuspendedUntil != null) {
            b.append("suspendedUntil", (Object)this.mySuspendedUntil);
        }
        return b.toString();
    }
}

