/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;

@Entity
@Immutable
@Subselect(value="SELECT h.PID               as PID,                           r.RES_ID            as RES_ID,                        h.RES_TYPE          as RES_TYPE,                      h.RES_VERSION       as RES_VERSION,                   h.RES_VER           as RES_VER,                       h.HAS_TAGS          as HAS_TAGS,                      h.RES_DELETED_AT    as RES_DELETED_AT,                h.RES_PUBLISHED     as RES_PUBLISHED,                 h.RES_UPDATED       as RES_UPDATED,                   h.RES_TEXT          as RES_TEXT,                      h.RES_TEXT_VC       as RES_TEXT_VC,                   h.RES_ENCODING      as RES_ENCODING,                  h.PARTITION_ID      as PARTITION_ID,                  p.SOURCE_URI        as PROV_SOURCE_URI,               p.REQUEST_ID        as PROV_REQUEST_ID,               r.FHIR_ID         as FHIR_ID      FROM HFJ_RESOURCE r     INNER JOIN HFJ_RES_VER h ON r.RES_ID = h.RES_ID and r.RES_VER = h.RES_VER    LEFT OUTER JOIN HFJ_RES_VER_PROV p ON p.RES_VER_PID = h.PID ")
public class ResourceSearchView
implements IBaseResourceEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PID")
    private Long myId;
    @Column(name="RES_ID")
    private Long myResourceId;
    @Column(name="RES_TYPE", length=100)
    private String myResourceType;
    @Column(name="RES_VERSION")
    @Enumerated(value=EnumType.STRING)
    private FhirVersionEnum myFhirVersion;
    @Column(name="RES_VER")
    private Long myResourceVersion;
    @Column(name="PROV_REQUEST_ID", length=16)
    private String myProvenanceRequestId;
    @Column(name="PROV_SOURCE_URI", length=100)
    private String myProvenanceSourceUri;
    @Column(name="HAS_TAGS")
    private boolean myHasTags;
    @Column(name="RES_DELETED_AT")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myDeleted;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="RES_PUBLISHED")
    private Date myPublished;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="RES_UPDATED")
    private Date myUpdated;
    @Column(name="RES_TEXT")
    @Lob
    private byte[] myResource;
    @Column(name="RES_TEXT_VC")
    private String myResourceTextVc;
    @Column(name="RES_ENCODING")
    @Enumerated(value=EnumType.STRING)
    private ResourceEncodingEnum myEncoding;
    @Column(name="FHIR_ID", length=100)
    private String myFhirId;
    @Column(name="PARTITION_ID")
    private Integer myPartitionId;

    public String getResourceTextVc() {
        return this.myResourceTextVc;
    }

    public String getProvenanceRequestId() {
        return this.myProvenanceRequestId;
    }

    public String getProvenanceSourceUri() {
        return this.myProvenanceSourceUri;
    }

    public Date getDeleted() {
        return this.myDeleted;
    }

    public void setDeleted(Date theDate) {
        this.myDeleted = theDate;
    }

    public FhirVersionEnum getFhirVersion() {
        return this.myFhirVersion;
    }

    public void setFhirVersion(FhirVersionEnum theFhirVersion) {
        this.myFhirVersion = theFhirVersion;
    }

    public String getFhirId() {
        return this.myFhirId;
    }

    public Long getId() {
        return this.myResourceId;
    }

    public IdDt getIdDt() {
        if (this.myFhirId == null) {
            Long id = this.myResourceId;
            return new IdDt(this.myResourceType + "/" + id + "/_history/" + this.getVersion());
        }
        return new IdDt(this.getResourceType() + "/" + this.getFhirId() + "/_history/" + this.getVersion());
    }

    public InstantDt getPublished() {
        if (this.myPublished != null) {
            return new InstantDt(this.myPublished);
        }
        return null;
    }

    public void setPublished(Date thePublished) {
        this.myPublished = thePublished;
    }

    public Long getResourceId() {
        return this.myResourceId;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public InstantDt getUpdated() {
        return new InstantDt(this.myUpdated);
    }

    public Date getUpdatedDate() {
        return this.myUpdated;
    }

    public long getVersion() {
        return this.myResourceVersion;
    }

    public boolean isHasTags() {
        return this.myHasTags;
    }

    @Nullable
    public PartitionablePartitionId getPartitionId() {
        if (this.myPartitionId != null) {
            return new PartitionablePartitionId(this.myPartitionId, null);
        }
        return null;
    }

    public byte[] getResource() {
        return this.myResource;
    }

    public ResourceEncodingEnum getEncoding() {
        return this.myEncoding;
    }
}

