/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.Search;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Table(name="HFJ_SEARCH_RESULT", uniqueConstraints={@UniqueConstraint(name="IDX_SEARCHRES_ORDER", columnNames={"SEARCH_PID", "SEARCH_ORDER"})})
public class SearchResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Deprecated(since="6.10", forRemoval=true)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SEARCH_RES")
    @SequenceGenerator(name="SEQ_SEARCH_RES", sequenceName="SEQ_SEARCH_RES")
    @Id
    @Column(name="PID")
    private Long myId;
    @Column(name="SEARCH_PID", insertable=true, updatable=false, nullable=false)
    private Long mySearchPid;
    @Column(name="SEARCH_ORDER", insertable=true, updatable=false, nullable=false)
    private int myOrder;
    @Column(name="RESOURCE_PID", insertable=true, updatable=false, nullable=false)
    private Long myResourcePid;

    public SearchResult() {
    }

    public SearchResult(Search theSearch) {
        Validate.notNull((Object)theSearch.getId());
        this.mySearchPid = theSearch.getId();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("search", (Object)this.mySearchPid).append("order", this.myOrder).append("resourcePid", (Object)this.myResourcePid).toString();
    }

    public boolean equals(Object theObj) {
        if (!(theObj instanceof SearchResult)) {
            return false;
        }
        return this.myResourcePid.equals(((SearchResult)theObj).myResourcePid);
    }

    public int getOrder() {
        return this.myOrder;
    }

    public void setOrder(int theOrder) {
        this.myOrder = theOrder;
    }

    public Long getResourcePid() {
        return this.myResourcePid;
    }

    public SearchResult setResourcePid(Long theResourcePid) {
        this.myResourcePid = theResourcePid;
        return this;
    }

    public int hashCode() {
        return this.myResourcePid.hashCode();
    }
}

