/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.util.ValidateUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Table(name="TRM_CODESYSTEM_VER", uniqueConstraints={@UniqueConstraint(name="IDX_CODESYSTEM_AND_VER", columnNames={"CODESYSTEM_PID", "CS_VERSION_ID"})}, indexes={@Index(name="FK_CODESYSVER_RES_ID", columnList="RES_ID"), @Index(name="FK_CODESYSVER_CS_ID", columnList="CODESYSTEM_PID")})
@Entity
public class TermCodeSystemVersion
implements Serializable {
    public static final String IDX_CODESYSTEM_AND_VER = "IDX_CODESYSTEM_AND_VER";
    public static final int MAX_VERSION_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="myCodeSystem")
    private Collection<TermConcept> myConcepts;
    @Id
    @SequenceGenerator(name="SEQ_CODESYSTEMVER_PID", sequenceName="SEQ_CODESYSTEMVER_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CODESYSTEMVER_PID")
    @Column(name="PID")
    private Long myId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", nullable=false, updatable=false, foreignKey=@ForeignKey(name="FK_CODESYSVER_RES_ID"))
    private ResourceTable myResource;
    @Column(name="RES_ID", nullable=false, insertable=false, updatable=false)
    private Long myResourcePid;
    @Column(name="CS_VERSION_ID", nullable=true, updatable=true, length=200)
    private String myCodeSystemVersionId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CODESYSTEM_PID", referencedColumnName="PID", nullable=true, foreignKey=@ForeignKey(name="FK_CODESYSVER_CS_ID"))
    private TermCodeSystem myCodeSystem;
    @Column(name="CODESYSTEM_PID", insertable=false, updatable=false)
    private Long myCodeSystemPid;
    @OneToOne(mappedBy="myCurrentVersion", optional=true, fetch=FetchType.LAZY)
    private TermCodeSystem myCodeSystemHavingThisVersionAsCurrentVersionIfAny;
    @Column(name="CS_DISPLAY", nullable=true, updatable=true, length=200)
    private String myCodeSystemDisplayName;

    public TermCodeSystem getCodeSystem() {
        return this.myCodeSystem;
    }

    public TermCodeSystemVersion setCodeSystem(TermCodeSystem theCodeSystem) {
        this.myCodeSystem = theCodeSystem;
        return this;
    }

    public String getCodeSystemVersionId() {
        return this.myCodeSystemVersionId;
    }

    public TermCodeSystemVersion setCodeSystemVersionId(String theCodeSystemVersionId) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theCodeSystemVersionId, (int)200, (String)("Version ID exceeds maximum length (200): " + StringUtils.length((CharSequence)theCodeSystemVersionId)));
        this.myCodeSystemVersionId = theCodeSystemVersionId;
        return this;
    }

    public Collection<TermConcept> getConcepts() {
        if (this.myConcepts == null) {
            this.myConcepts = new ArrayList<TermConcept>();
        }
        return this.myConcepts;
    }

    public Long getPid() {
        return this.myId;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public TermCodeSystemVersion setResource(ResourceTable theResource) {
        this.myResource = theResource;
        return this;
    }

    public TermCodeSystemVersion setId(Long theId) {
        this.myId = theId;
        return this;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        TermCodeSystemVersion that = (TermCodeSystemVersion)theO;
        return new EqualsBuilder().append((Object)this.myCodeSystemVersionId, (Object)that.myCodeSystemVersionId).append((Object)this.myCodeSystemPid, (Object)that.myCodeSystemPid).isEquals();
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder(17, 37);
        b.append((Object)this.myCodeSystemVersionId);
        b.append((Object)this.myCodeSystemPid);
        return b.toHashCode();
    }

    public String getCodeSystemDisplayName() {
        return this.myCodeSystemDisplayName;
    }

    public void setCodeSystemDisplayName(String theCodeSystemDisplayName) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theCodeSystemDisplayName, (int)200, (String)("Version ID exceeds maximum length (200): " + StringUtils.length((CharSequence)theCodeSystemDisplayName)));
        this.myCodeSystemDisplayName = theCodeSystemDisplayName;
    }

    public TermConcept addConcept() {
        TermConcept concept = new TermConcept();
        concept.setCodeSystemVersion(this);
        this.getConcepts().add(concept);
        return concept;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("pid", (Object)this.myId);
        b.append("displayName", (Object)this.myCodeSystemDisplayName);
        b.append("codeSystemResourcePid", (Object)this.myResourcePid);
        b.append("codeSystemPid", (Object)this.myCodeSystemPid);
        b.append("codeSystemVersionId", (Object)this.myCodeSystemVersionId);
        return b.toString();
    }

    TermCodeSystemVersion setCodeSystemPidForUnitTest(long theCodeSystemPid) {
        this.myCodeSystemPid = theCodeSystemPid;
        return this;
    }
}

