/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;

@Entity
@Table(name="TRM_CONCEPT_PC_LINK", indexes={@Index(name="FK_TERM_CONCEPTPC_CHILD", columnList="CHILD_PID", unique=false), @Index(name="FK_TERM_CONCEPTPC_PARENT", columnList="PARENT_PID", unique=false), @Index(name="FK_TERM_CONCEPTPC_CS", columnList="CODESYSTEM_PID")})
public class TermConceptParentChildLink
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CHILD_PID", nullable=false, referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_TERM_CONCEPTPC_CHILD"))
    private TermConcept myChild;
    @Column(name="CHILD_PID", insertable=false, updatable=false)
    private Long myChildPid;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CODESYSTEM_PID", nullable=false, foreignKey=@ForeignKey(name="FK_TERM_CONCEPTPC_CS"))
    private TermCodeSystemVersion myCodeSystem;
    @Column(name="CODESYSTEM_PID", insertable=false, updatable=false, nullable=false)
    @FullTextField(name="myCodeSystemVersionPid")
    private long myCodeSystemVersionPid;
    @ManyToOne(fetch=FetchType.LAZY, cascade={})
    @JoinColumn(name="PARENT_PID", nullable=false, referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_TERM_CONCEPTPC_PARENT"))
    private TermConcept myParent;
    @Column(name="PARENT_PID", insertable=false, updatable=false)
    private Long myParentPid;
    @Id
    @SequenceGenerator(name="SEQ_CONCEPT_PC_PID", sequenceName="SEQ_CONCEPT_PC_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CONCEPT_PC_PID")
    @Column(name="PID")
    private Long myPid;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="REL_TYPE", length=5, nullable=true)
    @JdbcTypeCode(value=4)
    private RelationshipTypeEnum myRelationshipType;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TermConceptParentChildLink other = (TermConceptParentChildLink)obj;
        if (this.myChild == null ? other.myChild != null : !this.myChild.equals(other.myChild)) {
            return false;
        }
        if (this.myCodeSystem == null ? other.myCodeSystem != null : !this.myCodeSystem.equals(other.myCodeSystem)) {
            return false;
        }
        if (this.myParent == null ? other.myParent != null : !this.myParent.equals(other.myParent)) {
            return false;
        }
        return this.myRelationshipType == other.myRelationshipType;
    }

    public TermConcept getChild() {
        return this.myChild;
    }

    public Long getChildPid() {
        return this.myChildPid;
    }

    public TermCodeSystemVersion getCodeSystem() {
        return this.myCodeSystem;
    }

    public Long getId() {
        return this.myPid;
    }

    public TermConcept getParent() {
        return this.myParent;
    }

    public Long getParentPid() {
        return this.myParentPid;
    }

    public RelationshipTypeEnum getRelationshipType() {
        return this.myRelationshipType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myChild == null ? 0 : this.myChild.hashCode());
        result = 31 * result + (this.myCodeSystem == null ? 0 : this.myCodeSystem.hashCode());
        result = 31 * result + (this.myParent == null ? 0 : this.myParent.hashCode());
        result = 31 * result + (this.myRelationshipType == null ? 0 : this.myRelationshipType.hashCode());
        return result;
    }

    public TermConceptParentChildLink setChild(TermConcept theChild) {
        this.myChild = theChild;
        return this;
    }

    public TermConceptParentChildLink setCodeSystem(TermCodeSystemVersion theCodeSystem) {
        this.myCodeSystem = theCodeSystem;
        return this;
    }

    public TermConceptParentChildLink setParent(TermConcept theParent) {
        this.myParent = theParent;
        return this;
    }

    public TermConceptParentChildLink setRelationshipType(RelationshipTypeEnum theRelationshipType) {
        this.myRelationshipType = theRelationshipType;
        return this;
    }

    public static enum RelationshipTypeEnum {
        ISA;

    }
}

