/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptPropertyTypeEnum;
import ca.uhn.fhir.util.ValidateUtil;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="TRM_CONCEPT_PROPERTY", uniqueConstraints={}, indexes={@Index(name="FK_CONCEPTPROP_CONCEPT", columnList="CONCEPT_PID", unique=false), @Index(name="FK_CONCEPTPROP_CSV", columnList="CS_VER_PID")})
public class TermConceptProperty
implements Serializable {
    public static final int MAX_PROPTYPE_ENUM_LENGTH = 6;
    private static final long serialVersionUID = 1L;
    public static final int MAX_LENGTH = 500;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONCEPT_PID", referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_CONCEPTPROP_CONCEPT"))
    private TermConcept myConcept;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CS_VER_PID", nullable=true, referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_CONCEPTPROP_CSV"))
    private TermCodeSystemVersion myCodeSystemVersion;
    @Id
    @SequenceGenerator(name="SEQ_CONCEPT_PROP_PID", sequenceName="SEQ_CONCEPT_PROP_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CONCEPT_PROP_PID")
    @Column(name="PID")
    private Long myId;
    @Column(name="PROP_KEY", nullable=false, length=500)
    @NotBlank
    @GenericField(searchable=Searchable.YES)
    private String myKey;
    @Column(name="PROP_VAL", nullable=true, length=500)
    @FullTextField(searchable=Searchable.YES, projectable=Projectable.YES, analyzer="standardAnalyzer")
    @GenericField(name="myValueString", searchable=Searchable.YES)
    private String myValue;
    @Deprecated(since="7.2.0")
    @Column(name="PROP_VAL_LOB")
    @Lob
    private byte[] myValueLob;
    @Column(name="PROP_VAL_BIN", nullable=true, length=0x7FFFFFFF)
    private byte[] myValueBin;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="PROP_TYPE", nullable=false)
    @JdbcTypeCode(value=4)
    private TermConceptPropertyTypeEnum myType;
    @Column(name="PROP_CODESYSTEM", length=500, nullable=true)
    private String myCodeSystem;
    @Column(name="PROP_DISPLAY", length=500, nullable=true)
    @GenericField(name="myDisplayString", searchable=Searchable.YES)
    private String myDisplay;

    public String getCodeSystem() {
        return this.myCodeSystem;
    }

    public TermConceptProperty setCodeSystem(String theCodeSystem) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theCodeSystem, (int)500, (String)("Property code system exceeds maximum length (500): " + StringUtils.length((CharSequence)theCodeSystem)));
        this.myCodeSystem = theCodeSystem;
        return this;
    }

    public String getDisplay() {
        return this.myDisplay;
    }

    public TermConceptProperty setDisplay(String theDisplay) {
        this.myDisplay = StringUtils.left((String)theDisplay, (int)500);
        return this;
    }

    public String getKey() {
        return this.myKey;
    }

    public TermConceptProperty setKey(@Nonnull String theKey) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theKey, (String)"theKey must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theKey, (int)500, (String)("Code exceeds maximum length (500): " + StringUtils.length((CharSequence)theKey)));
        this.myKey = theKey;
        return this;
    }

    public TermConceptPropertyTypeEnum getType() {
        return this.myType;
    }

    public TermConceptProperty setType(@Nonnull TermConceptPropertyTypeEnum theType) {
        Validate.notNull((Object)((Object)theType));
        this.myType = theType;
        return this;
    }

    public String getValue() {
        if (this.hasValueBin()) {
            return this.getValueBinAsString();
        }
        return this.myValue;
    }

    public TermConceptProperty setValue(String theValue) {
        if (theValue.length() > 500) {
            this.setValueBin(theValue);
        } else {
            this.myValueLob = null;
            this.myValueBin = null;
        }
        this.myValue = StringUtils.left((String)theValue, (int)500);
        return this;
    }

    public boolean hasValueBin() {
        if (this.myValueBin != null && this.myValueBin.length > 0) {
            return true;
        }
        return this.myValueLob != null && this.myValueLob.length > 0;
    }

    public TermConceptProperty setValueBin(byte[] theValueBin) {
        this.myValueBin = theValueBin;
        this.myValueLob = theValueBin;
        return this;
    }

    public TermConceptProperty setValueBin(String theValueBin) {
        return this.setValueBin(theValueBin.getBytes(StandardCharsets.UTF_8));
    }

    public String getValueBinAsString() {
        if (this.myValueBin != null && this.myValueBin.length > 0) {
            return new String(this.myValueBin, StandardCharsets.UTF_8);
        }
        return new String(this.myValueLob, StandardCharsets.UTF_8);
    }

    public TermConceptProperty setCodeSystemVersion(TermCodeSystemVersion theCodeSystemVersion) {
        this.myCodeSystemVersion = theCodeSystemVersion;
        return this;
    }

    public TermConceptProperty setConcept(TermConcept theConcept) {
        this.myConcept = theConcept;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("conceptPid", (Object)this.myConcept.getId()).append("key", (Object)this.myKey).append("value", (Object)this.getValue()).toString();
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        TermConceptProperty that = (TermConceptProperty)theO;
        return new EqualsBuilder().append((Object)this.myKey, (Object)that.myKey).append((Object)this.myValue, (Object)that.myValue).append((Object)this.myType, (Object)that.myType).append((Object)this.myCodeSystem, (Object)that.myCodeSystem).append((Object)this.myDisplay, (Object)that.myDisplay).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.myKey).append((Object)this.myValue).append((Object)this.myType).append((Object)this.myCodeSystem).append((Object)this.myDisplay).toHashCode();
    }

    public Long getPid() {
        return this.myId;
    }

    public void performLegacyLobSupport(boolean theSupportLegacyLob) {
        if (!theSupportLegacyLob) {
            this.myValueLob = null;
        }
    }

    @VisibleForTesting
    public boolean hasValueBlobForTesting() {
        return Objects.nonNull(this.myValueLob);
    }

    @VisibleForTesting
    public void setValueBlobForTesting(byte[] theValueLob) {
        this.myValueLob = theValueLob;
    }

    @VisibleForTesting
    public boolean hasValueBinForTesting() {
        return Objects.nonNull(this.myValueBin);
    }

    @VisibleForTesting
    public void setValueBinForTesting(byte[] theValuebin) {
        this.myValueBin = theValuebin;
    }
}

