/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages.loader;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.packages.PackageInstallationSpec;
import ca.uhn.fhir.jpa.packages.loader.NpmPackageData;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.ClasspathUtil;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageLoaderSvc
extends BasePackageCacheManager {
    private static final Logger ourLog = LoggerFactory.getLogger(PackageLoaderSvc.class);

    public NpmPackageData fetchPackageFromPackageSpec(PackageInstallationSpec theSpec) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)theSpec.getPackageUrl())) {
            byte[] contents = this.loadPackageUrlContents(theSpec.getPackageUrl());
            return this.createNpmPackageDataFromData(theSpec.getName(), theSpec.getVersion(), theSpec.getPackageUrl(), new ByteArrayInputStream(contents));
        }
        return this.fetchPackageFromServerInternal(theSpec.getName(), theSpec.getVersion());
    }

    public NpmPackageData fetchPackageFromPackageSpec(String thePackageId, String thePackageVersion) throws FHIRException, IOException {
        return this.fetchPackageFromServerInternal(thePackageId, thePackageVersion);
    }

    private NpmPackageData fetchPackageFromServerInternal(String thePackageId, String thePackageVersion) throws IOException {
        BasePackageCacheManager.InputStreamWithSrc pkg = this.loadFromPackageServer(thePackageId, thePackageVersion);
        if (pkg == null) {
            throw new ResourceNotFoundException(Msg.code((int)1301) + "Unable to locate package " + thePackageId + "#" + thePackageVersion);
        }
        NpmPackageData npmPackage = this.createNpmPackageDataFromData(thePackageId, thePackageVersion == null ? pkg.version : thePackageVersion, pkg.url, pkg.stream);
        return npmPackage;
    }

    public NpmPackageData createNpmPackageDataFromData(String thePackageId, String thePackageVersionId, String theSourceDesc, InputStream thePackageTgzInputStream) throws IOException {
        Validate.notBlank((CharSequence)thePackageId, (String)"thePackageId must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)thePackageVersionId, (String)"thePackageVersionId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)thePackageTgzInputStream, (String)"thePackageTgzInputStream must not be null", (Object[])new Object[0]);
        byte[] bytes = IOUtils.toByteArray((InputStream)thePackageTgzInputStream);
        ourLog.info("Parsing package .tar.gz ({} bytes) from {}", (Object)bytes.length, (Object)theSourceDesc);
        NpmPackage npmPackage = NpmPackage.fromPackage((InputStream)new ByteArrayInputStream(bytes));
        return new NpmPackageData(thePackageId, thePackageVersionId, theSourceDesc, bytes, npmPackage, thePackageTgzInputStream);
    }

    public NpmPackage loadPackageFromCacheOnly(String theS, @Nullable String theS1) {
        throw new UnsupportedOperationException(Msg.code((int)2215) + "Cannot load from cache. Caching not supported in PackageLoaderSvc. Use JpaPackageCache instead.");
    }

    public NpmPackage addPackageToCache(String theS, String theS1, InputStream theInputStream, String theS2) throws IOException {
        throw new UnsupportedOperationException(Msg.code((int)2216) + "Cannot add to cache. Caching not supported in PackageLoaderSvc. Use JpaPackageCache instead.");
    }

    public NpmPackage loadPackage(String theS, String theS1) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)2217) + "No packages are cached;  this service only loads from the server directly. Call fetchPackageFromServer to fetch the npm package from the server. Or use JpaPackageCache for a cache implementation.");
    }

    public byte[] loadPackageUrlContents(String thePackageUrl) {
        byte[] byArray;
        block13: {
            if (thePackageUrl.startsWith("classpath:")) {
                return ClasspathUtil.loadResourceAsByteArray((String)thePackageUrl.substring("classpath:".length()));
            }
            if (thePackageUrl.startsWith("file:")) {
                try {
                    byte[] bytes = Files.readAllBytes(Paths.get(new URI(thePackageUrl)));
                    return bytes;
                }
                catch (IOException | URISyntaxException e) {
                    throw new InternalErrorException(Msg.code((int)2031) + "Error loading \"" + thePackageUrl + "\": " + e.getMessage());
                }
            }
            BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager();
            CloseableHttpResponse request = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build().execute((HttpUriRequest)new HttpGet(thePackageUrl));
            try {
                if (request.getStatusLine().getStatusCode() != 200) {
                    throw new ResourceNotFoundException(Msg.code((int)1303) + "Received HTTP " + request.getStatusLine().getStatusCode() + " from URL: " + thePackageUrl);
                }
                byArray = IOUtils.toByteArray((InputStream)request.getEntity().getContent());
                if (request == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (request != null) {
                        try {
                            request.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalErrorException(Msg.code((int)1304) + "Error loading \"" + thePackageUrl + "\": " + e.getMessage());
                }
            }
            request.close();
        }
        return byArray;
    }
}

