/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages.loader;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class PackageResourceParsingSvc {
    private final FhirContext myFhirContext;

    public PackageResourceParsingSvc(FhirContext theContext) {
        this.myFhirContext = theContext;
    }

    public List<IBaseResource> parseResourcesOfType(String theType, NpmPackage thePkg) {
        if (!thePkg.getFolders().containsKey("package")) {
            return Collections.emptyList();
        }
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        List filesForType = null;
        try {
            filesForType = (List)((NpmPackage.NpmPackageFolder)thePkg.getFolders().get("package")).getTypes().get(theType);
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)2370) + "Cannot install resource of type " + theType + ": Could not get types", (Throwable)e);
        }
        if (filesForType != null) {
            for (String file : filesForType) {
                try {
                    byte[] content = ((NpmPackage.NpmPackageFolder)thePkg.getFolders().get("package")).fetchFile(file);
                    resources.add(this.myFhirContext.newJsonParser().parseResource(new String(content)));
                }
                catch (IOException e) {
                    throw new InternalErrorException(Msg.code((int)1289) + "Cannot install resource of type " + theType + ": Could not fetch file " + file, (Throwable)e);
                }
            }
        }
        return resources;
    }
}

