/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoConceptMap;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.term.TermConceptMappingSvcImpl;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.DatatypeUtil;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Parameters;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseJpaResourceProviderConceptMap<T extends IBaseResource>
extends BaseJpaResourceProvider<T> {
    @Autowired
    private VersionCanonicalizer myVersionCanonicalizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$translate", idempotent=true, returnParameters={@OperationParam(name="result", typeName="boolean", min=1, max=1), @OperationParam(name="message", typeName="string", min=0, max=1)})
    public IBaseParameters translate(HttpServletRequest theServletRequest, @IdParam(optional=true) IIdType theId, @OperationParam(name="url", min=0, max=1, typeName="uri") IPrimitiveType<String> theUrl, @OperationParam(name="conceptMapVersion", min=0, max=1, typeName="string") IPrimitiveType<String> theConceptMapVersion, @OperationParam(name="code", min=0, max=1, typeName="code") IPrimitiveType<String> theSourceCode, @OperationParam(name="system", min=0, max=1, typeName="uri") IPrimitiveType<String> theSourceCodeSystem, @OperationParam(name="version", min=0, max=1, typeName="string") IPrimitiveType<String> theSourceCodeSystemVersion, @OperationParam(name="source", min=0, max=1, typeName="uri") IPrimitiveType<String> theSourceValueSet, @OperationParam(name="coding", min=0, max=1, typeName="Coding") IBaseCoding theSourceCoding, @OperationParam(name="codeableConcept", min=0, max=1, typeName="CodeableConcept") IBaseDatatype theSourceCodeableConcept, @OperationParam(name="target", min=0, max=1, typeName="uri") IPrimitiveType<String> theTargetValueSet, @OperationParam(name="targetsystem", min=0, max=1, typeName="uri") IPrimitiveType<String> theTargetCodeSystem, @OperationParam(name="reverse", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theReverse, RequestDetails theRequestDetails) {
        boolean haveId;
        Coding sourceCoding = this.myVersionCanonicalizer.codingToCanonical(theSourceCoding);
        CodeableConcept sourceCodeableConcept = this.myVersionCanonicalizer.codeableConceptToCanonical(theSourceCodeableConcept);
        boolean haveSourceCode = theSourceCode != null && StringUtils.isNotBlank((CharSequence)((CharSequence)theSourceCode.getValue()));
        boolean haveSourceCodeSystem = theSourceCodeSystem != null && theSourceCodeSystem.hasValue();
        boolean haveSourceCodeSystemVersion = theSourceCodeSystemVersion != null && theSourceCodeSystemVersion.hasValue();
        boolean haveSourceCoding = sourceCoding != null && sourceCoding.hasCode();
        boolean haveSourceCodeableConcept = sourceCodeableConcept != null && sourceCodeableConcept.hasCoding() && sourceCodeableConcept.getCodingFirstRep().hasCode();
        boolean haveReverse = theReverse != null;
        boolean bl = haveId = theId != null && theId.hasIdPart();
        if (!haveSourceCode && !haveSourceCoding && !haveSourceCodeableConcept || BaseJpaResourceProviderConceptMap.moreThanOneTrue(haveSourceCode, haveSourceCoding, haveSourceCodeableConcept)) {
            throw new InvalidRequestException(Msg.code((int)1154) + "One (and only one) of the in parameters (code, coding, codeableConcept) must be provided, to identify the code that is to be translated.");
        }
        TranslationRequest translationRequest = new TranslationRequest();
        translationRequest.setUrl(DatatypeUtil.toStringValue(theUrl));
        translationRequest.setConceptMapVersion(DatatypeUtil.toStringValue(theConceptMapVersion));
        if (haveSourceCode) {
            translationRequest.getCodeableConcept().addCoding().setCode(DatatypeUtil.toStringValue(theSourceCode));
            if (haveSourceCodeSystem) {
                translationRequest.getCodeableConcept().getCodingFirstRep().setSystem(DatatypeUtil.toStringValue(theSourceCodeSystem));
            }
            if (haveSourceCodeSystemVersion) {
                translationRequest.getCodeableConcept().getCodingFirstRep().setVersion(DatatypeUtil.toStringValue(theSourceCodeSystemVersion));
            }
        } else if (haveSourceCoding) {
            translationRequest.getCodeableConcept().addCoding(sourceCoding);
        } else {
            translationRequest.setCodeableConcept(sourceCodeableConcept);
        }
        translationRequest.setSource(DatatypeUtil.toStringValue(theSourceValueSet));
        translationRequest.setTarget(DatatypeUtil.toStringValue(theTargetValueSet));
        translationRequest.setTargetSystem(DatatypeUtil.toStringValue(theTargetCodeSystem));
        if (haveReverse) {
            translationRequest.setReverse(DatatypeUtil.toBooleanValue(theReverse));
        }
        if (haveId) {
            translationRequest.setResourceId(theId);
        }
        BaseJpaResourceProviderConceptMap.startRequest((HttpServletRequest)theServletRequest);
        try {
            IFhirResourceDaoConceptMap dao = (IFhirResourceDaoConceptMap)this.getDao();
            TranslateConceptResults result = dao.translate(translationRequest, theRequestDetails);
            Parameters parameters = TermConceptMappingSvcImpl.toParameters(result);
            IBaseParameters iBaseParameters = this.myVersionCanonicalizer.parametersFromCanonical(parameters);
            return iBaseParameters;
        }
        finally {
            BaseJpaResourceProviderConceptMap.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    private static boolean moreThanOneTrue(boolean ... theBooleans) {
        boolean haveOne = false;
        for (boolean next : theBooleans) {
            if (!next) continue;
            if (haveOne) {
                return true;
            }
            haveOne = true;
        }
        return false;
    }
}

