/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoPatient;
import ca.uhn.fhir.jpa.api.dao.PatientEverythingParameters;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.StringOrListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseJpaResourceProviderPatient<T extends IBaseResource>
extends BaseJpaResourceProvider<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$everything", canonicalUrl="http://hl7.org/fhir/OperationDefinition/Patient-everything", idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider patientInstanceEverything(HttpServletRequest theServletRequest, @IdParam IIdType theId, @Description(shortDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count", typeName="unsignedInt") IPrimitiveType<Integer> theCount, @Description(shortDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset", typeName="unsignedInt") IPrimitiveType<Integer> theOffset, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OperationParam(name="_lastUpdated", min=0, max=1) DateRangeParam theLastUpdated, @Description(shortDefinition="Filter the resources to return only resources matching the given _content filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_content", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theContent, @Description(shortDefinition="Filter the resources to return only resources matching the given _text filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_text", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theNarrative, @Description(shortDefinition="Filter the resources to return only resources matching the given _filter filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_filter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theFilter, @Description(shortDefinition="Filter the resources to return only resources matching the given _type filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_type", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypes, @Description(shortDefinition="Filter the resources to return only resources matching the given _type filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_mdm", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theMdmExpand, @Sort SortSpec theSortSpec, RequestDetails theRequestDetails) {
        BaseJpaResourceProviderPatient.startRequest((HttpServletRequest)theServletRequest);
        try {
            PatientEverythingParameters everythingParams = new PatientEverythingParameters();
            everythingParams.setCount(theCount);
            everythingParams.setOffset(theOffset);
            everythingParams.setLastUpdated(theLastUpdated);
            everythingParams.setSort(theSortSpec);
            everythingParams.setContent(this.toStringAndList(theContent));
            everythingParams.setNarrative(this.toStringAndList(theNarrative));
            everythingParams.setFilter(this.toStringAndList(theFilter));
            everythingParams.setTypes(this.toStringAndList(theTypes));
            everythingParams.setMdmExpand(Boolean.valueOf(this.resolveNullValue(theMdmExpand)));
            IBundleProvider iBundleProvider = ((IFhirResourceDaoPatient)this.getDao()).patientInstanceEverything(theServletRequest, theRequestDetails, everythingParams, theId);
            return iBundleProvider;
        }
        finally {
            BaseJpaResourceProviderPatient.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$everything", canonicalUrl="http://hl7.org/fhir/OperationDefinition/Patient-everything", idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider patientTypeEverything(HttpServletRequest theServletRequest, @Description(shortDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count", typeName="unsignedInt") IPrimitiveType<Integer> theCount, @Description(shortDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset", typeName="unsignedInt") IPrimitiveType<Integer> theOffset, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OperationParam(name="_lastUpdated", min=0, max=1) DateRangeParam theLastUpdated, @Description(shortDefinition="Filter the resources to return only resources matching the given _content filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_content", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theContent, @Description(shortDefinition="Filter the resources to return only resources matching the given _text filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_text", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theNarrative, @Description(shortDefinition="Filter the resources to return only resources matching the given _filter filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_filter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theFilter, @Description(shortDefinition="Filter the resources to return only resources matching the given _type filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_type", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypes, @Description(shortDefinition="Filter the resources to return based on the patient ids provided.") @OperationParam(name="_id", min=0, max=-1, typeName="id") List<IIdType> theId, @Description(shortDefinition="Filter the resources to return only resources matching the given _type filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_mdm", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theMdmExpand, @Sort SortSpec theSortSpec, RequestDetails theRequestDetails) {
        BaseJpaResourceProviderPatient.startRequest((HttpServletRequest)theServletRequest);
        try {
            PatientEverythingParameters everythingParams = new PatientEverythingParameters();
            everythingParams.setCount(theCount);
            everythingParams.setOffset(theOffset);
            everythingParams.setLastUpdated(theLastUpdated);
            everythingParams.setSort(theSortSpec);
            everythingParams.setContent(this.toStringAndList(theContent));
            everythingParams.setNarrative(this.toStringAndList(theNarrative));
            everythingParams.setFilter(this.toStringAndList(theFilter));
            everythingParams.setTypes(this.toStringAndList(theTypes));
            everythingParams.setMdmExpand(Boolean.valueOf(this.resolveNullValue(theMdmExpand)));
            IBundleProvider iBundleProvider = ((IFhirResourceDaoPatient)this.getDao()).patientTypeEverything(theServletRequest, theRequestDetails, everythingParams, this.toFlattenedPatientIdTokenParamList(theId));
            return iBundleProvider;
        }
        finally {
            BaseJpaResourceProviderPatient.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    private TokenOrListParam toFlattenedPatientIdTokenParamList(List<IIdType> theId) {
        TokenOrListParam retVal = new TokenOrListParam();
        if (theId != null) {
            for (IIdType next : theId) {
                if (!StringUtils.isNotBlank((CharSequence)next.getValue())) continue;
                String[] split = next.getValueAsString().split(",");
                Arrays.stream(split).map(IdDt::new).forEach(id -> retVal.addOr(new TokenParam(id.getIdPart())));
            }
        }
        return retVal.getValuesAsQueryTokens().isEmpty() ? null : retVal;
    }

    private StringAndListParam toStringAndList(List<IPrimitiveType<String>> theNarrative) {
        StringAndListParam retVal = new StringAndListParam();
        if (theNarrative != null) {
            for (IPrimitiveType<String> next : theNarrative) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)next.getValue()))) continue;
                retVal.addAnd(new StringOrListParam().addOr(new StringParam((String)next.getValue())));
            }
        }
        if (retVal.getValuesAsQueryTokens().isEmpty()) {
            return null;
        }
        return retVal;
    }

    private boolean resolveNullValue(IPrimitiveType<Boolean> theMdmExpand) {
        return theMdmExpand == null ? Boolean.FALSE : (Boolean)theMdmExpand.getValue();
    }
}

