/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoValueSet;
import ca.uhn.fhir.jpa.provider.BaseJpaProvider;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ParametersUtil;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ValueSetOperationProvider
extends BaseJpaProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(ValueSetOperationProvider.class);
    @Autowired
    protected IValidationSupport myValidationSupport;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private ITermReadSvc myTermReadSvc;
    @Autowired
    @Qualifier(value="myJpaValidationSupportChain")
    private ValidationSupportChain myValidationSupportChain;

    @VisibleForTesting
    public void setDaoRegistryForUnitTest(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$expand", idempotent=true, typeName="ValueSet")
    public IBaseResource expand(HttpServletRequest theServletRequest, @IdParam(optional=true) IIdType theId, @OperationParam(name="valueSet", min=0, max=1) IBaseResource theValueSet, @OperationParam(name="url", min=0, max=1, typeName="uri") IPrimitiveType<String> theUrl, @OperationParam(name="valueSetVersion", min=0, max=1, typeName="string") IPrimitiveType<String> theValueSetVersion, @OperationParam(name="filter", min=0, max=1, typeName="string") IPrimitiveType<String> theFilter, @OperationParam(name="context", min=0, max=1, typeName="string") IPrimitiveType<String> theContext, @OperationParam(name="contextDirection", min=0, max=1, typeName="string") IPrimitiveType<String> theContextDirection, @OperationParam(name="offset", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theOffset, @OperationParam(name="count", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theCount, @OperationParam(name="displayLanguage", min=0, max=1, typeName="code") IPrimitiveType<String> theDisplayLanguage, @OperationParam(name="includeHierarchy", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theIncludeHierarchy, RequestDetails theRequestDetails) {
        ValueSetOperationProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBaseResource iBaseResource = this.getDao().expand(theId, theValueSet, theUrl, theValueSetVersion, theFilter, theContext, theContextDirection, theOffset, theCount, theDisplayLanguage, theIncludeHierarchy, theRequestDetails);
            return iBaseResource;
        }
        finally {
            ValueSetOperationProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    protected IFhirResourceDaoValueSet<IBaseResource> getDao() {
        return (IFhirResourceDaoValueSet)this.myDaoRegistry.getResourceDao("ValueSet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$validate-code", idempotent=true, typeName="ValueSet", returnParameters={@OperationParam(name="result", typeName="boolean", min=1), @OperationParam(name="message", typeName="string"), @OperationParam(name="display", typeName="string"), @OperationParam(name="sourceDetails", typeName="string")})
    public IBaseParameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IIdType theId, @OperationParam(name="url", min=0, max=1, typeName="uri") IPrimitiveType<String> theValueSetUrl, @OperationParam(name="valueSetVersion", min=0, max=1, typeName="string") IPrimitiveType<String> theValueSetVersion, @OperationParam(name="code", min=0, max=1, typeName="code") IPrimitiveType<String> theCode, @OperationParam(name="system", min=0, max=1, typeName="uri") IPrimitiveType<String> theSystem, @OperationParam(name="systemVersion", min=0, max=1, typeName="string") IPrimitiveType<String> theSystemVersion, @OperationParam(name="display", min=0, max=1, typeName="string") IPrimitiveType<String> theDisplay, @OperationParam(name="coding", min=0, max=1, typeName="Coding") IBaseCoding theCoding, @OperationParam(name="codeableConcept", min=0, max=1, typeName="CodeableConcept") ICompositeType theCodeableConcept, RequestDetails theRequestDetails) {
        ValueSetOperationProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IValidationSupport.CodeValidationResult result;
            if (this.myValidationSupportChain != null && this.myValidationSupportChain.isRemoteTerminologyServiceConfigured()) {
                String theValueSetUrlString;
                String theSystemString = theSystem != null && theSystem.hasValue() ? theSystem.getValueAsString() : null;
                String theCodeString = theCode != null && theCode.hasValue() ? theCode.getValueAsString() : null;
                String theDisplayString = theDisplay != null && theDisplay.hasValue() ? theDisplay.getValueAsString() : null;
                String string = theValueSetUrlString = theValueSetUrl != null && theValueSetUrl.hasValue() ? theValueSetUrl.getValueAsString() : null;
                if (theCoding != null && StringUtils.isNotBlank((CharSequence)theCoding.getSystem())) {
                    if (theSystemString != null && !theSystemString.equalsIgnoreCase(theCoding.getSystem())) {
                        throw new InvalidRequestException(Msg.code((int)2352) + "Coding.system '" + theCoding.getSystem() + "' does not equal param system '" + theSystemString + "'. Unable to validate-code.");
                    }
                    theSystemString = theCoding.getSystem();
                    theCodeString = theCoding.getCode();
                    theDisplayString = theCoding.getDisplay();
                }
                result = this.validateCodeWithTerminologyService(theSystemString, theCodeString, theDisplayString, theValueSetUrlString).orElseGet(this.supplyUnableToValidateResult(theSystemString, theCodeString, theValueSetUrlString));
            } else {
                IPrimitiveType codeSystemIdentifier;
                IPrimitiveType valueSetIdentifier;
                IFhirResourceDaoValueSet<IBaseResource> dao = this.getDao();
                if (theValueSetUrl != null && theValueSetVersion != null) {
                    valueSetIdentifier = (IPrimitiveType)this.getContext().getElementDefinition("uri").newInstance();
                    valueSetIdentifier.setValue((Object)((String)theValueSetUrl.getValue() + "|" + theValueSetVersion));
                } else {
                    valueSetIdentifier = theValueSetUrl;
                }
                if (theSystem != null && theSystemVersion != null) {
                    codeSystemIdentifier = (IPrimitiveType)this.getContext().getElementDefinition("uri").newInstance();
                    codeSystemIdentifier.setValue((Object)((String)theSystem.getValue() + "|" + theSystemVersion));
                } else {
                    codeSystemIdentifier = theSystem;
                }
                result = dao.validateCode(valueSetIdentifier, theId, theCode, codeSystemIdentifier, theDisplay, theCoding, (IBaseDatatype)theCodeableConcept, theRequestDetails);
            }
            IBaseParameters iBaseParameters = result.toParameters(this.getContext());
            return iBaseParameters;
        }
        finally {
            ValueSetOperationProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    private Optional<IValidationSupport.CodeValidationResult> validateCodeWithTerminologyService(String theSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return Optional.ofNullable(this.myValidationSupportChain.validateCode(new ValidationSupportContext((IValidationSupport)this.myValidationSupportChain), new ConceptValidationOptions(), theSystem, theCode, theDisplay, theValueSetUrl));
    }

    private Supplier<IValidationSupport.CodeValidationResult> supplyUnableToValidateResult(String theSystem, String theCode, String theValueSetUrl) {
        return () -> new IValidationSupport.CodeValidationResult().setMessage("Validator is unable to provide validation for " + theCode + "#" + theSystem + " - Unknown or unusable ValueSet[" + theValueSetUrl + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$invalidate-expansion", idempotent=false, typeName="ValueSet", returnParameters={@OperationParam(name="message", typeName="string", min=1, max=1)})
    public IBaseParameters invalidateValueSetExpansion(@IdParam IIdType theValueSetId, RequestDetails theRequestDetails, HttpServletRequest theServletRequest) {
        ValueSetOperationProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            String outcome = this.myTermReadSvc.invalidatePreCalculatedExpansion(theValueSetId, theRequestDetails);
            IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
            ParametersUtil.addParameterToParametersString((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)"message", (String)outcome);
            IBaseParameters iBaseParameters = retVal;
            return iBaseParameters;
        }
        finally {
            ValueSetOperationProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    public static ValueSetExpansionOptions createValueSetExpansionOptions(JpaStorageSettings theStorageSettings, IPrimitiveType<Integer> theOffset, IPrimitiveType<Integer> theCount, IPrimitiveType<Boolean> theIncludeHierarchy, IPrimitiveType<String> theFilter, IPrimitiveType<String> theDisplayLanguage) {
        int countMax;
        int offset = theStorageSettings.getPreExpandValueSetsDefaultOffset();
        if (theOffset != null && theOffset.hasValue()) {
            if ((Integer)theOffset.getValue() >= 0) {
                offset = (Integer)theOffset.getValue();
            } else {
                throw new InvalidRequestException(Msg.code((int)1135) + "offset parameter for $expand operation must be >= 0 when specified. offset: " + theOffset.getValue());
            }
        }
        int count = theStorageSettings.getPreExpandValueSetsDefaultCount();
        if (theCount != null && theCount.hasValue()) {
            if ((Integer)theCount.getValue() >= 0) {
                count = (Integer)theCount.getValue();
            } else {
                throw new InvalidRequestException(Msg.code((int)1136) + "count parameter for $expand operation must be >= 0 when specified. count: " + theCount.getValue());
            }
        }
        if (count > (countMax = theStorageSettings.getPreExpandValueSetsMaxCount())) {
            ourLog.warn("count parameter for $expand operation of {} exceeds maximum value of {}; using maximum value.", (Object)count, (Object)countMax);
            count = countMax;
        }
        ValueSetExpansionOptions options = ValueSetExpansionOptions.forOffsetAndCount((int)offset, (int)count);
        if (theIncludeHierarchy != null && Boolean.TRUE.equals(theIncludeHierarchy.getValue())) {
            options.setIncludeHierarchy(true);
        }
        if (theFilter != null) {
            options.setFilter((String)theFilter.getValue());
        }
        if (theDisplayLanguage != null) {
            options.setTheDisplayLanguage((String)theDisplayLanguage.getValue());
        }
        return options;
    }
}

