/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.model.SpecimenDefinition;

public class SpecimenDefinitionResourceProvider
extends BaseJpaResourceProvider<SpecimenDefinition> {
    public Class<SpecimenDefinition> getResourceType() {
        return SpecimenDefinition.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search the contents of the resource's data using a list") @OptionalParam(name="_list") StringAndListParam theList, @Description(shortDefinition="The language of the resource") @OptionalParam(name="_language") TokenAndListParam theResourceLanguage, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam the_lastUpdated, @Description(shortDefinition="The profile of the resource") @OptionalParam(name="_profile") UriAndListParam the_profile, @Description(shortDefinition="The security of the resource") @OptionalParam(name="_security") TokenAndListParam the_security, @Description(shortDefinition="The tag of the resource") @OptionalParam(name="_tag") TokenAndListParam the_tag, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="The type of specimen conditioned in container expected by the lab") @OptionalParam(name="container") TokenAndListParam theContainer, @Description(shortDefinition="Not for genuine usage (true)") @OptionalParam(name="experimental") TokenAndListParam theExperimental, @Description(shortDefinition="Multiple Resources: * [ActivityDefinition](activitydefinition.html): External identifier for the activity definition* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition* [Citation](citation.html): External identifier for the citation* [CodeSystem](codesystem.html): External identifier for the code system* [ConceptMap](conceptmap.html): External identifier for the concept map* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition* [EventDefinition](eventdefinition.html): External identifier for the event definition* [Evidence](evidence.html): External identifier for the evidence* [EvidenceReport](evidencereport.html): External identifier for the evidence report* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable* [ExampleScenario](examplescenario.html): External identifier for the example scenario* [GraphDefinition](graphdefinition.html): External identifier for the graph definition* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide* [Library](library.html): External identifier for the library* [Measure](measure.html): External identifier for the measure* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication* [MessageDefinition](messagedefinition.html): External identifier for the message definition* [NamingSystem](namingsystem.html): External identifier for the naming system* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition* [OperationDefinition](operationdefinition.html): External identifier for the search parameter* [PlanDefinition](plandefinition.html): External identifier for the plan definition* [Questionnaire](questionnaire.html): External identifier for the questionnaire* [Requirements](requirements.html): External identifier for the requirements* [SearchParameter](searchparameter.html): External identifier for the search parameter* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition* [StructureDefinition](structuredefinition.html): External identifier for the structure definition* [StructureMap](structuremap.html): External identifier for the structure map* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities* [TestPlan](testplan.html): An identifier for the test plan* [TestScript](testscript.html): External identifier for the test script* [ValueSet](valueset.html): External identifier for the value set") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Primary specimen (false) or derived specimen (true)") @OptionalParam(name="is-derived") TokenAndListParam theIs_derived, @Description(shortDefinition="Multiple Resources: * [ActivityDefinition](activitydefinition.html): The current status of the activity definition* [ActorDefinition](actordefinition.html): The current status of the Actor Definition* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition* [Citation](citation.html): The current status of the citation* [CodeSystem](codesystem.html): The current status of the code system* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition* [ConceptMap](conceptmap.html): The current status of the concept map* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition* [EventDefinition](eventdefinition.html): The current status of the event definition* [Evidence](evidence.html): The current status of the evidence* [EvidenceReport](evidencereport.html): The current status of the evidence report* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable* [ExampleScenario](examplescenario.html): The current status of the example scenario* [GraphDefinition](graphdefinition.html): The current status of the graph definition* [ImplementationGuide](implementationguide.html): The current status of the implementation guide* [Library](library.html): The current status of the library* [Measure](measure.html): The current status of the measure* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error* [MessageDefinition](messagedefinition.html): The current status of the message definition* [NamingSystem](namingsystem.html): The current status of the naming system* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown* [OperationDefinition](operationdefinition.html): The current status of the operation definition* [PlanDefinition](plandefinition.html): The current status of the plan definition* [Questionnaire](questionnaire.html): The current status of the questionnaire* [Requirements](requirements.html): The current status of the requirements* [SearchParameter](searchparameter.html): The current status of the search parameter* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown* [StructureDefinition](structuredefinition.html): The current status of the structure definition* [StructureMap](structuremap.html): The current status of the structure map* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities* [TestPlan](testplan.html): The current status of the test plan* [TestScript](testscript.html): The current status of the test script* [ValueSet](valueset.html): The current status of the value set") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="Multiple Resources: * [ActivityDefinition](activitydefinition.html): The human-friendly name of the activity definition* [ActorDefinition](actordefinition.html): The human-friendly name of the Actor Definition* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement* [ChargeItemDefinition](chargeitemdefinition.html): The human-friendly name of the charge item definition* [Citation](citation.html): The human-friendly name of the citation* [CodeSystem](codesystem.html): The human-friendly name of the code system* [ConceptMap](conceptmap.html): The human-friendly name of the concept map* [ConditionDefinition](conditiondefinition.html): The human-friendly name of the condition definition* [EventDefinition](eventdefinition.html): The human-friendly name of the event definition* [Evidence](evidence.html): The human-friendly name of the evidence* [EvidenceVariable](evidencevariable.html): The human-friendly name of the evidence variable* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide* [Library](library.html): The human-friendly name of the library* [Measure](measure.html): The human-friendly name of the measure* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition* [ObservationDefinition](observationdefinition.html): Human-friendly name of the ObservationDefinition* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition* [PlanDefinition](plandefinition.html): The human-friendly name of the plan definition* [Questionnaire](questionnaire.html): The human-friendly name of the questionnaire* [Requirements](requirements.html): The human-friendly name of the requirements* [SpecimenDefinition](specimendefinition.html): Human-friendly name of the SpecimenDefinition* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition* [StructureMap](structuremap.html): The human-friendly name of the structure map* [SubscriptionTopic](subscriptiontopic.html): Name for this SubscriptionTopic (Human friendly)* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities* [TestScript](testscript.html): The human-friendly name of the test script* [ValueSet](valueset.html): The human-friendly name of the value set") @OptionalParam(name="title") StringAndListParam theTitle, @Description(shortDefinition="The type of collected specimen") @OptionalParam(name="type") TokenAndListParam theType, @Description(shortDefinition="The type of specimen conditioned for testing") @OptionalParam(name="type-tested") TokenAndListParam theType_tested, @Description(shortDefinition="Multiple Resources: * [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition* [Citation](citation.html): The uri that identifies the citation* [CodeSystem](codesystem.html): The uri that identifies the code system* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition* [ConceptMap](conceptmap.html): The URI that identifies the concept map* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition* [EventDefinition](eventdefinition.html): The uri that identifies the event definition* [Evidence](evidence.html): The uri that identifies the evidence* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide* [Library](library.html): The uri that identifies the library* [Measure](measure.html): The uri that identifies the measure* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition* [NamingSystem](namingsystem.html): The uri that identifies the naming system* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire* [Requirements](requirements.html): The uri that identifies the requirements* [SearchParameter](searchparameter.html): The uri that identifies the search parameter* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition* [StructureMap](structuremap.html): The uri that identifies the structure map* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities* [TestPlan](testplan.html): The uri that identifies the test plan* [TestScript](testscript.html): The uri that identifies the test script* [ValueSet](valueset.html): The uri that identifies the value set") @OptionalParam(name="url") UriAndListParam theUrl, @RawParam Map<String, List<String>> theAdditionalRawParams, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        SpecimenDefinitionResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_list", (IQueryParameterAnd)theList);
            paramMap.add("_language", (IQueryParameterAnd)theResourceLanguage);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_profile", (IQueryParameterAnd)the_profile);
            paramMap.add("_security", (IQueryParameterAnd)the_security);
            paramMap.add("_tag", (IQueryParameterAnd)the_tag);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("container", (IQueryParameterAnd)theContainer);
            paramMap.add("experimental", (IQueryParameterAnd)theExperimental);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("is-derived", (IQueryParameterAnd)theIs_derived);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("title", (IQueryParameterAnd)theTitle);
            paramMap.add("type", (IQueryParameterAnd)theType);
            paramMap.add("type-tested", (IQueryParameterAnd)theType_tested);
            paramMap.add("url", (IQueryParameterAnd)theUrl);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(the_lastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            SpecimenDefinitionResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

