/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurationContext;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurationContext;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurer;
import org.springframework.stereotype.Component;

@Component
public class HapiHSearchAnalysisConfigurers {

    public static class HapiElasticsearchAnalysisConfigurer
    implements ElasticsearchAnalysisConfigurer {
        public void configure(ElasticsearchAnalysisConfigurationContext theConfigCtx) {
            theConfigCtx.analyzer("autocompleteEdgeAnalyzer").custom().tokenizer("pattern_all").tokenFilters(new String[]{"lowercase", "stop", "edgengram_3_50"});
            theConfigCtx.tokenizer("pattern_all").type("pattern").param("pattern", "(.*)").param("group", "1");
            theConfigCtx.tokenFilter("edgengram_3_50").type("edge_ngram").param("min_gram", "3").param("max_gram", "50");
            theConfigCtx.analyzer("autocompleteWordEdgeAnalyzer").custom().tokenizer("standard").tokenFilters(new String[]{"lowercase", "stop", "wordedgengram_3_50"});
            theConfigCtx.tokenFilter("wordedgengram_3_50").type("edge_ngram").param("min_gram", "3").param("max_gram", "20");
            theConfigCtx.analyzer("autocompletePhoneticAnalyzer").custom().tokenizer("standard").tokenFilters(new String[]{"stop", "snowball_english"});
            theConfigCtx.tokenFilter("snowball_english").type("snowball").param("language", "English");
            theConfigCtx.analyzer("autocompleteNGramAnalyzer").custom().tokenizer("standard").tokenFilters(new String[]{"word_delimiter", "lowercase", "ngram_3_20"});
            theConfigCtx.tokenFilter("ngram_3_20").type("ngram").param("min_gram", "3").param("max_gram", "20");
            theConfigCtx.analyzer("standardAnalyzer").custom().tokenizer("standard").tokenFilters(new String[]{"lowercase", "asciifolding"});
            theConfigCtx.analyzer("normStringAnalyzer").custom().tokenizer("keyword").tokenFilters(new String[]{"lowercase", "asciifolding"});
            theConfigCtx.analyzer("exactAnalyzer").custom().tokenizer("keyword").tokenFilters(new String[]{"unique"});
            theConfigCtx.analyzer("conceptParentPidsAnalyzer").custom().tokenizer("whitespace");
            theConfigCtx.normalizer("lowercaseAsciifoldingNormalizer").custom().tokenFilters(new String[]{"lowercase", "asciifolding"});
        }
    }

    public static class HapiLuceneAnalysisConfigurer
    implements LuceneAnalysisConfigurer {
        public static final String STANDARD_ANALYZER = "standardAnalyzer";
        public static final String NORM_STRING_ANALYZER = "normStringAnalyzer";
        public static final String EXACT_ANALYZER = "exactAnalyzer";

        public void configure(LuceneAnalysisConfigurationContext theLuceneCtx) {
            theLuceneCtx.analyzer("autocompleteEdgeAnalyzer").custom().tokenizer("pattern").param("pattern", "(.*)").param("group", "1").tokenFilter("lowercase").tokenFilter("stop").tokenFilter("edgeNGram").param("minGramSize", "3").param("maxGramSize", "50");
            theLuceneCtx.analyzer("autocompletePhoneticAnalyzer").custom().tokenizer("standard").tokenFilter("stop").tokenFilter("phonetic").param("encoder", "DoubleMetaphone").tokenFilter("snowballPorter").param("language", "English");
            theLuceneCtx.analyzer("autocompleteNGramAnalyzer").custom().tokenizer("standard").tokenFilter("wordDelimiterGraph").tokenFilter("lowercase").tokenFilter("nGram").param("minGramSize", "3").param("maxGramSize", "20");
            theLuceneCtx.analyzer("autocompleteWordEdgeAnalyzer").custom().tokenizer("standard").tokenFilter("lowercase").tokenFilter("stop").tokenFilter("edgeNGram").param("minGramSize", "3").param("maxGramSize", "20");
            theLuceneCtx.analyzer(STANDARD_ANALYZER).custom().tokenizer("standard").tokenFilter("lowercase").tokenFilter("asciiFolding");
            theLuceneCtx.analyzer(NORM_STRING_ANALYZER).custom().tokenizer("keyword").tokenFilter("lowercase").tokenFilter("asciiFolding");
            theLuceneCtx.analyzer(EXACT_ANALYZER).custom().tokenizer("keyword");
            theLuceneCtx.analyzer("conceptParentPidsAnalyzer").custom().tokenizer("whitespace");
            theLuceneCtx.normalizer("lowercaseAsciifoldingNormalizer").custom().tokenFilter("lowercase").tokenFilter("asciiFolding");
        }
    }
}

