/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.ISearchCoordinatorSvc;
import ca.uhn.fhir.jpa.dao.HistoryBuilder;
import ca.uhn.fhir.jpa.dao.HistoryBuilderFactory;
import ca.uhn.fhir.jpa.dao.IJpaStorageResourceParser;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchTypeEnum;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import ca.uhn.fhir.jpa.search.cache.SearchCacheStatusEnum;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.server.interceptor.ServerInterceptorUtil;
import ca.uhn.fhir.rest.server.method.ResponsePage;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PersistedJpaBundleProvider
implements IBundleProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(PersistedJpaBundleProvider.class);
    protected final RequestDetails myRequest;
    @Autowired
    protected HapiTransactionService myTxService;
    @PersistenceContext
    private EntityManager myEntityManager;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SearchBuilderFactory<JpaPid> mySearchBuilderFactory;
    @Autowired
    private HistoryBuilderFactory myHistoryBuilderFactory;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private ISearchCoordinatorSvc<JpaPid> mySearchCoordinatorSvc;
    @Autowired
    private ISearchCacheSvc mySearchCacheSvc;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @Autowired
    private IJpaStorageResourceParser myJpaStorageResourceParser;
    private Search mySearchEntity;
    private final String myUuid;
    private SearchCacheStatusEnum myCacheStatus;
    private RequestPartitionId myRequestPartitionId;

    public PersistedJpaBundleProvider(RequestDetails theRequest, String theSearchUuid) {
        this.myRequest = theRequest;
        this.myUuid = theSearchUuid;
    }

    public PersistedJpaBundleProvider(RequestDetails theRequest, Search theSearch) {
        this.myRequest = theRequest;
        this.mySearchEntity = theSearch;
        this.myUuid = theSearch.getUuid();
    }

    @VisibleForTesting
    public void setRequestPartitionHelperSvcForUnitTest(IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        this.myRequestPartitionHelperSvc = theRequestPartitionHelperSvc;
    }

    @VisibleForTesting
    public Search getSearchEntityForTesting() {
        return this.getSearchEntity();
    }

    protected Search getSearchEntity() {
        return this.mySearchEntity;
    }

    protected void setSearchEntity(Search theSearchEntity) {
        this.mySearchEntity = theSearchEntity;
    }

    private List<IBaseResource> doHistoryInTransaction(Integer theOffset, int theFromIndex, int theToIndex) {
        HistoryBuilder historyBuilder = this.myHistoryBuilderFactory.newHistoryBuilder(this.mySearchEntity.getResourceType(), this.mySearchEntity.getResourceId(), this.mySearchEntity.getLastUpdatedLow(), this.mySearchEntity.getLastUpdatedHigh());
        RequestPartitionId partitionId = this.getRequestPartitionId();
        List<ResourceHistoryTable> results = historyBuilder.fetchEntities(partitionId, theOffset, theFromIndex, theToIndex, this.mySearchEntity.getHistorySearchStyle());
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        Iterator<ResourceHistoryTable> iterator = results.iterator();
        while (iterator.hasNext()) {
            ResourceHistoryTable next;
            ResourceHistoryTable resource = next = iterator.next();
            retVal.add(this.myJpaStorageResourceParser.toResource((IBasePersistedResource)resource, true));
        }
        SimplePreResourceAccessDetails accessDetails = new SimplePreResourceAccessDetails(retVal);
        HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
        for (int i = retVal.size() - 1; i >= 0; --i) {
            if (!accessDetails.isDontReturnResourceAtIndex(i)) continue;
            retVal.remove(i);
        }
        SimplePreResourceShowDetails showDetails = new SimplePreResourceShowDetails(retVal);
        params = new HookParams().add(IPreResourceShowDetails.class, (Object)showDetails).add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (HookParams)params);
        retVal = showDetails.toList();
        return retVal;
    }

    @Nonnull
    protected final RequestPartitionId getRequestPartitionId() {
        if (this.myRequestPartitionId == null) {
            ReadPartitionIdRequestDetails details;
            if (this.mySearchEntity == null) {
                details = ReadPartitionIdRequestDetails.forSearchUuid((String)this.myUuid);
            } else if (this.mySearchEntity.getSearchType() == SearchTypeEnum.HISTORY) {
                details = ReadPartitionIdRequestDetails.forHistory((String)this.mySearchEntity.getResourceType(), null);
            } else {
                SearchParameterMap params = this.mySearchEntity.getSearchParameterMap().orElse(null);
                details = ReadPartitionIdRequestDetails.forSearchType((String)this.mySearchEntity.getResourceType(), (SearchParameterMap)params, null);
            }
            this.myRequestPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequest(this.myRequest, details);
        }
        return this.myRequestPartitionId;
    }

    public void setRequestPartitionId(RequestPartitionId theRequestPartitionId) {
        this.myRequestPartitionId = theRequestPartitionId;
    }

    protected List<IBaseResource> doSearchOrEverything(int theFromIndex, int theToIndex, @Nonnull ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
        if (this.mySearchEntity.getTotalCount() != null && this.mySearchEntity.getNumFound() <= 0) {
            return Collections.emptyList();
        }
        String resourceName = this.mySearchEntity.getResourceType();
        Class resourceType = this.myContext.getResourceDefinition(resourceName).getImplementingClass();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceName);
        ISearchBuilder sb = this.mySearchBuilderFactory.newSearchBuilder((IDao)dao, resourceName, resourceType);
        RequestPartitionId requestPartitionId = this.getRequestPartitionId();
        List pidsSubList = this.mySearchCoordinatorSvc.getResources(this.myUuid, theFromIndex, theToIndex + 1, this.myRequest, requestPartitionId);
        int maxSize = Math.min(theToIndex - theFromIndex, pidsSubList.size());
        theResponsePageBuilder.setTotalRequestedResourcesFetched(pidsSubList.size());
        List firstBatchOfPids = pidsSubList.subList(0, maxSize);
        List resources = (List)this.myTxService.withRequest(this.myRequest).withRequestPartitionId(requestPartitionId).execute(() -> this.toResourceList(sb, firstBatchOfPids, theResponsePageBuilder));
        return resources;
    }

    public boolean ensureSearchEntityLoaded() {
        if (this.mySearchEntity == null) {
            Optional searchOpt = (Optional)this.myTxService.withRequest(this.myRequest).withRequestPartitionId(this.myRequestPartitionId).execute(() -> this.mySearchCacheSvc.fetchByUuid(this.myUuid, this.myRequestPartitionId));
            if (!searchOpt.isPresent()) {
                return false;
            }
            this.setSearchEntity((Search)searchOpt.get());
            ourLog.trace("Retrieved search with version {} and total {}", (Object)this.mySearchEntity.getVersion(), (Object)this.mySearchEntity.getTotalCount());
            return true;
        }
        if (this.mySearchEntity.getSearchType() == SearchTypeEnum.HISTORY && this.mySearchEntity.getTotalCount() == null) {
            this.calculateHistoryCount();
        }
        return true;
    }

    private void calculateHistoryCount() {
        MemoryCacheService.HistoryCountKey key = this.mySearchEntity.getResourceId() != null ? MemoryCacheService.HistoryCountKey.forInstance((Long)this.mySearchEntity.getResourceId()) : (this.mySearchEntity.getResourceType() != null ? MemoryCacheService.HistoryCountKey.forType((String)this.mySearchEntity.getResourceType()) : MemoryCacheService.HistoryCountKey.forSystem());
        Function<MemoryCacheService.HistoryCountKey, Integer> supplier = k -> (Integer)this.myTxService.withRequest(this.myRequest).withRequestPartitionId(this.getRequestPartitionId()).execute(() -> {
            HistoryBuilder historyBuilder = this.myHistoryBuilderFactory.newHistoryBuilder(this.mySearchEntity.getResourceType(), this.mySearchEntity.getResourceId(), this.mySearchEntity.getLastUpdatedLow(), this.mySearchEntity.getLastUpdatedHigh());
            Long count = historyBuilder.fetchCount(this.getRequestPartitionId());
            return count.intValue();
        });
        boolean haveOffset = this.mySearchEntity.getLastUpdatedLow() != null || this.mySearchEntity.getLastUpdatedHigh() != null;
        switch (this.myStorageSettings.getHistoryCountMode()) {
            case COUNT_ACCURATE: {
                int count = supplier.apply(key);
                this.mySearchEntity.setTotalCount(count);
                break;
            }
            case CACHED_ONLY_WITHOUT_OFFSET: {
                if (haveOffset) break;
                int count = (Integer)this.myMemoryCacheService.get(MemoryCacheService.CacheEnum.HISTORY_COUNT, (Object)key, supplier);
                this.mySearchEntity.setTotalCount(count);
                break;
            }
        }
    }

    public InstantDt getPublished() {
        this.ensureSearchEntityLoaded();
        return new InstantDt(this.mySearchEntity.getCreated());
    }

    @Nonnull
    public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
        return this.getResources(theFromIndex, theToIndex, new ResponsePage.ResponsePageBuilder());
    }

    public List<IBaseResource> getResources(int theFromIndex, int theToIndex, @Nonnull ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
        boolean entityLoaded = this.ensureSearchEntityLoaded();
        assert (entityLoaded);
        assert (this.mySearchEntity != null);
        assert (this.mySearchEntity.getSearchType() != null);
        switch (this.mySearchEntity.getSearchType()) {
            case HISTORY: {
                return (List)this.myTxService.withRequest(this.myRequest).withRequestPartitionId(this.getRequestPartitionId()).execute(() -> this.doHistoryInTransaction(this.mySearchEntity.getOffset(), theFromIndex, theToIndex));
            }
        }
        List<IBaseResource> retVal = this.doSearchOrEverything(theFromIndex, theToIndex, theResponsePageBuilder);
        if (retVal.size() < theToIndex - theFromIndex) {
            this.mySearchEntity = null;
        }
        return retVal;
    }

    public String getUuid() {
        return this.myUuid;
    }

    public SearchCacheStatusEnum getCacheStatus() {
        return this.myCacheStatus;
    }

    void setCacheStatus(SearchCacheStatusEnum theSearchCacheStatusEnum) {
        this.myCacheStatus = theSearchCacheStatusEnum;
    }

    public Integer preferredPageSize() {
        this.ensureSearchEntityLoaded();
        return this.mySearchEntity.getPreferredPageSize();
    }

    public void setContext(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void setEntityManager(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    @VisibleForTesting
    public void setSearchCoordinatorSvcForUnitTest(ISearchCoordinatorSvc theSearchCoordinatorSvc) {
        this.mySearchCoordinatorSvc = theSearchCoordinatorSvc;
    }

    @VisibleForTesting
    public void setTxServiceForUnitTest(HapiTransactionService theTxManager) {
        this.myTxService = theTxManager;
    }

    public Integer size() {
        this.ensureSearchEntityLoaded();
        QueryParameterUtils.verifySearchHasntFailedOrThrowInternalErrorException(this.mySearchEntity);
        Integer size = this.mySearchEntity.getTotalCount();
        if (size != null) {
            return Math.max(0, size);
        }
        if (this.mySearchEntity.getSearchType() == SearchTypeEnum.HISTORY) {
            return null;
        }
        return this.mySearchCoordinatorSvc.getSearchTotal(this.myUuid, this.myRequest, this.myRequestPartitionId).orElse(null);
    }

    protected boolean hasIncludes() {
        this.ensureSearchEntityLoaded();
        return !this.mySearchEntity.getIncludes().isEmpty();
    }

    protected List<IBaseResource> toResourceList(ISearchBuilder theSearchBuilder, List<JpaPid> thePids, ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
        ArrayList includedPidList = new ArrayList();
        if (this.mySearchEntity.getSearchType() == SearchTypeEnum.SEARCH) {
            Integer maxIncludes = this.myStorageSettings.getMaximumIncludesToLoadPerPage();
            Set nonIterateRevIncludedPids = theSearchBuilder.loadIncludes(this.myContext, this.myEntityManager, thePids, this.mySearchEntity.toRevIncludesList(false), true, this.mySearchEntity.getLastUpdated(), this.myUuid, this.myRequest, maxIncludes);
            if (maxIncludes != null) {
                maxIncludes = maxIncludes - nonIterateRevIncludedPids.size();
            }
            thePids.addAll(nonIterateRevIncludedPids);
            includedPidList.addAll(nonIterateRevIncludedPids);
            Set nonIterateIncludedPids = theSearchBuilder.loadIncludes(this.myContext, this.myEntityManager, thePids, this.mySearchEntity.toIncludesList(false), false, this.mySearchEntity.getLastUpdated(), this.myUuid, this.myRequest, maxIncludes);
            if (maxIncludes != null) {
                maxIncludes = maxIncludes - nonIterateIncludedPids.size();
            }
            thePids.addAll(nonIterateIncludedPids);
            includedPidList.addAll(nonIterateIncludedPids);
            Set iterateRevIncludedPids = theSearchBuilder.loadIncludes(this.myContext, this.myEntityManager, thePids, this.mySearchEntity.toRevIncludesList(true), true, this.mySearchEntity.getLastUpdated(), this.myUuid, this.myRequest, maxIncludes);
            if (maxIncludes != null) {
                maxIncludes = maxIncludes - iterateRevIncludedPids.size();
            }
            thePids.addAll(iterateRevIncludedPids);
            includedPidList.addAll(iterateRevIncludedPids);
            Set iterateIncludedPids = theSearchBuilder.loadIncludes(this.myContext, this.myEntityManager, thePids, this.mySearchEntity.toIncludesList(true), false, this.mySearchEntity.getLastUpdated(), this.myUuid, this.myRequest, maxIncludes);
            thePids.addAll(iterateIncludedPids);
            includedPidList.addAll(iterateIncludedPids);
        }
        List<IBaseResource> resources = new ArrayList();
        theSearchBuilder.loadResourcesByPid(thePids, includedPidList, resources, false, this.myRequest);
        int precount = resources.size();
        resources = ServerInterceptorUtil.fireStoragePreshowResource(resources, (RequestDetails)this.myRequest, (IInterceptorBroadcaster)this.myInterceptorBroadcaster);
        theResponsePageBuilder.setOmittedResourceCount(precount - resources.size());
        theResponsePageBuilder.setResources(resources);
        theResponsePageBuilder.setIncludedResourceCount(includedPidList.size());
        return resources;
    }

    public void setInterceptorBroadcaster(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setSearchCacheSvcForUnitTest(ISearchCacheSvc theSearchCacheSvc) {
        this.mySearchCacheSvc = theSearchCacheSvc;
    }

    @VisibleForTesting
    public void setDaoRegistryForUnitTest(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    @VisibleForTesting
    public void setStorageSettingsForUnitTest(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    @VisibleForTesting
    public void setSearchBuilderFactoryForUnitTest(SearchBuilderFactory theSearchBuilderFactory) {
        this.mySearchBuilderFactory = theSearchBuilderFactory;
    }
}

