/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.exception.TokenParamFormatInvalidRequestException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.NormalizedQuantitySearchLevel;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.jpa.search.builder.models.MissingParameterQueryParams;
import ca.uhn.fhir.jpa.search.builder.models.MissingQueryParameterPredicateParams;
import ca.uhn.fhir.jpa.search.builder.models.PredicateBuilderCacheKey;
import ca.uhn.fhir.jpa.search.builder.models.PredicateBuilderCacheLookupResult;
import ca.uhn.fhir.jpa.search.builder.models.PredicateBuilderTypeEnum;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseQuantityPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboNonUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.CoordsPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.DatePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ICanMakeMissingParamPredicate;
import ca.uhn.fhir.jpa.search.builder.predicate.NumberPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ParsedLocationParam;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceIdPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceLinkPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceTablePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SearchParamPresentPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SourcePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TagPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TokenPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.UriPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.PredicateBuilderFactory;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.searchparam.util.SourceParam;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SetOperationQuery;
import com.healthmarketscience.sqlbuilder.Subquery;
import com.healthmarketscience.sqlbuilder.UnionQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QueryStack {
    private static final Logger ourLog = LoggerFactory.getLogger(QueryStack.class);
    public static final String LOCATION_POSITION = "Location.position";
    private static final Pattern PATTERN_DOT_AND_ALL_AFTER = Pattern.compile("\\..*");
    private final FhirContext myFhirContext;
    private final SearchQueryBuilder mySqlBuilder;
    private final SearchParameterMap mySearchParameters;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final PartitionSettings myPartitionSettings;
    private final JpaStorageSettings myStorageSettings;
    private final EnumSet<PredicateBuilderTypeEnum> myReusePredicateBuilderTypes;
    private Map<PredicateBuilderCacheKey, BaseJoiningPredicateBuilder> myJoinMap;
    private Map<String, BaseJoiningPredicateBuilder> myParamNameToPredicateBuilderMap;
    private boolean myUseAggregate;

    public QueryStack(SearchParameterMap theSearchParameters, JpaStorageSettings theStorageSettings, FhirContext theFhirContext, SearchQueryBuilder theSqlBuilder, ISearchParamRegistry theSearchParamRegistry, PartitionSettings thePartitionSettings) {
        this(theSearchParameters, theStorageSettings, theFhirContext, theSqlBuilder, theSearchParamRegistry, thePartitionSettings, EnumSet.of(PredicateBuilderTypeEnum.DATE));
    }

    private QueryStack(SearchParameterMap theSearchParameters, JpaStorageSettings theStorageSettings, FhirContext theFhirContext, SearchQueryBuilder theSqlBuilder, ISearchParamRegistry theSearchParamRegistry, PartitionSettings thePartitionSettings, EnumSet<PredicateBuilderTypeEnum> theReusePredicateBuilderTypes) {
        this.myPartitionSettings = thePartitionSettings;
        assert (theSearchParameters != null);
        assert (theStorageSettings != null);
        assert (theFhirContext != null);
        assert (theSqlBuilder != null);
        this.mySearchParameters = theSearchParameters;
        this.myStorageSettings = theStorageSettings;
        this.myFhirContext = theFhirContext;
        this.mySqlBuilder = theSqlBuilder;
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myReusePredicateBuilderTypes = theReusePredicateBuilderTypes;
    }

    public void addSortOnCoordsNear(String theParamName, boolean theAscending, SearchParameterMap theParams) {
        BaseJoiningPredicateBuilder builder;
        boolean handled = false;
        if (this.myParamNameToPredicateBuilderMap != null && (builder = this.myParamNameToPredicateBuilderMap.get(theParamName)) instanceof CoordsPredicateBuilder) {
            CoordsPredicateBuilder coordsBuilder = (CoordsPredicateBuilder)builder;
            List params = theParams.get(theParamName);
            if (params.size() > 0 && ((List)params.get(0)).size() > 0) {
                IQueryParameterType param = (IQueryParameterType)((List)params.get(0)).get(0);
                ParsedLocationParam location = ParsedLocationParam.from(theParams, param);
                double latitudeValue = location.getLatitudeValue();
                double longitudeValue = location.getLongitudeValue();
                this.mySqlBuilder.addSortCoordsNear(coordsBuilder, latitudeValue, longitudeValue, theAscending);
                handled = true;
            }
        }
        if (!handled) {
            String msg = this.myFhirContext.getLocalizer().getMessageSanitized(QueryStack.class, "cantSortOnCoordParamWithoutValues", new Object[]{theParamName});
            throw new InvalidRequestException(Msg.code((int)2307) + msg);
        }
    }

    public void addSortOnDate(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        DatePredicateBuilder datePredicateBuilder = this.mySqlBuilder.createDatePredicateBuilder();
        Condition hashIdentityPredicate = datePredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.addSortCustomJoin(firstPredicateBuilder, (BaseJoiningPredicateBuilder)datePredicateBuilder, hashIdentityPredicate);
        this.mySqlBuilder.addSortDate(datePredicateBuilder.getColumnValueLow(), theAscending, this.myUseAggregate);
    }

    public void addSortOnLastUpdated(boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ResourceTablePredicateBuilder resourceTablePredicateBuilder = firstPredicateBuilder instanceof ResourceTablePredicateBuilder ? (ResourceTablePredicateBuilder)firstPredicateBuilder : this.mySqlBuilder.addResourceTablePredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        this.mySqlBuilder.addSortDate(resourceTablePredicateBuilder.getColumnLastUpdated(), theAscending, this.myUseAggregate);
    }

    public void addSortOnNumber(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        NumberPredicateBuilder numberPredicateBuilder = this.mySqlBuilder.createNumberPredicateBuilder();
        Condition hashIdentityPredicate = numberPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.addSortCustomJoin(firstPredicateBuilder, (BaseJoiningPredicateBuilder)numberPredicateBuilder, hashIdentityPredicate);
        this.mySqlBuilder.addSortNumeric(numberPredicateBuilder.getColumnValue(), theAscending, this.myUseAggregate);
    }

    public void addSortOnQuantity(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        QuantityPredicateBuilder quantityPredicateBuilder = this.mySqlBuilder.createQuantityPredicateBuilder();
        Condition hashIdentityPredicate = quantityPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.addSortCustomJoin(firstPredicateBuilder, (BaseJoiningPredicateBuilder)quantityPredicateBuilder, hashIdentityPredicate);
        this.mySqlBuilder.addSortNumeric(quantityPredicateBuilder.getColumnValue(), theAscending, this.myUseAggregate);
    }

    public void addSortOnResourceId(boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ResourceTablePredicateBuilder resourceTablePredicateBuilder = firstPredicateBuilder instanceof ResourceTablePredicateBuilder ? (ResourceTablePredicateBuilder)firstPredicateBuilder : this.mySqlBuilder.addResourceTablePredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        this.mySqlBuilder.addSortString(resourceTablePredicateBuilder.getColumnFhirId(), theAscending, this.myUseAggregate);
    }

    public void addSortOnResourcePID(boolean theAscending) {
        BaseJoiningPredicateBuilder predicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        this.mySqlBuilder.addSortString(predicateBuilder.getResourceIdColumn(), theAscending);
    }

    public void addSortOnResourceLink(String theResourceName, String theReferenceTargetType, String theParamName, String theChain, boolean theAscending, SearchParameterMap theParams) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ResourceLinkPredicateBuilder resourceLinkPredicateBuilder = this.mySqlBuilder.createReferencePredicateBuilder(this);
        Condition pathPredicate = resourceLinkPredicateBuilder.createPredicateSourcePaths(theResourceName, theParamName);
        this.addSortCustomJoin(firstPredicateBuilder, (BaseJoiningPredicateBuilder)resourceLinkPredicateBuilder, pathPredicate);
        if (StringUtils.isBlank((CharSequence)theChain)) {
            this.mySqlBuilder.addSortNumeric(resourceLinkPredicateBuilder.getColumnTargetResourceId(), theAscending, this.myUseAggregate);
            return;
        }
        String targetType = null;
        RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
        if (theReferenceTargetType != null) {
            targetType = theReferenceTargetType;
        } else {
            if (param.getTargets().size() > 1) {
                throw new InvalidRequestException(Msg.code((int)2287) + "Unable to sort on a chained parameter from '" + theParamName + "' as this parameter has multiple target types. Please specify the target type.");
            }
            if (param.getTargets().size() == 1) {
                targetType = (String)param.getTargets().iterator().next();
            }
        }
        if (StringUtils.isBlank((CharSequence)targetType)) {
            throw new InvalidRequestException(Msg.code((int)2288) + "Unable to sort on a chained parameter from '" + theParamName + "' as this parameter as this parameter does not define a target type. Please specify the target type.");
        }
        RuntimeSearchParam targetSearchParameter = this.mySearchParamRegistry.getActiveSearchParam(targetType, theChain);
        if (targetSearchParameter == null) {
            Collection validSearchParameterNames = this.mySearchParamRegistry.getActiveSearchParams(targetType).values().stream().filter(t -> t.getParamType() == RestSearchParameterTypeEnum.STRING || t.getParamType() == RestSearchParameterTypeEnum.TOKEN || t.getParamType() == RestSearchParameterTypeEnum.DATE).map(RuntimeSearchParam::getName).sorted().distinct().collect(Collectors.toList());
            String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSortParameter", new Object[]{theChain, targetType, validSearchParameterNames});
            throw new InvalidRequestException(Msg.code((int)2289) + msg);
        }
        switch (targetSearchParameter.getParamType()) {
            case STRING: {
                StringPredicateBuilder stringPredicateBuilder = this.mySqlBuilder.createStringPredicateBuilder();
                this.addSortCustomJoin(resourceLinkPredicateBuilder.getColumnTargetResourceId(), (BaseJoiningPredicateBuilder)stringPredicateBuilder, stringPredicateBuilder.createHashIdentityPredicate(targetType, theChain));
                this.mySqlBuilder.addSortString(stringPredicateBuilder.getColumnValueNormalized(), theAscending, this.myUseAggregate);
                return;
            }
            case TOKEN: {
                TokenPredicateBuilder tokenPredicateBuilder = this.mySqlBuilder.createTokenPredicateBuilder();
                this.addSortCustomJoin(resourceLinkPredicateBuilder.getColumnTargetResourceId(), (BaseJoiningPredicateBuilder)tokenPredicateBuilder, tokenPredicateBuilder.createHashIdentityPredicate(targetType, theChain));
                this.mySqlBuilder.addSortString(tokenPredicateBuilder.getColumnSystem(), theAscending, this.myUseAggregate);
                this.mySqlBuilder.addSortString(tokenPredicateBuilder.getColumnValue(), theAscending, this.myUseAggregate);
                return;
            }
            case DATE: {
                DatePredicateBuilder datePredicateBuilder = this.mySqlBuilder.createDatePredicateBuilder();
                this.addSortCustomJoin(resourceLinkPredicateBuilder.getColumnTargetResourceId(), (BaseJoiningPredicateBuilder)datePredicateBuilder, datePredicateBuilder.createHashIdentityPredicate(targetType, theChain));
                this.mySqlBuilder.addSortDate(datePredicateBuilder.getColumnValueLow(), theAscending, this.myUseAggregate);
                return;
            }
            case SPECIAL: {
                if (!LOCATION_POSITION.equals(targetSearchParameter.getPath())) break;
                List params = theParams.get(theParamName);
                if (params == null || params.isEmpty() || ((List)params.get(0)).isEmpty()) {
                    String msg = this.myFhirContext.getLocalizer().getMessageSanitized(QueryStack.class, "cantSortOnCoordParamWithoutValues", new Object[]{theParamName});
                    throw new InvalidRequestException(Msg.code((int)2497) + msg);
                }
                IQueryParameterType locationParam = (IQueryParameterType)((List)params.get(0)).get(0);
                SpecialParam specialParam = new SpecialParam().setValue(locationParam.getValueAsQueryToken(this.myFhirContext));
                ParsedLocationParam location = ParsedLocationParam.from(theParams, (IQueryParameterType)specialParam);
                double latitudeValue = location.getLatitudeValue();
                double longitudeValue = location.getLongitudeValue();
                CoordsPredicateBuilder coordsPredicateBuilder = this.mySqlBuilder.addCoordsPredicateBuilder(resourceLinkPredicateBuilder.getColumnTargetResourceId());
                this.mySqlBuilder.addSortCoordsNear(coordsPredicateBuilder, latitudeValue, longitudeValue, theAscending);
                return;
            }
        }
        throw new InvalidRequestException(Msg.code((int)2290) + "Unable to sort on a chained parameter " + theParamName + "." + theChain + " as this parameter. Can not sort on chains of target type: " + targetSearchParameter.getParamType().name());
    }

    public void addSortOnString(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        StringPredicateBuilder stringPredicateBuilder = this.mySqlBuilder.createStringPredicateBuilder();
        Condition hashIdentityPredicate = stringPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.addSortCustomJoin(firstPredicateBuilder, (BaseJoiningPredicateBuilder)stringPredicateBuilder, hashIdentityPredicate);
        this.mySqlBuilder.addSortString(stringPredicateBuilder.getColumnValueNormalized(), theAscending, this.myUseAggregate);
    }

    public void addSortOnToken(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        TokenPredicateBuilder tokenPredicateBuilder = this.mySqlBuilder.createTokenPredicateBuilder();
        Condition hashIdentityPredicate = tokenPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.addSortCustomJoin(firstPredicateBuilder, (BaseJoiningPredicateBuilder)tokenPredicateBuilder, hashIdentityPredicate);
        this.mySqlBuilder.addSortString(tokenPredicateBuilder.getColumnSystem(), theAscending, this.myUseAggregate);
        this.mySqlBuilder.addSortString(tokenPredicateBuilder.getColumnValue(), theAscending, this.myUseAggregate);
    }

    public void addSortOnUri(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        UriPredicateBuilder uriPredicateBuilder = this.mySqlBuilder.createUriPredicateBuilder();
        Condition hashIdentityPredicate = uriPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.addSortCustomJoin(firstPredicateBuilder, (BaseJoiningPredicateBuilder)uriPredicateBuilder, hashIdentityPredicate);
        this.mySqlBuilder.addSortString(uriPredicateBuilder.getColumnValue(), theAscending, this.myUseAggregate);
    }

    private void addSortCustomJoin(BaseJoiningPredicateBuilder theFromJoiningPredicateBuilder, BaseJoiningPredicateBuilder theToJoiningPredicateBuilder, Condition theCondition) {
        this.addSortCustomJoin(theFromJoiningPredicateBuilder.getResourceIdColumn(), theToJoiningPredicateBuilder, theCondition);
    }

    private void addSortCustomJoin(DbColumn theFromDbColumn, BaseJoiningPredicateBuilder theToJoiningPredicateBuilder, Condition theCondition) {
        ComboCondition onCondition = this.mySqlBuilder.createOnCondition(theFromDbColumn, theToJoiningPredicateBuilder.getResourceIdColumn());
        if (theCondition != null) {
            onCondition.addCondition(theCondition);
        }
        this.mySqlBuilder.addCustomJoin(SelectQuery.JoinType.LEFT_OUTER, theFromDbColumn.getTable(), theToJoiningPredicateBuilder.getTable(), (Condition)onCondition);
    }

    public void setUseAggregate(boolean theUseAggregate) {
        this.myUseAggregate = theUseAggregate;
    }

    private <T extends BaseJoiningPredicateBuilder> PredicateBuilderCacheLookupResult<T> createOrReusePredicateBuilder(PredicateBuilderTypeEnum theType, DbColumn theSourceJoinColumn, String theParamName, Supplier<T> theFactoryMethod) {
        BaseJoiningPredicateBuilder retVal;
        boolean cacheHit = false;
        if (this.myReusePredicateBuilderTypes.contains((Object)theType)) {
            PredicateBuilderCacheKey key = new PredicateBuilderCacheKey(theSourceJoinColumn, theType, theParamName);
            if (this.myJoinMap == null) {
                this.myJoinMap = new HashMap<PredicateBuilderCacheKey, BaseJoiningPredicateBuilder>();
            }
            if ((retVal = this.myJoinMap.get(key)) != null) {
                cacheHit = true;
            } else {
                retVal = (BaseJoiningPredicateBuilder)theFactoryMethod.get();
                this.myJoinMap.put(key, retVal);
            }
        } else {
            retVal = (BaseJoiningPredicateBuilder)theFactoryMethod.get();
        }
        if (theType == PredicateBuilderTypeEnum.COORDS) {
            if (this.myParamNameToPredicateBuilderMap == null) {
                this.myParamNameToPredicateBuilderMap = new HashMap<String, BaseJoiningPredicateBuilder>();
            }
            this.myParamNameToPredicateBuilderMap.put(theParamName, retVal);
        }
        return new PredicateBuilderCacheLookupResult<BaseJoiningPredicateBuilder>(cacheHit, retVal);
    }

    private Condition createPredicateComposite(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theParamDef, List<? extends IQueryParameterType> theNextAnd, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateComposite(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDef, theNextAnd, theRequestPartitionId, this.mySqlBuilder);
    }

    private Condition createPredicateComposite(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theParamDef, List<? extends IQueryParameterType> theNextAnd, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        Condition orCondidtion = null;
        for (IQueryParameterType iQueryParameterType : theNextAnd) {
            if (!(iQueryParameterType instanceof CompositeParam)) {
                throw new InvalidRequestException(Msg.code((int)1203) + "Invalid type for composite param (must be " + CompositeParam.class.getSimpleName() + ": " + iQueryParameterType.getClass());
            }
            CompositeParam cp = (CompositeParam)iQueryParameterType;
            List componentParams = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParamDef);
            RuntimeSearchParam left = (RuntimeSearchParam)componentParams.get(0);
            IQueryParameterType leftValue = cp.getLeftValue();
            Condition leftPredicate = this.createPredicateCompositePart(theSourceJoinColumn, theResourceName, theSpnamePrefix, left, leftValue, theRequestPartitionId, theSqlBuilder);
            RuntimeSearchParam right = (RuntimeSearchParam)componentParams.get(1);
            IQueryParameterType rightValue = cp.getRightValue();
            Condition rightPredicate = this.createPredicateCompositePart(theSourceJoinColumn, theResourceName, theSpnamePrefix, right, rightValue, theRequestPartitionId, theSqlBuilder);
            Condition andCondition = QueryParameterUtils.toAndPredicate(leftPredicate, rightPredicate);
            if (orCondidtion == null) {
                orCondidtion = QueryParameterUtils.toOrPredicate(andCondition);
                continue;
            }
            orCondidtion = QueryParameterUtils.toOrPredicate(orCondidtion, andCondition);
        }
        return orCondidtion;
    }

    private Condition createPredicateCompositePart(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theParam, IQueryParameterType theParamValue, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        switch (theParam.getParamType()) {
            case STRING: {
                return this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId, theSqlBuilder);
            }
            case TOKEN: {
                return this.createPredicateToken(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId, theSqlBuilder);
            }
            case DATE: {
                return this.createPredicateDate(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), QueryParameterUtils.toOperation(((DateParam)theParamValue).getPrefix()), theRequestPartitionId, theSqlBuilder);
            }
            case QUANTITY: {
                return this.createPredicateQuantity(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId, theSqlBuilder);
            }
        }
        throw new InvalidRequestException(Msg.code((int)1204) + "Don't know how to handle composite parameter with type of " + theParam.getParamType());
    }

    private Condition createMissingParameterQuery(MissingParameterQueryParams theParams) {
        if (theParams.getParamType() == RestSearchParameterTypeEnum.COMPOSITE) {
            ourLog.error("Cannot create missing parameter query for a composite parameter.");
            return null;
        }
        if (theParams.getParamType() == RestSearchParameterTypeEnum.REFERENCE && this.isEligibleForEmbeddedChainedResourceSearch(theParams.getResourceType(), theParams.getParamName(), theParams.getQueryParameterTypes()).supportsUplifted()) {
            ourLog.error("Cannot construct missing query parameter search for ContainedResource REFERENCE search.");
            return null;
        }
        SearchQueryBuilder sqlBuilder = theParams.getSqlBuilder();
        if (this.myStorageSettings.getIndexMissingFields() == StorageSettings.IndexEnabledEnum.DISABLED) {
            return this.createMissingPredicateForUnindexedMissingFields(theParams, sqlBuilder);
        }
        return this.createMissingPredicateForIndexedMissingFields(theParams, sqlBuilder);
    }

    private Condition createMissingPredicateForIndexedMissingFields(MissingParameterQueryParams theParams, SearchQueryBuilder sqlBuilder) {
        PredicateBuilderTypeEnum predicateType = null;
        Supplier<BaseJoiningPredicateBuilder> supplier = null;
        switch (theParams.getParamType()) {
            case STRING: {
                predicateType = PredicateBuilderTypeEnum.STRING;
                supplier = () -> sqlBuilder.addStringPredicateBuilder(theParams.getSourceJoinColumn());
                break;
            }
            case NUMBER: {
                predicateType = PredicateBuilderTypeEnum.NUMBER;
                supplier = () -> sqlBuilder.addNumberPredicateBuilder(theParams.getSourceJoinColumn());
                break;
            }
            case DATE: {
                predicateType = PredicateBuilderTypeEnum.DATE;
                supplier = () -> sqlBuilder.addDatePredicateBuilder(theParams.getSourceJoinColumn());
                break;
            }
            case TOKEN: {
                predicateType = PredicateBuilderTypeEnum.TOKEN;
                supplier = () -> sqlBuilder.addTokenPredicateBuilder(theParams.getSourceJoinColumn());
                break;
            }
            case QUANTITY: {
                predicateType = PredicateBuilderTypeEnum.QUANTITY;
                supplier = () -> sqlBuilder.addQuantityPredicateBuilder(theParams.getSourceJoinColumn());
                break;
            }
            case REFERENCE: 
            case URI: {
                break;
            }
            case SPECIAL: 
            case HAS: {
                predicateType = PredicateBuilderTypeEnum.COORDS;
                supplier = () -> sqlBuilder.addCoordsPredicateBuilder(theParams.getSourceJoinColumn());
                break;
            }
        }
        if (supplier != null) {
            BaseSearchParamPredicateBuilder join = (BaseSearchParamPredicateBuilder)this.createOrReusePredicateBuilder(predicateType, theParams.getSourceJoinColumn(), theParams.getParamName(), supplier).getResult();
            return join.createPredicateParamMissingForNonReference(theParams.getResourceType(), theParams.getParamName(), theParams.isMissing(), theParams.getRequestPartitionId());
        }
        if (theParams.getParamType() == RestSearchParameterTypeEnum.REFERENCE) {
            SearchParamPresentPredicateBuilder join = sqlBuilder.addSearchParamPresentPredicateBuilder(theParams.getSourceJoinColumn());
            return join.createPredicateParamMissingForReference(theParams.getResourceType(), theParams.getParamName(), theParams.isMissing(), theParams.getRequestPartitionId());
        }
        if (theParams.getParamType() == RestSearchParameterTypeEnum.URI) {
            UriPredicateBuilder join = sqlBuilder.addUriPredicateBuilder(theParams.getSourceJoinColumn());
            return join.createPredicateParamMissingForNonReference(theParams.getResourceType(), theParams.getParamName(), theParams.isMissing(), theParams.getRequestPartitionId());
        }
        ourLog.error("Invalid param type " + theParams.getParamType().name());
        return null;
    }

    private Condition createMissingPredicateForUnindexedMissingFields(MissingParameterQueryParams theParams, SearchQueryBuilder sqlBuilder) {
        ResourceTablePredicateBuilder table = sqlBuilder.getOrCreateResourceTablePredicateBuilder();
        ICanMakeMissingParamPredicate innerQuery = PredicateBuilderFactory.createPredicateBuilderForParamType(theParams.getParamType(), theParams.getSqlBuilder(), this);
        return innerQuery.createPredicateParamMissingValue(new MissingQueryParameterPredicateParams(table, theParams.isMissing(), theParams.getParamName(), theParams.getRequestPartitionId()));
    }

    public Condition createPredicateCoords(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        Boolean isMissing = theList.get(0).getMissing();
        if (isMissing != null) {
            String paramName = QueryParameterUtils.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
            return this.createMissingParameterQuery(new MissingParameterQueryParams(theSqlBuilder, theSearchParam.getParamType(), theList, paramName, theResourceName, theSourceJoinColumn, theRequestPartitionId));
        }
        CoordsPredicateBuilder predicateBuilder = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.COORDS, theSourceJoinColumn, theSearchParam.getName(), () -> this.mySqlBuilder.addCoordsPredicateBuilder(theSourceJoinColumn)).getResult();
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition singleCode = predicateBuilder.createPredicateCoords(this.mySearchParameters, iQueryParameterType, theResourceName, theSearchParam, predicateBuilder, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        return predicateBuilder.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateDate(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateDate(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateDate(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        String paramName = QueryParameterUtils.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        Boolean isMissing = theList.get(0).getMissing();
        if (isMissing != null) {
            return this.createMissingParameterQuery(new MissingParameterQueryParams(theSqlBuilder, theSearchParam.getParamType(), theList, paramName, theResourceName, theSourceJoinColumn, theRequestPartitionId));
        }
        PredicateBuilderCacheLookupResult<DatePredicateBuilder> predicateBuilderLookupResult = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.DATE, theSourceJoinColumn, paramName, () -> theSqlBuilder.addDatePredicateBuilder(theSourceJoinColumn));
        DatePredicateBuilder predicateBuilder = predicateBuilderLookupResult.getResult();
        boolean cacheHit = predicateBuilderLookupResult.isCacheHit();
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition p = predicateBuilder.createPredicateDateWithoutIdentityPredicate(iQueryParameterType, theOperation);
            codePredicates.add(p);
        }
        Condition predicate = QueryParameterUtils.toOrPredicate(codePredicates);
        if (!cacheHit) {
            predicate = predicateBuilder.combineWithHashIdentityPredicate(theResourceName, paramName, predicate);
            predicate = predicateBuilder.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
        }
        return predicate;
    }

    private Condition createPredicateFilter(QueryStack theQueryStack3, SearchFilterParser.BaseFilter theFilter, String theResourceName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        if (theFilter instanceof SearchFilterParser.FilterParameter) {
            return this.createPredicateFilter(theQueryStack3, (SearchFilterParser.FilterParameter)theFilter, theResourceName, theRequest, theRequestPartitionId);
        }
        if (theFilter instanceof SearchFilterParser.FilterLogical) {
            Condition xPredicate = this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterLogical)theFilter).getFilter1(), theResourceName, theRequest, theRequestPartitionId);
            Condition yPredicate = this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterLogical)theFilter).getFilter2(), theResourceName, theRequest, theRequestPartitionId);
            if (((SearchFilterParser.FilterLogical)theFilter).getOperation() == SearchFilterParser.FilterLogicalOperation.and) {
                return ComboCondition.and((Condition[])new Condition[]{xPredicate, yPredicate});
            }
            if (((SearchFilterParser.FilterLogical)theFilter).getOperation() == SearchFilterParser.FilterLogicalOperation.or) {
                return ComboCondition.or((Condition[])new Condition[]{xPredicate, yPredicate});
            }
            throw new InvalidRequestException(Msg.code((int)1205) + "Don't know how to handle operation " + ((SearchFilterParser.FilterLogical)theFilter).getOperation());
        }
        return this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterParameterGroup)theFilter).getContained(), theResourceName, theRequest, theRequestPartitionId);
    }

    private Condition createPredicateFilter(QueryStack theQueryStack3, SearchFilterParser.FilterParameter theFilter, String theResourceName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        String paramName;
        switch (paramName = theFilter.getParamPath().getName()) {
            case "_id": {
                TokenParam param = new TokenParam();
                param.setValueAsQueryToken(null, null, null, theFilter.getValue());
                return theQueryStack3.createPredicateResourceId(null, Collections.singletonList(Collections.singletonList(param)), theResourceName, theFilter.getOperation(), theRequestPartitionId);
            }
            case "_source": {
                TokenParam param = new TokenParam();
                param.setValueAsQueryToken(null, null, null, theFilter.getValue());
                return this.createPredicateSource(null, Collections.singletonList(param));
            }
        }
        RuntimeSearchParam searchParam = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, paramName);
        if (searchParam == null) {
            Collection validNames = this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName);
            String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSearchParameter", new Object[]{paramName, theResourceName, validNames});
            throw new InvalidRequestException(Msg.code((int)1206) + msg);
        }
        RestSearchParameterTypeEnum typeEnum = searchParam.getParamType();
        if (typeEnum == RestSearchParameterTypeEnum.URI) {
            return theQueryStack3.createPredicateUri(null, theResourceName, null, searchParam, Collections.singletonList(new UriParam(theFilter.getValue())), theFilter.getOperation(), theRequest, theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.STRING) {
            return theQueryStack3.createPredicateString(null, theResourceName, null, searchParam, Collections.singletonList(new StringParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.DATE) {
            return theQueryStack3.createPredicateDate(null, theResourceName, null, searchParam, Collections.singletonList(new DateParam(QueryParameterUtils.fromOperation(theFilter.getOperation()), theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.NUMBER) {
            return theQueryStack3.createPredicateNumber(null, theResourceName, null, searchParam, Collections.singletonList(new NumberParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.REFERENCE) {
            SearchFilterParser.CompareOperation operation = theFilter.getOperation();
            String resourceType = null;
            String chain = theFilter.getParamPath().getNext() != null ? theFilter.getParamPath().getNext().toString() : null;
            String value = theFilter.getValue();
            ReferenceParam referenceParam = new ReferenceParam(resourceType, chain, value);
            return theQueryStack3.createPredicateReference(null, theResourceName, paramName, new ArrayList<String>(), Collections.singletonList(referenceParam), operation, theRequest, theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.QUANTITY) {
            return theQueryStack3.createPredicateQuantity(null, theResourceName, null, searchParam, Collections.singletonList(new QuantityParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.COMPOSITE) {
            throw new InvalidRequestException(Msg.code((int)1207) + "Composite search parameters not currently supported with _filter clauses");
        }
        if (typeEnum == RestSearchParameterTypeEnum.TOKEN) {
            TokenParam param = new TokenParam();
            param.setValueAsQueryToken(null, null, null, theFilter.getValue());
            return theQueryStack3.createPredicateToken(null, theResourceName, null, searchParam, Collections.singletonList(param), theFilter.getOperation(), theRequestPartitionId);
        }
        return null;
    }

    private Condition createPredicateHas(@Nullable DbColumn theSourceJoinColumn, String theResourceType, List<List<IQueryParameterType>> theHasParameters, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        ArrayList<Condition> andPredicates = new ArrayList<Condition>();
        for (List<IQueryParameterType> nextOrList : theHasParameters) {
            int colonIndex;
            String targetResourceType = null;
            String paramReference = null;
            String parameterName = null;
            String paramName = null;
            ArrayList<QualifiedParamList> parameters = new ArrayList<QualifiedParamList>();
            for (IQueryParameterType nextParam : nextOrList) {
                HasParam hasParam = (HasParam)nextParam;
                targetResourceType = hasParam.getTargetResourceType();
                paramReference = hasParam.getReferenceFieldName();
                parameterName = hasParam.getParameterName();
                paramName = PATTERN_DOT_AND_ALL_AFTER.matcher(parameterName).replaceAll("");
                parameters.add(QualifiedParamList.singleton(null, (String)hasParam.getValueAsQueryToken(this.myFhirContext)));
            }
            if (paramName == null) continue;
            try {
                this.myFhirContext.getResourceDefinition(targetResourceType);
            }
            catch (DataFormatException e) {
                throw new InvalidRequestException(Msg.code((int)1208) + "Invalid resource type: " + targetResourceType);
            }
            ArrayList orValues = Lists.newArrayList();
            if (paramName.startsWith("_has:")) {
                ourLog.trace("Handling double _has query: {}", (Object)paramName);
                String qualifier = paramName.substring(4);
                for (IQueryParameterType iQueryParameterType : nextOrList) {
                    HasParam nextHasParam = new HasParam();
                    nextHasParam.setValueAsQueryToken(this.myFhirContext, "_has", qualifier, iQueryParameterType.getValueAsQueryToken(this.myFhirContext));
                    orValues.add(nextHasParam);
                }
            } else if (paramName.equals("_id")) {
                for (IQueryParameterType iQueryParameterType : nextOrList) {
                    orValues.add(new TokenParam(iQueryParameterType.getValueAsQueryToken(this.myFhirContext)));
                }
            } else {
                RuntimeSearchParam owningParameterDef = this.mySearchParamRegistry.getRuntimeSearchParam(targetResourceType, paramName);
                this.mySearchParamRegistry.getRuntimeSearchParam(targetResourceType, paramReference);
                IQueryParameterAnd iQueryParameterAnd = JpaParamUtil.parseQueryParams((ISearchParamRegistry)this.mySearchParamRegistry, (FhirContext)this.myFhirContext, (RuntimeSearchParam)owningParameterDef, (String)paramName, parameters);
                for (IQueryParameterOr next2 : iQueryParameterAnd.getValuesAsQueryTokens()) {
                    orValues.addAll(next2.getValuesAsQueryTokens());
                }
            }
            if (parameterName.contains(".")) {
                String chainedPart = QueryParameterUtils.getChainedPart(parameterName);
                orValues.stream().filter(qp -> qp instanceof ReferenceParam).map(qp -> (ReferenceParam)qp).forEach(rp -> rp.setChain(chainedPart));
                parameterName = parameterName.substring(0, parameterName.indexOf(46));
            }
            if ((colonIndex = parameterName.indexOf(58)) != -1) {
                parameterName = parameterName.substring(0, colonIndex);
            }
            ResourceLinkPredicateBuilder resourceLinkPredicateBuilder = this.mySqlBuilder.addReferencePredicateBuilderReversed(this, theSourceJoinColumn);
            Condition condition = resourceLinkPredicateBuilder.createPartitionIdPredicate(theRequestPartitionId);
            List<String> paths = resourceLinkPredicateBuilder.createResourceLinkPaths(targetResourceType, paramReference, new ArrayList<String>());
            if (CollectionUtils.isEmpty(paths)) {
                throw new InvalidRequestException(Msg.code((int)2305) + "Reference field does not exist: " + paramReference);
            }
            BinaryCondition typePredicate = BinaryCondition.equalTo((Object)resourceLinkPredicateBuilder.getColumnTargetResourceType(), (Object)this.mySqlBuilder.generatePlaceholder(theResourceType));
            Condition pathPredicate = QueryParameterUtils.toEqualToOrInPredicate(resourceLinkPredicateBuilder.getColumnSourcePath(), this.mySqlBuilder.generatePlaceholders(paths));
            Condition linkedPredicate = this.searchForIdsWithAndOr(SearchForIdsParams.with().setSourceJoinColumn(resourceLinkPredicateBuilder.getColumnSrcResourceId()).setResourceName(targetResourceType).setParamName(parameterName).setAndOrParams(Collections.singletonList(orValues)).setRequest(theRequest).setRequestPartitionId(theRequestPartitionId));
            andPredicates.add(QueryParameterUtils.toAndPredicate(new Condition[]{condition, pathPredicate, typePredicate, linkedPredicate}));
        }
        return QueryParameterUtils.toAndPredicate(andPredicates);
    }

    public Condition createPredicateNumber(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateNumber(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateNumber(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        String paramName = QueryParameterUtils.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        Boolean isMissing = theList.get(0).getMissing();
        if (isMissing != null) {
            return this.createMissingParameterQuery(new MissingParameterQueryParams(theSqlBuilder, theSearchParam.getParamType(), theList, paramName, theResourceName, theSourceJoinColumn, theRequestPartitionId));
        }
        NumberPredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.NUMBER, theSourceJoinColumn, paramName, () -> theSqlBuilder.addNumberPredicateBuilder(theSourceJoinColumn)).getResult();
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            if (iQueryParameterType instanceof NumberParam) {
                NumberParam param = (NumberParam)iQueryParameterType;
                BigDecimal value = param.getValue();
                if (value == null) continue;
                SearchFilterParser.CompareOperation operation = theOperation;
                if (operation == null) {
                    operation = QueryParameterUtils.toOperation(param.getPrefix());
                }
                Condition predicate = join.createPredicateNumeric(theResourceName, paramName, operation, value, theRequestPartitionId, iQueryParameterType);
                codePredicates.add(predicate);
                continue;
            }
            throw new IllegalArgumentException(Msg.code((int)1211) + "Invalid token type: " + iQueryParameterType.getClass());
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateQuantity(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateQuantity(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateQuantity(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        List normalizedQuantityParams;
        String paramName = QueryParameterUtils.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        Boolean isMissing = theList.get(0).getMissing();
        if (isMissing != null) {
            return this.createMissingParameterQuery(new MissingParameterQueryParams(theSqlBuilder, theSearchParam.getParamType(), theList, paramName, theResourceName, theSourceJoinColumn, theRequestPartitionId));
        }
        List quantityParams = theList.stream().map(t -> QuantityParam.toQuantityParam((IQueryParameterType)t)).collect(Collectors.toList());
        BaseQuantityPredicateBuilder join = null;
        boolean normalizedSearchEnabled = this.myStorageSettings.getNormalizedQuantitySearchLevel().equals((Object)NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_SEARCH_SUPPORTED);
        if (normalizedSearchEnabled && (normalizedQuantityParams = quantityParams.stream().map(t -> UcumServiceUtil.toCanonicalQuantityOrNull((QuantityParam)t)).filter(t -> t != null).collect(Collectors.toList())).size() == quantityParams.size()) {
            join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.QUANTITY, theSourceJoinColumn, paramName, () -> theSqlBuilder.addQuantityNormalizedPredicateBuilder(theSourceJoinColumn)).getResult();
            quantityParams = normalizedQuantityParams;
        }
        if (join == null) {
            join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.QUANTITY, theSourceJoinColumn, paramName, () -> theSqlBuilder.addQuantityPredicateBuilder(theSourceJoinColumn)).getResult();
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (QuantityParam nextOr : quantityParams) {
            Condition singleCode = join.createPredicateQuantity(nextOr, theResourceName, paramName, null, join, theOperation, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateReference(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<String> theQualifiers, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateReference(theSourceJoinColumn, theResourceName, theParamName, theQualifiers, theList, theOperation, theRequest, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateReference(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<String> theQualifiers, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        if (theOperation != null && theOperation != SearchFilterParser.CompareOperation.eq && theOperation != SearchFilterParser.CompareOperation.ne) {
            throw new InvalidRequestException(Msg.code((int)1212) + "Invalid operator specified for reference predicate.  Supported operators for reference predicate are \"eq\" and \"ne\".");
        }
        Boolean isMissing = theList.get(0).getMissing();
        if (isMissing != null) {
            return this.createMissingParameterQuery(new MissingParameterQueryParams(theSqlBuilder, RestSearchParameterTypeEnum.REFERENCE, theList, theParamName, theResourceName, theSourceJoinColumn, theRequestPartitionId));
        }
        ResourceLinkPredicateBuilder predicateBuilder = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.REFERENCE, theSourceJoinColumn, theParamName, () -> theSqlBuilder.addReferencePredicateBuilder(this, theSourceJoinColumn)).getResult();
        return predicateBuilder.createPredicate(theRequest, theResourceName, theParamName, theQualifiers, theList, theOperation, theRequestPartitionId);
    }

    public void addGrouping() {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        this.mySqlBuilder.getSelect().addGroupings(new Column[]{firstPredicateBuilder.getResourceIdColumn()});
    }

    public void addOrdering() {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        this.mySqlBuilder.getSelect().addOrderings(new Column[]{firstPredicateBuilder.getResourceIdColumn()});
    }

    public Condition createPredicateReferenceForEmbeddedChainedSearchResource(@Nullable DbColumn theSourceJoinColumn, String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, EmbeddedChainedSearchModeEnum theEmbeddedChainedSearchModeEnum) {
        boolean wantChainedAndNormal = theEmbeddedChainedSearchModeEnum == EmbeddedChainedSearchModeEnum.UPLIFTED_AND_REF_JOIN;
        EnumSet<PredicateBuilderTypeEnum> cachedReusePredicateBuilderTypes = EnumSet.copyOf(this.myReusePredicateBuilderTypes);
        if (wantChainedAndNormal) {
            this.myReusePredicateBuilderTypes.clear();
        }
        ReferenceChainExtractor chainExtractor = new ReferenceChainExtractor();
        chainExtractor.deriveChains(theResourceName, theSearchParam, theList);
        Map<List<ChainElement>, Set<LeafNodeDefinition>> chains = chainExtractor.getChains();
        HashMap referenceLinks = Maps.newHashMap();
        for (List<ChainElement> nextChain : chains.keySet()) {
            Set<LeafNodeDefinition> leafNodes = chains.get(nextChain);
            this.collateChainedSearchOptions(referenceLinks, nextChain, leafNodes, theEmbeddedChainedSearchModeEnum);
        }
        UnionQuery union = null;
        ArrayList<Condition> predicates = null;
        if (wantChainedAndNormal) {
            union = new UnionQuery(SetOperationQuery.Type.UNION_ALL);
        } else {
            predicates = new ArrayList<Condition>();
        }
        predicates = new ArrayList();
        for (List nextReferenceLink : referenceLinks.keySet()) {
            for (LeafNodeDefinition leafNodeDefinition : (Set)referenceLinks.get(nextReferenceLink)) {
                SearchQueryBuilder builder = wantChainedAndNormal ? this.mySqlBuilder.newChildSqlBuilder() : this.mySqlBuilder;
                DbColumn previousJoinColumn = null;
                for (String nextLink : nextReferenceLink) {
                    ResourceLinkPredicateBuilder resourceLinkPredicateBuilder = builder.addReferencePredicateBuilder(this, previousJoinColumn);
                    builder.addPredicate(resourceLinkPredicateBuilder.createPredicateSourcePaths(Lists.newArrayList((Object[])new String[]{nextLink})));
                    previousJoinColumn = resourceLinkPredicateBuilder.getColumnTargetResourceId();
                }
                Condition containedCondition = this.createIndexPredicate(previousJoinColumn, leafNodeDefinition.getLeafTarget(), leafNodeDefinition.getLeafPathPrefix(), leafNodeDefinition.getLeafParamName(), leafNodeDefinition.getParamDefinition(), leafNodeDefinition.getOrValues(), theOperation, leafNodeDefinition.getQualifiers(), theRequest, theRequestPartitionId, builder);
                if (wantChainedAndNormal) {
                    builder.addPredicate(containedCondition);
                    union.addQueries(new SelectQuery[]{builder.getSelect()});
                    continue;
                }
                predicates.add(containedCondition);
            }
        }
        Object retVal = wantChainedAndNormal ? (theSourceJoinColumn == null ? new InCondition((Object)this.mySqlBuilder.getOrCreateFirstPredicateBuilder(false).getResourceIdColumn(), new Object[]{union}) : new InCondition((Object)theSourceJoinColumn, new Object[]{union})) : QueryParameterUtils.toOrPredicate(predicates);
        this.myReusePredicateBuilderTypes.addAll(cachedReusePredicateBuilderTypes);
        return retVal;
    }

    private void collateChainedSearchOptions(Map<List<String>, Set<LeafNodeDefinition>> referenceLinks, List<ChainElement> nextChain, Set<LeafNodeDefinition> leafNodes, EmbeddedChainedSearchModeEnum theEmbeddedChainedSearchModeEnum) {
        if (nextChain.size() == 1) {
            if (theEmbeddedChainedSearchModeEnum == EmbeddedChainedSearchModeEnum.UPLIFTED_AND_REF_JOIN) {
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath()}), leafNodes);
            }
            RuntimeSearchParam firstParamDefinition = leafNodes.iterator().next().getParamDefinition();
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList(), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(0)).getResourceType(), ((ChainElement)nextChain.get(0)).getSearchParameterName())).map(t -> t.withParam(firstParamDefinition)).collect(Collectors.toSet()));
        } else if (nextChain.size() == 2) {
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath(), nextChain.get(1).getPath()}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath()}), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(1)).getResourceType(), ((ChainElement)nextChain.get(1)).getSearchParameterName())).collect(Collectors.toSet()));
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{this.mergePaths(nextChain.get(0).getPath(), nextChain.get(1).getPath())}), leafNodes);
            if (this.myStorageSettings.isIndexOnContainedResourcesRecursively()) {
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList(), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(0)).getResourceType(), ((ChainElement)nextChain.get(0)).getSearchParameterName() + "." + ((ChainElement)nextChain.get(1)).getSearchParameterName())).collect(Collectors.toSet()));
            }
        } else if (nextChain.size() == 3) {
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath(), nextChain.get(1).getPath(), nextChain.get(2).getPath()}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath(), nextChain.get(1).getPath()}), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(2)).getResourceType(), ((ChainElement)nextChain.get(2)).getSearchParameterName())).collect(Collectors.toSet()));
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath(), this.mergePaths(nextChain.get(1).getPath(), nextChain.get(2).getPath())}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{this.mergePaths(nextChain.get(0).getPath(), nextChain.get(1).getPath()), nextChain.get(2).getPath()}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{this.mergePaths(nextChain.get(0).getPath(), nextChain.get(1).getPath())}), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(2)).getResourceType(), ((ChainElement)nextChain.get(2)).getSearchParameterName())).collect(Collectors.toSet()));
            if (this.myStorageSettings.isIndexOnContainedResourcesRecursively()) {
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{this.mergePaths(nextChain.get(0).getPath(), nextChain.get(1).getPath(), nextChain.get(2).getPath())}), leafNodes);
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath()}), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(1)).getResourceType(), ((ChainElement)nextChain.get(1)).getSearchParameterName() + "." + ((ChainElement)nextChain.get(2)).getSearchParameterName())).collect(Collectors.toSet()));
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList(), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(0)).getResourceType(), ((ChainElement)nextChain.get(0)).getSearchParameterName() + "." + ((ChainElement)nextChain.get(1)).getSearchParameterName() + "." + ((ChainElement)nextChain.get(2)).getSearchParameterName())).collect(Collectors.toSet()));
            }
        } else {
            throw new InvalidRequestException(Msg.code((int)2011) + "The search chain is too long. Only chains of up to three references are supported.");
        }
    }

    private void updateMapOfReferenceLinks(Map<List<String>, Set<LeafNodeDefinition>> theReferenceLinksMap, ArrayList<String> thePath, Set<LeafNodeDefinition> theLeafNodesToAdd) {
        HashSet leafNodes = theReferenceLinksMap.get(thePath);
        if (leafNodes == null) {
            leafNodes = Sets.newHashSet();
            theReferenceLinksMap.put(thePath, leafNodes);
        }
        leafNodes.addAll(theLeafNodesToAdd);
    }

    private String mergePaths(String ... paths) {
        Object result = "";
        for (String nextPath : paths) {
            int separatorIndex = nextPath.indexOf(46);
            result = StringUtils.isEmpty((CharSequence)result) ? nextPath : (String)result + nextPath.substring(separatorIndex);
        }
        return result;
    }

    private Condition createIndexPredicate(DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, String theParamName, RuntimeSearchParam theParamDefinition, ArrayList<IQueryParameterType> theOrValues, SearchFilterParser.CompareOperation theOperation, List<String> theQualifiers, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        Condition containedCondition;
        switch (theParamDefinition.getParamType()) {
            case DATE: {
                containedCondition = this.createPredicateDate(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case NUMBER: {
                containedCondition = this.createPredicateNumber(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case QUANTITY: {
                containedCondition = this.createPredicateQuantity(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case STRING: {
                containedCondition = this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case TOKEN: {
                containedCondition = this.createPredicateToken(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case COMPOSITE: {
                containedCondition = this.createPredicateComposite(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case URI: {
                containedCondition = this.createPredicateUri(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequest, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case REFERENCE: {
                containedCondition = this.createPredicateReference(theSourceJoinColumn, theResourceName, (String)(StringUtils.isBlank((CharSequence)theSpnamePrefix) ? theParamName : theSpnamePrefix + "." + theParamName), theQualifiers, theOrValues, theOperation, theRequest, theRequestPartitionId, theSqlBuilder);
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)1215) + "The search type:" + theParamDefinition.getParamType() + " is not supported.");
            }
        }
        return containedCondition;
    }

    @Nullable
    public Condition createPredicateResourceId(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theValues, String theResourceName, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        ResourceIdPredicateBuilder builder = this.mySqlBuilder.newResourceIdBuilder();
        return builder.createPredicateResourceId(theSourceJoinColumn, theResourceName, theValues, theOperation, theRequestPartitionId);
    }

    private Condition createPredicateSourceForAndList(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theAndOrParams) {
        this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ArrayList<Condition> andPredicates = new ArrayList<Condition>(theAndOrParams.size());
        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
            andPredicates.add(this.createPredicateSource(theSourceJoinColumn, nextAnd));
        }
        return QueryParameterUtils.toAndPredicate(andPredicates);
    }

    private Condition createPredicateSource(@Nullable DbColumn theSourceJoinColumn, List<? extends IQueryParameterType> theList) {
        if (this.myStorageSettings.getStoreMetaSourceInformation() == JpaStorageSettings.StoreMetaSourceInformationEnum.NONE) {
            String msg = this.myFhirContext.getLocalizer().getMessage(QueryStack.class, "sourceParamDisabled", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)1216) + msg);
        }
        ArrayList<Condition> orPredicates = new ArrayList<Condition>();
        Optional<IQueryParameterType> isMissingSourceOptional = theList.stream().filter(nextParameter -> nextParameter.getMissing() != null && nextParameter.getMissing() != false).findFirst();
        if (isMissingSourceOptional.isPresent()) {
            SourcePredicateBuilder join = this.getSourcePredicateBuilder(theSourceJoinColumn, SelectQuery.JoinType.LEFT_OUTER);
            orPredicates.add(join.createPredicateMissingSourceUri());
            return QueryParameterUtils.toOrPredicate(orPredicates);
        }
        SourcePredicateBuilder join = this.getSourcePredicateBuilder(theSourceJoinColumn, SelectQuery.JoinType.INNER);
        for (IQueryParameterType iQueryParameterType : theList) {
            SourceParam sourceParameter = new SourceParam(iQueryParameterType.getValueAsQueryToken(this.myFhirContext));
            String sourceUri = sourceParameter.getSourceUri();
            String requestId = sourceParameter.getRequestId();
            if (StringUtils.isNotBlank((CharSequence)sourceUri) && StringUtils.isNotBlank((CharSequence)requestId)) {
                orPredicates.add(QueryParameterUtils.toAndPredicate(join.createPredicateSourceUri(sourceUri), join.createPredicateRequestId(requestId)));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)sourceUri)) {
                orPredicates.add(join.createPredicateSourceUriWithModifiers(iQueryParameterType, this.myStorageSettings, sourceUri));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)requestId)) continue;
            orPredicates.add(join.createPredicateRequestId(requestId));
        }
        return QueryParameterUtils.toOrPredicate(orPredicates);
    }

    private SourcePredicateBuilder getSourcePredicateBuilder(@Nullable DbColumn theSourceJoinColumn, SelectQuery.JoinType theJoinType) {
        return this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.SOURCE, theSourceJoinColumn, "_source", () -> this.mySqlBuilder.addSourcePredicateBuilder(theSourceJoinColumn, theJoinType)).getResult();
    }

    public Condition createPredicateString(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateString(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        Boolean isMissing = theList.get(0).getMissing();
        String paramName = QueryParameterUtils.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        if (isMissing != null) {
            return this.createMissingParameterQuery(new MissingParameterQueryParams(theSqlBuilder, theSearchParam.getParamType(), theList, paramName, theResourceName, theSourceJoinColumn, theRequestPartitionId));
        }
        StringPredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.STRING, theSourceJoinColumn, paramName, () -> theSqlBuilder.addStringPredicateBuilder(theSourceJoinColumn)).getResult();
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition singleCode = join.createPredicateString(iQueryParameterType, theResourceName, theSpnamePrefix, theSearchParam, join, theOperation);
            codePredicates.add(singleCode);
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, QueryParameterUtils.toOrPredicate(codePredicates));
    }

    public Condition createPredicateTag(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theList, String theParamName, RequestPartitionId theRequestPartitionId) {
        TagTypeEnum tagType;
        if ("_tag".equals(theParamName)) {
            tagType = TagTypeEnum.TAG;
        } else if ("_profile".equals(theParamName)) {
            tagType = TagTypeEnum.PROFILE;
        } else if ("_security".equals(theParamName)) {
            tagType = TagTypeEnum.SECURITY_LABEL;
        } else {
            throw new IllegalArgumentException(Msg.code((int)1217) + "Param name: " + theParamName);
        }
        ArrayList<Condition> andPredicates = new ArrayList<Condition>();
        for (List<IQueryParameterType> nextAndParams : theList) {
            Condition tagPredicate;
            BaseJoiningPredicateBuilder join;
            if (!this.checkHaveTags(nextAndParams, theParamName)) continue;
            ArrayList tokens = Lists.newArrayList();
            boolean paramInverted = this.populateTokens(tokens, nextAndParams);
            if (tokens.isEmpty()) continue;
            if (paramInverted) {
                SearchQueryBuilder sqlBuilder = this.mySqlBuilder.newChildSqlBuilder();
                TagPredicateBuilder tagSelector = sqlBuilder.addTagPredicateBuilder(null);
                sqlBuilder.addPredicate(tagSelector.createPredicateTag(tagType, tokens, theParamName, theRequestPartitionId));
                SelectQuery sql = sqlBuilder.getSelect();
                join = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
                Subquery subSelect = new Subquery((Object)sql);
                tagPredicate = new InCondition((Object)join.getResourceIdColumn(), new Object[]{subSelect}).setNegate(true);
            } else {
                this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
                TagPredicateBuilder tagJoin = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.TAG, theSourceJoinColumn, theParamName, () -> this.mySqlBuilder.addTagPredicateBuilder(theSourceJoinColumn)).getResult();
                tagPredicate = tagJoin.createPredicateTag(tagType, tokens, theParamName, theRequestPartitionId);
                join = tagJoin;
            }
            andPredicates.add(join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, tagPredicate));
        }
        return QueryParameterUtils.toAndPredicate(andPredicates);
    }

    private boolean populateTokens(List<Triple<String, String, String>> theTokens, List<? extends IQueryParameterType> theAndParams) {
        boolean paramInverted = false;
        for (IQueryParameterType iQueryParameterType : theAndParams) {
            String system;
            String code;
            TokenParam nextParam;
            if (iQueryParameterType instanceof TokenParam) {
                nextParam = (TokenParam)iQueryParameterType;
                code = nextParam.getValue();
                system = nextParam.getSystem();
                if (nextParam.getModifier() == TokenParamModifier.NOT) {
                    paramInverted = true;
                }
            } else {
                nextParam = (UriParam)iQueryParameterType;
                code = nextParam.getValue();
                system = null;
            }
            if (!StringUtils.isNotBlank((CharSequence)code)) continue;
            theTokens.add((Triple<String, String, String>)Triple.of((Object)system, (Object)iQueryParameterType.getQueryParameterQualifier(), (Object)code));
        }
        return paramInverted;
    }

    private boolean checkHaveTags(List<? extends IQueryParameterType> theParams, String theParamName) {
        for (IQueryParameterType iQueryParameterType : theParams) {
            TokenParam nextParam;
            if (iQueryParameterType instanceof TokenParam) {
                nextParam = (TokenParam)iQueryParameterType;
                if (StringUtils.isNotBlank((CharSequence)nextParam.getValue())) {
                    return true;
                }
                if (StringUtils.isNotBlank((CharSequence)nextParam.getSystem())) {
                    throw new TokenParamFormatInvalidRequestException(Msg.code((int)1218), theParamName, nextParam.getValueAsQueryToken(this.myFhirContext));
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(nextParam = (UriParam)iQueryParameterType).getValue())) continue;
            return true;
        }
        return false;
    }

    public Condition createPredicateToken(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateToken(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    /*
     * WARNING - void declaration
     */
    public Condition createPredicateToken(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        void var13_18;
        BaseJoiningPredicateBuilder join;
        ArrayList<IQueryParameterType> tokens = new ArrayList<IQueryParameterType>();
        boolean paramInverted = false;
        for (IQueryParameterType iQueryParameterType : theList) {
            if (iQueryParameterType instanceof TokenParam) {
                if (((TokenParam)iQueryParameterType).isEmpty()) continue;
                TokenParam id = (TokenParam)iQueryParameterType;
                if (id.isText()) {
                    boolean tokenTextIndexingEnabled = BaseSearchParamExtractor.tokenTextIndexingEnabledForSearchParam((StorageSettings)this.myStorageSettings, (RuntimeSearchParam)theSearchParam);
                    if (!tokenTextIndexingEnabled) {
                        String msg = this.myStorageSettings.isSuppressStringIndexingInTokens() ? this.myFhirContext.getLocalizer().getMessage(QueryStack.class, "textModifierDisabledForServer", new Object[0]) : this.myFhirContext.getLocalizer().getMessage(QueryStack.class, "textModifierDisabledForSearchParam", new Object[0]);
                        throw new MethodNotAllowedException(Msg.code((int)1219) + msg);
                    }
                    return this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, null, theRequestPartitionId, theSqlBuilder);
                }
                TokenParamModifier modifier = id.getModifier();
                if (modifier == TokenParamModifier.NOT) {
                    tokens.add((IQueryParameterType)new TokenParam(((TokenParam)iQueryParameterType).getSystem(), ((TokenParam)iQueryParameterType).getValue()));
                    paramInverted = true;
                    continue;
                }
                tokens.add(iQueryParameterType);
                continue;
            }
            tokens.add(iQueryParameterType);
        }
        if (tokens.isEmpty()) {
            return null;
        }
        String paramName = QueryParameterUtils.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        if (paramInverted) {
            SearchQueryBuilder sqlBuilder = theSqlBuilder.newChildSqlBuilder();
            TokenPredicateBuilder tokenSelector = sqlBuilder.addTokenPredicateBuilder(null);
            sqlBuilder.addPredicate(tokenSelector.createPredicateToken(tokens, theResourceName, theSpnamePrefix, theSearchParam, theRequestPartitionId));
            SelectQuery sql = sqlBuilder.getSelect();
            Subquery subSelect = new Subquery((Object)sql);
            join = theSqlBuilder.getOrCreateFirstPredicateBuilder();
            if (theSourceJoinColumn == null) {
                InCondition inCondition = new InCondition((Object)join.getResourceIdColumn(), new Object[]{subSelect}).setNegate(true);
            } else {
                InCondition inCondition = new InCondition((Object)theSourceJoinColumn, new Object[]{subSelect}).setNegate(true);
            }
        } else {
            Boolean isMissing = theList.get(0).getMissing();
            if (isMissing != null) {
                return this.createMissingParameterQuery(new MissingParameterQueryParams(theSqlBuilder, theSearchParam.getParamType(), theList, paramName, theResourceName, theSourceJoinColumn, theRequestPartitionId));
            }
            TokenPredicateBuilder tokenJoin = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.TOKEN, theSourceJoinColumn, paramName, () -> theSqlBuilder.addTokenPredicateBuilder(theSourceJoinColumn)).getResult();
            Condition condition = tokenJoin.createPredicateToken(tokens, theResourceName, theSpnamePrefix, theSearchParam, theOperation, theRequestPartitionId);
            join = tokenJoin;
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)var13_18);
    }

    public Condition createPredicateUri(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateUri(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestDetails, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateUri(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        String paramName = QueryParameterUtils.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        Boolean isMissing = theList.get(0).getMissing();
        if (isMissing != null) {
            return this.createMissingParameterQuery(new MissingParameterQueryParams(theSqlBuilder, theSearchParam.getParamType(), theList, paramName, theResourceName, theSourceJoinColumn, theRequestPartitionId));
        }
        UriPredicateBuilder join = theSqlBuilder.addUriPredicateBuilder(theSourceJoinColumn);
        Condition predicate = join.addPredicate(theList, paramName, theOperation, theRequestDetails);
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
    }

    public QueryStack newChildQueryFactoryWithFullBuilderReuse() {
        return new QueryStack(this.mySearchParameters, this.myStorageSettings, this.myFhirContext, this.mySqlBuilder, this.mySearchParamRegistry, this.myPartitionSettings, EnumSet.allOf(PredicateBuilderTypeEnum.class));
    }

    @Nullable
    public Condition searchForIdsWithAndOr(SearchForIdsParams theSearchForIdsParams) {
        if (theSearchForIdsParams.myAndOrParams.isEmpty()) {
            return null;
        }
        switch (theSearchForIdsParams.myParamName) {
            case "_id": {
                return this.createPredicateResourceId(theSearchForIdsParams.mySourceJoinColumn, theSearchForIdsParams.myAndOrParams, theSearchForIdsParams.myResourceName, null, theSearchForIdsParams.myRequestPartitionId);
            }
            case "_pid": {
                return this.createPredicateResourcePID(theSearchForIdsParams.mySourceJoinColumn, theSearchForIdsParams.myAndOrParams);
            }
            case "_has": {
                return this.createPredicateHas(theSearchForIdsParams.mySourceJoinColumn, theSearchForIdsParams.myResourceName, theSearchForIdsParams.myAndOrParams, theSearchForIdsParams.myRequest, theSearchForIdsParams.myRequestPartitionId);
            }
            case "_tag": 
            case "_profile": 
            case "_security": {
                if (this.myStorageSettings.getTagStorageMode() == JpaStorageSettings.TagStorageModeEnum.INLINE) {
                    return this.createPredicateSearchParameter(theSearchForIdsParams.mySourceJoinColumn, theSearchForIdsParams.myResourceName, theSearchForIdsParams.myParamName, theSearchForIdsParams.myAndOrParams, theSearchForIdsParams.myRequest, theSearchForIdsParams.myRequestPartitionId);
                }
                return this.createPredicateTag(theSearchForIdsParams.mySourceJoinColumn, theSearchForIdsParams.myAndOrParams, theSearchForIdsParams.myParamName, theSearchForIdsParams.myRequestPartitionId);
            }
            case "_source": {
                return this.createPredicateSourceForAndList(theSearchForIdsParams.mySourceJoinColumn, theSearchForIdsParams.myAndOrParams);
            }
            case "_lastUpdated": {
                return this.createReverseSearchPredicateLastUpdated(theSearchForIdsParams.myAndOrParams, theSearchForIdsParams.mySourceJoinColumn);
            }
        }
        return this.createPredicateSearchParameter(theSearchForIdsParams.mySourceJoinColumn, theSearchForIdsParams.myResourceName, theSearchForIdsParams.myParamName, theSearchForIdsParams.myAndOrParams, theSearchForIdsParams.myRequest, theSearchForIdsParams.myRequestPartitionId);
    }

    private Condition createPredicateResourcePID(DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theAndOrParams) {
        Set pids;
        DbColumn pidColumn = theSourceJoinColumn;
        if (pidColumn == null) {
            BaseJoiningPredicateBuilder predicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
            pidColumn = predicateBuilder.getResourceIdColumn();
        }
        if ((pids = theAndOrParams.stream().map(orList -> orList.stream().map(v -> v.getValueAsQueryToken(this.myFhirContext)).map(Long::valueOf).collect(Collectors.toSet())).reduce(Sets::intersection).orElse(Set.of())).isEmpty()) {
            this.mySqlBuilder.setMatchNothing();
            return null;
        }
        return QueryParameterUtils.toEqualToOrInPredicate(pidColumn, this.mySqlBuilder.generatePlaceholders(pids));
    }

    private Condition createReverseSearchPredicateLastUpdated(List<List<IQueryParameterType>> theAndOrParams, DbColumn theSourceColumn) {
        ResourceTablePredicateBuilder resourceTableJoin = this.mySqlBuilder.addResourceTablePredicateBuilder(theSourceColumn);
        ArrayList<Condition> andPredicates = new ArrayList<Condition>(theAndOrParams.size());
        for (List<IQueryParameterType> aList : theAndOrParams) {
            if (aList.isEmpty()) continue;
            DateParam dateParam = (DateParam)aList.get(0);
            DateRangeParam dateRangeParam = new DateRangeParam(dateParam);
            ComboCondition aCondition = this.mySqlBuilder.addPredicateLastUpdated(dateRangeParam, resourceTableJoin);
            andPredicates.add((Condition)aCondition);
        }
        return QueryParameterUtils.toAndPredicate(andPredicates);
    }

    @Nullable
    private Condition createPredicateSearchParameter(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<List<IQueryParameterType>> theAndOrParams, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        ArrayList<Condition> andPredicates;
        block35: {
            block34: {
                andPredicates = new ArrayList<Condition>();
                RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
                if (nextParamDef == null) break block34;
                if (this.myPartitionSettings.isPartitioningEnabled() && this.myPartitionSettings.isIncludePartitionInSearchHashes() && theRequestPartitionId.isAllPartitions()) {
                    throw new PreconditionFailedException(Msg.code((int)1220) + "This server is not configured to support search against all partitions");
                }
                switch (nextParamDef.getParamType()) {
                    case DATE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            SearchFilterParser.CompareOperation operation = null;
                            if (nextAnd.size() > 0) {
                                DateParam param = (DateParam)nextAnd.get(0);
                                operation = QueryParameterUtils.toOperation(param.getPrefix());
                            }
                            andPredicates.add(this.createPredicateDate(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, operation, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case QUANTITY: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            SearchFilterParser.CompareOperation operation = null;
                            if (nextAnd.size() > 0) {
                                QuantityParam param = (QuantityParam)nextAnd.get(0);
                                operation = QueryParameterUtils.toOperation(param.getPrefix());
                            }
                            andPredicates.add(this.createPredicateQuantity(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, operation, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case REFERENCE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if (this.handleFullyChainedParameter(theSourceJoinColumn, theResourceName, theParamName, theRequest, theRequestPartitionId, andPredicates, nextAnd)) continue;
                            EmbeddedChainedSearchModeEnum embeddedChainedSearchModeEnum = this.isEligibleForEmbeddedChainedResourceSearch(theResourceName, theParamName, nextAnd);
                            if (embeddedChainedSearchModeEnum == EmbeddedChainedSearchModeEnum.REF_JOIN_ONLY) {
                                andPredicates.add(this.createPredicateReference(theSourceJoinColumn, theResourceName, theParamName, new ArrayList<String>(), nextAnd, null, theRequest, theRequestPartitionId));
                                continue;
                            }
                            andPredicates.add(this.createPredicateReferenceForEmbeddedChainedSearchResource(theSourceJoinColumn, theResourceName, nextParamDef, nextAnd, null, theRequest, theRequestPartitionId, embeddedChainedSearchModeEnum));
                        }
                        break block35;
                    }
                    case STRING: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateString(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, SearchFilterParser.CompareOperation.sw, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case TOKEN: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if (LOCATION_POSITION.equals(nextParamDef.getPath())) {
                                andPredicates.add(this.createPredicateCoords(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, theRequestPartitionId, this.mySqlBuilder));
                                continue;
                            }
                            andPredicates.add(this.createPredicateToken(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, null, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case NUMBER: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateNumber(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, null, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case COMPOSITE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateComposite(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case URI: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateUri(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, SearchFilterParser.CompareOperation.eq, theRequest, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case SPECIAL: 
                    case HAS: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if (!LOCATION_POSITION.equals(nextParamDef.getPath())) continue;
                            andPredicates.add(this.createPredicateCoords(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, theRequestPartitionId, this.mySqlBuilder));
                        }
                        break;
                    }
                }
                break block35;
            }
            if (!"_content".equals(theParamName) && !"_text".equals(theParamName)) {
                if ("_filter".equals(theParamName)) {
                    if (theAndOrParams.get(0).get(0) instanceof StringParam) {
                        SearchFilterParser.BaseFilter filter;
                        String filterString = ((StringParam)theAndOrParams.get(0).get(0)).getValue();
                        try {
                            filter = SearchFilterParser.parse(filterString);
                        }
                        catch (SearchFilterParser.FilterSyntaxException theE) {
                            throw new InvalidRequestException(Msg.code((int)1221) + "Error parsing _filter syntax: " + theE.getMessage());
                        }
                        if (filter != null) {
                            if (!this.myStorageSettings.isFilterParameterEnabled()) {
                                throw new InvalidRequestException(Msg.code((int)1222) + "_filter parameter is disabled on this server");
                            }
                            Condition predicate = this.createPredicateFilter(this, filter, theResourceName, theRequest, theRequestPartitionId);
                            if (predicate != null) {
                                this.mySqlBuilder.addPredicate(predicate);
                            }
                        }
                    }
                } else {
                    String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSearchParameter", new Object[]{theParamName, theResourceName, this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName)});
                    throw new InvalidRequestException(Msg.code((int)1223) + msg);
                }
            }
        }
        return QueryParameterUtils.toAndPredicate(andPredicates);
    }

    private boolean handleFullyChainedParameter(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, List<Condition> andPredicates, List<? extends IQueryParameterType> nextAnd) {
        String fullName;
        RuntimeSearchParam fullChainParam;
        ReferenceParam param;
        if (!nextAnd.isEmpty() && nextAnd.get(0) instanceof ReferenceParam && StringUtils.isNotBlank((CharSequence)(param = (ReferenceParam)nextAnd.get(0)).getChain()) && (fullChainParam = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, fullName = theParamName + "." + param.getChain())) != null) {
            List swappedParamTypes = nextAnd.stream().map(t -> this.newParameterInstance(fullChainParam, null, t.getValueAsQueryToken(this.myFhirContext))).collect(Collectors.toList());
            List<List<IQueryParameterType>> params = List.of(swappedParamTypes);
            Condition predicate = this.createPredicateSearchParameter(theSourceJoinColumn, theResourceName, fullName, params, theRequest, theRequestPartitionId);
            andPredicates.add(predicate);
            return true;
        }
        return false;
    }

    private EmbeddedChainedSearchModeEnum isEligibleForEmbeddedChainedResourceSearch(String theResourceType, String theParameterName, List<? extends IQueryParameterType> theParameter) {
        boolean indexOnContainedResources = this.myStorageSettings.isIndexOnContainedResources();
        boolean indexOnUpliftedRefchains = this.myStorageSettings.isIndexOnUpliftedRefchains();
        if (!indexOnContainedResources && !indexOnUpliftedRefchains) {
            return EmbeddedChainedSearchModeEnum.REF_JOIN_ONLY;
        }
        boolean haveUpliftCandidates = theParameter.stream().filter(t -> t instanceof ReferenceParam).map(t -> ((ReferenceParam)t).getChain()).filter(StringUtils::isNotBlank).filter(t -> !t.startsWith("_has:")).anyMatch(t -> {
            if (indexOnContainedResources) {
                return true;
            }
            RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(theResourceType, theParameterName);
            return param != null && param.hasUpliftRefchain(t);
        });
        if (haveUpliftCandidates) {
            if (indexOnContainedResources) {
                return EmbeddedChainedSearchModeEnum.UPLIFTED_AND_REF_JOIN;
            }
            return EmbeddedChainedSearchModeEnum.UPLIFTED_ONLY;
        }
        return EmbeddedChainedSearchModeEnum.REF_JOIN_ONLY;
    }

    public void addPredicateCompositeUnique(List<String> theIndexStrings, RequestPartitionId theRequestPartitionId) {
        ComboUniqueSearchParameterPredicateBuilder predicateBuilder = this.mySqlBuilder.addComboUniquePredicateBuilder();
        Condition predicate = predicateBuilder.createPredicateIndexString(theRequestPartitionId, theIndexStrings);
        this.mySqlBuilder.addPredicate(predicate);
    }

    public void addPredicateCompositeNonUnique(List<String> theIndexStrings, RequestPartitionId theRequestPartitionId) {
        ComboNonUniqueSearchParameterPredicateBuilder predicateBuilder = this.mySqlBuilder.addComboNonUniquePredicateBuilder();
        Condition predicate = predicateBuilder.createPredicateHashComplete(theRequestPartitionId, theIndexStrings);
        this.mySqlBuilder.addPredicate(predicate);
    }

    public void addPredicateEverythingOperation(String theResourceName, List<String> theTypeSourceResourceNames, Long ... theTargetPids) {
        ResourceLinkPredicateBuilder table = this.mySqlBuilder.addReferencePredicateBuilder(this, null);
        Condition predicate = table.createEverythingPredicate(theResourceName, theTypeSourceResourceNames, theTargetPids);
        this.mySqlBuilder.addPredicate(predicate);
        this.mySqlBuilder.getSelect().setIsDistinct(true);
    }

    public IQueryParameterType newParameterInstance(RuntimeSearchParam theParam, String theQualifier, String theValueAsQueryToken) {
        IQueryParameterType qp = this.newParameterInstance(theParam);
        qp.setValueAsQueryToken(this.myFhirContext, theParam.getName(), theQualifier, theValueAsQueryToken);
        return qp;
    }

    private IQueryParameterType newParameterInstance(RuntimeSearchParam theParam) {
        DateParam qp;
        switch (theParam.getParamType()) {
            case DATE: {
                qp = new DateParam();
                break;
            }
            case NUMBER: {
                qp = new NumberParam();
                break;
            }
            case QUANTITY: {
                qp = new QuantityParam();
                break;
            }
            case STRING: {
                qp = new StringParam();
                break;
            }
            case TOKEN: {
                qp = new TokenParam();
                break;
            }
            case COMPOSITE: {
                List compositeOf = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParam);
                if (compositeOf.size() != 2) {
                    throw new InternalErrorException(Msg.code((int)1224) + "Parameter " + theParam.getName() + " has " + compositeOf.size() + " composite parts. Don't know how handlt this.");
                }
                IQueryParameterType leftParam = this.newParameterInstance((RuntimeSearchParam)compositeOf.get(0));
                IQueryParameterType rightParam = this.newParameterInstance((RuntimeSearchParam)compositeOf.get(1));
                qp = new CompositeParam(leftParam, rightParam);
                break;
            }
            case URI: {
                qp = new UriParam();
                break;
            }
            case REFERENCE: {
                qp = new ReferenceParam();
                break;
            }
            case SPECIAL: {
                qp = new SpecialParam();
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)1225) + "The search type: " + theParam.getParamType() + " is not supported.");
            }
        }
        return qp;
    }

    static enum EmbeddedChainedSearchModeEnum {
        UPLIFTED_ONLY(true),
        UPLIFTED_AND_REF_JOIN(true),
        REF_JOIN_ONLY(false);

        private final boolean mySupportsUplifted;

        private EmbeddedChainedSearchModeEnum(boolean theSupportsUplifted) {
            this.mySupportsUplifted = theSupportsUplifted;
        }

        public boolean supportsUplifted() {
            return this.mySupportsUplifted;
        }
    }

    public static class SearchForIdsParams {
        DbColumn mySourceJoinColumn;
        String myResourceName;
        String myParamName;
        List<List<IQueryParameterType>> myAndOrParams;
        RequestDetails myRequest;
        RequestPartitionId myRequestPartitionId;
        ResourceTablePredicateBuilder myResourceTablePredicateBuilder;

        public static SearchForIdsParams with() {
            return new SearchForIdsParams();
        }

        public DbColumn getSourceJoinColumn() {
            return this.mySourceJoinColumn;
        }

        public SearchForIdsParams setSourceJoinColumn(DbColumn theSourceJoinColumn) {
            this.mySourceJoinColumn = theSourceJoinColumn;
            return this;
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public SearchForIdsParams setResourceName(String theResourceName) {
            this.myResourceName = theResourceName;
            return this;
        }

        public String getParamName() {
            return this.myParamName;
        }

        public SearchForIdsParams setParamName(String theParamName) {
            this.myParamName = theParamName;
            return this;
        }

        public List<List<IQueryParameterType>> getAndOrParams() {
            return this.myAndOrParams;
        }

        public SearchForIdsParams setAndOrParams(List<List<IQueryParameterType>> theAndOrParams) {
            this.myAndOrParams = theAndOrParams;
            return this;
        }

        public RequestDetails getRequest() {
            return this.myRequest;
        }

        public SearchForIdsParams setRequest(RequestDetails theRequest) {
            this.myRequest = theRequest;
            return this;
        }

        public RequestPartitionId getRequestPartitionId() {
            return this.myRequestPartitionId;
        }

        public SearchForIdsParams setRequestPartitionId(RequestPartitionId theRequestPartitionId) {
            this.myRequestPartitionId = theRequestPartitionId;
            return this;
        }

        public ResourceTablePredicateBuilder getResourceTablePredicateBuilder() {
            return this.myResourceTablePredicateBuilder;
        }

        public SearchForIdsParams setResourceTablePredicateBuilder(ResourceTablePredicateBuilder theResourceTablePredicateBuilder) {
            this.myResourceTablePredicateBuilder = theResourceTablePredicateBuilder;
            return this;
        }
    }

    private class ReferenceChainExtractor {
        private final Map<List<ChainElement>, Set<LeafNodeDefinition>> myChains = Maps.newHashMap();

        private ReferenceChainExtractor() {
        }

        public Map<List<ChainElement>, Set<LeafNodeDefinition>> getChains() {
            return this.myChains;
        }

        private boolean isReferenceParamValid(ReferenceParam theReferenceParam) {
            return StringUtils.split((String)theReferenceParam.getChain(), (char)'.').length <= 3;
        }

        private List<String> extractPaths(String theResourceType, RuntimeSearchParam theSearchParam) {
            List<String> pathsForType = theSearchParam.getPathsSplit().stream().map(String::trim).filter(t -> t.startsWith(theResourceType) || t.startsWith("(" + theResourceType)).collect(Collectors.toList());
            if (pathsForType.isEmpty()) {
                ourLog.warn("Search parameter {} does not have a path for resource type {}.", (Object)theSearchParam.getName(), (Object)theResourceType);
            }
            return pathsForType;
        }

        public void deriveChains(String theResourceType, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList) {
            List<String> paths = this.extractPaths(theResourceType, theSearchParam);
            for (String path : paths) {
                ArrayList searchParams = Lists.newArrayList();
                searchParams.add(new ChainElement(theResourceType, theSearchParam.getName(), path));
                for (IQueryParameterType iQueryParameterType : theList) {
                    String targetValue = iQueryParameterType.getValueAsQueryToken(QueryStack.this.myFhirContext);
                    if (!(iQueryParameterType instanceof ReferenceParam)) continue;
                    ReferenceParam referenceParam = (ReferenceParam)iQueryParameterType;
                    if (!this.isReferenceParamValid(referenceParam)) {
                        throw new InvalidRequestException(Msg.code((int)2007) + "The search chain " + theSearchParam.getName() + "." + referenceParam.getChain() + " is too long. Only chains up to three references are supported.");
                    }
                    String targetChain = referenceParam.getChain();
                    ArrayList qualifiers = Lists.newArrayList((Object[])new String[]{referenceParam.getResourceType()});
                    this.processNextLinkInChain(searchParams, theSearchParam, targetChain, targetValue, qualifiers, referenceParam.getResourceType());
                }
            }
        }

        private void processNextLinkInChain(List<ChainElement> theSearchParams, RuntimeSearchParam thePreviousSearchParam, String theChain, String theTargetValue, List<String> theQualifiers, String theResourceType) {
            int qualifierIndex;
            String nextParamName = theChain;
            String nextChain = null;
            String nextQualifier = null;
            int linkIndex = theChain.indexOf(46);
            if (linkIndex != -1) {
                nextParamName = theChain.substring(0, linkIndex);
                nextChain = theChain.substring(linkIndex + 1);
            }
            if ((qualifierIndex = nextParamName.indexOf(58)) != -1) {
                nextParamName = nextParamName.substring(0, qualifierIndex);
                nextQualifier = nextParamName.substring(qualifierIndex);
            }
            ArrayList qualifiersBranch = Lists.newArrayList();
            qualifiersBranch.addAll(theQualifiers);
            qualifiersBranch.add(nextQualifier);
            boolean searchParamFound = false;
            for (String nextTarget : thePreviousSearchParam.getTargets()) {
                RuntimeSearchParam nextSearchParam = null;
                if (StringUtils.isBlank((CharSequence)theResourceType) || theResourceType.equals(nextTarget)) {
                    nextSearchParam = QueryStack.this.mySearchParamRegistry.getActiveSearchParam(nextTarget, nextParamName);
                }
                if (nextSearchParam == null) continue;
                searchParamFound = true;
                if (StringUtils.isEmpty((CharSequence)nextChain)) {
                    ArrayList orValues = Lists.newArrayList();
                    if (RestSearchParameterTypeEnum.REFERENCE.equals((Object)nextSearchParam.getParamType())) {
                        orValues.add(new ReferenceParam(nextQualifier, "", theTargetValue));
                    } else {
                        IQueryParameterType qp = QueryStack.this.newParameterInstance(nextSearchParam);
                        qp.setValueAsQueryToken(QueryStack.this.myFhirContext, nextSearchParam.getName(), null, theTargetValue);
                        orValues.add(qp);
                    }
                    HashSet leafNodes = this.myChains.get(theSearchParams);
                    if (leafNodes == null) {
                        leafNodes = Sets.newHashSet();
                        this.myChains.put(theSearchParams, leafNodes);
                    }
                    leafNodes.add(new LeafNodeDefinition(nextSearchParam, orValues, nextTarget, nextParamName, "", qualifiersBranch));
                    continue;
                }
                List<String> nextPaths = this.extractPaths(nextTarget, nextSearchParam);
                for (String nextPath : nextPaths) {
                    ArrayList searchParamBranch = Lists.newArrayList();
                    searchParamBranch.addAll(theSearchParams);
                    searchParamBranch.add(new ChainElement(nextTarget, nextSearchParam.getName(), nextPath));
                    this.processNextLinkInChain(searchParamBranch, nextSearchParam, nextChain, theTargetValue, qualifiersBranch, nextQualifier);
                }
            }
            if (!searchParamFound) {
                throw new InvalidRequestException(Msg.code((int)1214) + QueryStack.this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidParameterChain", new Object[]{thePreviousSearchParam.getName() + "." + theChain}));
            }
        }
    }

    private static class LeafNodeDefinition {
        private final RuntimeSearchParam myParamDefinition;
        private final ArrayList<IQueryParameterType> myOrValues;
        private final String myLeafTarget;
        private final String myLeafParamName;
        private final String myLeafPathPrefix;
        private final List<String> myQualifiers;

        public LeafNodeDefinition(RuntimeSearchParam theParamDefinition, ArrayList<IQueryParameterType> theOrValues, String theLeafTarget, String theLeafParamName, String theLeafPathPrefix, List<String> theQualifiers) {
            this.myParamDefinition = theParamDefinition;
            this.myOrValues = theOrValues;
            this.myLeafTarget = theLeafTarget;
            this.myLeafParamName = theLeafParamName;
            this.myLeafPathPrefix = theLeafPathPrefix;
            this.myQualifiers = theQualifiers;
        }

        public RuntimeSearchParam getParamDefinition() {
            return this.myParamDefinition;
        }

        public ArrayList<IQueryParameterType> getOrValues() {
            return this.myOrValues;
        }

        public String getLeafTarget() {
            return this.myLeafTarget;
        }

        public String getLeafParamName() {
            return this.myLeafParamName;
        }

        public String getLeafPathPrefix() {
            return this.myLeafPathPrefix;
        }

        public List<String> getQualifiers() {
            return this.myQualifiers;
        }

        public LeafNodeDefinition withPathPrefix(String theResourceType, String theName) {
            return new LeafNodeDefinition(this.myParamDefinition, this.myOrValues, theResourceType, this.myLeafParamName, theName, this.myQualifiers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeafNodeDefinition that = (LeafNodeDefinition)o;
            return Objects.equals(this.myParamDefinition, that.myParamDefinition) && Objects.equals(this.myOrValues, that.myOrValues) && Objects.equals(this.myLeafTarget, that.myLeafTarget) && Objects.equals(this.myLeafParamName, that.myLeafParamName) && Objects.equals(this.myLeafPathPrefix, that.myLeafPathPrefix) && Objects.equals(this.myQualifiers, that.myQualifiers);
        }

        public int hashCode() {
            return Objects.hash(this.myParamDefinition, this.myOrValues, this.myLeafTarget, this.myLeafParamName, this.myLeafPathPrefix, this.myQualifiers);
        }

        public LeafNodeDefinition withParam(RuntimeSearchParam theParamDefinition) {
            return new LeafNodeDefinition(theParamDefinition, this.myOrValues, this.myLeafTarget, this.myLeafParamName, this.myLeafPathPrefix, this.myQualifiers);
        }
    }

    private static final class ChainElement {
        private final String myResourceType;
        private final String mySearchParameterName;
        private final String myPath;

        public ChainElement(String theResourceType, String theSearchParameterName, String thePath) {
            this.myResourceType = theResourceType;
            this.mySearchParameterName = theSearchParameterName;
            this.myPath = thePath;
        }

        public String getResourceType() {
            return this.myResourceType;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getSearchParameterName() {
            return this.mySearchParameterName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChainElement that = (ChainElement)o;
            return this.myResourceType.equals(that.myResourceType) && this.mySearchParameterName.equals(that.mySearchParameterName) && this.myPath.equals(that.myPath);
        }

        public int hashCode() {
            return Objects.hash(this.myResourceType, this.mySearchParameterName, this.myPath);
        }
    }
}

