/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.config.HapiFhirLocalContainerEntityManagerFactoryBean;
import ca.uhn.fhir.jpa.config.HibernatePropertiesProvider;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IJpaStorageResourceParser;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.data.IResourceSearchViewDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.dao.search.ResourceNotFoundInIndexException;
import ca.uhn.fhir.jpa.entity.ResourceSearchView;
import ca.uhn.fhir.jpa.interceptor.JpaPreResourceAccessDetails;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.SearchBuilderLoadIncludesParameters;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.model.util.JpaConstants;
import ca.uhn.fhir.jpa.search.builder.ISearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.SearchQueryExecutors;
import ca.uhn.fhir.jpa.search.builder.models.ResolvedSearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.sql.GeneratedSql;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.sql.SqlObjectFactory;
import ca.uhn.fhir.jpa.search.lastn.IElasticsearchSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.Dstu3DistanceHelper;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.searchparam.util.LastNParameterHelper;
import ca.uhn.fhir.jpa.util.BaseIterator;
import ca.uhn.fhir.jpa.util.CartesianProductUtil;
import ca.uhn.fhir.jpa.util.CurrentThreadCaptureQueriesListener;
import ca.uhn.fhir.jpa.util.InClauseNormalizer;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.jpa.util.SqlQueryList;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.BaseParamWithPrefix;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.StringUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SearchBuilder
implements ISearchBuilder<JpaPid> {
    @Deprecated
    public static final int MAXIMUM_PAGE_SIZE = 800;
    public static final int MAXIMUM_PAGE_SIZE_FOR_TESTING = 50;
    public static final String RESOURCE_ID_ALIAS = "resource_id";
    public static final String RESOURCE_VERSION_ALIAS = "resource_version";
    private static final Logger ourLog = LoggerFactory.getLogger(SearchBuilder.class);
    private static final JpaPid NO_MORE = JpaPid.fromId((Long)-1L);
    private static final String MY_TARGET_RESOURCE_PID = "myTargetResourcePid";
    private static final String MY_SOURCE_RESOURCE_PID = "mySourceResourcePid";
    private static final String MY_TARGET_RESOURCE_TYPE = "myTargetResourceType";
    private static final String MY_SOURCE_RESOURCE_TYPE = "mySourceResourceType";
    private static final String MY_TARGET_RESOURCE_VERSION = "myTargetResourceVersion";
    public static boolean myUseMaxPageSize50ForTest = false;
    protected final IInterceptorBroadcaster myInterceptorBroadcaster;
    protected final IResourceTagDao myResourceTagDao;
    private String myResourceName;
    private final Class<? extends IBaseResource> myResourceType;
    private final HapiFhirLocalContainerEntityManagerFactoryBean myEntityManagerFactory;
    private final SqlObjectFactory mySqlBuilderFactory;
    private final HibernatePropertiesProvider myDialectProvider;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final PartitionSettings myPartitionSettings;
    private final DaoRegistry myDaoRegistry;
    private final IResourceSearchViewDao myResourceSearchViewDao;
    private final FhirContext myContext;
    private final IIdHelperService<JpaPid> myIdHelperService;
    private final JpaStorageSettings myStorageSettings;
    private final IDao myCallingDao;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    private CriteriaBuilder myCriteriaBuilder;
    private SearchParameterMap myParams;
    private String mySearchUuid;
    private int myFetchSize;
    private Integer myMaxResultsToFetch;
    private Set<JpaPid> myPidSet;
    private boolean myHasNextIteratorQuery = false;
    private RequestPartitionId myRequestPartitionId;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearchSvc;
    @Autowired(required=false)
    private IElasticsearchSvc myIElasticsearchSvc;
    @Autowired
    private IJpaStorageResourceParser myJpaStorageResourceParser;

    public SearchBuilder(IDao theDao, String theResourceName, JpaStorageSettings theStorageSettings, HapiFhirLocalContainerEntityManagerFactoryBean theEntityManagerFactory, SqlObjectFactory theSqlBuilderFactory, HibernatePropertiesProvider theDialectProvider, ISearchParamRegistry theSearchParamRegistry, PartitionSettings thePartitionSettings, IInterceptorBroadcaster theInterceptorBroadcaster, IResourceTagDao theResourceTagDao, DaoRegistry theDaoRegistry, IResourceSearchViewDao theResourceSearchViewDao, FhirContext theContext, IIdHelperService theIdHelperService, Class<? extends IBaseResource> theResourceType) {
        this.myCallingDao = theDao;
        this.myResourceName = theResourceName;
        this.myResourceType = theResourceType;
        this.myStorageSettings = theStorageSettings;
        this.myEntityManagerFactory = theEntityManagerFactory;
        this.mySqlBuilderFactory = theSqlBuilderFactory;
        this.myDialectProvider = theDialectProvider;
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myPartitionSettings = thePartitionSettings;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
        this.myResourceTagDao = theResourceTagDao;
        this.myDaoRegistry = theDaoRegistry;
        this.myResourceSearchViewDao = theResourceSearchViewDao;
        this.myContext = theContext;
        this.myIdHelperService = theIdHelperService;
    }

    @VisibleForTesting
    void setResourceName(String theName) {
        this.myResourceName = theName;
    }

    public void setMaxResultsToFetch(Integer theMaxResultsToFetch) {
        this.myMaxResultsToFetch = theMaxResultsToFetch;
    }

    private void searchForIdsWithAndOr(SearchQueryBuilder theSearchSqlBuilder, QueryStack theQueryStack, @Nonnull SearchParameterMap theParams, RequestDetails theRequest) {
        this.myParams = theParams;
        theParams.clean();
        if (this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            Dstu3DistanceHelper.setNearDistance(this.myResourceType, (SearchParameterMap)theParams);
        }
        if (this.isCompositeUniqueSpCandidate()) {
            this.attemptComboUniqueSpProcessing(theQueryStack, theParams, theRequest);
        }
        List paramNames = this.myParams.keySet().stream().filter(t -> !t.equals("_id")).filter(t -> !t.equals("_tag")).collect(Collectors.toList());
        if (this.myParams.containsKey("_id")) {
            paramNames.add("_id");
        }
        if (this.myParams.containsKey("_tag")) {
            paramNames.add("_tag");
        }
        for (String nextParamName : paramNames) {
            if (this.myParams.isLastN() && LastNParameterHelper.isLastNParameter((String)nextParamName, (FhirContext)this.myContext)) continue;
            List andOrParams = this.myParams.get(nextParamName);
            Condition predicate = theQueryStack.searchForIdsWithAndOr(QueryStack.SearchForIdsParams.with().setResourceName(this.myResourceName).setParamName(nextParamName).setAndOrParams(andOrParams).setRequest(theRequest).setRequestPartitionId(this.myRequestPartitionId));
            if (predicate == null) continue;
            theSearchSqlBuilder.addPredicate(predicate);
        }
    }

    private boolean isCompositeUniqueSpCandidate() {
        return this.myStorageSettings.isUniqueIndexesEnabled() && this.myParams.getEverythingMode() == null;
    }

    public Long createCountQuery(SearchParameterMap theParams, String theSearchUuid, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        assert (theRequestPartitionId != null);
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        this.init(theParams, theSearchUuid, theRequestPartitionId);
        if (this.checkUseHibernateSearch()) {
            return this.myFulltextSearchSvc.count(this.myResourceName, theParams.clone());
        }
        List<ISearchQueryExecutor> queries = this.createQuery(theParams.clone(), null, null, null, true, theRequest, null);
        if (queries.isEmpty()) {
            return 0L;
        }
        return (Long)queries.get(0).next();
    }

    public void setPreviouslyAddedResourcePids(@Nonnull List<JpaPid> thePidSet) {
        this.myPidSet = new HashSet<JpaPid>(thePidSet);
    }

    public IResultIterator<JpaPid> createQuery(SearchParameterMap theParams, SearchRuntimeDetails theSearchRuntimeDetails, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        assert (theRequestPartitionId != null);
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        this.init(theParams, theSearchRuntimeDetails.getSearchUuid(), theRequestPartitionId);
        if (this.myPidSet == null) {
            this.myPidSet = new HashSet<JpaPid>();
        }
        return new QueryIterator(theSearchRuntimeDetails, theRequest);
    }

    private void init(SearchParameterMap theParams, String theSearchUuid, RequestPartitionId theRequestPartitionId) {
        this.myCriteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        this.myParams = theParams.clone();
        this.mySearchUuid = theSearchUuid;
        this.myRequestPartitionId = theRequestPartitionId;
    }

    private List<ISearchQueryExecutor> createQuery(SearchParameterMap theParams, SortSpec sort, Integer theOffset, Integer theMaximumResults, boolean theCountOnlyFlag, RequestDetails theRequest, SearchRuntimeDetails theSearchRuntimeDetails) {
        ArrayList<ISearchQueryExecutor> queries = new ArrayList<ISearchQueryExecutor>();
        if (this.checkUseHibernateSearch()) {
            boolean canSkipDatabase;
            ISearchQueryExecutor fulltextExecutor = null;
            ArrayList fulltextMatchIds = null;
            int resultCount = 0;
            if (this.myParams.isLastN()) {
                fulltextMatchIds = this.executeLastNAgainstIndex(theMaximumResults);
                resultCount = fulltextMatchIds.size();
            } else if (this.myParams.getEverythingMode() != null) {
                fulltextMatchIds = this.queryHibernateSearchForEverythingPids(theRequest);
                resultCount = fulltextMatchIds.size();
            } else {
                fulltextExecutor = this.myFulltextSearchSvc.searchScrolled(this.myResourceName, this.myParams, theRequest);
            }
            if (fulltextExecutor == null) {
                fulltextExecutor = SearchQueryExecutors.from(fulltextMatchIds != null ? fulltextMatchIds : new ArrayList());
            }
            if (theSearchRuntimeDetails != null) {
                theSearchRuntimeDetails.setFoundIndexMatchesCount(resultCount);
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(SearchRuntimeDetails.class, (Object)theSearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INDEXSEARCH_QUERY_COMPLETE, (HookParams)params);
            }
            boolean bl = canSkipDatabase = !fulltextExecutor.hasNext() || !this.myPartitionSettings.isPartitioningEnabled() && theParams.isEmpty() && theParams.getNearDistanceParam() == null && theParams.getLastUpdated() == null && theParams.getEverythingMode() == null && theParams.getOffset() == null;
            if (canSkipDatabase) {
                ourLog.trace("Query finished after HSearch.  Skip db query phase");
                if (theMaximumResults != null) {
                    fulltextExecutor = SearchQueryExecutors.limited(fulltextExecutor, theMaximumResults.intValue());
                }
                queries.add(fulltextExecutor);
            } else {
                ourLog.trace("Query needs db after HSearch.  Chunking.");
                new QueryChunker().chunk(fulltextExecutor, SearchBuilder.getMaximumPageSize(), t -> this.doCreateChunkedQueries(theParams, (List<Long>)t, theOffset, sort, theCountOnlyFlag, theRequest, queries));
            }
        } else {
            this.createChunkedQuery(theParams, sort, theOffset, theMaximumResults, theCountOnlyFlag, theRequest, null, queries);
        }
        return queries;
    }

    private boolean checkUseHibernateSearch() {
        boolean fulltextEnabled;
        boolean bl = fulltextEnabled = this.myFulltextSearchSvc != null && !this.myFulltextSearchSvc.isDisabled();
        if (!fulltextEnabled) {
            this.failIfUsed("_text");
            this.failIfUsed("_content");
        } else {
            for (SortSpec sortSpec : this.myParams.getAllChainsInOrder()) {
                String paramName = sortSpec.getParamName();
                if (!paramName.contains(".")) continue;
                this.failIfUsedWithChainedSort("_text");
                this.failIfUsedWithChainedSort("_content");
            }
        }
        return fulltextEnabled && this.myParams != null && this.myParams.getSearchContainedMode() == SearchContainedModeEnum.FALSE && this.myFulltextSearchSvc.canUseHibernateSearch(this.myResourceName, this.myParams) && this.myFulltextSearchSvc.supportsAllSortTerms(this.myResourceName, this.myParams);
    }

    private void failIfUsed(String theParamName) {
        if (this.myParams.containsKey(theParamName)) {
            throw new InvalidRequestException(Msg.code((int)1192) + "Fulltext search is not enabled on this service, can not process parameter: " + theParamName);
        }
    }

    private void failIfUsedWithChainedSort(String theParamName) {
        if (this.myParams.containsKey(theParamName)) {
            throw new InvalidRequestException(Msg.code((int)2524) + "Fulltext search combined with chained sorts are not supported, can not process parameter: " + theParamName);
        }
    }

    private List<JpaPid> executeLastNAgainstIndex(Integer theMaximumResults) {
        if (this.myStorageSettings.isAdvancedHSearchIndexing()) {
            if (this.myFulltextSearchSvc == null) {
                throw new InvalidRequestException(Msg.code((int)2027) + "LastN operation is not enabled on this service, can not process this request");
            }
            return this.myFulltextSearchSvc.lastN(this.myParams, theMaximumResults).stream().map(lastNResourceId -> (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, String.valueOf(lastNResourceId))).collect(Collectors.toList());
        }
        throw new InvalidRequestException(Msg.code((int)2033) + "LastN operation is not enabled on this service, can not process this request");
    }

    private List<JpaPid> queryHibernateSearchForEverythingPids(RequestDetails theRequestDetails) {
        JpaPid pid = null;
        if (this.myParams.get("_id") != null) {
            String idParamValue;
            IQueryParameterType idParam = (IQueryParameterType)((List)this.myParams.get("_id").get(0)).get(0);
            if (idParam instanceof TokenParam) {
                TokenParam idParm = (TokenParam)idParam;
                idParamValue = idParm.getValue();
            } else {
                StringParam idParm = (StringParam)idParam;
                idParamValue = idParm.getValue();
            }
            pid = (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, idParamValue);
        }
        return this.myFulltextSearchSvc.everything(this.myResourceName, this.myParams, pid, theRequestDetails);
    }

    private void doCreateChunkedQueries(SearchParameterMap theParams, List<Long> thePids, Integer theOffset, SortSpec sort, boolean theCount, RequestDetails theRequest, ArrayList<ISearchQueryExecutor> theQueries) {
        if (thePids.size() < SearchBuilder.getMaximumPageSize()) {
            thePids = InClauseNormalizer.normalizeIdListForInClause(thePids);
        }
        this.createChunkedQuery(theParams, sort, theOffset, thePids.size(), theCount, theRequest, thePids, theQueries);
    }

    private void extractTargetPidsFromIdParams(Set<Long> theTargetPids) {
        HashSet<String> ids = new HashSet<String>();
        List params = this.myParams.get("_id");
        for (List paramList : params) {
            for (IQueryParameterType param : paramList) {
                if (param instanceof StringParam) {
                    ids.add(((StringParam)param).getValue());
                    continue;
                }
                if (param instanceof TokenParam) {
                    ids.add(((TokenParam)param).getValue());
                    continue;
                }
                throw new IllegalArgumentException(Msg.code((int)1193) + "_id parameter must be a StringParam or TokenParam");
            }
        }
        Map idToPid = this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, new ArrayList(ids));
        for (JpaPid pid : idToPid.values()) {
            theTargetPids.add(pid.getId());
        }
    }

    private void createChunkedQuery(SearchParameterMap theParams, SortSpec sort, Integer theOffset, Integer theMaximumResults, boolean theCountOnlyFlag, RequestDetails theRequest, List<Long> thePidList, List<ISearchQueryExecutor> theSearchQueryExecutors) {
        if (this.myParams.getEverythingMode() != null) {
            this.createChunkedQueryForEverythingSearch(theParams, theOffset, theMaximumResults, theCountOnlyFlag, thePidList, theSearchQueryExecutors);
        } else {
            this.createChunkedQueryNormalSearch(theParams, sort, theOffset, theCountOnlyFlag, theRequest, thePidList, theSearchQueryExecutors);
        }
    }

    private void createChunkedQueryNormalSearch(SearchParameterMap theParams, SortSpec sort, Integer theOffset, boolean theCountOnlyFlag, RequestDetails theRequest, List<Long> thePidList, List<ISearchQueryExecutor> theSearchQueryExecutors) {
        Condition partitionIdPredicate;
        List activeComboParams;
        SearchQueryBuilder sqlBuilder = new SearchQueryBuilder(this.myContext, (StorageSettings)this.myStorageSettings, this.myPartitionSettings, this.myRequestPartitionId, this.myResourceName, this.mySqlBuilderFactory, this.myDialectProvider, theCountOnlyFlag);
        QueryStack queryStack3 = new QueryStack(theParams, this.myStorageSettings, this.myContext, sqlBuilder, this.mySearchParamRegistry, this.myPartitionSettings);
        if ((theParams.keySet().size() > 1 || theParams.getSort() != null || theParams.keySet().contains("_has") || this.isPotentiallyContainedReferenceParameterExistsAtRoot(theParams)) && (activeComboParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName, theParams.keySet())).isEmpty()) {
            sqlBuilder.setNeedResourceTableRoot(true);
        }
        if (theParams.containsKey("_filter") && (partitionIdPredicate = sqlBuilder.getOrCreateResourceTablePredicateBuilder().createPartitionIdPredicate(this.myRequestPartitionId)) != null) {
            sqlBuilder.addPredicate(partitionIdPredicate);
        }
        this.searchForIdsWithAndOr(sqlBuilder, queryStack3, this.myParams, theRequest);
        if (!sqlBuilder.haveAtLeastOnePredicate() && (partitionIdPredicate = sqlBuilder.getOrCreateResourceTablePredicateBuilder().createPartitionIdPredicate(this.myRequestPartitionId)) != null) {
            sqlBuilder.addPredicate(partitionIdPredicate);
        }
        this.addPidListPredicate(thePidList, sqlBuilder);
        this.addLastUpdatePredicate(sqlBuilder);
        if (this.myHasNextIteratorQuery && this.myPidSet.size() + sqlBuilder.countBindVariables() < 900) {
            sqlBuilder.excludeResourceIdsPredicate(this.myPidSet);
        }
        if (theOffset != null) {
            queryStack3.addGrouping();
            queryStack3.setUseAggregate(true);
        }
        if (sort != null) {
            assert (!theCountOnlyFlag);
            this.createSort(queryStack3, sort, theParams);
        }
        this.executeSearch(theOffset, theSearchQueryExecutors, sqlBuilder);
    }

    private void executeSearch(Integer theOffset, List<ISearchQueryExecutor> theSearchQueryExecutors, SearchQueryBuilder sqlBuilder) {
        GeneratedSql generatedSql = sqlBuilder.generate(theOffset, this.myMaxResultsToFetch);
        if (!generatedSql.isMatchNothing()) {
            SearchQueryExecutor executor = this.mySqlBuilderFactory.newSearchQueryExecutor(generatedSql, this.myMaxResultsToFetch);
            theSearchQueryExecutors.add(executor);
        }
    }

    private void createChunkedQueryForEverythingSearch(SearchParameterMap theParams, Integer theOffset, Integer theMaximumResults, boolean theCountOnlyFlag, List<Long> thePidList, List<ISearchQueryExecutor> theSearchQueryExecutors) {
        SearchQueryBuilder sqlBuilder = new SearchQueryBuilder(this.myContext, (StorageSettings)this.myStorageSettings, this.myPartitionSettings, this.myRequestPartitionId, null, this.mySqlBuilderFactory, this.myDialectProvider, theCountOnlyFlag);
        QueryStack queryStack3 = new QueryStack(theParams, this.myStorageSettings, this.myContext, sqlBuilder, this.mySearchParamRegistry, this.myPartitionSettings);
        JdbcTemplate jdbcTemplate = this.initializeJdbcTemplate(theMaximumResults);
        HashSet<Long> targetPids = new HashSet<Long>();
        if (this.myParams.get("_id") != null) {
            this.extractTargetPidsFromIdParams(targetPids);
            theSearchQueryExecutors.add(new ResolvedSearchQueryExecutor(new ArrayList<Long>(targetPids)));
        } else {
            SearchQueryBuilder fetchPidsSqlBuilder = new SearchQueryBuilder(this.myContext, (StorageSettings)this.myStorageSettings, this.myPartitionSettings, this.myRequestPartitionId, this.myResourceName, this.mySqlBuilderFactory, this.myDialectProvider, theCountOnlyFlag);
            GeneratedSql allTargetsSql = fetchPidsSqlBuilder.generate(theOffset, this.myMaxResultsToFetch);
            String sql = allTargetsSql.getSql();
            Object[] args = allTargetsSql.getBindVariables().toArray(new Object[0]);
            List output = jdbcTemplate.query(sql, args, (RowMapper)new SingleColumnRowMapper(Long.class));
            theSearchQueryExecutors.add(new ResolvedSearchQueryExecutor(output));
        }
        ArrayList<String> typeSourceResources = new ArrayList<String>();
        if (this.myParams.get("_type") != null) {
            typeSourceResources.addAll(this.extractTypeSourceResourcesFromParams());
        }
        queryStack3.addPredicateEverythingOperation(this.myResourceName, typeSourceResources, targetPids.toArray(new Long[0]));
        this.addPidListPredicate(thePidList, sqlBuilder);
        if (theOffset != null) {
            queryStack3.addGrouping();
            queryStack3.addOrdering();
            queryStack3.setUseAggregate(true);
        }
        this.executeSearch(theOffset, theSearchQueryExecutors, sqlBuilder);
    }

    private void addPidListPredicate(List<Long> thePidList, SearchQueryBuilder theSqlBuilder) {
        if (thePidList != null && !thePidList.isEmpty()) {
            theSqlBuilder.addResourceIdsPredicate(thePidList);
        }
    }

    private void addLastUpdatePredicate(SearchQueryBuilder theSqlBuilder) {
        DateRangeParam lu = this.myParams.getLastUpdated();
        if (lu != null && !lu.isEmpty()) {
            ComboCondition lastUpdatedPredicates = theSqlBuilder.addPredicateLastUpdated(lu);
            theSqlBuilder.addPredicate((Condition)lastUpdatedPredicates);
        }
    }

    private JdbcTemplate initializeJdbcTemplate(Integer theMaximumResults) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.myEntityManagerFactory.getDataSource());
        jdbcTemplate.setFetchSize(this.myFetchSize);
        if (theMaximumResults != null) {
            jdbcTemplate.setMaxRows(theMaximumResults.intValue());
        }
        return jdbcTemplate;
    }

    private Collection<String> extractTypeSourceResourcesFromParams() {
        List listOfList = this.myParams.get("_type");
        List iQueryParameterTypesList = listOfList.stream().flatMap(Collection::stream).collect(Collectors.toList());
        List resourceTypes = iQueryParameterTypesList.stream().map(param -> ((StringParam)param).getValue()).map(csvString -> List.of(csvString.split(","))).flatMap(Collection::stream).collect(Collectors.toList());
        Set knownResourceTypes = this.myContext.getResourceTypes();
        HashSet<String> retVal = new HashSet<String>();
        for (String type : resourceTypes) {
            String trimmed = type.trim();
            if (!knownResourceTypes.contains(trimmed)) {
                throw new ResourceNotFoundException(Msg.code((int)2197) + "Unknown resource type '" + trimmed + "' in _type parameter.");
            }
            retVal.add(trimmed);
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPotentiallyContainedReferenceParameterExistsAtRoot(SearchParameterMap theParams) {
        if (!this.myStorageSettings.isIndexOnContainedResources()) return false;
        if (!theParams.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).anyMatch(ReferenceParam.class::isInstance)) return false;
        return true;
    }

    private void createSort(QueryStack theQueryStack, SortSpec theSort, SearchParameterMap theParams) {
        boolean ascending;
        if (theSort == null || StringUtils.isBlank((CharSequence)theSort.getParamName())) {
            return;
        }
        boolean bl = ascending = theSort.getOrder() == null || theSort.getOrder() == SortOrderEnum.ASC;
        if ("_id".equals(theSort.getParamName())) {
            theQueryStack.addSortOnResourceId(ascending);
        } else if ("_pid".equals(theSort.getParamName())) {
            theQueryStack.addSortOnResourcePID(ascending);
        } else if ("_lastUpdated".equals(theSort.getParamName())) {
            theQueryStack.addSortOnLastUpdated(ascending);
        } else {
            String[] chains;
            RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, theSort.getParamName());
            String paramName = theSort.getParamName();
            if (param == null && this.myStorageSettings.isIndexOnUpliftedRefchains() && (chains = StringUtils.split((String)paramName, (char)'.')).length == 2) {
                RuntimeSearchParam outerParam;
                String referenceParam = chains[0];
                String referenceParamTargetType = null;
                String targetParam = chains[1];
                int colonIdx = referenceParam.indexOf(58);
                if (colonIdx > -1) {
                    referenceParamTargetType = referenceParam.substring(0, colonIdx);
                    referenceParam = referenceParam.substring(colonIdx + 1);
                }
                if ((outerParam = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, referenceParam)) == null) {
                    this.throwInvalidRequestExceptionForUnknownSortParameter(this.myResourceName, referenceParam);
                } else if (outerParam.hasUpliftRefchain(targetParam)) {
                    for (String nextTargetType : outerParam.getTargets()) {
                        RuntimeSearchParam innerParam;
                        if (referenceParamTargetType != null && !referenceParamTargetType.equals(nextTargetType) || (innerParam = this.mySearchParamRegistry.getActiveSearchParam(nextTargetType, targetParam)) == null) continue;
                        param = innerParam;
                        break;
                    }
                }
            }
            int colonIdx = paramName.indexOf(58);
            String referenceTargetType = null;
            if (colonIdx > -1) {
                referenceTargetType = paramName.substring(0, colonIdx);
                paramName = paramName.substring(colonIdx + 1);
            }
            int dotIdx = paramName.indexOf(46);
            String chainName = null;
            if (param == null && dotIdx > -1) {
                chainName = paramName.substring(dotIdx + 1);
                paramName = paramName.substring(0, dotIdx);
                if (chainName.contains(".")) {
                    String msg = this.myContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSortParameterTooManyChains", new Object[]{paramName + "." + chainName});
                    throw new InvalidRequestException(Msg.code((int)2286) + msg);
                }
            }
            if (param == null) {
                param = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, paramName);
            }
            if (param == null) {
                this.throwInvalidRequestExceptionForUnknownSortParameter(this.getResourceName(), paramName);
            }
            assert (param != null);
            if (StringUtils.isNotBlank(chainName) && param.getParamType() != RestSearchParameterTypeEnum.REFERENCE) {
                throw new InvalidRequestException(Msg.code((int)2285) + "Invalid chain, " + paramName + " is not a reference SearchParameter");
            }
            switch (param.getParamType()) {
                case STRING: {
                    theQueryStack.addSortOnString(this.myResourceName, paramName, ascending);
                    break;
                }
                case DATE: {
                    theQueryStack.addSortOnDate(this.myResourceName, paramName, ascending);
                    break;
                }
                case REFERENCE: {
                    theQueryStack.addSortOnResourceLink(this.myResourceName, referenceTargetType, paramName, chainName, ascending, theParams);
                    break;
                }
                case TOKEN: {
                    theQueryStack.addSortOnToken(this.myResourceName, paramName, ascending);
                    break;
                }
                case NUMBER: {
                    theQueryStack.addSortOnNumber(this.myResourceName, paramName, ascending);
                    break;
                }
                case URI: {
                    theQueryStack.addSortOnUri(this.myResourceName, paramName, ascending);
                    break;
                }
                case QUANTITY: {
                    theQueryStack.addSortOnQuantity(this.myResourceName, paramName, ascending);
                    break;
                }
                case COMPOSITE: {
                    List compositeList = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)param);
                    if (compositeList == null) {
                        throw new InvalidRequestException(Msg.code((int)1195) + "The composite _sort parameter " + paramName + " is not defined by the resource " + this.myResourceName);
                    }
                    if (compositeList.size() != 2) {
                        throw new InvalidRequestException(Msg.code((int)1196) + "The composite _sort parameter " + paramName + " must have 2 composite types declared in parameter annotation, found " + compositeList.size());
                    }
                    RuntimeSearchParam left = (RuntimeSearchParam)compositeList.get(0);
                    RuntimeSearchParam right = (RuntimeSearchParam)compositeList.get(1);
                    this.createCompositeSort(theQueryStack, left.getParamType(), left.getName(), ascending);
                    this.createCompositeSort(theQueryStack, right.getParamType(), right.getName(), ascending);
                    break;
                }
                case SPECIAL: {
                    if ("Location.position".equals(param.getPath())) {
                        theQueryStack.addSortOnCoordsNear(paramName, ascending, theParams);
                        break;
                    }
                    throw new InvalidRequestException(Msg.code((int)2306) + "This server does not support _sort specifications of type " + param.getParamType() + " - Can't serve _sort=" + paramName);
                }
                default: {
                    throw new InvalidRequestException(Msg.code((int)1197) + "This server does not support _sort specifications of type " + param.getParamType() + " - Can't serve _sort=" + paramName);
                }
            }
        }
        this.createSort(theQueryStack, theSort.getChain(), theParams);
    }

    private void throwInvalidRequestExceptionForUnknownSortParameter(String theResourceName, String theParamName) {
        Collection validSearchParameterNames = this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName);
        String msg = this.myContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSortParameter", new Object[]{theParamName, theResourceName, validSearchParameterNames});
        throw new InvalidRequestException(Msg.code((int)1194) + msg);
    }

    private void createCompositeSort(QueryStack theQueryStack, RestSearchParameterTypeEnum theParamType, String theParamName, boolean theAscending) {
        switch (theParamType) {
            case STRING: {
                theQueryStack.addSortOnString(this.myResourceName, theParamName, theAscending);
                break;
            }
            case DATE: {
                theQueryStack.addSortOnDate(this.myResourceName, theParamName, theAscending);
                break;
            }
            case TOKEN: {
                theQueryStack.addSortOnToken(this.myResourceName, theParamName, theAscending);
                break;
            }
            case QUANTITY: {
                theQueryStack.addSortOnQuantity(this.myResourceName, theParamName, theAscending);
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)1198) + "Don't know how to handle composite parameter with type of " + theParamType + " on _sort=" + theParamName);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doLoadPids(Collection<JpaPid> thePids, Collection<JpaPid> theIncludedPids, List<IBaseResource> theResourceListToPopulate, boolean theForHistoryOperation, Map<JpaPid, Integer> thePosition) {
        HashMap<Long, Long> resourcePidToVersion = null;
        for (JpaPid next : thePids) {
            if (next.getVersion() == null || !this.myStorageSettings.isRespectVersionsForSearchIncludes()) continue;
            if (resourcePidToVersion == null) {
                resourcePidToVersion = new HashMap<Long, Long>();
            }
            resourcePidToVersion.put(next.getId(), next.getVersion());
        }
        List<Long> versionlessPids = JpaPid.toLongList(thePids);
        if (versionlessPids.size() < SearchBuilder.getMaximumPageSize()) {
            versionlessPids = InClauseNormalizer.normalizeIdListForInClause(versionlessPids);
        }
        Collection<ResourceSearchView> resourceSearchViewList = this.myResourceSearchViewDao.findByResourceIds(versionlessPids);
        Map<Long, Collection<ResourceTag>> tagMap = this.getResourceTagMap(resourceSearchViewList);
        for (IBaseResourceEntity iBaseResourceEntity : resourceSearchViewList) {
            void var11_11;
            if (iBaseResourceEntity.getDeleted() != null) continue;
            Class resourceType = this.myContext.getResourceDefinition(iBaseResourceEntity.getResourceType()).getImplementingClass();
            JpaPid resourceId = JpaPid.fromId((Long)iBaseResourceEntity.getResourceId());
            if (resourcePidToVersion != null) {
                Long version = (Long)resourcePidToVersion.get(iBaseResourceEntity.getResourceId());
                resourceId.setVersion(version);
                if (version != null && !version.equals(iBaseResourceEntity.getVersion())) {
                    IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
                    IBaseResourceEntity iBaseResourceEntity2 = (IBaseResourceEntity)dao.readEntity((IIdType)iBaseResourceEntity.getIdDt().withVersion(Long.toString(version)), null);
                }
            }
            Object resource = null;
            if (var11_11 != null) {
                resource = this.myJpaStorageResourceParser.toResource(resourceType, (IBaseResourceEntity)var11_11, tagMap.get(var11_11.getId()), theForHistoryOperation);
            }
            if (resource == null) {
                if (var11_11 != null) {
                    ourLog.warn("Unable to find resource {}/{}/_history/{} in database", new Object[]{var11_11.getResourceType(), var11_11.getIdDt().getIdPart(), var11_11.getVersion()});
                    continue;
                }
                ourLog.warn("Unable to find resource in database.");
                continue;
            }
            Integer index = thePosition.get(resourceId);
            if (index == null) {
                ourLog.warn("Got back unexpected resource PID {}", (Object)resourceId);
                continue;
            }
            if (theIncludedPids.contains(resourceId)) {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put(resource, (Object)BundleEntrySearchModeEnum.INCLUDE);
            } else {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put(resource, (Object)BundleEntrySearchModeEnum.MATCH);
            }
            theResourceListToPopulate.set(index, (IBaseResource)resource);
        }
    }

    private Map<Long, Collection<ResourceTag>> getResourceTagMap(Collection<? extends IBaseResourceEntity> theResourceSearchViewList) {
        ArrayList<Long> idList = new ArrayList<Long>(theResourceSearchViewList.size());
        for (IBaseResourceEntity iBaseResourceEntity : theResourceSearchViewList) {
            if (!iBaseResourceEntity.isHasTags()) continue;
            idList.add(iBaseResourceEntity.getId());
        }
        return this.getPidToTagMap(idList);
    }

    @Nonnull
    private Map<Long, Collection<ResourceTag>> getPidToTagMap(List<Long> thePidList) {
        HashMap<Long, Collection<ResourceTag>> tagMap = new HashMap<Long, Collection<ResourceTag>>();
        if (thePidList.isEmpty()) {
            return tagMap;
        }
        Collection<ResourceTag> tagList = this.myResourceTagDao.findByResourceIds(thePidList);
        for (ResourceTag tag : tagList) {
            JpaPid resourceId = JpaPid.fromId((Long)tag.getResourceId());
            ArrayList<ResourceTag> tagCol = (ArrayList<ResourceTag>)tagMap.get(resourceId.getId());
            if (tagCol == null) {
                tagCol = new ArrayList<ResourceTag>();
                tagCol.add(tag);
                tagMap.put(resourceId.getId(), tagCol);
                continue;
            }
            tagCol.add(tag);
        }
        return tagMap;
    }

    public void loadResourcesByPid(Collection<JpaPid> thePids, Collection<JpaPid> theIncludedPids, List<IBaseResource> theResourceListToPopulate, boolean theForHistoryOperation, RequestDetails theDetails) {
        if (thePids.isEmpty()) {
            ourLog.debug("The include pids are empty");
        }
        assert (new HashSet<JpaPid>(thePids).size() == thePids.size()) : "PID list contains duplicates: " + thePids;
        HashMap<JpaPid, Integer> position = new HashMap<JpaPid, Integer>();
        for (JpaPid next : thePids) {
            position.put(next, theResourceListToPopulate.size());
            theResourceListToPopulate.add(null);
        }
        if (this.isLoadingFromElasticSearchSupported(thePids)) {
            try {
                theResourceListToPopulate.addAll(this.loadResourcesFromElasticSearch(thePids));
                return;
            }
            catch (ResourceNotFoundInIndexException theE) {
                ourLog.warn("Some resources were not found in index. Make sure all resources were indexed. Resorting to database search.");
            }
        }
        new QueryChunker<JpaPid>().chunk(thePids, t -> this.doLoadPids((Collection<JpaPid>)t, theIncludedPids, theResourceListToPopulate, theForHistoryOperation, (Map<JpaPid, Integer>)position));
    }

    private boolean isLoadingFromElasticSearchSupported(Collection<JpaPid> thePids) {
        return this.myStorageSettings.isStoreResourceInHSearchIndex() && this.myStorageSettings.isAdvancedHSearchIndexing() && thePids.stream().noneMatch(p -> p.getVersion() != null) && this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3);
    }

    private List<IBaseResource> loadResourcesFromElasticSearch(Collection<JpaPid> thePids) {
        if (this.myStorageSettings.isAdvancedHSearchIndexing() && this.myStorageSettings.isStoreResourceInHSearchIndex()) {
            List<Long> pidList = thePids.stream().map(JpaPid::getId).collect(Collectors.toList());
            return this.myFulltextSearchSvc.getResources(pidList);
        }
        if (!Objects.isNull(this.myParams) && this.myParams.isLastN()) {
            return this.myIElasticsearchSvc.getObservationResources(thePids);
        }
        return Collections.emptyList();
    }

    public Set<JpaPid> loadIncludes(FhirContext theContext, EntityManager theEntityManager, Collection<JpaPid> theMatches, Collection<Include> theIncludes, boolean theReverseMode, DateRangeParam theLastUpdated, String theSearchIdOrDescription, RequestDetails theRequest, Integer theMaxCount) {
        SearchBuilderLoadIncludesParameters parameters = new SearchBuilderLoadIncludesParameters();
        parameters.setFhirContext(theContext);
        parameters.setEntityManager(theEntityManager);
        parameters.setMatches(theMatches);
        parameters.setIncludeFilters(theIncludes);
        parameters.setReverseMode(theReverseMode);
        parameters.setLastUpdated(theLastUpdated);
        parameters.setSearchIdOrDescription(theSearchIdOrDescription);
        parameters.setRequestDetails(theRequest);
        parameters.setMaxCount(theMaxCount);
        return this.loadIncludes((SearchBuilderLoadIncludesParameters<JpaPid>)parameters);
    }

    public Set<JpaPid> loadIncludes(SearchBuilderLoadIncludesParameters<JpaPid> theParameters) {
        boolean addedSomeThisRound;
        boolean hasDesiredResourceTypes;
        Collection matches = theParameters.getMatches();
        Collection currentIncludes = theParameters.getIncludeFilters();
        boolean reverseMode = theParameters.isReverseMode();
        EntityManager entityManager = theParameters.getEntityManager();
        Integer maxCount = theParameters.getMaxCount();
        FhirContext fhirContext = theParameters.getFhirContext();
        RequestDetails request = theParameters.getRequestDetails();
        String searchIdOrDescription = theParameters.getSearchIdOrDescription();
        List desiredResourceTypes = theParameters.getDesiredResourceTypes();
        boolean bl = hasDesiredResourceTypes = desiredResourceTypes != null && !desiredResourceTypes.isEmpty();
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theParameters.getRequestDetails())) {
            CurrentThreadCaptureQueriesListener.startCapturing();
        }
        if (matches.isEmpty()) {
            return new HashSet<JpaPid>();
        }
        if (currentIncludes == null || currentIncludes.isEmpty()) {
            return new HashSet<JpaPid>();
        }
        String searchPidFieldName = reverseMode ? MY_TARGET_RESOURCE_PID : MY_SOURCE_RESOURCE_PID;
        String findPidFieldName = reverseMode ? MY_SOURCE_RESOURCE_PID : MY_TARGET_RESOURCE_PID;
        String findResourceTypeFieldName = reverseMode ? MY_SOURCE_RESOURCE_TYPE : MY_TARGET_RESOURCE_TYPE;
        String findVersionFieldName = null;
        if (!reverseMode && this.myStorageSettings.isRespectVersionsForSearchIncludes()) {
            findVersionFieldName = MY_TARGET_RESOURCE_VERSION;
        }
        ArrayList<JpaPid> nextRoundMatches = new ArrayList<JpaPid>(matches);
        HashSet<JpaPid> allAdded = new HashSet<JpaPid>();
        HashSet original = new HashSet(matches);
        ArrayList includes = new ArrayList(currentIncludes);
        int roundCounts = 0;
        StopWatch w = new StopWatch();
        do {
            ++roundCounts;
            HashSet<JpaPid> pidsToInclude = new HashSet<JpaPid>();
            Iterator iter = includes.iterator();
            while (iter.hasNext()) {
                Include nextInclude = (Include)iter.next();
                if (!nextInclude.isRecurse()) {
                    iter.remove();
                }
                boolean matchAll = "*".equals(nextInclude.getValue());
                String wantResourceType = null;
                if (!matchAll && "*".equals(nextInclude.getParamName())) {
                    wantResourceType = nextInclude.getParamType();
                    matchAll = true;
                }
                if (matchAll) {
                    this.loadIncludesMatchAll(findPidFieldName, findResourceTypeFieldName, findVersionFieldName, searchPidFieldName, wantResourceType, reverseMode, hasDesiredResourceTypes, nextRoundMatches, entityManager, maxCount, desiredResourceTypes, pidsToInclude, request);
                    continue;
                }
                this.loadIncludesMatchSpecific(nextInclude, fhirContext, findPidFieldName, findVersionFieldName, searchPidFieldName, reverseMode, nextRoundMatches, entityManager, maxCount, pidsToInclude);
            }
            nextRoundMatches.clear();
            for (JpaPid next : pidsToInclude) {
                if (original.contains(next) || allAdded.contains(next)) continue;
                nextRoundMatches.add(next);
            }
            addedSomeThisRound = allAdded.addAll(pidsToInclude);
        } while ((maxCount == null || allAdded.size() < maxCount) && !includes.isEmpty() && !nextRoundMatches.isEmpty() && addedSomeThisRound);
        allAdded.removeAll(original);
        ourLog.info("Loaded {} {} in {} rounds and {} ms for search {}", new Object[]{allAdded.size(), reverseMode ? "_revincludes" : "_includes", roundCounts, w.getMillisAndRestart(), searchIdOrDescription});
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)request)) {
            this.callRawSqlHookWithCurrentThreadQueries(request);
        }
        if (!allAdded.isEmpty() && CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)request)) {
            ArrayList<JpaPid> includedPidList = new ArrayList<JpaPid>(allAdded);
            JpaPreResourceAccessDetails accessDetails = new JpaPreResourceAccessDetails(includedPidList, (ICallable<ISearchBuilder>)((ICallable)() -> this));
            HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)request).addIfMatchesType(ServletRequestDetails.class, (Object)request);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)request, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
            for (int i = includedPidList.size() - 1; i >= 0; --i) {
                JpaPid value;
                if (!accessDetails.isDontReturnResourceAtIndex(i) || (value = (JpaPid)includedPidList.remove(i)) == null) continue;
                allAdded.remove(value);
            }
        }
        return allAdded;
    }

    private void loadIncludesMatchSpecific(Include nextInclude, FhirContext fhirContext, String findPidFieldName, String findVersionFieldName, String searchPidFieldName, boolean reverseMode, List<JpaPid> nextRoundMatches, EntityManager entityManager, Integer maxCount, HashSet<JpaPid> pidsToInclude) {
        String resType = nextInclude.getParamType();
        if (StringUtils.isBlank((CharSequence)resType)) {
            return;
        }
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition(resType);
        if (def == null) {
            ourLog.warn("Unknown resource type in include/revinclude=" + nextInclude.getValue());
            return;
        }
        String paramName = nextInclude.getParamName();
        RuntimeSearchParam param = StringUtils.isNotBlank((CharSequence)paramName) ? this.mySearchParamRegistry.getActiveSearchParam(resType, paramName) : null;
        if (param == null) {
            ourLog.warn("Unknown param name in include/revinclude=" + nextInclude.getValue());
            return;
        }
        List paths = param.getPathsSplitForResourceType(resType);
        Set<String> targetResourceTypes = SearchBuilder.computeTargetResourceTypes(nextInclude, param);
        for (String nextPath : paths) {
            String findPidFieldSqlColumn = findPidFieldName.equals(MY_SOURCE_RESOURCE_PID) ? "src_resource_id" : "target_resource_id";
            String fieldsToLoad = "r." + findPidFieldSqlColumn + " AS resource_id";
            if (findVersionFieldName != null) {
                fieldsToLoad = fieldsToLoad + ", r.target_resource_version AS resource_version";
            }
            HashMap<String, Object> localReferenceQueryParams = new HashMap<String, Object>();
            String searchPidFieldSqlColumn = searchPidFieldName.equals(MY_TARGET_RESOURCE_PID) ? "target_resource_id" : "src_resource_id";
            StringBuilder localReferenceQuery = new StringBuilder("SELECT " + fieldsToLoad + " FROM hfj_res_link r  WHERE r.src_path = :src_path AND  r.target_resource_id IS NOT NULL AND  r." + searchPidFieldSqlColumn + " IN (:target_pids) ");
            localReferenceQueryParams.put("src_path", nextPath);
            if (targetResourceTypes != null) {
                if (targetResourceTypes.size() == 1) {
                    localReferenceQuery.append(" AND r.target_resource_type = :target_resource_type ");
                    localReferenceQueryParams.put("target_resource_type", targetResourceTypes.iterator().next());
                } else {
                    localReferenceQuery.append(" AND r.target_resource_type in (:target_resource_types) ");
                    localReferenceQueryParams.put("target_resource_types", targetResourceTypes);
                }
            }
            Pair<String, Map<String, Object>> canonicalQuery = this.buildCanonicalUrlQuery(findVersionFieldName, targetResourceTypes, reverseMode);
            String sql = localReferenceQuery + " UNION " + (String)canonicalQuery.getLeft();
            List<Collection<JpaPid>> partitions = this.partition(nextRoundMatches, SearchBuilder.getMaximumPageSize());
            for (Collection<JpaPid> nextPartition : partitions) {
                Query q = entityManager.createNativeQuery(sql, Tuple.class);
                q.setParameter("target_pids", (Object)JpaPid.toLongList(nextPartition));
                localReferenceQueryParams.forEach((arg_0, arg_1) -> ((Query)q).setParameter(arg_0, arg_1));
                ((Map)canonicalQuery.getRight()).forEach((arg_0, arg_1) -> ((Query)q).setParameter(arg_0, arg_1));
                if (maxCount != null) {
                    q.setMaxResults(maxCount.intValue());
                }
                List results = q.getResultList();
                for (Tuple result : results) {
                    if (result == null) continue;
                    Long resourceId = NumberUtils.createLong((String)String.valueOf(result.get(RESOURCE_ID_ALIAS)));
                    Long resourceVersion = null;
                    if (findVersionFieldName != null && result.get(RESOURCE_VERSION_ALIAS) != null) {
                        resourceVersion = NumberUtils.createLong((String)String.valueOf(result.get(RESOURCE_VERSION_ALIAS)));
                    }
                    pidsToInclude.add(JpaPid.fromIdAndVersion((Long)resourceId, resourceVersion));
                }
            }
        }
    }

    private void loadIncludesMatchAll(String findPidFieldName, String findResourceTypeFieldName, String findVersionFieldName, String searchPidFieldName, String wantResourceType, boolean reverseMode, boolean hasDesiredResourceTypes, List<JpaPid> nextRoundMatches, EntityManager entityManager, Integer maxCount, List<String> desiredResourceTypes, HashSet<JpaPid> pidsToInclude, RequestDetails request) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT r.").append(findPidFieldName);
        sqlBuilder.append(", r.").append(findResourceTypeFieldName);
        sqlBuilder.append(", r.myTargetResourceUrl");
        if (findVersionFieldName != null) {
            sqlBuilder.append(", r.").append(findVersionFieldName);
        }
        sqlBuilder.append(" FROM ResourceLink r WHERE ");
        sqlBuilder.append("r.");
        sqlBuilder.append(searchPidFieldName);
        sqlBuilder.append(" IN (:target_pids)");
        if (wantResourceType != null && (reverseMode || this.myParams != null && this.myParams.getEverythingMode() != null)) {
            sqlBuilder.append(" AND r.mySourceResourceType = :want_resource_type");
        } else {
            wantResourceType = null;
        }
        if (this.myParams != null && this.myParams.getEverythingMode() == SearchParameterMap.EverythingModeEnum.PATIENT_INSTANCE) {
            sqlBuilder.append(" AND r.myTargetResourceType != 'Patient'");
            sqlBuilder.append(JpaConstants.UNDESIRED_RESOURCE_LINKAGES_FOR_EVERYTHING_ON_PATIENT_INSTANCE.stream().collect(Collectors.joining("', '", " AND r.mySourceResourceType NOT IN ('", "')")));
        }
        if (hasDesiredResourceTypes) {
            sqlBuilder.append(" AND r.myTargetResourceType IN (:desired_target_resource_types)");
        }
        String sql = sqlBuilder.toString();
        List<Collection<JpaPid>> partitions = this.partition(nextRoundMatches, SearchBuilder.getMaximumPageSize());
        for (Collection<JpaPid> nextPartition : partitions) {
            TypedQuery q = entityManager.createQuery(sql, Object[].class);
            q.setParameter("target_pids", (Object)JpaPid.toLongList(nextPartition));
            if (wantResourceType != null) {
                q.setParameter("want_resource_type", (Object)wantResourceType);
            }
            if (maxCount != null) {
                q.setMaxResults(maxCount.intValue());
            }
            if (hasDesiredResourceTypes) {
                q.setParameter("desired_target_resource_types", desiredResourceTypes);
            }
            List results = q.getResultList();
            HashSet<String> canonicalUrls = null;
            for (Object nextRow : results) {
                if (nextRow == null) continue;
                Long version = null;
                Long resourceId = (Long)((Object[])nextRow)[0];
                String resourceType = (String)((Object[])nextRow)[1];
                String resourceCanonicalUrl = (String)((Object[])nextRow)[2];
                if (findVersionFieldName != null) {
                    version = (Long)((Object[])nextRow)[3];
                }
                if (resourceId != null) {
                    JpaPid pid = JpaPid.fromIdAndVersionAndResourceType((Long)resourceId, (Long)version, (String)resourceType);
                    pidsToInclude.add(pid);
                    continue;
                }
                if (resourceCanonicalUrl == null) continue;
                if (canonicalUrls == null) {
                    canonicalUrls = new HashSet<String>();
                }
                canonicalUrls.add(resourceCanonicalUrl);
            }
            if (canonicalUrls == null) continue;
            String message = "Search with _include=* can be inefficient when references using canonical URLs are detected. Use more specific _include values instead.";
            this.firePerformanceWarning(request, message);
            this.loadCanonicalUrls(canonicalUrls, entityManager, pidsToInclude, reverseMode);
        }
    }

    private void loadCanonicalUrls(Set<String> theCanonicalUrls, EntityManager theEntityManager, HashSet<JpaPid> thePidsToInclude, boolean theReverse) {
        Set<Long> identityHashesForTypes = this.calculateIndexUriIdentityHashesForResourceTypes(null, theReverse);
        List<Collection<String>> canonicalUrlPartitions = this.partition(theCanonicalUrls, SearchBuilder.getMaximumPageSize() - identityHashesForTypes.size());
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT i.myResourcePid ");
        sqlBuilder.append("FROM ResourceIndexedSearchParamUri i ");
        sqlBuilder.append("WHERE i.myHashIdentity IN (:hash_identity) ");
        sqlBuilder.append("AND i.myUri IN (:uris)");
        String canonicalResSql = sqlBuilder.toString();
        for (Collection<String> nextCanonicalUrlList : canonicalUrlPartitions) {
            TypedQuery canonicalResIdQuery = theEntityManager.createQuery(canonicalResSql, Long.class);
            canonicalResIdQuery.setParameter("hash_identity", identityHashesForTypes);
            canonicalResIdQuery.setParameter("uris", nextCanonicalUrlList);
            List resIds = canonicalResIdQuery.getResultList();
            for (Long next : resIds) {
                if (next == null) continue;
                thePidsToInclude.add(JpaPid.fromId((Long)next));
            }
        }
    }

    private void callRawSqlHookWithCurrentThreadQueries(RequestDetails request) {
        SqlQueryList capturedQueries = CurrentThreadCaptureQueriesListener.getCurrentQueueAndStopCapturing();
        HookParams params = new HookParams().add(RequestDetails.class, (Object)request).addIfMatchesType(ServletRequestDetails.class, (Object)request).add(SqlQueryList.class, (Object)capturedQueries);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)request, (Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (HookParams)params);
    }

    @Nullable
    private static Set<String> computeTargetResourceTypes(Include nextInclude, RuntimeSearchParam param) {
        String targetResourceType = StringUtils.defaultString((String)nextInclude.getParamTargetType(), null);
        boolean haveTargetTypesDefinedByParam = param.hasTargets();
        Set targetResourceTypes = targetResourceType != null ? Set.of(targetResourceType) : (haveTargetTypesDefinedByParam ? param.getTargets() : null);
        return targetResourceTypes;
    }

    @Nonnull
    private Pair<String, Map<String, Object>> buildCanonicalUrlQuery(String theVersionFieldName, Set<String> theTargetResourceTypes, boolean theReverse) {
        Object fieldsToLoadFromSpidxUriTable;
        Object object = fieldsToLoadFromSpidxUriTable = theReverse ? "r.src_resource_id" : "rUri.res_id";
        if (theVersionFieldName != null) {
            fieldsToLoadFromSpidxUriTable = (String)fieldsToLoadFromSpidxUriTable + ", NULL";
        }
        Set<Long> identityHashesForTypes = this.calculateIndexUriIdentityHashesForResourceTypes(theTargetResourceTypes, theReverse);
        HashMap<String, Object> canonicalUriQueryParams = new HashMap<String, Object>();
        StringBuilder canonicalUrlQuery = new StringBuilder("SELECT " + (String)fieldsToLoadFromSpidxUriTable + " FROM hfj_res_link r  JOIN hfj_spidx_uri rUri ON ( ");
        if (theTargetResourceTypes != null && theTargetResourceTypes.size() == 1) {
            canonicalUrlQuery.append("   rUri.hash_identity = :uri_identity_hash ");
            canonicalUriQueryParams.put("uri_identity_hash", identityHashesForTypes.iterator().next());
        } else {
            canonicalUrlQuery.append("   rUri.hash_identity in (:uri_identity_hashes) ");
            canonicalUriQueryParams.put("uri_identity_hashes", identityHashesForTypes);
        }
        canonicalUrlQuery.append(" AND r.target_resource_url = rUri.sp_uri  )");
        canonicalUrlQuery.append(" WHERE r.src_path = :src_path AND ");
        canonicalUrlQuery.append(" r.target_resource_id IS NULL ");
        canonicalUrlQuery.append(" AND ");
        if (theReverse) {
            canonicalUrlQuery.append("rUri.res_id");
        } else {
            canonicalUrlQuery.append("r.src_resource_id");
        }
        canonicalUrlQuery.append(" IN (:target_pids) ");
        return Pair.of((Object)canonicalUrlQuery.toString(), canonicalUriQueryParams);
    }

    @Nonnull
    Set<Long> calculateIndexUriIdentityHashesForResourceTypes(Set<String> theTargetResourceTypes, boolean theReverse) {
        Set targetResourceTypes = theTargetResourceTypes;
        if (targetResourceTypes == null) {
            targetResourceTypes = new HashSet<String>();
            Set possibleTypes = this.myDaoRegistry.getRegisteredDaoTypes();
            if (theReverse) {
                targetResourceTypes = possibleTypes;
            } else {
                for (RuntimeSearchParam next : this.mySearchParamRegistry.getActiveSearchParams(this.myResourceName).values().stream().filter(t -> t.getParamType().equals((Object)RestSearchParameterTypeEnum.REFERENCE)).collect(Collectors.toList())) {
                    if (next.getPath().startsWith(this.myResourceName + ".")) {
                        BaseRuntimeElementDefinition childDef;
                        BaseRuntimeChildDefinition child;
                        String elementName = next.getPath().substring(next.getPath().indexOf(46) + 1);
                        int secondDotIndex = elementName.indexOf(46);
                        if (secondDotIndex != -1) {
                            elementName = elementName.substring(0, secondDotIndex);
                        }
                        if ((child = this.myContext.getResourceDefinition(this.myResourceName).getChildByName(elementName)) != null && (childDef = child.getChildByName(elementName)) != null && childDef.getName().equals("Reference")) continue;
                    }
                    if (!next.getTargets().isEmpty()) {
                        for (String nextTarget : next.getTargets()) {
                            if (!possibleTypes.contains(nextTarget)) continue;
                            targetResourceTypes.add(nextTarget);
                        }
                        continue;
                    }
                    targetResourceTypes.addAll(possibleTypes);
                    break;
                }
            }
        }
        assert (!targetResourceTypes.isEmpty());
        return targetResourceTypes.stream().map(type -> BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)this.myRequestPartitionId, (String)type, (String)"url")).collect(Collectors.toSet());
    }

    private <T> List<Collection<T>> partition(Collection<T> theNextRoundMatches, int theMaxLoad) {
        if (theNextRoundMatches.size() <= theMaxLoad) {
            return Collections.singletonList(theNextRoundMatches);
        }
        ArrayList<Collection<T>> retVal = new ArrayList<Collection<T>>();
        ArrayList<T> current = null;
        for (T next : theNextRoundMatches) {
            if (current == null) {
                current = new ArrayList<T>(theMaxLoad);
                retVal.add(current);
            }
            current.add(next);
            if (current.size() < theMaxLoad) continue;
            current = null;
        }
        return retVal;
    }

    private void attemptComboUniqueSpProcessing(QueryStack theQueryStack, @Nonnull SearchParameterMap theParams, RequestDetails theRequest) {
        RuntimeSearchParam comboParam = null;
        List<String> comboParamNames = null;
        List exactMatchParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName, theParams.keySet());
        if (!exactMatchParams.isEmpty()) {
            comboParam = (RuntimeSearchParam)exactMatchParams.get(0);
            comboParamNames = new ArrayList<String>(theParams.keySet());
        }
        if (comboParam == null) {
            List candidateComboParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName);
            for (RuntimeSearchParam nextCandidate : candidateComboParams) {
                List nextCandidateParamNames = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)nextCandidate).stream().map(RuntimeSearchParam::getName).collect(Collectors.toList());
                if (!theParams.keySet().containsAll(nextCandidateParamNames)) continue;
                comboParam = nextCandidate;
                comboParamNames = nextCandidateParamNames;
                break;
            }
        }
        if (comboParam != null) {
            Collections.sort(comboParamNames);
            theParams.values().forEach(this::ensureSubListsAreWritable);
            while (this.validateParamValuesAreValidForComboParam(theRequest, theParams, comboParamNames)) {
                this.applyComboSearchParam(theQueryStack, theParams, theRequest, comboParamNames, comboParam);
            }
        }
    }

    private void applyComboSearchParam(QueryStack theQueryStack, @Nonnull SearchParameterMap theParams, RequestDetails theRequest, List<String> theComboParamNames, RuntimeSearchParam theComboParam) {
        ArrayList inputs = new ArrayList();
        for (String nextParamName : theComboParamNames) {
            List nextValues = (List)theParams.get(nextParamName).remove(0);
            inputs.add(nextValues);
        }
        List inputPermutations = Lists.cartesianProduct(inputs);
        ArrayList<String> indexStrings = new ArrayList<String>(CartesianProductUtil.calculateCartesianProductSize(inputs));
        for (List nextPermutation : inputPermutations) {
            StringBuilder searchStringBuilder = new StringBuilder();
            searchStringBuilder.append(this.myResourceName);
            searchStringBuilder.append("?");
            boolean first = true;
            for (int paramIndex = 0; paramIndex < theComboParamNames.size(); ++paramIndex) {
                String nextParamName = theComboParamNames.get(paramIndex);
                IQueryParameterType nextOr = (IQueryParameterType)nextPermutation.get(paramIndex);
                String nextOrValue = nextOr.getValueAsQueryToken(this.myContext);
                RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, nextParamName);
                if (theComboParam.getComboSearchParamType() == ComboSearchParamType.NON_UNIQUE && nextParamDef.getParamType() == RestSearchParameterTypeEnum.STRING) {
                    nextOrValue = StringUtil.normalizeStringForSearchIndexing((String)nextOrValue);
                }
                if (first) {
                    first = false;
                } else {
                    searchStringBuilder.append('&');
                }
                nextParamName = UrlUtil.escapeUrlParam((String)nextParamName);
                nextOrValue = UrlUtil.escapeUrlParam((String)nextOrValue);
                searchStringBuilder.append(nextParamName).append('=').append(nextOrValue);
            }
            String indexString = searchStringBuilder.toString();
            ourLog.debug("Checking for {} combo index for query: {}", (Object)theComboParam.getComboSearchParamType(), (Object)indexString);
            indexStrings.add(indexString);
        }
        indexStrings.sort(Comparator.naturalOrder());
        String indexStringForLog = indexStrings.size() > 1 ? ((Object)indexStrings).toString() : (String)indexStrings.get(0);
        StorageProcessingMessage msg = new StorageProcessingMessage().setMessage("Using " + theComboParam.getComboSearchParamType() + " index(es) for query for search: " + indexStringForLog);
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)msg);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
        switch (Objects.requireNonNull(theComboParam.getComboSearchParamType())) {
            case UNIQUE: {
                theQueryStack.addPredicateCompositeUnique(indexStrings, this.myRequestPartitionId);
                break;
            }
            case NON_UNIQUE: {
                theQueryStack.addPredicateCompositeNonUnique(indexStrings, this.myRequestPartitionId);
            }
        }
        theParams.clean();
    }

    private boolean validateParamValuesAreValidForComboParam(RequestDetails theRequest, @Nonnull SearchParameterMap theParams, List<String> theComboParamNames) {
        boolean paramValuesAreValidForCombo = true;
        ArrayList paramOrValues = new ArrayList(theComboParamNames.size());
        for (String nextParamName : theComboParamNames) {
            ReferenceParam param;
            RuntimeSearchParam nextParamDef;
            List nextValues = theParams.get(nextParamName);
            if (nextValues == null || nextValues.isEmpty()) {
                paramValuesAreValidForCombo = false;
                break;
            }
            List nextAndValue = (List)nextValues.get(0);
            paramOrValues.add(nextAndValue);
            for (IQueryParameterType nextOrValue : nextAndValue) {
                BaseParamWithPrefix paramWithPrefix;
                String message;
                DateParam dateParam;
                if (nextOrValue instanceof DateParam && (dateParam = (DateParam)nextOrValue).getPrecision() != TemporalPrecisionEnum.DAY) {
                    message = "Search with params " + theComboParamNames + " is not a candidate for combo searching - Date search with non-DAY precision for parameter '" + nextParamName + "'";
                    this.firePerformanceInfo(theRequest, message);
                    paramValuesAreValidForCombo = false;
                    break;
                }
                if (nextOrValue instanceof BaseParamWithPrefix && (paramWithPrefix = (BaseParamWithPrefix)nextOrValue).getPrefix() != null) {
                    message = "Search with params " + theComboParamNames + " is not a candidate for combo searching - Parameter '" + nextParamName + "' has prefix: '" + paramWithPrefix.getPrefix().getValue() + "'";
                    this.firePerformanceInfo(theRequest, message);
                    paramValuesAreValidForCombo = false;
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)nextOrValue.getQueryParameterQualifier())) continue;
                String message2 = "Search with params " + theComboParamNames + " is not a candidate for combo searching - Parameter '" + nextParamName + "' has modifier: '" + nextOrValue.getQueryParameterQualifier() + "'";
                this.firePerformanceInfo(theRequest, message2);
                paramValuesAreValidForCombo = false;
                break;
            }
            if ((nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, nextParamName)).getParamType() != RestSearchParameterTypeEnum.REFERENCE || !StringUtils.isBlank((CharSequence)(param = (ReferenceParam)((List)nextValues.get(0)).get(0)).getResourceType())) continue;
            ourLog.debug("Search is not a candidate for unique combo searching - Reference with no type specified");
            paramValuesAreValidForCombo = false;
            break;
        }
        if (CartesianProductUtil.calculateCartesianProductSize(paramOrValues) > 500) {
            ourLog.debug("Search is not a candidate for unique combo searching - Too many OR values would result in too many permutations");
            paramValuesAreValidForCombo = false;
        }
        return paramValuesAreValidForCombo;
    }

    private <T> void ensureSubListsAreWritable(List<List<T>> theListOfLists) {
        for (int i = 0; i < theListOfLists.size(); ++i) {
            List<T> oldSubList = theListOfLists.get(i);
            if (oldSubList instanceof ArrayList) continue;
            ArrayList<T> newSubList = new ArrayList<T>(oldSubList);
            theListOfLists.set(i, newSubList);
        }
    }

    public void setFetchSize(int theFetchSize) {
        this.myFetchSize = theFetchSize;
    }

    public SearchParameterMap getParams() {
        return this.myParams;
    }

    public CriteriaBuilder getBuilder() {
        return this.myCriteriaBuilder;
    }

    public Class<? extends IBaseResource> getResourceType() {
        return this.myResourceType;
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    private void firePerformanceInfo(RequestDetails theRequest, String theMessage) {
        ourLog.debug(theMessage);
        this.firePerformanceMessage(theRequest, theMessage, Pointcut.JPA_PERFTRACE_INFO);
    }

    private void firePerformanceWarning(RequestDetails theRequest, String theMessage) {
        ourLog.warn(theMessage);
        this.firePerformanceMessage(theRequest, theMessage, Pointcut.JPA_PERFTRACE_WARNING);
    }

    private void firePerformanceMessage(RequestDetails theRequest, String theMessage, Pointcut pointcut) {
        StorageProcessingMessage message = new StorageProcessingMessage();
        message.setMessage(theMessage);
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)message);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)pointcut, (HookParams)params);
    }

    public static int getMaximumPageSize() {
        if (myUseMaxPageSize50ForTest) {
            return 50;
        }
        return 800;
    }

    public static void setMaxPageSize50ForTest(boolean theIsTest) {
        myUseMaxPageSize50ForTest = theIsTest;
    }

    private final class QueryIterator
    extends BaseIterator<JpaPid>
    implements IResultIterator<JpaPid> {
        private final SearchRuntimeDetails mySearchRuntimeDetails;
        private final RequestDetails myRequest;
        private final boolean myHaveRawSqlHooks;
        private final boolean myHavePerfTraceFoundIdHook;
        private final SortSpec mySort;
        private final Integer myOffset;
        private boolean myFirst = true;
        private IncludesIterator myIncludesIterator;
        private JpaPid myNext;
        private ISearchQueryExecutor myResultsIterator;
        private boolean myFetchIncludesForEverythingOperation;
        private int mySkipCount = 0;
        private int myNonSkipCount = 0;
        private List<ISearchQueryExecutor> myQueryList = new ArrayList<ISearchQueryExecutor>();

        private QueryIterator(SearchRuntimeDetails theSearchRuntimeDetails, RequestDetails theRequest) {
            this.mySearchRuntimeDetails = theSearchRuntimeDetails;
            this.mySort = SearchBuilder.this.myParams.getSort();
            this.myOffset = SearchBuilder.this.myParams.getOffset();
            this.myRequest = theRequest;
            if (SearchBuilder.this.myParams.getEverythingMode() != null) {
                this.myFetchIncludesForEverythingOperation = true;
            }
            this.myHavePerfTraceFoundIdHook = CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FOUND_ID, (IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest);
            this.myHaveRawSqlHooks = CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest);
        }

        private void fetchNext() {
            HookParams params;
            try {
                if (this.myHaveRawSqlHooks) {
                    CurrentThreadCaptureQueriesListener.startCapturing();
                }
                if (this.myResultsIterator == null) {
                    if (SearchBuilder.this.myMaxResultsToFetch == null) {
                        SearchBuilder.this.myMaxResultsToFetch = this.calculateMaxResultsToFetch();
                    }
                    this.initializeIteratorQuery(this.myOffset, SearchBuilder.this.myMaxResultsToFetch);
                }
                if (this.myNext == null) {
                    while (this.myResultsIterator.hasNext() || !this.myQueryList.isEmpty()) {
                        if (!this.myResultsIterator.hasNext()) {
                            this.retrieveNextIteratorQuery();
                            if (!this.myResultsIterator.hasNext()) break;
                        }
                        Long nextLong = (Long)this.myResultsIterator.next();
                        if (this.myHavePerfTraceFoundIdHook) {
                            this.callPerformanceTracingHook(nextLong);
                        }
                        if (nextLong != null) {
                            JpaPid next = JpaPid.fromId((Long)nextLong);
                            if (SearchBuilder.this.myPidSet.add(next) && this.doNotSkipNextPidForEverything()) {
                                this.myNext = next;
                                ++this.myNonSkipCount;
                                break;
                            }
                            ++this.mySkipCount;
                        }
                        if (this.myResultsIterator.hasNext() || SearchBuilder.this.myMaxResultsToFetch == null || this.mySkipCount + this.myNonSkipCount != SearchBuilder.this.myMaxResultsToFetch || this.mySkipCount <= 0 || this.myNonSkipCount != 0) continue;
                        this.sendProcessingMsgAndFirePerformanceHook();
                        SearchBuilder.this.myMaxResultsToFetch = SearchBuilder.this.myMaxResultsToFetch + 1000;
                        this.initializeIteratorQuery(this.myOffset, SearchBuilder.this.myMaxResultsToFetch);
                    }
                }
                if (this.myNext == null) {
                    if (this.myFetchIncludesForEverythingOperation) {
                        this.myIncludesIterator = new IncludesIterator(SearchBuilder.this.myPidSet, this.myRequest);
                        this.myFetchIncludesForEverythingOperation = false;
                    }
                    if (this.myIncludesIterator != null) {
                        while (this.myIncludesIterator.hasNext()) {
                            JpaPid next = this.myIncludesIterator.next();
                            if (next == null || !SearchBuilder.this.myPidSet.add(next) || !this.doNotSkipNextPidForEverything()) continue;
                            this.myNext = next;
                            break;
                        }
                        if (this.myNext == null) {
                            this.myNext = NO_MORE;
                        }
                    } else {
                        this.myNext = NO_MORE;
                    }
                }
                this.mySearchRuntimeDetails.setFoundMatchesCount(SearchBuilder.this.myPidSet.size());
            }
            finally {
                if (this.myHaveRawSqlHooks) {
                    SearchBuilder.this.callRawSqlHookWithCurrentThreadQueries(this.myRequest);
                }
            }
            if (this.myFirst) {
                params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FIRST_RESULT_LOADED, (HookParams)params);
                this.myFirst = false;
            }
            if (NO_MORE.equals((Object)this.myNext)) {
                params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_SELECT_COMPLETE, (HookParams)params);
            }
        }

        private Integer calculateMaxResultsToFetch() {
            if (SearchBuilder.this.myParams.getLoadSynchronousUpTo() != null) {
                return SearchBuilder.this.myParams.getLoadSynchronousUpTo();
            }
            if (SearchBuilder.this.myParams.getOffset() != null && SearchBuilder.this.myParams.getCount() != null) {
                return SearchBuilder.this.myParams.getEverythingMode() != null ? SearchBuilder.this.myParams.getOffset() + SearchBuilder.this.myParams.getCount() : SearchBuilder.this.myParams.getCount();
            }
            return SearchBuilder.this.myStorageSettings.getFetchSizeDefaultMaximum();
        }

        private boolean doNotSkipNextPidForEverything() {
            return SearchBuilder.this.myParams.getEverythingMode() == null || this.myOffset == null || this.myOffset < SearchBuilder.this.myPidSet.size();
        }

        private void callPerformanceTracingHook(Long theNextLong) {
            HookParams params = new HookParams().add(Integer.class, (Object)System.identityHashCode(this)).add(Object.class, (Object)theNextLong);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FOUND_ID, (HookParams)params);
        }

        private void sendProcessingMsgAndFirePerformanceHook() {
            String msg = "Pass completed with no matching results seeking rows " + SearchBuilder.this.myPidSet.size() + "-" + this.mySkipCount + ". This indicates an inefficient query! Retrying with new max count of " + SearchBuilder.this.myMaxResultsToFetch;
            SearchBuilder.this.firePerformanceWarning(this.myRequest, msg);
        }

        private void initializeIteratorQuery(Integer theOffset, Integer theMaxResultsToFetch) {
            Integer offset = theOffset;
            if (this.myQueryList.isEmpty()) {
                this.mySearchRuntimeDetails.setQueryStopwatch(new StopWatch());
                if (SearchBuilder.this.myParams.getEverythingMode() != null) {
                    offset = 0;
                }
                this.myQueryList = SearchBuilder.this.createQuery(SearchBuilder.this.myParams, this.mySort, offset, theMaxResultsToFetch, false, this.myRequest, this.mySearchRuntimeDetails);
            }
            this.mySearchRuntimeDetails.setQueryStopwatch(new StopWatch());
            this.retrieveNextIteratorQuery();
            this.mySkipCount = 0;
            this.myNonSkipCount = 0;
        }

        private void retrieveNextIteratorQuery() {
            this.close();
            if (CollectionUtils.isNotEmpty(this.myQueryList)) {
                this.myResultsIterator = this.myQueryList.remove(0);
                SearchBuilder.this.myHasNextIteratorQuery = true;
            } else {
                this.myResultsIterator = SearchQueryExecutor.emptyExecutor();
                SearchBuilder.this.myHasNextIteratorQuery = false;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.myNext == null) {
                this.fetchNext();
            }
            return !NO_MORE.equals((Object)this.myNext);
        }

        @Override
        public JpaPid next() {
            this.fetchNext();
            JpaPid retVal = this.myNext;
            this.myNext = null;
            Validate.isTrue((!NO_MORE.equals((Object)retVal) ? 1 : 0) != 0, (String)"No more elements", (Object[])new Object[0]);
            return retVal;
        }

        public int getSkippedCount() {
            return this.mySkipCount;
        }

        public int getNonSkippedCount() {
            return this.myNonSkipCount;
        }

        public Collection<JpaPid> getNextResultBatch(long theBatchSize) {
            ArrayList<JpaPid> batch = new ArrayList<JpaPid>();
            while (this.hasNext() && (long)batch.size() < theBatchSize) {
                batch.add(this.next());
            }
            return batch;
        }

        public void close() {
            if (this.myResultsIterator != null) {
                this.myResultsIterator.close();
            }
            this.myResultsIterator = null;
        }
    }

    public class IncludesIterator
    extends BaseIterator<JpaPid>
    implements Iterator<JpaPid> {
        private final RequestDetails myRequest;
        private final Set<JpaPid> myCurrentPids;
        private Iterator<JpaPid> myCurrentIterator;
        private JpaPid myNext;

        IncludesIterator(Set<JpaPid> thePidSet, RequestDetails theRequest) {
            this.myCurrentPids = new HashSet<JpaPid>(thePidSet);
            this.myCurrentIterator = null;
            this.myRequest = theRequest;
        }

        private void fetchNext() {
            while (this.myNext == null) {
                if (this.myCurrentIterator == null) {
                    HashSet<Include> includes = new HashSet<Include>();
                    if (SearchBuilder.this.myParams.containsKey("_type")) {
                        for (List typeList : SearchBuilder.this.myParams.get("_type")) {
                            for (IQueryParameterType type : typeList) {
                                String queryString = ParameterUtil.unescape((String)type.getValueAsQueryToken(SearchBuilder.this.myContext));
                                for (String resourceType : queryString.split(",")) {
                                    String rt = resourceType.trim();
                                    if (!StringUtils.isNotBlank((CharSequence)rt)) continue;
                                    includes.add(new Include(rt + ":*", true));
                                }
                            }
                        }
                    }
                    if (includes.isEmpty()) {
                        includes.add(new Include("*", true));
                    }
                    Set<JpaPid> newPids = SearchBuilder.this.loadIncludes(SearchBuilder.this.myContext, SearchBuilder.this.myEntityManager, this.myCurrentPids, includes, false, SearchBuilder.this.getParams().getLastUpdated(), SearchBuilder.this.mySearchUuid, this.myRequest, null);
                    this.myCurrentIterator = newPids.iterator();
                }
                if (this.myCurrentIterator.hasNext()) {
                    this.myNext = this.myCurrentIterator.next();
                    continue;
                }
                this.myNext = NO_MORE;
            }
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return !NO_MORE.equals((Object)this.myNext);
        }

        @Override
        public JpaPid next() {
            this.fetchNext();
            JpaPid retVal = this.myNext;
            this.myNext = null;
            return retVal;
        }
    }
}

