/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder;

import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.search.builder.ISearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.models.ResolvedSearchQueryExecutor;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class SearchQueryExecutors {
    public static ISearchQueryExecutor limited(final ISearchQueryExecutor theExecutor, final long theLimit) {
        Validate.isTrue((theLimit >= 0L ? 1 : 0) != 0, (String)"limit must be non-negative", (Object[])new Object[0]);
        return new ISearchQueryExecutor(){
            long myCount = 0L;

            @Override
            public void close() {
                theExecutor.close();
            }

            @Override
            public boolean hasNext() {
                return theExecutor.hasNext() && this.myCount < theLimit;
            }

            @Override
            public Long next() {
                ++this.myCount;
                return (Long)theExecutor.next();
            }
        };
    }

    @Nonnull
    public static ISearchQueryExecutor from(List<Long> rawPids) {
        return new ResolvedSearchQueryExecutor(rawPids);
    }

    public static ISearchQueryExecutor from(Iterator<JpaPid> theIterator) {
        return new JpaPidQueryAdaptor(theIterator);
    }

    public static ISearchQueryExecutor from(Iterable<JpaPid> theIterable) {
        return new JpaPidQueryAdaptor(theIterable.iterator());
    }

    static class JpaPidQueryAdaptor
    implements ISearchQueryExecutor {
        final Iterator<JpaPid> myIterator;

        JpaPidQueryAdaptor(Iterator<JpaPid> theIterator) {
            this.myIterator = theIterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public Long next() {
            JpaPid next = this.myIterator.next();
            return next == null ? null : next.getId();
        }
    }
}

