/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.search.builder.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.NotCondition;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public abstract class BaseJoiningPredicateBuilder
extends BasePredicateBuilder {
    private final DbTable myTable;
    private final DbColumn myColumnPartitionId;

    BaseJoiningPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder, DbTable theTable) {
        super(theSearchSqlBuilder);
        this.myTable = theTable;
        this.myColumnPartitionId = theTable.addColumn("PARTITION_ID");
    }

    public DbTable getTable() {
        return this.myTable;
    }

    public abstract DbColumn getResourceIdColumn();

    DbColumn getPartitionIdColumn() {
        return this.myColumnPartitionId;
    }

    public Condition combineWithRequestPartitionIdPredicate(RequestPartitionId theRequestPartitionId, Condition theCondition) {
        Condition partitionIdPredicate = this.createPartitionIdPredicate(theRequestPartitionId);
        if (partitionIdPredicate == null) {
            return theCondition;
        }
        return QueryParameterUtils.toAndPredicate(partitionIdPredicate, theCondition);
    }

    @Nullable
    public Condition createPartitionIdPredicate(RequestPartitionId theRequestPartitionId) {
        if (theRequestPartitionId != null && !theRequestPartitionId.isAllPartitions()) {
            UnaryCondition condition;
            boolean defaultPartitionIsNull;
            boolean bl = defaultPartitionIsNull = this.getPartitionSettings().getDefaultPartitionId() == null;
            if (theRequestPartitionId.isDefaultPartition() && defaultPartitionIsNull) {
                condition = UnaryCondition.isNull((Object)this.getPartitionIdColumn());
            } else if (theRequestPartitionId.hasDefaultPartitionId() && defaultPartitionIsNull) {
                List<String> placeholders = this.generatePlaceholders(theRequestPartitionId.getPartitionIdsWithoutDefault());
                UnaryCondition partitionNullPredicate = UnaryCondition.isNull((Object)this.getPartitionIdColumn());
                Condition partitionIdsPredicate = QueryParameterUtils.toEqualToOrInPredicate(this.getPartitionIdColumn(), placeholders);
                condition = QueryParameterUtils.toOrPredicate(new Condition[]{partitionNullPredicate, partitionIdsPredicate});
            } else {
                List<Integer> partitionIds = theRequestPartitionId.getPartitionIds();
                partitionIds = BaseJoiningPredicateBuilder.replaceDefaultPartitionIdIfNonNull(this.getPartitionSettings(), partitionIds);
                List<String> placeholders = this.generatePlaceholders(partitionIds);
                condition = QueryParameterUtils.toEqualToOrInPredicate(this.getPartitionIdColumn(), placeholders);
            }
            return condition;
        }
        return null;
    }

    public Condition createPredicateResourceIds(boolean theInverse, List<Long> theResourceIds) {
        Validate.notNull(theResourceIds, (String)"theResourceIds must not be null", (Object[])new Object[0]);
        Condition inResourceIds = QueryParameterUtils.toEqualToOrInPredicate(this.getResourceIdColumn(), this.generatePlaceholders(theResourceIds));
        if (theInverse) {
            inResourceIds = new NotCondition(inResourceIds);
        }
        return inResourceIds;
    }

    public static List<Integer> replaceDefaultPartitionIdIfNonNull(PartitionSettings thePartitionSettings, List<Integer> thePartitionIds) {
        List<Integer> partitionIds = thePartitionIds;
        if (thePartitionSettings.getDefaultPartitionId() != null) {
            partitionIds = partitionIds.stream().map(t -> t == null ? thePartitionSettings.getDefaultPartitionId() : t).collect(Collectors.toList());
        }
        return partitionIds;
    }
}

