/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.NumberPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.QuantityParam;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import jakarta.persistence.criteria.CriteriaBuilder;
import java.math.BigDecimal;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseQuantityPredicateBuilder
extends BaseSearchParamPredicateBuilder {
    protected DbColumn myColumnHashIdentitySystemUnits;
    protected DbColumn myColumnHashIdentityUnits;
    protected DbColumn myColumnValue;
    @Autowired
    private FhirContext myFhirContext;

    public BaseQuantityPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder, DbTable theTable) {
        super(theSearchSqlBuilder, theTable);
    }

    public Condition createPredicateQuantity(QuantityParam theParam, String theResourceName, String theParamName, CriteriaBuilder theBuilder, BaseQuantityPredicateBuilder theFrom, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        BinaryCondition hashPredicate;
        long hash;
        String systemValue = theParam.getSystem();
        String unitsValue = theParam.getUnits();
        ParamPrefixEnum cmpValue = theParam.getPrefix();
        BigDecimal valueValue = theParam.getValue();
        if (!StringUtils.isBlank((CharSequence)systemValue) && !StringUtils.isBlank((CharSequence)unitsValue)) {
            hash = BaseResourceIndexedSearchParamQuantity.calculateHashSystemAndUnits((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (String)systemValue, (String)unitsValue);
            hashPredicate = BinaryCondition.equalTo((Object)this.myColumnHashIdentitySystemUnits, (Object)this.generatePlaceholder(hash));
        } else if (!StringUtils.isBlank((CharSequence)unitsValue)) {
            hash = BaseResourceIndexedSearchParamQuantity.calculateHashUnits((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (String)unitsValue);
            hashPredicate = BinaryCondition.equalTo((Object)this.myColumnHashIdentityUnits, (Object)this.generatePlaceholder(hash));
        } else {
            hash = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName);
            hashPredicate = BinaryCondition.equalTo((Object)this.getColumnHashIdentity(), (Object)this.generatePlaceholder(hash));
        }
        SearchFilterParser.CompareOperation operation = theOperation;
        if (operation == null && cmpValue != null) {
            operation = QueryParameterUtils.toOperation(cmpValue);
        }
        operation = (SearchFilterParser.CompareOperation)((Object)ObjectUtils.defaultIfNull((Object)((Object)operation), (Object)((Object)SearchFilterParser.CompareOperation.eq)));
        Condition numericPredicate = NumberPredicateBuilder.createPredicateNumeric(this, operation, valueValue, this.myColumnValue, "invalidQuantityPrefix", this.myFhirContext, (IQueryParameterType)theParam);
        return ComboCondition.and((Condition[])new Condition[]{hashPredicate, numericPredicate});
    }

    public DbColumn getColumnValue() {
        return this.myColumnValue;
    }
}

