/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.search.builder.models.MissingQueryParameterPredicateParams;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ICanMakeMissingParamPredicate;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.NotCondition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;

public abstract class BaseSearchParamPredicateBuilder
extends BaseJoiningPredicateBuilder
implements ICanMakeMissingParamPredicate {
    private final DbColumn myColumnMissing;
    private final DbColumn myColumnResType;
    private final DbColumn myColumnParamName;
    private final DbColumn myColumnResId = this.getTable().addColumn("RES_ID");
    private final DbColumn myColumnHashIdentity;

    public BaseSearchParamPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder, DbTable theTable) {
        super(theSearchSqlBuilder, theTable);
        this.myColumnMissing = theTable.addColumn("SP_MISSING");
        this.myColumnResType = theTable.addColumn("RES_TYPE");
        this.myColumnParamName = theTable.addColumn("SP_NAME");
        this.myColumnHashIdentity = theTable.addColumn("HASH_IDENTITY");
    }

    public DbColumn getColumnHashIdentity() {
        return this.myColumnHashIdentity;
    }

    public DbColumn getResourceTypeColumn() {
        return this.myColumnResType;
    }

    public DbColumn getColumnParamName() {
        return this.myColumnParamName;
    }

    public DbColumn getMissingColumn() {
        return this.myColumnMissing;
    }

    @Override
    public DbColumn getResourceIdColumn() {
        return this.myColumnResId;
    }

    public Condition combineWithHashIdentityPredicate(String theResourceName, String theParamName, Condition thePredicate) {
        ArrayList<Condition> andPredicates = new ArrayList<Condition>();
        Condition hashIdentityPredicate = this.createHashIdentityPredicate(theResourceName, theParamName);
        andPredicates.add(hashIdentityPredicate);
        andPredicates.add(thePredicate);
        return QueryParameterUtils.toAndPredicate(andPredicates);
    }

    @Nonnull
    public Condition createHashIdentityPredicate(String theResourceType, String theParamName) {
        long hashIdentity = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (String)theResourceType, (String)theParamName);
        String hashIdentityVal = this.generatePlaceholder(hashIdentity);
        return BinaryCondition.equalTo((Object)this.myColumnHashIdentity, (Object)hashIdentityVal);
    }

    public Condition createPredicateParamMissingForNonReference(String theResourceName, String theParamName, Boolean theMissing, RequestPartitionId theRequestPartitionId) {
        ArrayList<BinaryCondition> conditions = new ArrayList<BinaryCondition>();
        if (this.getStorageSettings().isIndexStorageOptimized()) {
            Long hashIdentity = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (String)theResourceName, (String)theParamName);
            conditions.add(BinaryCondition.equalTo((Object)this.getColumnHashIdentity(), (Object)this.generatePlaceholder(hashIdentity)));
        } else {
            conditions.add(BinaryCondition.equalTo((Object)this.getResourceTypeColumn(), (Object)this.generatePlaceholder(theResourceName)));
            conditions.add(BinaryCondition.equalTo((Object)this.getColumnParamName(), (Object)this.generatePlaceholder(theParamName)));
        }
        conditions.add(BinaryCondition.equalTo((Object)this.getMissingColumn(), (Object)this.generatePlaceholder(theMissing)));
        ComboCondition condition = ComboCondition.and((Object[])conditions.toArray());
        return this.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)condition);
    }

    @Override
    public Condition createPredicateParamMissingValue(MissingQueryParameterPredicateParams theParams) {
        SelectQuery subquery = new SelectQuery();
        subquery.addCustomColumns(new Object[]{1});
        subquery.addFromTable((Table)this.getTable());
        long hashIdentity = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theParams.getRequestPartitionId(), (String)theParams.getResourceTablePredicateBuilder().getResourceType(), (String)theParams.getParamName());
        ComboCondition subQueryCondition = ComboCondition.and((Condition[])new Condition[]{BinaryCondition.equalTo((Object)this.getResourceIdColumn(), (Object)theParams.getResourceTablePredicateBuilder().getResourceIdColumn()), BinaryCondition.equalTo((Object)this.getColumnHashIdentity(), (Object)this.generatePlaceholder(hashIdentity))});
        subquery.addCondition((Condition)subQueryCondition);
        UnaryCondition unaryCondition = UnaryCondition.exists((Object)subquery);
        if (theParams.isMissing()) {
            unaryCondition = new NotCondition((Condition)unaryCondition);
        }
        return this.combineWithRequestPartitionIdPredicate(theParams.getRequestPartitionId(), (Condition)unaryCondition);
    }
}

