/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.List;
import java.util.stream.Collectors;

public class ComboNonUniqueSearchParameterPredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private final DbColumn myColumnHashComplete = this.getTable().addColumn("HASH_COMPLETE");

    public ComboNonUniqueSearchParameterPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_IDX_CMB_TOK_NU"));
    }

    public Condition createPredicateHashComplete(RequestPartitionId theRequestPartitionId, List<String> theIndexStrings) {
        PartitionablePartitionId partitionId = PartitionablePartitionId.toStoragePartition((RequestPartitionId)theRequestPartitionId, (PartitionSettings)this.getPartitionSettings());
        List hashes = theIndexStrings.stream().map(t -> ResourceIndexedComboTokenNonUnique.calculateHashComplete((PartitionSettings)this.getPartitionSettings(), (PartitionablePartitionId)partitionId, (String)t)).collect(Collectors.toList());
        Condition predicate = QueryParameterUtils.toEqualToOrInPredicate(this.myColumnHashComplete, this.generatePlaceholders(hashes));
        return this.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
    }
}

