/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.UrlUtil;
import org.apache.commons.lang3.StringUtils;

public class ParsedLocationParam {
    private final double myLatitudeValue;
    private final double myLongitudeValue;
    private final double myDistanceKm;

    private ParsedLocationParam(String theLatitudeValue, String theLongitudeValue, double theDistanceKm) {
        this.myLatitudeValue = ParsedLocationParam.parseLatLonParameter(theLatitudeValue);
        this.myLongitudeValue = ParsedLocationParam.parseLatLonParameter(theLongitudeValue);
        this.myDistanceKm = theDistanceKm;
    }

    private static double parseLatLonParameter(String theValue) {
        try {
            return Double.parseDouble(StringUtils.defaultString((String)theValue));
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException(Msg.code((int)2308) + "Invalid lat/lon parameter value: " + UrlUtil.sanitizeUrlPart((CharSequence)theValue));
        }
    }

    public double getLatitudeValue() {
        return this.myLatitudeValue;
    }

    public double getLongitudeValue() {
        return this.myLongitudeValue;
    }

    public double getDistanceKm() {
        return this.myDistanceKm;
    }

    public static ParsedLocationParam from(SearchParameterMap theParams, IQueryParameterType theParam) {
        String longitudeValue;
        String latitudeValue;
        double distanceKm = 0.0;
        if (theParam instanceof TokenParam) {
            TokenParam param = (TokenParam)theParam;
            String value = param.getValue();
            String[] parts = value.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException(Msg.code((int)1228) + "Invalid position format '" + value + "'.  Required format is 'latitude:longitude'");
            }
            latitudeValue = parts[0];
            longitudeValue = parts[1];
            if (StringUtils.isBlank((CharSequence)latitudeValue) || StringUtils.isBlank((CharSequence)longitudeValue)) {
                throw new IllegalArgumentException(Msg.code((int)1229) + "Invalid position format '" + value + "'.  Both latitude and longitude must be provided.");
            }
            QuantityParam distanceParam = theParams.getNearDistanceParam();
            if (distanceParam != null) {
                distanceKm = ParsedLocationParam.parseLatLonParameter(distanceParam.getValueAsString());
            }
        } else if (theParam instanceof SpecialParam) {
            SpecialParam param = (SpecialParam)theParam;
            String value = param.getValue();
            String[] parts = StringUtils.split((String)value, (char)'|');
            if (parts.length < 2 || parts.length > 4) {
                throw new IllegalArgumentException(Msg.code((int)1230) + "Invalid position format '" + value + "'.  Required format is 'latitude|longitude' or 'latitude|longitude|distance' or 'latitude|longitude|distance|units'");
            }
            latitudeValue = parts[0];
            longitudeValue = parts[1];
            if (StringUtils.isBlank((CharSequence)latitudeValue) || StringUtils.isBlank((CharSequence)longitudeValue)) {
                throw new IllegalArgumentException(Msg.code((int)1231) + "Invalid position format '" + value + "'.  Both latitude and longitude must be provided.");
            }
            if (parts.length >= 3) {
                String distanceString = parts[2];
                if (!StringUtils.isBlank((CharSequence)distanceString)) {
                    distanceKm = ParsedLocationParam.parseLatLonParameter(distanceString);
                }
                if (parts.length >= 4) {
                    String distanceUnits = parts[3];
                    distanceKm = UcumServiceUtil.convert((double)distanceKm, (String)distanceUnits, (String)"km");
                }
            }
        } else {
            throw new IllegalArgumentException(Msg.code((int)1232) + "Invalid position type: " + theParam.getClass());
        }
        return new ParsedLocationParam(latitudeValue, longitudeValue, distanceKm);
    }
}

