/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.StringUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourcePredicateBuilder
extends BaseJoiningPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(SourcePredicateBuilder.class);
    private final DbColumn myColumnSourceUri;
    private final DbColumn myColumnRequestId;
    private final DbColumn myResourceIdColumn = this.getTable().addColumn("RES_PID");

    public SourcePredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_RES_VER_PROV"));
        this.myColumnSourceUri = this.getTable().addColumn("SOURCE_URI");
        this.myColumnRequestId = this.getTable().addColumn("REQUEST_ID");
    }

    @Override
    public DbColumn getResourceIdColumn() {
        return this.myResourceIdColumn;
    }

    public Condition createPredicateSourceUri(String theSourceUri) {
        return BinaryCondition.equalTo((Object)this.myColumnSourceUri, (Object)this.generatePlaceholder(theSourceUri));
    }

    public Condition createPredicateMissingSourceUri() {
        return UnaryCondition.isNull((Object)this.myColumnSourceUri);
    }

    public Condition createPredicateSourceUriWithModifiers(IQueryParameterType theQueryParameter, JpaStorageSettings theStorageSetting, String theSourceUri) {
        if (theQueryParameter.getMissing() != null && !theQueryParameter.getMissing().booleanValue()) {
            return UnaryCondition.isNotNull((Object)this.myColumnSourceUri);
        }
        if (theQueryParameter instanceof UriParam && theQueryParameter.getQueryParameterQualifier() != null) {
            UriParam uriParam = (UriParam)theQueryParameter;
            switch (uriParam.getQualifier()) {
                case ABOVE: {
                    return this.createPredicateSourceAbove(theSourceUri);
                }
                case BELOW: {
                    return this.createPredicateSourceBelow(theSourceUri);
                }
                case CONTAINS: {
                    return this.createPredicateSourceContains(theStorageSetting, theSourceUri);
                }
            }
            throw new InvalidRequestException(Msg.code((int)2418) + String.format("Unsupported qualifier specified, qualifier=%s", theQueryParameter.getQueryParameterQualifier()));
        }
        return this.createPredicateSourceUri(theSourceUri);
    }

    private Condition createPredicateSourceAbove(String theSourceUri) {
        List aboveUriCandidates = UrlUtil.getAboveUriCandidates((String)theSourceUri);
        List<String> aboveUriPlaceholders = this.generatePlaceholders(aboveUriCandidates);
        return QueryParameterUtils.toEqualToOrInPredicate(this.myColumnSourceUri, aboveUriPlaceholders);
    }

    private Condition createPredicateSourceBelow(String theSourceUri) {
        String belowLikeExpression = StringPredicateBuilder.createLeftMatchLikeExpression(theSourceUri);
        return BinaryCondition.like((Object)this.myColumnSourceUri, (Object)this.generatePlaceholder(belowLikeExpression));
    }

    private Condition createPredicateSourceContains(JpaStorageSettings theStorageSetting, String theSourceUri) {
        if (theStorageSetting.isAllowContainsSearches()) {
            FunctionCall upperFunction = new FunctionCall((Object)"UPPER");
            upperFunction.addCustomParams(new Object[]{this.myColumnSourceUri});
            String normalizedString = StringUtil.normalizeStringForSearchIndexing((String)theSourceUri);
            String containsLikeExpression = StringPredicateBuilder.createLeftAndRightMatchLikeExpression(normalizedString);
            return BinaryCondition.like((Object)upperFunction, (Object)this.generatePlaceholder(containsLikeExpression));
        }
        throw new MethodNotAllowedException(Msg.code((int)2417) + ":contains modifier is disabled on this server");
    }

    public Condition createPredicateRequestId(String theRequestId) {
        return BinaryCondition.equalTo((Object)this.myColumnRequestId, (Object)this.generatePlaceholder(theRequestId));
    }
}

