/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.rest.param.UriParamQualifierEnum;
import com.google.common.collect.Lists;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class TagPredicateBuilder
extends BaseJoiningPredicateBuilder {
    private final DbColumn myColumnResId = this.getTable().addColumn("RES_ID");
    private final DbTable myTagDefinitionTable;
    private final DbColumn myTagDefinitionColumnTagId;
    private final DbColumn myTagDefinitionColumnTagSystem;
    private final DbColumn myTagDefinitionColumnTagCode;
    private final DbColumn myColumnTagId = this.getTable().addColumn("TAG_ID");
    private final DbColumn myTagDefinitionColumnTagType;

    public TagPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_RES_TAG"));
        this.myTagDefinitionTable = theSearchSqlBuilder.addTable("HFJ_TAG_DEF");
        this.myTagDefinitionColumnTagId = this.myTagDefinitionTable.addColumn("TAG_ID");
        this.myTagDefinitionColumnTagSystem = this.myTagDefinitionTable.addColumn("TAG_SYSTEM");
        this.myTagDefinitionColumnTagCode = this.myTagDefinitionTable.addColumn("TAG_CODE");
        this.myTagDefinitionColumnTagType = this.myTagDefinitionTable.addColumn("TAG_TYPE");
    }

    public Condition createPredicateTag(TagTypeEnum theTagType, List<Triple<String, String, String>> theTokens, String theParamName, RequestPartitionId theRequestPartitionId) {
        this.addJoin(this.getTable(), this.myTagDefinitionTable, this.myColumnTagId, this.myTagDefinitionColumnTagId);
        return this.createPredicateTagList(theTagType, theTokens);
    }

    private Condition createPredicateTagList(TagTypeEnum theTagType, List<Triple<String, String, String>> theTokens) {
        BinaryCondition typePredicate = BinaryCondition.equalTo((Object)this.myTagDefinitionColumnTagType, (Object)this.generatePlaceholder(theTagType.ordinal()));
        ArrayList orPredicates = Lists.newArrayList();
        for (Triple<String, String, String> next : theTokens) {
            BinaryCondition codePredicate;
            String system = (String)next.getLeft();
            String code = (String)next.getRight();
            String qualifier = (String)next.getMiddle();
            if (theTagType == TagTypeEnum.PROFILE) {
                system = "https://github.com/hapifhir/hapi-fhir/ns/jpa/profile";
            }
            BinaryCondition binaryCondition = codePredicate = Objects.equals(qualifier, UriParamQualifierEnum.BELOW.getValue()) ? BinaryCondition.like((Object)this.myTagDefinitionColumnTagCode, (Object)this.generatePlaceholder(StringPredicateBuilder.createLeftMatchLikeExpression(code))) : BinaryCondition.equalTo((Object)this.myTagDefinitionColumnTagCode, (Object)this.generatePlaceholder(code));
            if (StringUtils.isNotBlank((CharSequence)system)) {
                BinaryCondition systemPredicate = BinaryCondition.equalTo((Object)this.myTagDefinitionColumnTagSystem, (Object)this.generatePlaceholder(system));
                orPredicates.add(ComboCondition.and((Condition[])new Condition[]{typePredicate, systemPredicate, codePredicate}));
                continue;
            }
            orPredicates.add(ComboCondition.and((Condition[])new Condition[]{typePredicate, codePredicate}));
        }
        return ComboCondition.or((Condition[])orPredicates.toArray(new Condition[0]));
    }

    @Override
    public DbColumn getResourceIdColumn() {
        return this.myColumnResId;
    }
}

