/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.FhirVersionIndependentConcept;
import com.google.common.collect.Sets;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TokenPredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(TokenPredicateBuilder.class);
    private final DbColumn myColumnResId = this.getTable().addColumn("RES_ID");
    private final DbColumn myColumnHashSystemAndValue;
    private final DbColumn myColumnHashSystem = this.getTable().addColumn("HASH_SYS");
    private final DbColumn myColumnHashValue;
    private final DbColumn myColumnSystem;
    private final DbColumn myColumnValue;
    @Autowired
    private IValidationSupport myValidationSupport;
    @Autowired
    private ITermReadSvc myTerminologySvc;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private JpaStorageSettings myStorageSettings;

    public TokenPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_SPIDX_TOKEN"));
        this.myColumnHashSystemAndValue = this.getTable().addColumn("HASH_SYS_AND_VALUE");
        this.myColumnHashValue = this.getTable().addColumn("HASH_VALUE");
        this.myColumnSystem = this.getTable().addColumn("SP_SYSTEM");
        this.myColumnValue = this.getTable().addColumn("SP_VALUE");
    }

    @Override
    public DbColumn getResourceIdColumn() {
        return this.myColumnResId;
    }

    public Condition createPredicateToken(Collection<IQueryParameterType> theParameters, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateToken(theParameters, theResourceName, theSpnamePrefix, theSearchParam, null, theRequestPartitionId);
    }

    public Condition createPredicateToken(Collection<IQueryParameterType> theParameters, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        Condition predicate;
        ArrayList<FhirVersionIndependentConcept> codes = new ArrayList<FhirVersionIndependentConcept>();
        Object paramName = QueryParameterUtils.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        SearchFilterParser.CompareOperation operation = theOperation;
        TokenParamModifier modifier = null;
        for (IQueryParameterType nextParameter : theParameters) {
            String code;
            String system;
            TokenParam id;
            if (nextParameter instanceof TokenParam) {
                id = (TokenParam)nextParameter;
                system = id.getSystem();
                code = id.getValue();
                modifier = id.getModifier();
            } else if (nextParameter instanceof BaseIdentifierDt) {
                id = (BaseIdentifierDt)nextParameter;
                system = id.getSystemElement().getValueAsString();
                code = (String)id.getValueElement().getValue();
            } else if (nextParameter instanceof BaseCodingDt) {
                id = (BaseCodingDt)nextParameter;
                system = id.getSystemElement().getValueAsString();
                code = (String)id.getCodeElement().getValue();
            } else if (nextParameter instanceof NumberParam) {
                NumberParam number = (NumberParam)nextParameter;
                system = null;
                code = number.getValueAsQueryToken(this.getFhirContext());
            } else {
                throw new IllegalArgumentException(Msg.code((int)1236) + "Invalid token type: " + nextParameter.getClass());
            }
            if (system != null && system.length() > 200) {
                ourLog.info("Parameter[{}] has system ({}) that is longer than maximum ({}) so will truncate: {} ", new Object[]{paramName, system.length(), 200, system});
            }
            if (code != null && code.length() > 200) {
                ourLog.info("Parameter[{}] has code ({}) that is longer than maximum ({}) so will truncate: {} ", new Object[]{paramName, code.length(), 200, code});
            }
            if (modifier == TokenParamModifier.IN || modifier == TokenParamModifier.NOT_IN) {
                if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2)) {
                    ValueSetExpansionOptions valueSetExpansionOptions = new ValueSetExpansionOptions();
                    valueSetExpansionOptions.setCount(this.myStorageSettings.getMaximumExpansionSize());
                    IValidationSupport.ValueSetExpansionOutcome expanded = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), valueSetExpansionOptions, code);
                    codes.addAll(this.extractValueSetCodes(expanded.getValueSet()));
                } else {
                    codes.addAll(this.myTerminologySvc.expandValueSetIntoConceptList(null, code));
                }
                if (modifier != TokenParamModifier.NOT_IN) continue;
                operation = SearchFilterParser.CompareOperation.ne;
                continue;
            }
            if (modifier == TokenParamModifier.ABOVE) {
                system = this.determineSystemIfMissing(theSearchParam, code, system);
                this.validateHaveSystemAndCodeForToken((String)paramName, code, system);
                codes.addAll(this.myTerminologySvc.findCodesAbove(system, code));
                continue;
            }
            if (modifier == TokenParamModifier.BELOW) {
                system = this.determineSystemIfMissing(theSearchParam, code, system);
                this.validateHaveSystemAndCodeForToken((String)paramName, code, system);
                codes.addAll(this.myTerminologySvc.findCodesBelow(system, code));
                continue;
            }
            if (modifier == TokenParamModifier.OF_TYPE) {
                if (!this.myStorageSettings.isIndexIdentifierOfType()) {
                    throw new MethodNotAllowedException(Msg.code((int)2012) + "The :of-type modifier is not enabled on this server");
                }
                if (StringUtils.isBlank((CharSequence)system) || StringUtils.isBlank((CharSequence)code)) {
                    throw new InvalidRequestException(Msg.code((int)2013) + "Invalid parameter value for :of-type query");
                }
                int pipeIdx = code.indexOf(124);
                if (pipeIdx < 1 || pipeIdx == code.length() - 1) {
                    throw new InvalidRequestException(Msg.code((int)2014) + "Invalid parameter value for :of-type query");
                }
                paramName = (String)paramName + ":of-type";
                codes.add(new FhirVersionIndependentConcept(system, code));
                continue;
            }
            if (modifier == TokenParamModifier.NOT && operation == null) {
                operation = SearchFilterParser.CompareOperation.ne;
            }
            codes.add(new FhirVersionIndependentConcept(system, code));
        }
        List<FhirVersionIndependentConcept> sortedCodesList = codes.stream().filter(t -> t.getCode() != null || t.getSystem() != null).sorted().distinct().collect(Collectors.toList());
        if (codes.isEmpty()) {
            this.setMatchNothing();
            return null;
        }
        if (operation == SearchFilterParser.CompareOperation.ne) {
            long hashIdentity = BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)paramName);
            BinaryCondition hashIdentityPredicate = BinaryCondition.equalTo((Object)this.getColumnHashIdentity(), (Object)this.generatePlaceholder(hashIdentity));
            Condition hashValuePredicate = this.createPredicateOrList(theResourceName, (String)paramName, sortedCodesList, false);
            predicate = QueryParameterUtils.toAndPredicate(new Condition[]{hashIdentityPredicate, hashValuePredicate});
        } else {
            predicate = this.createPredicateOrList(theResourceName, (String)paramName, sortedCodesList, true);
        }
        return predicate;
    }

    private List<FhirVersionIndependentConcept> extractValueSetCodes(IBaseResource theValueSet) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        RuntimeResourceDefinition vsDef = this.myContext.getResourceDefinition("ValueSet");
        BaseRuntimeChildDefinition expansionChild = vsDef.getChildByName("expansion");
        Optional expansionOpt = expansionChild.getAccessor().getFirstValueOrNull((IBase)theValueSet);
        if (expansionOpt.isPresent()) {
            IBase expansion = (IBase)expansionOpt.get();
            BaseRuntimeElementCompositeDefinition expansionDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(expansion.getClass());
            BaseRuntimeChildDefinition containsChild = expansionDef.getChildByName("contains");
            List contains = containsChild.getAccessor().getValues(expansion);
            BaseRuntimeChildDefinition.IAccessor systemAccessor = null;
            BaseRuntimeChildDefinition.IAccessor codeAccessor = null;
            for (IBase nextContains : contains) {
                if (systemAccessor == null) {
                    systemAccessor = this.myContext.getElementDefinition(nextContains.getClass()).getChildByName("system").getAccessor();
                }
                if (codeAccessor == null) {
                    codeAccessor = this.myContext.getElementDefinition(nextContains.getClass()).getChildByName("code").getAccessor();
                }
                String system = systemAccessor.getFirstValueOrNull(nextContains).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
                String code = codeAccessor.getFirstValueOrNull(nextContains).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
                if (!StringUtils.isNotBlank((CharSequence)system) || !StringUtils.isNotBlank((CharSequence)code)) continue;
                retVal.add(new FhirVersionIndependentConcept(system, code));
            }
        }
        return retVal;
    }

    private String determineSystemIfMissing(RuntimeSearchParam theSearchParam, String code, String theSystem) {
        String retVal = theSystem;
        if (retVal == null && theSearchParam != null) {
            HashSet valueSetUris = Sets.newHashSet();
            for (String nextPath : theSearchParam.getPathsSplitForResourceType(this.getResourceType())) {
                String valueSet;
                Class type = this.getFhirContext().getResourceDefinition(this.getResourceType()).getImplementingClass();
                BaseRuntimeChildDefinition def = this.getFhirContext().newTerser().getDefinition(type, nextPath);
                if (!(def instanceof BaseRuntimeDeclaredChildDefinition) || !StringUtils.isNotBlank((CharSequence)(valueSet = ((BaseRuntimeDeclaredChildDefinition)def).getBindingValueSet()))) continue;
                valueSetUris.add(valueSet);
            }
            if (valueSetUris.size() == 1) {
                String valueSet = (String)valueSetUris.iterator().next();
                ValueSetExpansionOptions options = new ValueSetExpansionOptions().setFailOnMissingCodeSystem(false);
                List<FhirVersionIndependentConcept> candidateCodes = this.myTerminologySvc.expandValueSetIntoConceptList(options, valueSet);
                for (FhirVersionIndependentConcept nextCandidate : candidateCodes) {
                    if (!nextCandidate.getCode().equals(code)) continue;
                    retVal = nextCandidate.getSystem();
                    break;
                }
            }
        }
        return retVal;
    }

    public DbColumn getColumnSystem() {
        return this.myColumnSystem;
    }

    public DbColumn getColumnValue() {
        return this.myColumnValue;
    }

    private void validateHaveSystemAndCodeForToken(String theParamName, String theCode, String theSystem) {
        String systemDesc = (String)StringUtils.defaultIfBlank((CharSequence)theSystem, (CharSequence)"(missing)");
        String codeDesc = (String)StringUtils.defaultIfBlank((CharSequence)theCode, (CharSequence)"(missing)");
        if (StringUtils.isBlank((CharSequence)theCode)) {
            String msg = this.getFhirContext().getLocalizer().getMessage(TokenPredicateBuilder.class, "invalidCodeMissingSystem", new Object[]{theParamName, systemDesc, codeDesc});
            throw new InvalidRequestException(Msg.code((int)1239) + msg);
        }
        if (StringUtils.isBlank((CharSequence)theSystem)) {
            String msg = this.getFhirContext().getLocalizer().getMessage(TokenPredicateBuilder.class, "invalidCodeMissingCode", new Object[]{theParamName, systemDesc, codeDesc});
            throw new InvalidRequestException(Msg.code((int)1240) + msg);
        }
    }

    private Condition createPredicateOrList(String theResourceType, String theSearchParamName, List<FhirVersionIndependentConcept> theCodes, boolean theWantEquals) {
        int i;
        Condition[] conditions = new Condition[theCodes.size()];
        Long[] hashes = new Long[theCodes.size()];
        DbColumn[] columns = new DbColumn[theCodes.size()];
        boolean haveMultipleColumns = false;
        for (i = 0; i < conditions.length; ++i) {
            DbColumn column;
            long hash;
            FhirVersionIndependentConcept nextToken = theCodes.get(i);
            if (nextToken.getSystem() == null) {
                hash = ResourceIndexedSearchParamToken.calculateHashValue((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (String)theResourceType, (String)theSearchParamName, (String)nextToken.getCode());
                column = this.myColumnHashValue;
            } else if (StringUtils.isBlank((CharSequence)nextToken.getCode())) {
                hash = ResourceIndexedSearchParamToken.calculateHashSystem((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (String)theResourceType, (String)theSearchParamName, (String)nextToken.getSystem());
                column = this.myColumnHashSystem;
            } else {
                hash = ResourceIndexedSearchParamToken.calculateHashSystemAndValue((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (String)theResourceType, (String)theSearchParamName, (String)nextToken.getSystem(), (String)nextToken.getCode());
                column = this.myColumnHashSystemAndValue;
            }
            hashes[i] = hash;
            columns[i] = column;
            if (i <= 0 || columns[0] == columns[i]) continue;
            haveMultipleColumns = true;
        }
        if (!haveMultipleColumns && conditions.length > 1) {
            List<Long> values = Arrays.asList(hashes);
            return QueryParameterUtils.toEqualToOrInPredicate(columns[0], this.generatePlaceholders(values), !theWantEquals);
        }
        for (i = 0; i < conditions.length; ++i) {
            String valuePlaceholder = this.generatePlaceholder(hashes[i]);
            conditions[i] = theWantEquals ? BinaryCondition.equalTo((Object)columns[i], (Object)valuePlaceholder) : BinaryCondition.notEqualTo((Object)columns[i], (Object)valuePlaceholder);
        }
        if (conditions.length > 1) {
            if (theWantEquals) {
                return QueryParameterUtils.toOrPredicate(conditions);
            }
            return QueryParameterUtils.toAndPredicate(conditions);
        }
        return conditions[0];
    }
}

