/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.sql;

import java.util.List;
import java.util.regex.Pattern;

public class GeneratedSql {
    public static final Pattern INLINE_EQ_PATTERN = Pattern.compile("=\\s*['0-9]");
    public static final Pattern INLINE_IN_PATTERN = Pattern.compile("(in|IN)\\s*\\(\\s*['0-9]");
    private final String mySql;
    private final List<Object> myBindVariables;
    private final boolean myMatchNothing;

    public GeneratedSql(boolean theMatchNothing, String theSql, List<Object> theBindVariables) {
        assert (!INLINE_EQ_PATTERN.matcher(theSql).find()) : "Non-bound SQL parameter found: " + theSql;
        assert (!INLINE_IN_PATTERN.matcher(theSql).find()) : "Non-bound SQL parameter found: " + theSql;
        this.myMatchNothing = theMatchNothing;
        this.mySql = theSql;
        this.myBindVariables = theBindVariables;
    }

    public boolean isMatchNothing() {
        return this.myMatchNothing;
    }

    public List<Object> getBindVariables() {
        return this.myBindVariables;
    }

    public String getSql() {
        return this.mySql;
    }
}

