/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.sql;

import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.predicate.CoordsPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.DatePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ICanMakeMissingParamPredicate;
import ca.uhn.fhir.jpa.search.builder.predicate.NumberPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceLinkPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TokenPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.UriPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateBuilderFactory {
    private static final Logger ourLog = LoggerFactory.getLogger(PredicateBuilderFactory.class);

    public static ICanMakeMissingParamPredicate createPredicateBuilderForParamType(RestSearchParameterTypeEnum theParamType, SearchQueryBuilder theBuilder, QueryStack theQueryStack) {
        switch (theParamType) {
            case NUMBER: {
                return PredicateBuilderFactory.createNumberPredicateBuilder(theBuilder);
            }
            case DATE: {
                return PredicateBuilderFactory.createDatePredicateBuilder(theBuilder);
            }
            case STRING: {
                return PredicateBuilderFactory.createStringPredicateBuilder(theBuilder);
            }
            case TOKEN: {
                return PredicateBuilderFactory.createTokenPredicateBuilder(theBuilder);
            }
            case QUANTITY: {
                return PredicateBuilderFactory.createQuantityPredicateBuilder(theBuilder);
            }
            case URI: {
                return PredicateBuilderFactory.createUriPredicateBuilder(theBuilder);
            }
            case REFERENCE: {
                return PredicateBuilderFactory.createReferencePredicateBuilder(theQueryStack, theBuilder);
            }
            case HAS: 
            case SPECIAL: {
                return PredicateBuilderFactory.createCoordsPredicateBuilder(theBuilder);
            }
        }
        ourLog.error("Invalid param type " + theParamType.name());
        return null;
    }

    private static StringPredicateBuilder createStringPredicateBuilder(SearchQueryBuilder theBuilder) {
        StringPredicateBuilder sp = theBuilder.getSqlBuilderFactory().stringIndexTable(theBuilder);
        return sp;
    }

    private static NumberPredicateBuilder createNumberPredicateBuilder(SearchQueryBuilder theBuilder) {
        NumberPredicateBuilder np = theBuilder.getSqlBuilderFactory().numberIndexTable(theBuilder);
        return np;
    }

    private static QuantityPredicateBuilder createQuantityPredicateBuilder(SearchQueryBuilder theBuilder) {
        QuantityPredicateBuilder qp = theBuilder.getSqlBuilderFactory().quantityIndexTable(theBuilder);
        return qp;
    }

    private static CoordsPredicateBuilder createCoordsPredicateBuilder(SearchQueryBuilder theBuilder) {
        CoordsPredicateBuilder cp = theBuilder.getSqlBuilderFactory().coordsPredicateBuilder(theBuilder);
        return cp;
    }

    private static TokenPredicateBuilder createTokenPredicateBuilder(SearchQueryBuilder theBuilder) {
        TokenPredicateBuilder tp = theBuilder.getSqlBuilderFactory().tokenIndexTable(theBuilder);
        return tp;
    }

    private static DatePredicateBuilder createDatePredicateBuilder(SearchQueryBuilder theBuilder) {
        DatePredicateBuilder dp = theBuilder.getSqlBuilderFactory().dateIndexTable(theBuilder);
        return dp;
    }

    private static UriPredicateBuilder createUriPredicateBuilder(SearchQueryBuilder theBuilder) {
        UriPredicateBuilder up = theBuilder.getSqlBuilderFactory().uriIndexTable(theBuilder);
        return up;
    }

    private static ResourceLinkPredicateBuilder createReferencePredicateBuilder(QueryStack theQueryStack, SearchQueryBuilder theBuilder) {
        ResourceLinkPredicateBuilder retVal = theBuilder.getSqlBuilderFactory().referenceIndexTable(theQueryStack, theBuilder, false);
        return retVal;
    }
}

