/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.elastic;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.search.HapiHSearchAnalysisConfigurers;
import ca.uhn.fhir.jpa.search.elastic.IndexNamePrefixLayoutStrategy;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.engine.cfg.BackendSettings;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchHibernatePropertiesBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(ElasticsearchHibernatePropertiesBuilder.class);
    private IndexStatus myRequiredIndexStatus = IndexStatus.YELLOW;
    private SchemaManagementStrategyName myIndexSchemaManagementStrategy = SchemaManagementStrategyName.CREATE;
    private String myHosts;
    private String myUsername;
    private String myPassword;
    private String myAwsRegion;
    private long myIndexManagementWaitTimeoutMillis = 10000L;
    private long myScrollTimeoutSecs = 60L;
    private String myDebugSyncStrategy = "async";
    private boolean myDebugPrettyPrintJsonLog = false;
    private String myProtocol;

    public String getAwsRegion() {
        return this.myAwsRegion;
    }

    public ElasticsearchHibernatePropertiesBuilder setUsername(String theUsername) {
        this.myUsername = theUsername;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setPassword(String thePassword) {
        this.myPassword = thePassword;
        return this;
    }

    public void apply(Properties theProperties) {
        theProperties.put(BackendSettings.backendKey((String)"type"), "elasticsearch");
        theProperties.put(BackendSettings.backendKey((String)"analysis.configurer"), HapiHSearchAnalysisConfigurers.HapiElasticsearchAnalysisConfigurer.class.getName());
        theProperties.put(BackendSettings.backendKey((String)"hosts"), this.myHosts);
        theProperties.put(BackendSettings.backendKey((String)"protocol"), this.myProtocol);
        if (StringUtils.isNotBlank((CharSequence)this.myUsername)) {
            theProperties.put(BackendSettings.backendKey((String)"username"), this.myUsername);
        }
        if (StringUtils.isNotBlank((CharSequence)this.myPassword)) {
            theProperties.put(BackendSettings.backendKey((String)"password"), this.myPassword);
        }
        theProperties.put("hibernate.search.schema_management.strategy", this.myIndexSchemaManagementStrategy.externalRepresentation());
        theProperties.put(BackendSettings.backendKey((String)"schema_management.minimal_required_status_wait_timeout"), Long.toString(this.myIndexManagementWaitTimeoutMillis));
        theProperties.put(BackendSettings.backendKey((String)"schema_management.minimal_required_status"), this.myRequiredIndexStatus.externalRepresentation());
        theProperties.put(BackendSettings.backendKey((String)"dynamic_mapping"), "true");
        theProperties.put("hibernate.search.automatic_indexing.synchronization.strategy", this.myDebugSyncStrategy);
        theProperties.put(BackendSettings.backendKey((String)"log.json_pretty_printing"), Boolean.toString(this.myDebugPrettyPrintJsonLog));
        theProperties.put(BackendSettings.backendKey((String)"scroll_timeout"), Long.toString(this.myScrollTimeoutSecs));
        theProperties.put(BackendSettings.backendKey((String)"layout.strategy"), IndexNamePrefixLayoutStrategy.class.getName());
        theProperties.put(BackendSettings.backendKey((String)"schema_management.settings_file"), "ca/uhn/fhir/jpa/elastic/index-settings.json");
        if (!StringUtils.isBlank((CharSequence)this.myAwsRegion)) {
            theProperties.put(BackendSettings.backendKey((String)"aws.region"), this.myAwsRegion);
            theProperties.put(BackendSettings.backendKey((String)"aws.signing.enabled"), (Object)true);
            if (!StringUtils.isBlank((CharSequence)this.myUsername) && !StringUtils.isBlank((CharSequence)this.myPassword)) {
                theProperties.put(BackendSettings.backendKey((String)"aws.credentials.type"), "static");
                theProperties.put(BackendSettings.backendKey((String)"aws.credentials.access_key_id"), this.myUsername);
                theProperties.put(BackendSettings.backendKey((String)"aws.credentials.secret_access_key"), this.myPassword);
            } else {
                theProperties.put(BackendSettings.backendKey((String)"aws.credentials.type"), "default");
            }
        }
    }

    public ElasticsearchHibernatePropertiesBuilder setRequiredIndexStatus(IndexStatus theRequiredIndexStatus) {
        this.myRequiredIndexStatus = theRequiredIndexStatus;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setHosts(String hosts) {
        if (hosts.contains("://")) {
            throw new ConfigurationException(Msg.code((int)2139) + "Elasticsearch URLs cannot include a protocol, that is a separate property. Remove http:// or https:// from this URL.");
        }
        this.myHosts = hosts;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setProtocol(String theProtocol) {
        this.myProtocol = theProtocol;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setIndexSchemaManagementStrategy(SchemaManagementStrategyName theIndexSchemaManagementStrategy) {
        this.myIndexSchemaManagementStrategy = theIndexSchemaManagementStrategy;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setIndexManagementWaitTimeoutMillis(long theIndexManagementWaitTimeoutMillis) {
        this.myIndexManagementWaitTimeoutMillis = theIndexManagementWaitTimeoutMillis;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setScrollTimeoutSecs(long theScrollTimeoutSecs) {
        this.myScrollTimeoutSecs = theScrollTimeoutSecs;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setDebugIndexSyncStrategy(String theSyncStrategy) {
        this.myDebugSyncStrategy = theSyncStrategy;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setDebugPrettyPrintJsonLog(boolean theDebugPrettyPrintJsonLog) {
        this.myDebugPrettyPrintJsonLog = theDebugPrettyPrintJsonLog;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setAwsRegion(String theAwsRegion) {
        this.myAwsRegion = theAwsRegion;
        return this;
    }
}

