/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.TranslateConceptResult;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.model.TranslationQuery;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.ITermConceptMapDao;
import ca.uhn.fhir.jpa.entity.TermConceptMap;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElement;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElementTarget;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.term.TermConceptMappingSvcImpl;
import ca.uhn.fhir.jpa.term.api.ITermConceptClientMappingSvc;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.jpa.util.ScrollableResultsIterator;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.query.Query;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumerations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class TermConceptClientMappingSvcImpl
implements ITermConceptClientMappingSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(TermConceptClientMappingSvcImpl.class);
    private final int myFetchSize = 250;
    protected static boolean ourLastResultsFromTranslationCache;
    protected static boolean ourLastResultsFromTranslationWithReverseCache;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    protected FhirContext myContext;
    @Autowired
    protected MemoryCacheService myMemoryCacheService;
    @Autowired
    protected IIdHelperService<JpaPid> myIdHelperService;
    @Autowired
    protected ITermConceptMapDao myConceptMapDao;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public TranslateConceptResults translate(TranslationRequest theTranslationRequest) {
        TranslateConceptResults retVal = new TranslateConceptResults();
        CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(TermConceptMapGroupElementTarget.class);
        Root root = query.from(TermConceptMapGroupElementTarget.class);
        Join elementJoin = root.join("myConceptMapGroupElement");
        Join groupJoin = elementJoin.join("myConceptMapGroup");
        Join conceptMapJoin = groupJoin.join("myConceptMap");
        List translationQueries = theTranslationRequest.getTranslationQueries();
        String latestConceptMapVersion = null;
        if (theTranslationRequest.hasUrl() && !theTranslationRequest.hasConceptMapVersion()) {
            latestConceptMapVersion = this.getLatestConceptMapVersion(theTranslationRequest);
        }
        for (TranslationQuery translationQuery : translationQueries) {
            List cachedTargets = (List)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.CONCEPT_TRANSLATION, (Object)translationQuery);
            if (cachedTargets == null) {
                ArrayList<TranslateConceptResult> targets = new ArrayList<TranslateConceptResult>();
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                Coding coding = translationQuery.getCoding();
                if (!coding.hasCode()) {
                    throw new InvalidRequestException(Msg.code((int)842) + "A code must be provided for translation to occur.");
                }
                predicates.add(criteriaBuilder.equal((Expression)elementJoin.get("myCode"), (Object)coding.getCode()));
                if (coding.hasSystem()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("mySource"), (Object)coding.getSystem()));
                }
                if (coding.hasVersion()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("mySourceVersion"), (Object)coding.getVersion()));
                }
                if (translationQuery.hasTargetSystem()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("myTarget"), (Object)translationQuery.getTargetSystem()));
                }
                if (translationQuery.hasUrl()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myUrl"), (Object)translationQuery.getUrl()));
                    if (translationQuery.hasConceptMapVersion()) {
                        predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myVersion"), (Object)translationQuery.getConceptMapVersion()));
                    } else if (StringUtils.isNotBlank((CharSequence)latestConceptMapVersion)) {
                        predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myVersion"), (Object)latestConceptMapVersion));
                    } else {
                        predicates.add(criteriaBuilder.isNull((Expression)conceptMapJoin.get("myVersion")));
                    }
                }
                if (translationQuery.hasSource()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("mySource"), (Object)translationQuery.getSource()));
                }
                if (translationQuery.hasTarget()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myTarget"), (Object)translationQuery.getTarget()));
                }
                if (translationQuery.hasResourceId()) {
                    IIdType resourceId = translationQuery.getResourceId();
                    JpaPid resourcePid = (JpaPid)this.myIdHelperService.getPidOrThrowException(RequestPartitionId.defaultPartition(), resourceId);
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myResourcePid"), (Object)resourcePid.getId()));
                }
                Predicate outerPredicate = criteriaBuilder.and(predicates.toArray(new Predicate[0]));
                query.where((Expression)outerPredicate);
                TypedQuery typedQuery = this.myEntityManager.createQuery(query.select((Selection)root));
                Query hibernateQuery = (Query)typedQuery;
                hibernateQuery.setFetchSize(250);
                ScrollableResults scrollableResults = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
                try (ScrollableResultsIterator scrollableResultsIterator = new ScrollableResultsIterator(scrollableResults);){
                    HashSet<TermConceptMapGroupElementTarget> matches = new HashSet<TermConceptMapGroupElementTarget>();
                    while (scrollableResultsIterator.hasNext()) {
                        TermConceptMapGroupElementTarget next = (TermConceptMapGroupElementTarget)scrollableResultsIterator.next();
                        if (!matches.add(next)) continue;
                        TranslateConceptResult translationMatch = new TranslateConceptResult();
                        if (next.getEquivalence() != null) {
                            translationMatch.setEquivalence(next.getEquivalence().toCode());
                        }
                        translationMatch.setCode(next.getCode());
                        translationMatch.setSystem(next.getSystem());
                        translationMatch.setSystemVersion(next.getSystemVersion());
                        translationMatch.setDisplay(next.getDisplay());
                        translationMatch.setValueSet(next.getValueSet());
                        translationMatch.setSystemVersion(next.getSystemVersion());
                        translationMatch.setConceptMapUrl(next.getConceptMapUrl());
                        targets.add(translationMatch);
                    }
                }
                ourLastResultsFromTranslationCache = false;
                this.myMemoryCacheService.put(MemoryCacheService.CacheEnum.CONCEPT_TRANSLATION, (Object)translationQuery, targets);
                retVal.getResults().addAll(targets);
                continue;
            }
            ourLastResultsFromTranslationCache = true;
            retVal.getResults().addAll(cachedTargets);
        }
        this.buildTranslationResult(retVal);
        return retVal;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public TranslateConceptResults translateWithReverse(TranslationRequest theTranslationRequest) {
        TranslateConceptResults retVal = new TranslateConceptResults();
        CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(TermConceptMapGroupElement.class);
        Root root = query.from(TermConceptMapGroupElement.class);
        Join targetJoin = root.join("myConceptMapGroupElementTargets");
        Join groupJoin = root.join("myConceptMapGroup");
        Join conceptMapJoin = groupJoin.join("myConceptMap");
        List translationQueries = theTranslationRequest.getTranslationQueries();
        String latestConceptMapVersion = null;
        if (theTranslationRequest.hasUrl() && !theTranslationRequest.hasConceptMapVersion()) {
            latestConceptMapVersion = this.getLatestConceptMapVersion(theTranslationRequest);
        }
        for (TranslationQuery translationQuery : translationQueries) {
            List cachedElements = (List)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.CONCEPT_TRANSLATION_REVERSE, (Object)translationQuery);
            if (cachedElements == null) {
                ArrayList<TranslateConceptResult> elements = new ArrayList<TranslateConceptResult>();
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                Coding coding = translationQuery.getCoding();
                String targetCodeSystem = null;
                if (!coding.hasCode()) {
                    throw new InvalidRequestException(Msg.code((int)843) + "A code must be provided for translation to occur.");
                }
                predicates.add(criteriaBuilder.equal((Expression)targetJoin.get("myCode"), (Object)coding.getCode()));
                String targetCode = coding.getCode();
                if (coding.hasSystem()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("myTarget"), (Object)coding.getSystem()));
                    targetCodeSystem = coding.getSystem();
                }
                if (coding.hasVersion()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("myTargetVersion"), (Object)coding.getVersion()));
                }
                if (translationQuery.hasUrl()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myUrl"), (Object)translationQuery.getUrl()));
                    if (translationQuery.hasConceptMapVersion()) {
                        predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myVersion"), (Object)translationQuery.getConceptMapVersion()));
                    } else if (StringUtils.isNotBlank((CharSequence)latestConceptMapVersion)) {
                        predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myVersion"), (Object)latestConceptMapVersion));
                    } else {
                        predicates.add(criteriaBuilder.isNull((Expression)conceptMapJoin.get("myVersion")));
                    }
                }
                if (translationQuery.hasTargetSystem()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("mySource"), (Object)translationQuery.getTargetSystem()));
                }
                if (translationQuery.hasSource()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myTarget"), (Object)translationQuery.getSource()));
                }
                if (translationQuery.hasTarget()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("mySource"), (Object)translationQuery.getTarget()));
                }
                if (translationQuery.hasResourceId()) {
                    IIdType resourceId = translationQuery.getResourceId();
                    JpaPid resourcePid = (JpaPid)this.myIdHelperService.getPidOrThrowException(RequestPartitionId.defaultPartition(), resourceId);
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myResourcePid"), (Object)resourcePid.getId()));
                }
                Predicate outerPredicate = criteriaBuilder.and(predicates.toArray(new Predicate[0]));
                query.where((Expression)outerPredicate);
                TypedQuery typedQuery = this.myEntityManager.createQuery(query.select((Selection)root));
                Query hibernateQuery = (Query)typedQuery;
                hibernateQuery.setFetchSize(250);
                ScrollableResults scrollableResults = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
                try (ScrollableResultsIterator scrollableResultsIterator = new ScrollableResultsIterator(scrollableResults);){
                    HashSet<TermConceptMapGroupElementTarget> matches = new HashSet<TermConceptMapGroupElementTarget>();
                    while (scrollableResultsIterator.hasNext()) {
                        TermConceptMapGroupElement nextElement = (TermConceptMapGroupElement)scrollableResultsIterator.next();
                        int size = nextElement.getConceptMapGroupElementTargets().size();
                        ourLog.trace("Have {} targets", (Object)size);
                        this.myEntityManager.detach((Object)nextElement);
                        if (!StringUtils.isNotBlank((CharSequence)targetCode)) continue;
                        for (TermConceptMapGroupElementTarget next : nextElement.getConceptMapGroupElementTargets()) {
                            if (!matches.add(next) || !StringUtils.isBlank((CharSequence)targetCodeSystem) && !StringUtils.equals((CharSequence)targetCodeSystem, (CharSequence)next.getSystem()) || !StringUtils.equals((CharSequence)targetCode, (CharSequence)next.getCode())) continue;
                            TranslateConceptResult translationMatch = new TranslateConceptResult();
                            translationMatch.setCode(nextElement.getCode());
                            translationMatch.setSystem(nextElement.getSystem());
                            translationMatch.setSystemVersion(nextElement.getSystemVersion());
                            translationMatch.setDisplay(nextElement.getDisplay());
                            translationMatch.setValueSet(nextElement.getValueSet());
                            translationMatch.setSystemVersion(nextElement.getSystemVersion());
                            translationMatch.setConceptMapUrl(nextElement.getConceptMapUrl());
                            if (next.getEquivalence() != null) {
                                translationMatch.setEquivalence(next.getEquivalence().toCode());
                            }
                            if (this.alreadyContainsMapping(elements, translationMatch) || this.alreadyContainsMapping(retVal.getResults(), translationMatch)) continue;
                            elements.add(translationMatch);
                        }
                    }
                }
                ourLastResultsFromTranslationWithReverseCache = false;
                this.myMemoryCacheService.put(MemoryCacheService.CacheEnum.CONCEPT_TRANSLATION_REVERSE, (Object)translationQuery, elements);
                retVal.getResults().addAll(elements);
                continue;
            }
            ourLastResultsFromTranslationWithReverseCache = true;
            retVal.getResults().addAll(cachedElements);
        }
        this.buildTranslationResult(retVal);
        return retVal;
    }

    public FhirContext getFhirContext() {
        return this.myContext;
    }

    private String getLatestConceptMapVersion(TranslationRequest theTranslationRequest) {
        PageRequest page = PageRequest.of((int)0, (int)1);
        List<TermConceptMap> theConceptMapList = this.myConceptMapDao.getTermConceptMapEntitiesByUrlOrderByMostRecentUpdate((Pageable)page, theTranslationRequest.getUrl());
        if (!theConceptMapList.isEmpty()) {
            return theConceptMapList.get(0).getVersion();
        }
        return null;
    }

    private void buildTranslationResult(TranslateConceptResults theTranslationResult) {
        if (theTranslationResult.getResults().isEmpty()) {
            theTranslationResult.setResult(false);
            String msg = this.myContext.getLocalizer().getMessage(TermConceptMappingSvcImpl.class, "noMatchesFound", new Object[0]);
            theTranslationResult.setMessage(msg);
        } else if (this.isOnlyNegativeMatches(theTranslationResult)) {
            theTranslationResult.setResult(false);
            String msg = this.myContext.getLocalizer().getMessage(TermConceptMappingSvcImpl.class, "onlyNegativeMatchesFound", new Object[0]);
            theTranslationResult.setMessage(msg);
        } else {
            theTranslationResult.setResult(true);
            String msg = this.myContext.getLocalizer().getMessage(TermConceptMappingSvcImpl.class, "matchesFound", new Object[0]);
            theTranslationResult.setMessage(msg);
        }
    }

    private boolean isOnlyNegativeMatches(TranslateConceptResults theTranslationResult) {
        return theTranslationResult.getResults().stream().map(TranslateConceptResult::getEquivalence).allMatch(t -> StringUtils.equals((CharSequence)Enumerations.ConceptMapEquivalence.UNMATCHED.toCode(), (CharSequence)t) || StringUtils.equals((CharSequence)Enumerations.ConceptMapEquivalence.DISJOINT.toCode(), (CharSequence)t));
    }

    private boolean alreadyContainsMapping(List<TranslateConceptResult> elements, TranslateConceptResult translationMatch) {
        for (TranslateConceptResult nextExistingElement : elements) {
            if (!StringUtils.equals((CharSequence)nextExistingElement.getSystem(), (CharSequence)translationMatch.getSystem()) || !StringUtils.equals((CharSequence)nextExistingElement.getSystemVersion(), (CharSequence)translationMatch.getSystemVersion()) || !StringUtils.equals((CharSequence)nextExistingElement.getCode(), (CharSequence)translationMatch.getCode())) continue;
            return true;
        }
        return false;
    }
}

