/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.LookupCodeRequest;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.config.HibernatePropertiesProvider;
import ca.uhn.fhir.jpa.config.util.ConnectionPoolInfoProvider;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IJpaStorageResourceParser;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemDao;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemVersionDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDesignationDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptPropertyDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptDesignationDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptViewDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptViewOracleDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetDao;
import ca.uhn.fhir.jpa.entity.ITermValueSetConceptView;
import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.entity.TermConceptPropertyTypeEnum;
import ca.uhn.fhir.jpa.entity.TermValueSet;
import ca.uhn.fhir.jpa.entity.TermValueSetConcept;
import ca.uhn.fhir.jpa.entity.TermValueSetPreExpansionStatusEnum;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.search.builder.SearchBuilder;
import ca.uhn.fhir.jpa.term.ExpansionFilter;
import ca.uhn.fhir.jpa.term.IValueSetConceptAccumulator;
import ca.uhn.fhir.jpa.term.TermReadSvcUtil;
import ca.uhn.fhir.jpa.term.ValueSetConceptAccumulator;
import ca.uhn.fhir.jpa.term.ValueSetConceptAccumulatorFactory;
import ca.uhn.fhir.jpa.term.ValueSetExpansionComponentWithConceptAccumulator;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.term.api.ReindexTerminologyResult;
import ca.uhn.fhir.jpa.term.ex.ExpansionTooCostlyException;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.FhirVersionIndependentConcept;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.ValidateUtil;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.CacheMode;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.engine.search.query.SearchScrollResult;
import org.hibernate.search.mapper.orm.Search;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingLoggingMonitor;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.context.ConversionContext40_50;
import org.hl7.fhir.convertors.conv40_50.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.resources40_50.ValueSet40_50;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;
import org.hl7.fhir.r5.model.ValueSet;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.comparator.Comparators;

public class TermReadSvcImpl
implements ITermReadSvc,
IHasScheduledJobs {
    public static final int DEFAULT_FETCH_SIZE = 250;
    public static final int DEFAULT_MASS_INDEXER_OBJECT_LOADING_THREADS = 2;
    public static final int MAX_MASS_INDEXER_OBJECT_LOADING_THREADS = 6;
    private static final Logger ourLog = LoggerFactory.getLogger(TermReadSvcImpl.class);
    private static final ValueSetExpansionOptions DEFAULT_EXPANSION_OPTIONS = new ValueSetExpansionOptions();
    private static final TermCodeSystemVersionDetails NO_CURRENT_VERSION = new TermCodeSystemVersionDetails(-1L, null);
    private static final String OUR_PIPE_CHARACTER = "|";
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int INDEXED_ROOTS_LOGGING_COUNT = 50000;
    private static Runnable myInvokeOnNextCallForUnitTest;
    private static boolean ourForceDisableHibernateSearchForUnitTest;
    private final Cache<String, TermCodeSystemVersionDetails> myCodeSystemCurrentVersionCache = CacheFactory.build((long)TimeUnit.MINUTES.toMillis(1L));
    @Autowired
    protected DaoRegistry myDaoRegistry;
    @Autowired
    protected ITermCodeSystemDao myCodeSystemDao;
    @Autowired
    protected ITermConceptDao myConceptDao;
    @Autowired
    protected ITermConceptPropertyDao myConceptPropertyDao;
    @Autowired
    protected ITermConceptDesignationDao myConceptDesignationDao;
    @Autowired
    protected ITermValueSetDao myTermValueSetDao;
    @Autowired
    protected ITermValueSetConceptDao myValueSetConceptDao;
    @Autowired
    protected ITermValueSetConceptDesignationDao myValueSetConceptDesignationDao;
    @Autowired
    protected FhirContext myContext;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    private boolean myPreExpandingValueSets = false;
    @Autowired
    private ITermCodeSystemVersionDao myCodeSystemVersionDao;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    private TransactionTemplate myTxTemplate;
    @Autowired
    private PlatformTransactionManager myTransactionManager;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearchSvc;
    @Autowired
    private PlatformTransactionManager myTxManager;
    @Autowired
    private ITermConceptDao myTermConceptDao;
    @Autowired
    private ITermValueSetConceptViewDao myTermValueSetConceptViewDao;
    @Autowired
    private ITermValueSetConceptViewOracleDao myTermValueSetConceptViewOracleDao;
    @Autowired(required=false)
    private ITermDeferredStorageSvc myDeferredStorageSvc;
    @Autowired
    private IIdHelperService<JpaPid> myIdHelperService;
    @Autowired
    private ApplicationContext myApplicationContext;
    private volatile IValidationSupport myJpaValidationSupport;
    private volatile IValidationSupport myValidationSupport;
    @Autowired
    private HibernatePropertiesProvider myHibernatePropertiesProvider;
    @Autowired
    private CachingValidationSupport myCachingValidationSupport;
    @Autowired
    private VersionCanonicalizer myVersionCanonicalizer;
    @Autowired
    private IJpaStorageResourceParser myJpaStorageResourceParser;
    @Autowired
    private InMemoryTerminologyServerValidationSupport myInMemoryTerminologyServerValidationSupport;
    @Autowired
    private ValueSetConceptAccumulatorFactory myValueSetConceptAccumulatorFactory;

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        if (StringUtils.isBlank((CharSequence)theSystem)) {
            return false;
        }
        TermCodeSystemVersionDetails cs = this.getCurrentCodeSystemVersion(theSystem);
        return cs != null;
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return this.fetchValueSet(theValueSetUrl) != null;
    }

    private boolean addCodeIfNotAlreadyAdded(@Nullable ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, TermConcept theConcept, boolean theAdd, String theValueSetIncludeVersion) {
        String codeSystem = theConcept.getCodeSystemVersion().getCodeSystem().getCodeSystemUri();
        String codeSystemVersion = theConcept.getCodeSystemVersion().getCodeSystemVersionId();
        String code = theConcept.getCode();
        String display = theConcept.getDisplay();
        Long sourceConceptPid = theConcept.getId();
        String directParentPids = "";
        if (theExpansionOptions != null && theExpansionOptions.isIncludeHierarchy()) {
            directParentPids = theConcept.getParents().stream().map(t -> t.getParent().getId().toString()).collect(Collectors.joining(" "));
        }
        Collection<TermConceptDesignation> designations = theConcept.getDesignations();
        if (StringUtils.isNotEmpty((CharSequence)theValueSetIncludeVersion)) {
            return this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, designations, theAdd, codeSystem + OUR_PIPE_CHARACTER + theValueSetIncludeVersion, code, display, sourceConceptPid, directParentPids, codeSystemVersion);
        }
        return this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, designations, theAdd, codeSystem, code, display, sourceConceptPid, directParentPids, codeSystemVersion);
    }

    private boolean addCodeIfNotAlreadyAdded(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, boolean theAdd, String theCodeSystem, String theCodeSystemVersion, String theCode, String theDisplay, Long theSourceConceptPid, String theSourceConceptDirectParentPids, Collection<TermConceptDesignation> theDesignations) {
        if (StringUtils.isNotEmpty((CharSequence)theCodeSystemVersion)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theCodeSystem, theCode})) {
                if (theAdd && theAddedCodes.add(theCodeSystem + OUR_PIPE_CHARACTER + theCode)) {
                    theValueSetCodeAccumulator.includeConceptWithDesignations(theCodeSystem + OUR_PIPE_CHARACTER + theCodeSystemVersion, theCode, theDisplay, theDesignations, theSourceConceptPid, theSourceConceptDirectParentPids, theCodeSystemVersion);
                    return true;
                }
                if (!theAdd && theAddedCodes.remove(theCodeSystem + OUR_PIPE_CHARACTER + theCode)) {
                    theValueSetCodeAccumulator.excludeConcept(theCodeSystem + OUR_PIPE_CHARACTER + theCodeSystemVersion, theCode);
                    return true;
                }
            }
        } else {
            if (theAdd && theAddedCodes.add(theCodeSystem + OUR_PIPE_CHARACTER + theCode)) {
                theValueSetCodeAccumulator.includeConceptWithDesignations(theCodeSystem, theCode, theDisplay, theDesignations, theSourceConceptPid, theSourceConceptDirectParentPids, theCodeSystemVersion);
                return true;
            }
            if (!theAdd && theAddedCodes.remove(theCodeSystem + OUR_PIPE_CHARACTER + theCode)) {
                theValueSetCodeAccumulator.excludeConcept(theCodeSystem, theCode);
                return true;
            }
        }
        return false;
    }

    private boolean addCodeIfNotAlreadyAdded(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, Collection<TermConceptDesignation> theDesignations, boolean theAdd, String theCodeSystem, String theCode, String theDisplay, Long theSourceConceptPid, String theSourceConceptDirectParentPids, String theSystemVersion) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theCodeSystem, theCode})) {
            if (theAdd && theAddedCodes.add(theCodeSystem + OUR_PIPE_CHARACTER + theCode)) {
                theValueSetCodeAccumulator.includeConceptWithDesignations(theCodeSystem, theCode, theDisplay, theDesignations, theSourceConceptPid, theSourceConceptDirectParentPids, theSystemVersion);
                return true;
            }
            if (!theAdd && theAddedCodes.remove(theCodeSystem + OUR_PIPE_CHARACTER + theCode)) {
                theValueSetCodeAccumulator.excludeConcept(theCodeSystem, theCode);
                return true;
            }
        }
        return false;
    }

    private boolean addToSet(Set<TermConcept> theSetToPopulate, TermConcept theConcept) {
        boolean retVal = theSetToPopulate.add(theConcept);
        if (retVal && theSetToPopulate.size() >= this.myStorageSettings.getMaximumExpansionSize()) {
            String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "expansionTooLarge", new Object[]{this.myStorageSettings.getMaximumExpansionSize()});
            throw new ExpansionTooCostlyException(Msg.code((int)885) + msg);
        }
        return retVal;
    }

    @VisibleForTesting
    public void clearCaches() {
        this.myCodeSystemCurrentVersionCache.invalidateAll();
    }

    public void deleteValueSetForResource(ResourceTable theResourceTable) {
        Optional<TermValueSet> optionalExistingTermValueSetById = this.myTermValueSetDao.findByResourcePid(theResourceTable.getId());
        if (optionalExistingTermValueSetById.isPresent()) {
            TermValueSet existingTermValueSet = optionalExistingTermValueSetById.get();
            ourLog.info("Deleting existing TermValueSet[{}] and its children...", (Object)existingTermValueSet.getId());
            this.deletePreCalculatedValueSetContents(existingTermValueSet);
            this.myTermValueSetDao.deleteById(existingTermValueSet.getId());
            ourLog.info("Done deleting existing TermValueSet[{}] and its children.", (Object)existingTermValueSet.getId());
        }
    }

    private void deletePreCalculatedValueSetContents(TermValueSet theValueSet) {
        this.myValueSetConceptDesignationDao.deleteByTermValueSetId(theValueSet.getId());
        this.myValueSetConceptDao.deleteByTermValueSetId(theValueSet.getId());
    }

    @Override
    @Transactional
    public void deleteValueSetAndChildren(ResourceTable theResourceTable) {
        this.deleteValueSetForResource(theResourceTable);
    }

    @Override
    @Transactional
    public List<FhirVersionIndependentConcept> expandValueSetIntoConceptList(@Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull String theValueSetCanonicalUrl) {
        org.hl7.fhir.r4.model.ValueSet expanded = this.expandValueSet(theExpansionOptions, theValueSetCanonicalUrl);
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        for (ValueSet.ValueSetExpansionContainsComponent nextContains : expanded.getExpansion().getContains()) {
            retVal.add(new FhirVersionIndependentConcept(nextContains.getSystem(), nextContains.getCode(), nextContains.getDisplay(), nextContains.getVersion()));
        }
        return retVal;
    }

    @Override
    public org.hl7.fhir.r4.model.ValueSet expandValueSet(@Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull String theValueSetCanonicalUrl) {
        org.hl7.fhir.r4.model.ValueSet valueSet = this.fetchCanonicalValueSetFromCompleteContext(theValueSetCanonicalUrl);
        if (valueSet == null) {
            throw new ResourceNotFoundException(Msg.code((int)886) + "Unknown ValueSet: " + UrlUtil.escapeUrlParam((String)theValueSetCanonicalUrl));
        }
        return this.expandValueSet(theExpansionOptions, valueSet);
    }

    @Override
    public org.hl7.fhir.r4.model.ValueSet expandValueSet(@Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull org.hl7.fhir.r4.model.ValueSet theValueSetToExpand) {
        String filter = null;
        if (theExpansionOptions != null) {
            filter = theExpansionOptions.getFilter();
        }
        return this.doExpandValueSet(theExpansionOptions, theValueSetToExpand, ExpansionFilter.fromFilterString(filter));
    }

    private org.hl7.fhir.r4.model.ValueSet doExpandValueSet(@Nullable ValueSetExpansionOptions theExpansionOptions, org.hl7.fhir.r4.model.ValueSet theValueSetToExpand, ExpansionFilter theFilter) {
        HashSet addedCodes = new HashSet();
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSetToExpand, (String)"ValueSet to expand can not be null", (Object[])new Object[0]);
        ValueSetExpansionOptions expansionOptions = this.provideExpansionOptions(theExpansionOptions);
        int offset = expansionOptions.getOffset();
        int count = expansionOptions.getCount();
        ValueSetExpansionComponentWithConceptAccumulator accumulator = new ValueSetExpansionComponentWithConceptAccumulator(this.myContext, count, expansionOptions.isIncludeHierarchy());
        accumulator.setHardExpansionMaximumSize(this.myStorageSettings.getMaximumExpansionSize());
        accumulator.setSkipCountRemaining(offset);
        accumulator.setIdentifier(UUID.randomUUID().toString());
        accumulator.setTimestamp(new Date());
        accumulator.setOffset(offset);
        if (theExpansionOptions != null && this.isHibernateSearchEnabled()) {
            accumulator.addParameter().setName("offset").setValue((Type)new IntegerType(offset));
            accumulator.addParameter().setName("count").setValue((Type)new IntegerType(count));
        }
        this.myTxTemplate.executeWithoutResult(tx -> this.expandValueSetIntoAccumulator(theValueSetToExpand, theExpansionOptions, accumulator, theFilter, true, addedCodes));
        if (accumulator.getTotalConcepts() != null) {
            accumulator.setTotal(accumulator.getTotalConcepts());
        }
        org.hl7.fhir.r4.model.ValueSet valueSet = new org.hl7.fhir.r4.model.ValueSet();
        valueSet.setUrl(theValueSetToExpand.getUrl());
        valueSet.setId(theValueSetToExpand.getId());
        valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
        valueSet.setCompose(theValueSetToExpand.getCompose());
        valueSet.setExpansion((ValueSet.ValueSetExpansionComponent)accumulator);
        for (String next : accumulator.getMessages()) {
            valueSet.getMeta().addExtension().setUrl("http://hapifhir.io/fhir/StructureDefinition/valueset-expansion-message").setValue((Type)new StringType(next));
        }
        if (expansionOptions.isIncludeHierarchy()) {
            accumulator.applyHierarchy();
        }
        return valueSet;
    }

    private void expandValueSetIntoAccumulator(org.hl7.fhir.r4.model.ValueSet theValueSetToExpand, ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theAccumulator, ExpansionFilter theFilter, boolean theAdd, Set<String> theAddedCodes) {
        Optional<Object> optionalTermValueSet = theValueSetToExpand.hasUrl() ? (theValueSetToExpand.hasVersion() ? this.myTermValueSetDao.findTermValueSetByUrlAndVersion(theValueSetToExpand.getUrl(), theValueSetToExpand.getVersion()) : this.findCurrentTermValueSet(theValueSetToExpand.getUrl())) : Optional.empty();
        if (optionalTermValueSet.isEmpty()) {
            ourLog.debug("ValueSet is not present in terminology tables. Will perform in-memory expansion without parameters. {}", (Object)this.getValueSetInfo(theValueSetToExpand));
            String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "valueSetExpandedUsingInMemoryExpansion", new Object[]{this.getValueSetInfo(theValueSetToExpand)});
            theAccumulator.addMessage(msg);
            this.doExpandValueSet(theExpansionOptions, theValueSetToExpand, theAccumulator, theFilter, theAddedCodes);
            return;
        }
        TermValueSet termValueSet = (TermValueSet)optionalTermValueSet.get();
        if (termValueSet.getExpansionStatus() != TermValueSetPreExpansionStatusEnum.EXPANDED) {
            String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "valueSetNotYetExpanded", new Object[]{this.getValueSetInfo(theValueSetToExpand), termValueSet.getExpansionStatus().name(), termValueSet.getExpansionStatus().getDescription()});
            theAccumulator.addMessage(msg);
            this.doExpandValueSet(theExpansionOptions, theValueSetToExpand, theAccumulator, theFilter, theAddedCodes);
            return;
        }
        String expansionTimestamp = this.toHumanReadableExpansionTimestamp(termValueSet);
        String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "valueSetExpandedUsingPreExpansion", new Object[]{expansionTimestamp});
        theAccumulator.addMessage(msg);
        this.expandConcepts(theExpansionOptions, theAccumulator, termValueSet, theFilter, theAdd, theAddedCodes, this.myHibernatePropertiesProvider.isOracleDialect());
    }

    @Nonnull
    private String toHumanReadableExpansionTimestamp(TermValueSet termValueSet) {
        Object expansionTimestamp = "(unknown)";
        if (termValueSet.getExpansionTimestamp() != null) {
            String timeElapsed = StopWatch.formatMillis((long)(System.currentTimeMillis() - termValueSet.getExpansionTimestamp().getTime()));
            expansionTimestamp = new InstantType(termValueSet.getExpansionTimestamp()).getValueAsString() + " (" + timeElapsed + " ago)";
        }
        return expansionTimestamp;
    }

    private void expandConcepts(ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theAccumulator, TermValueSet theTermValueSet, ExpansionFilter theFilter, boolean theAdd, Set<String> theAddedCodes, boolean theOracle) {
        List<Serializable> conceptViews;
        Integer offset = theAccumulator.getSkipCountRemaining();
        offset = (Integer)ObjectUtils.defaultIfNull((Object)offset, (Object)0);
        offset = Math.min(offset, theTermValueSet.getTotalConcepts().intValue());
        Integer count = theAccumulator.getCapacityRemaining();
        count = (Integer)ObjectUtils.defaultIfNull((Object)count, (Object)this.myStorageSettings.getMaximumExpansionSize());
        int conceptsExpanded = 0;
        int designationsExpanded = 0;
        int toIndex = offset + count;
        boolean wasFilteredResult = false;
        String filterDisplayValue = null;
        if (!theFilter.getFilters().isEmpty() && "display".equals(theFilter.getFilters().get(0).getProperty()) && theFilter.getFilters().get(0).getOp() == ValueSet.FilterOperator.EQUAL) {
            filterDisplayValue = StringUtils.lowerCase((String)theFilter.getFilters().get(0).getValue().replace("%", "[%]"));
            String displayValue = "%" + StringUtils.lowerCase((String)filterDisplayValue) + "%";
            conceptViews = theOracle ? this.myTermValueSetConceptViewOracleDao.findByTermValueSetId(theTermValueSet.getId(), displayValue) : this.myTermValueSetConceptViewDao.findByTermValueSetId(theTermValueSet.getId(), displayValue);
            wasFilteredResult = true;
        } else {
            conceptViews = theOracle ? this.myTermValueSetConceptViewOracleDao.findByTermValueSetId(offset, toIndex, theTermValueSet.getId()) : this.myTermValueSetConceptViewDao.findByTermValueSetId(offset, toIndex, theTermValueSet.getId());
            theAccumulator.consumeSkipCount(offset);
            if (theAdd) {
                theAccumulator.incrementOrDecrementTotalConcepts(true, theTermValueSet.getTotalConcepts().intValue());
            }
        }
        if (conceptViews.isEmpty()) {
            this.logConceptsExpanded("No concepts to expand. ", theTermValueSet, conceptsExpanded);
            return;
        }
        LinkedHashMap<Long, FhirVersionIndependentConcept> pidToConcept = new LinkedHashMap<Long, FhirVersionIndependentConcept>();
        ArrayListMultimap pidToDesignations = ArrayListMultimap.create();
        HashMap<Long, Long> pidToSourcePid = new HashMap<Long, Long>();
        HashMap<Long, String> pidToSourceDirectParentPids = new HashMap<Long, String>();
        for (ITermValueSetConceptView iTermValueSetConceptView : conceptViews) {
            String system = iTermValueSetConceptView.getConceptSystemUrl();
            String code = iTermValueSetConceptView.getConceptCode();
            String display = iTermValueSetConceptView.getConceptDisplay();
            String systemVersion = iTermValueSetConceptView.getConceptSystemVersion();
            if (!this.applyFilter(display, filterDisplayValue)) continue;
            Long conceptPid = iTermValueSetConceptView.getConceptPid();
            if (!pidToConcept.containsKey(conceptPid)) {
                FhirVersionIndependentConcept concept = new FhirVersionIndependentConcept(system, code, display, systemVersion);
                pidToConcept.put(conceptPid, concept);
            }
            if (iTermValueSetConceptView.getDesignationPid() != null) {
                TermConceptDesignation designation = new TermConceptDesignation();
                if (TermReadSvcImpl.isValueSetDisplayLanguageMatch(theExpansionOptions, iTermValueSetConceptView.getDesignationLang())) {
                    designation.setUseSystem(iTermValueSetConceptView.getDesignationUseSystem());
                    designation.setUseCode(iTermValueSetConceptView.getDesignationUseCode());
                    designation.setUseDisplay(iTermValueSetConceptView.getDesignationUseDisplay());
                    designation.setValue(iTermValueSetConceptView.getDesignationVal());
                    designation.setLanguage(iTermValueSetConceptView.getDesignationLang());
                    pidToDesignations.put((Object)conceptPid, (Object)designation);
                }
                if (++designationsExpanded % 250 == 0) {
                    this.logDesignationsExpanded("Expansion of designations in progress. ", theTermValueSet, designationsExpanded);
                }
            }
            if (theAccumulator.isTrackingHierarchy()) {
                pidToSourcePid.put(conceptPid, iTermValueSetConceptView.getSourceConceptPid());
                pidToSourceDirectParentPids.put(conceptPid, iTermValueSetConceptView.getSourceConceptDirectParentPids());
            }
            if (++conceptsExpanded % 250 != 0) continue;
            this.logConceptsExpanded("Expansion of concepts in progress. ", theTermValueSet, conceptsExpanded);
        }
        for (Long l : pidToConcept.keySet()) {
            FhirVersionIndependentConcept concept = (FhirVersionIndependentConcept)pidToConcept.get(l);
            List designations = pidToDesignations.get((Object)l);
            String system = concept.getSystem();
            String code = concept.getCode();
            String display = concept.getDisplay();
            String systemVersion = concept.getSystemVersion();
            if (theAdd) {
                if (theAccumulator.getCapacityRemaining() != null && theAccumulator.getCapacityRemaining() == 0) break;
                Long sourceConceptPid = (Long)pidToSourcePid.get(l);
                String sourceConceptDirectParentPids = (String)pidToSourceDirectParentPids.get(l);
                if (!theAddedCodes.add(system + OUR_PIPE_CHARACTER + code)) continue;
                theAccumulator.includeConceptWithDesignations(system, code, display, designations, sourceConceptPid, sourceConceptDirectParentPids, systemVersion);
                if (!wasFilteredResult) continue;
                theAccumulator.incrementOrDecrementTotalConcepts(true, 1);
                continue;
            }
            if (!theAddedCodes.remove(system + OUR_PIPE_CHARACTER + code)) continue;
            theAccumulator.excludeConcept(system, code);
            theAccumulator.incrementOrDecrementTotalConcepts(false, 1);
        }
        this.logDesignationsExpanded("Finished expanding designations. ", theTermValueSet, designationsExpanded);
        this.logConceptsExpanded("Finished expanding concepts. ", theTermValueSet, conceptsExpanded);
    }

    private void logConceptsExpanded(String theLogDescriptionPrefix, TermValueSet theTermValueSet, int theConceptsExpanded) {
        if (theConceptsExpanded > 0) {
            ourLog.debug("{}Have expanded {} concepts in ValueSet[{}]", new Object[]{theLogDescriptionPrefix, theConceptsExpanded, theTermValueSet.getUrl()});
        }
    }

    private void logDesignationsExpanded(String theLogDescriptionPrefix, TermValueSet theTermValueSet, int theDesignationsExpanded) {
        if (theDesignationsExpanded > 0) {
            ourLog.debug("{}Have expanded {} designations in ValueSet[{}]", new Object[]{theLogDescriptionPrefix, theDesignationsExpanded, theTermValueSet.getUrl()});
        }
    }

    public boolean applyFilter(String theDisplay, String theFilterDisplay) {
        if (theDisplay == null || theFilterDisplay == null) {
            return true;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)theDisplay, (CharSequence)theFilterDisplay)) {
            return true;
        }
        return this.startsWithByWordBoundaries(theDisplay, theFilterDisplay);
    }

    private boolean startsWithByWordBoundaries(String theDisplay, String theFilterDisplay) {
        StringTokenizer tok = new StringTokenizer(theDisplay);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)theFilterDisplay)) {
                return true;
            }
            tokens.add(token);
        }
        for (int start = 0; start <= tokens.size() - 1; ++start) {
            for (int end = start + 1; end <= tokens.size(); ++end) {
                String sublist = String.join((CharSequence)" ", tokens.subList(start, end));
                if (!StringUtils.startsWithIgnoreCase((CharSequence)sublist, (CharSequence)theFilterDisplay)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void expandValueSet(ValueSetExpansionOptions theExpansionOptions, org.hl7.fhir.r4.model.ValueSet theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator) {
        HashSet<String> addedCodes = new HashSet<String>();
        this.doExpandValueSet(theExpansionOptions, theValueSetToExpand, theValueSetCodeAccumulator, ExpansionFilter.NO_FILTER, addedCodes);
    }

    private void doExpandValueSet(ValueSetExpansionOptions theExpansionOptions, org.hl7.fhir.r4.model.ValueSet theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator, @Nonnull ExpansionFilter theExpansionFilter, Set<String> theAddedCodes) {
        StopWatch sw = new StopWatch();
        String valueSetInfo = this.getValueSetInfo(theValueSetToExpand);
        ourLog.debug("Working with {}", (Object)valueSetInfo);
        Integer skipCountRemaining = theValueSetCodeAccumulator.getSkipCountRemaining();
        if (skipCountRemaining != null && skipCountRemaining > 0 && !theValueSetToExpand.getCompose().getExclude().isEmpty()) {
            String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "valueSetNotYetExpanded_OffsetNotAllowed", new Object[]{valueSetInfo});
            throw new InvalidRequestException(Msg.code((int)887) + msg);
        }
        ourLog.debug("Handling includes");
        for (ValueSet.ConceptSetComponent include : theValueSetToExpand.getCompose().getInclude()) {
            this.myTxTemplate.executeWithoutResult(tx -> this.expandValueSetHandleIncludeOrExclude(theExpansionOptions, theValueSetCodeAccumulator, theAddedCodes, include, true, theExpansionFilter));
        }
        ourLog.debug("Handling excludes");
        for (ValueSet.ConceptSetComponent exclude : theValueSetToExpand.getCompose().getExclude()) {
            this.myTxTemplate.executeWithoutResult(tx -> this.expandValueSetHandleIncludeOrExclude(theExpansionOptions, theValueSetCodeAccumulator, theAddedCodes, exclude, false, ExpansionFilter.NO_FILTER));
        }
        if (theValueSetCodeAccumulator instanceof ValueSetConceptAccumulator) {
            this.myTxTemplate.execute(t -> ((ValueSetConceptAccumulator)theValueSetCodeAccumulator).removeGapsFromConceptOrder());
        }
        ourLog.debug("Done working with {} in {}ms", (Object)valueSetInfo, (Object)sw.getMillis());
    }

    private String getValueSetInfo(org.hl7.fhir.r4.model.ValueSet theValueSet) {
        StringBuilder sb = new StringBuilder();
        boolean isIdentified = false;
        if (theValueSet.hasUrl()) {
            isIdentified = true;
            sb.append("ValueSet.url[").append(theValueSet.getUrl()).append("]");
        } else if (theValueSet.hasId()) {
            isIdentified = true;
            sb.append("ValueSet.id[").append(theValueSet.getId()).append("]");
        }
        if (!isIdentified) {
            sb.append("Unidentified ValueSet");
        }
        return sb.toString();
    }

    private void expandValueSetHandleIncludeOrExclude(@Nullable ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, ValueSet.ConceptSetComponent theIncludeOrExclude, boolean theAdd, @Nonnull ExpansionFilter theExpansionFilter) {
        boolean hasValueSet;
        String system = theIncludeOrExclude.getSystem();
        boolean hasSystem = StringUtils.isNotBlank((CharSequence)system);
        boolean bl = hasValueSet = !theIncludeOrExclude.getValueSet().isEmpty();
        if (hasSystem) {
            if (theExpansionFilter.hasCode() && theExpansionFilter.getSystem() != null && !system.equals(theExpansionFilter.getSystem())) {
                return;
            }
            ourLog.debug("Starting {} expansion around CodeSystem: {}", (Object)(theAdd ? "inclusion" : "exclusion"), (Object)system);
            Optional<TermCodeSystemVersion> termCodeSystemVersion = this.optionalFindTermCodeSystemVersion(theIncludeOrExclude);
            if (termCodeSystemVersion.isPresent()) {
                this.expandValueSetHandleIncludeOrExcludeUsingDatabase(theExpansionOptions, theValueSetCodeAccumulator, theAddedCodes, theIncludeOrExclude, theAdd, theExpansionFilter, system, termCodeSystemVersion.get());
            } else {
                if (!theIncludeOrExclude.getConcept().isEmpty() && theExpansionFilter.hasCode() && StringUtils.defaultString((String)theIncludeOrExclude.getSystem()).equals(theExpansionFilter.getSystem()) && theIncludeOrExclude.getConcept().stream().noneMatch(t -> t.getCode().equals(theExpansionFilter.getCode()))) {
                    return;
                }
                Consumer<FhirVersionIndependentConcept> consumer = c -> this.addOrRemoveCode(theValueSetCodeAccumulator, theAddedCodes, theAdd, system, c.getCode(), c.getDisplay(), c.getSystemVersion());
                try {
                    ConversionContext40_50.INSTANCE.init(new VersionConvertor_40_50(new BaseAdvisor_40_50()), "ValueSet");
                    ValueSet.ConceptSetComponent includeOrExclude = ValueSet40_50.convertConceptSetComponent((ValueSet.ConceptSetComponent)theIncludeOrExclude);
                    this.myInMemoryTerminologyServerValidationSupport.expandValueSetIncludeOrExclude(new ValidationSupportContext(this.provideValidationSupport()), consumer, includeOrExclude);
                }
                catch (InMemoryTerminologyServerValidationSupport.ExpansionCouldNotBeCompletedInternallyException e) {
                    if (theExpansionOptions != null && !theExpansionOptions.isFailOnMissingCodeSystem() && e.getCodeValidationIssue().getCoding() == IValidationSupport.CodeValidationIssueCoding.NOT_FOUND) {
                        return;
                    }
                    throw new InternalErrorException(Msg.code((int)888) + e);
                }
                finally {
                    ConversionContext40_50.INSTANCE.close("ValueSet");
                }
            }
        } else if (hasValueSet) {
            for (CanonicalType nextValueSet : theIncludeOrExclude.getValueSet()) {
                String valueSetUrl = nextValueSet.getValueAsString();
                ourLog.debug("Starting {} expansion around ValueSet: {}", (Object)(theAdd ? "inclusion" : "exclusion"), (Object)valueSetUrl);
                ExpansionFilter subExpansionFilter = new ExpansionFilter(theExpansionFilter, theIncludeOrExclude.getFilter(), theValueSetCodeAccumulator.getCapacityRemaining());
                org.hl7.fhir.r4.model.ValueSet valueSet = this.fetchCanonicalValueSetFromCompleteContext(valueSetUrl);
                if (valueSet == null) {
                    throw new ResourceNotFoundException(Msg.code((int)889) + "Unknown ValueSet: " + UrlUtil.escapeUrlParam((String)valueSetUrl));
                }
                this.expandValueSetIntoAccumulator(valueSet, theExpansionOptions, theValueSetCodeAccumulator, subExpansionFilter, theAdd, theAddedCodes);
            }
        } else {
            throw new InvalidRequestException(Msg.code((int)890) + "ValueSet contains " + (theAdd ? "include" : "exclude") + " criteria with no system defined");
        }
    }

    private Optional<TermCodeSystemVersion> optionalFindTermCodeSystemVersion(ValueSet.ConceptSetComponent theIncludeOrExclude) {
        if (StringUtils.isEmpty((CharSequence)theIncludeOrExclude.getVersion())) {
            return Optional.ofNullable(this.myCodeSystemDao.findByCodeSystemUri(theIncludeOrExclude.getSystem())).map(TermCodeSystem::getCurrentVersion);
        }
        return Optional.ofNullable(this.myCodeSystemVersionDao.findByCodeSystemUriAndVersion(theIncludeOrExclude.getSystem(), theIncludeOrExclude.getVersion()));
    }

    private boolean isHibernateSearchEnabled() {
        return this.myFulltextSearchSvc != null && !ourForceDisableHibernateSearchForUnitTest;
    }

    private void expandValueSetHandleIncludeOrExcludeUsingDatabase(ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, ValueSet.ConceptSetComponent theIncludeOrExclude, boolean theAdd, @Nonnull ExpansionFilter theExpansionFilter, String theSystem, TermCodeSystemVersion theTermCodeSystemVersion) {
        StopWatch fullOperationSw = new StopWatch();
        String includeOrExcludeVersion = theIncludeOrExclude.getVersion();
        if (!this.isHibernateSearchEnabled()) {
            this.expandWithoutHibernateSearch(theValueSetCodeAccumulator, theTermCodeSystemVersion, theAddedCodes, theIncludeOrExclude, theSystem, theAdd);
            return;
        }
        int count = 0;
        Optional<Integer> chunkSizeOpt = this.getScrollChunkSize(theAdd, theValueSetCodeAccumulator);
        if (chunkSizeOpt.isEmpty()) {
            return;
        }
        int chunkSize = chunkSizeOpt.get();
        SearchProperties searchProps = this.buildSearchScrolls(theTermCodeSystemVersion, theExpansionFilter, theSystem, theIncludeOrExclude, chunkSize, includeOrExcludeVersion);
        int accumulatedBatchesSoFar = 0;
        for (Supplier<SearchScroll<EntityReference>> next : searchProps.getSearchScroll()) {
            SearchScroll<EntityReference> scroll = next.get();
            try {
                ourLog.debug("Beginning batch expansion for {} with max results per batch: {}", (Object)(theAdd ? "inclusion" : "exclusion"), (Object)chunkSize);
                SearchScrollResult chunk = scroll.next();
                while (chunk.hasHits()) {
                    int countForBatch = 0;
                    List<Long> pids = chunk.hits().stream().map(t -> (Long)t.id()).collect(Collectors.toList());
                    List<TermConcept> termConcepts = this.myTermConceptDao.fetchConceptsAndDesignationsByPid(pids);
                    termConcepts = this.sortTermConcepts(searchProps, termConcepts);
                    int delta = 0;
                    for (TermConcept concept : termConcepts) {
                        boolean added;
                        ValueSet.ConceptReferenceComponent theIncludeConcept;
                        ++count;
                        ++countForBatch;
                        if (theAdd && searchProps.hasIncludeOrExcludeCodes() && (theIncludeConcept = this.getMatchedConceptIncludedInValueSet(theIncludeOrExclude, concept)) != null && StringUtils.isNotBlank((CharSequence)theIncludeConcept.getDisplay())) {
                            concept.setDisplay(theIncludeConcept.getDisplay());
                        }
                        if (!(added = this.addCodeIfNotAlreadyAdded(theExpansionOptions, theValueSetCodeAccumulator, theAddedCodes, concept, theAdd, includeOrExcludeVersion))) continue;
                        ++delta;
                    }
                    ourLog.debug("Batch expansion scroll for {} with offset {} produced {} results in {}ms", new Object[]{theAdd ? "inclusion" : "exclusion", accumulatedBatchesSoFar, chunk.hits().size(), chunk.took().toMillis()});
                    theValueSetCodeAccumulator.incrementOrDecrementTotalConcepts(theAdd, delta);
                    accumulatedBatchesSoFar += countForBatch;
                    this.myEntityManager.flush();
                    this.myEntityManager.clear();
                    chunk = scroll.next();
                }
                ourLog.debug("Expansion for {} produced {} results in {}ms", new Object[]{theAdd ? "inclusion" : "exclusion", count, fullOperationSw.getMillis()});
            }
            finally {
                if (scroll == null) continue;
                scroll.close();
            }
        }
    }

    private List<TermConcept> sortTermConcepts(SearchProperties searchProps, List<TermConcept> termConcepts) {
        List<String> codes = searchProps.getIncludeOrExcludeCodes();
        if (codes.size() > 1) {
            termConcepts = new ArrayList<TermConcept>(termConcepts);
            HashMap<String, Integer> codeToIndex = new HashMap<String, Integer>(codes.size());
            for (int i = 0; i < codes.size(); ++i) {
                codeToIndex.put(codes.get(i), i);
            }
            termConcepts.sort((o1, o2) -> {
                Integer idx1 = (Integer)codeToIndex.get(o1.getCode());
                Integer idx2 = (Integer)codeToIndex.get(o2.getCode());
                return Comparators.nullsHigh().compare(idx1, idx2);
            });
        }
        return termConcepts;
    }

    private Optional<Integer> getScrollChunkSize(boolean theAdd, IValueSetConceptAccumulator theValueSetCodeAccumulator) {
        Integer accumulatorCapacityRemaining;
        int maxResultsPerBatch = SearchBuilder.getMaximumPageSize();
        if (theAdd && (accumulatorCapacityRemaining = theValueSetCodeAccumulator.getCapacityRemaining()) != null) {
            maxResultsPerBatch = Math.min(maxResultsPerBatch, accumulatorCapacityRemaining + 1);
        }
        return maxResultsPerBatch > 0 ? Optional.of(maxResultsPerBatch) : Optional.empty();
    }

    private SearchProperties buildSearchScrolls(TermCodeSystemVersion theTermCodeSystemVersion, ExpansionFilter theExpansionFilter, String theSystem, ValueSet.ConceptSetComponent theIncludeOrExclude, Integer theScrollChunkSize, String theIncludeOrExcludeVersion) {
        SearchSession searchSession = Search.session((EntityManager)this.myEntityManager);
        SearchPredicateFactory predicate = searchSession.scope(TermConcept.class).predicate();
        List<String> allCodes = theIncludeOrExclude.getConcept().stream().filter(Objects::nonNull).map(ValueSet.ConceptReferenceComponent::getCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        SearchProperties returnProps = new SearchProperties();
        returnProps.setIncludeOrExcludeCodes(allCodes);
        List partitionedCodes = ListUtils.partition(allCodes, (int)(IndexSearcher.getMaxClauseCount() - 10));
        if (partitionedCodes.isEmpty()) {
            partitionedCodes = List.of(List.of());
        }
        for (List list : partitionedCodes) {
            Supplier<SearchScroll<EntityReference>> nextScroll = () -> {
                PredicateFinalStep finishedQuery;
                PredicateFinalStep step = predicate.bool(b -> {
                    b.must((PredicateFinalStep)predicate.match().field("myCodeSystemVersionPid").matching((Object)theTermCodeSystemVersion.getPid()));
                    if (theExpansionFilter.hasCode()) {
                        b.must((PredicateFinalStep)predicate.match().field("myCode").matching((Object)theExpansionFilter.getCode()));
                    }
                    String codeSystemUrlAndVersion = this.buildCodeSystemUrlAndVersion(theSystem, theIncludeOrExcludeVersion);
                    for (ValueSet.ConceptSetFilterComponent nextFilter : theIncludeOrExclude.getFilter()) {
                        this.handleFilter(codeSystemUrlAndVersion, predicate, (BooleanPredicateClausesStep<?>)b, nextFilter);
                    }
                    for (ValueSet.ConceptSetFilterComponent nextFilter : theExpansionFilter.getFilters()) {
                        this.handleFilter(codeSystemUrlAndVersion, predicate, (BooleanPredicateClausesStep<?>)b, nextFilter);
                    }
                });
                if (nextCodePartition.isEmpty()) {
                    finishedQuery = step;
                } else {
                    PredicateFinalStep expansionStep = this.buildExpansionPredicate(nextCodePartition, predicate);
                    finishedQuery = (PredicateFinalStep)((BooleanPredicateClausesStep)predicate.bool().must(step)).must(expansionStep);
                }
                SearchQuery termConceptsQuery = searchSession.search(TermConcept.class).selectEntityReference().where(f -> finishedQuery).toQuery();
                return termConceptsQuery.scroll(theScrollChunkSize.intValue());
            };
            returnProps.addSearchScroll(nextScroll);
        }
        return returnProps;
    }

    private ValueSet.ConceptReferenceComponent getMatchedConceptIncludedInValueSet(ValueSet.ConceptSetComponent theIncludeOrExclude, TermConcept concept) {
        return theIncludeOrExclude.getConcept().stream().filter(includedConcept -> includedConcept.getCode().equalsIgnoreCase(concept.getCode())).findFirst().orElse(null);
    }

    private PredicateFinalStep buildExpansionPredicate(List<String> theCodes, SearchPredicateFactory thePredicate) {
        assert (!theCodes.isEmpty());
        return thePredicate.simpleQueryString().field("myCode").matching(String.join((CharSequence)" | ", theCodes));
    }

    private String buildCodeSystemUrlAndVersion(String theSystem, String theIncludeOrExcludeVersion) {
        Object codeSystemUrlAndVersion = theIncludeOrExcludeVersion != null ? theSystem + OUR_PIPE_CHARACTER + theIncludeOrExcludeVersion : theSystem;
        return codeSystemUrlAndVersion;
    }

    @Nonnull
    private ValueSetExpansionOptions provideExpansionOptions(@Nullable ValueSetExpansionOptions theExpansionOptions) {
        return Objects.requireNonNullElse(theExpansionOptions, DEFAULT_EXPANSION_OPTIONS);
    }

    private void addOrRemoveCode(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, boolean theAdd, String theSystem, String theCode, String theDisplay, String theSystemVersion) {
        if (theAdd && theAddedCodes.add(theSystem + OUR_PIPE_CHARACTER + theCode)) {
            theValueSetCodeAccumulator.includeConcept(theSystem, theCode, theDisplay, null, null, theSystemVersion);
        }
        if (!theAdd && theAddedCodes.remove(theSystem + OUR_PIPE_CHARACTER + theCode)) {
            theValueSetCodeAccumulator.excludeConcept(theSystem, theCode);
        }
    }

    private void handleFilter(String theCodeSystemIdentifier, SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB, ValueSet.ConceptSetFilterComponent theFilter) {
        if (StringUtils.isBlank((CharSequence)theFilter.getValue()) && theFilter.getOp() == null && StringUtils.isBlank((CharSequence)theFilter.getProperty())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)theFilter.getValue()) && theFilter.getOp() != ValueSet.FilterOperator.EXISTS || theFilter.getOp() == null || StringUtils.isBlank((CharSequence)theFilter.getProperty())) {
            throw new InvalidRequestException(Msg.code((int)891) + "Invalid filter, must have fields populated: property op value");
        }
        switch (theFilter.getProperty()) {
            case "display:exact": 
            case "display": {
                this.handleFilterDisplay(theF, theB, theFilter);
                break;
            }
            case "concept": 
            case "code": {
                this.handleFilterConceptAndCode(theCodeSystemIdentifier, theF, theB, theFilter);
                break;
            }
            case "parent": 
            case "child": {
                this.isCodeSystemLoincOrThrowInvalidRequestException(theCodeSystemIdentifier, theFilter.getProperty());
                this.handleFilterLoincParentChild(theF, theB, theFilter);
                break;
            }
            case "ancestor": {
                this.isCodeSystemLoincOrThrowInvalidRequestException(theCodeSystemIdentifier, theFilter.getProperty());
                this.handleFilterLoincAncestor(theCodeSystemIdentifier, theF, theB, theFilter);
                break;
            }
            case "descendant": {
                this.isCodeSystemLoincOrThrowInvalidRequestException(theCodeSystemIdentifier, theFilter.getProperty());
                this.handleFilterLoincDescendant(theCodeSystemIdentifier, theF, theB, theFilter);
                break;
            }
            case "copyright": {
                this.isCodeSystemLoincOrThrowInvalidRequestException(theCodeSystemIdentifier, theFilter.getProperty());
                this.handleFilterLoincCopyright(theF, theB, theFilter);
                break;
            }
            default: {
                if (theFilter.getOp() == ValueSet.FilterOperator.REGEX) {
                    this.handleFilterRegex(theF, theB, theFilter);
                    break;
                }
                this.handleFilterPropertyDefault(theF, theB, theFilter);
            }
        }
    }

    private void handleFilterPropertyDefault(SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB, ValueSet.ConceptSetFilterComponent theFilter) {
        String value = theFilter.getValue();
        if (theFilter.getOp() == ValueSet.FilterOperator.EXISTS) {
            Term term = new Term("P:" + theFilter.getProperty());
            theB.must((PredicateFinalStep)theF.exists().field(term.field()));
        } else {
            Term term = new Term("P:" + theFilter.getProperty(), value);
            switch (theFilter.getOp()) {
                case EQUAL: {
                    theB.must((PredicateFinalStep)theF.match().field(term.field()).matching((Object)term.text()));
                    break;
                }
                case IN: 
                case NOTIN: {
                    boolean isNotFilter = theFilter.getOp() == ValueSet.FilterOperator.NOTIN;
                    String[] values = term.text().split(",");
                    HashSet<String> valueSet = new HashSet<String>(Arrays.asList(values));
                    if (isNotFilter) {
                        theB.filter((PredicateFinalStep)theF.not((PredicateFinalStep)theF.terms().field(term.field()).matchingAny(valueSet)));
                        break;
                    }
                    theB.filter((PredicateFinalStep)theF.terms().field(term.field()).matchingAny(valueSet));
                    break;
                }
                default: {
                    ourLog.error("Unsupported property filter {}. This may affect expansion, but will not cause errors.", (Object)theFilter.getOp().getDisplay());
                    theB.must((PredicateFinalStep)theF.matchNone());
                }
            }
        }
    }

    private void handleFilterRegex(SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB, ValueSet.ConceptSetFilterComponent theFilter) {
        Object value = theFilter.getValue();
        if (((String)value).endsWith("$")) {
            value = ((String)value).substring(0, ((String)value).length() - 1);
        } else if (!((String)value).endsWith(".*")) {
            value = (String)value + ".*";
        }
        if (!((String)value).startsWith("^") && !((String)value).startsWith(".*")) {
            value = ".*" + (String)value;
        } else if (((String)value).startsWith("^")) {
            value = ((String)value).substring(1);
        }
        theB.must((PredicateFinalStep)theF.regexp().field("P:" + theFilter.getProperty()).matching((String)value));
    }

    private void handleFilterLoincCopyright(SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB, ValueSet.ConceptSetFilterComponent theFilter) {
        if (theFilter.getOp() == ValueSet.FilterOperator.EQUAL) {
            String copyrightFilterValue;
            switch (copyrightFilterValue = StringUtils.defaultString((String)theFilter.getValue()).toLowerCase()) {
                case "3rdparty": {
                    this.logFilteringValueOnProperty(theFilter.getValue(), theFilter.getProperty());
                    this.addFilterLoincCopyright3rdParty(theF, theB);
                    break;
                }
                case "loinc": {
                    this.logFilteringValueOnProperty(theFilter.getValue(), theFilter.getProperty());
                    this.addFilterLoincCopyrightLoinc(theF, theB);
                    break;
                }
                default: {
                    this.throwInvalidRequestForValueOnProperty(theFilter.getValue(), theFilter.getProperty());
                    break;
                }
            }
        } else {
            this.throwInvalidRequestForOpOnProperty(theFilter.getOp(), theFilter.getProperty());
        }
    }

    private void addFilterLoincCopyrightLoinc(SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB) {
        theB.mustNot((PredicateFinalStep)theF.exists().field("P:EXTERNAL_COPYRIGHT_NOTICE"));
    }

    private void addFilterLoincCopyright3rdParty(SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB) {
        theB.must((PredicateFinalStep)theF.exists().field("P:EXTERNAL_COPYRIGHT_NOTICE"));
    }

    private void handleFilterLoincAncestor(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        switch (theFilter.getOp()) {
            case EQUAL: {
                this.addLoincFilterAncestorEqual(theSystem, f, b, theFilter);
                break;
            }
            case IN: {
                this.addLoincFilterAncestorIn(theSystem, f, b, theFilter);
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)892) + "Don't know how to handle op=" + theFilter.getOp() + " on property " + theFilter.getProperty());
            }
        }
    }

    private void addLoincFilterAncestorEqual(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        this.addLoincFilterAncestorEqual(theSystem, f, b, theFilter.getProperty(), theFilter.getValue());
    }

    private void addLoincFilterAncestorEqual(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, String theProperty, String theValue) {
        List<Term> terms = this.getAncestorTerms(theSystem, theProperty, theValue);
        b.must(f.bool(innerB -> terms.forEach(term -> innerB.should((PredicateFinalStep)f.match().field(term.field()).matching((Object)term.text())))));
    }

    private void addLoincFilterAncestorIn(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        String[] values = theFilter.getValue().split(",");
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String value : values) {
            terms.addAll(this.getAncestorTerms(theSystem, theFilter.getProperty(), value));
        }
        b.must(f.bool(innerB -> terms.forEach(term -> innerB.should((PredicateFinalStep)f.match().field(term.field()).matching((Object)term.text())))));
    }

    private void handleFilterLoincParentChild(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        switch (theFilter.getOp()) {
            case EQUAL: {
                this.addLoincFilterParentChildEqual(f, b, theFilter.getProperty(), theFilter.getValue());
                break;
            }
            case IN: {
                this.addLoincFilterParentChildIn(f, b, theFilter);
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)893) + "Don't know how to handle op=" + theFilter.getOp() + " on property " + theFilter.getProperty());
            }
        }
    }

    private void addLoincFilterParentChildIn(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        String[] values = theFilter.getValue().split(",");
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String value : values) {
            this.logFilteringValueOnProperty(value, theFilter.getProperty());
            terms.add(this.getPropertyTerm(theFilter.getProperty(), value));
        }
        b.must(f.bool(innerB -> terms.forEach(term -> innerB.should((PredicateFinalStep)f.match().field(term.field()).matching((Object)term.text())))));
    }

    private void addLoincFilterParentChildEqual(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, String theProperty, String theValue) {
        this.logFilteringValueOnProperty(theValue, theProperty);
        b.must((PredicateFinalStep)f.match().field("P:" + theProperty).matching((Object)theValue));
    }

    private void handleFilterConceptAndCode(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        TermConcept code = this.findCodeForFilterCriteriaCodeOrConcept(theSystem, theFilter);
        if (theFilter.getOp() == ValueSet.FilterOperator.ISA) {
            ourLog.debug(" * Filtering on specific code and codes with a parent of {}/{}/{}", new Object[]{code.getId(), code.getCode(), code.getDisplay()});
            b.must((PredicateFinalStep)((BooleanPredicateClausesStep)f.bool().should((PredicateFinalStep)f.match().field("myParentPids").matching((Object)("" + code.getId())))).should((PredicateFinalStep)f.match().field("myId").matching((Object)code.getId())));
        } else if (theFilter.getOp() == ValueSet.FilterOperator.DESCENDENTOF) {
            ourLog.debug(" * Filtering on codes with a parent of {}/{}/{}", new Object[]{code.getId(), code.getCode(), code.getDisplay()});
            b.must((PredicateFinalStep)f.match().field("myParentPids").matching((Object)("" + code.getId())));
        } else {
            this.throwInvalidFilter(theFilter, "");
        }
    }

    @Nonnull
    private TermConcept findCodeForFilterCriteriaCodeOrConcept(String theSystem, ValueSet.ConceptSetFilterComponent theFilter) {
        return this.findCode(theSystem, theFilter.getValue()).orElseThrow(() -> new InvalidRequestException(Msg.code((int)2071) + "Invalid filter criteria - code does not exist: {" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "}" + theFilter.getValue()));
    }

    private void throwInvalidFilter(ValueSet.ConceptSetFilterComponent theFilter, String theErrorSuffix) {
        throw new InvalidRequestException(Msg.code((int)894) + "Don't know how to handle op=" + theFilter.getOp() + " on property " + theFilter.getProperty() + theErrorSuffix);
    }

    private void isCodeSystemLoincOrThrowInvalidRequestException(String theSystemIdentifier, String theProperty) {
        String systemUrl = this.getUrlFromIdentifier(theSystemIdentifier);
        if (!this.isCodeSystemLoinc(systemUrl)) {
            throw new InvalidRequestException(Msg.code((int)895) + "Invalid filter, property " + theProperty + " is LOINC-specific and cannot be used with system: " + systemUrl);
        }
    }

    private boolean isCodeSystemLoinc(String theSystem) {
        return "http://loinc.org".equals(theSystem);
    }

    private void handleFilterDisplay(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        if (theFilter.getProperty().equals("display:exact") && theFilter.getOp() == ValueSet.FilterOperator.EQUAL) {
            this.addDisplayFilterExact(f, b, theFilter);
        } else if (theFilter.getProperty().equals("display") && theFilter.getOp() == ValueSet.FilterOperator.EQUAL) {
            if (theFilter.getValue().trim().contains(" ")) {
                this.addDisplayFilterExact(f, b, theFilter);
            } else {
                this.addDisplayFilterInexact(f, b, theFilter);
            }
        }
    }

    private void addDisplayFilterExact(SearchPredicateFactory f, BooleanPredicateClausesStep<?> bool, ValueSet.ConceptSetFilterComponent nextFilter) {
        bool.must((PredicateFinalStep)f.phrase().field("myDisplay").matching(nextFilter.getValue()));
    }

    private void addDisplayFilterInexact(SearchPredicateFactory f, BooleanPredicateClausesStep<?> bool, ValueSet.ConceptSetFilterComponent nextFilter) {
        bool.must((PredicateFinalStep)((PhrasePredicateFieldMoreStep)((PhrasePredicateFieldMoreStep)((PhrasePredicateFieldMoreStep)f.phrase().field("myDisplay").boost(4.0f)).field("myDisplayWordEdgeNGram").boost(1.0f)).field("myDisplayEdgeNGram").boost(1.0f)).matching(nextFilter.getValue().toLowerCase()).slop(2));
    }

    private Term getPropertyTerm(String theProperty, String theValue) {
        return new Term("P:" + theProperty, theValue);
    }

    private List<Term> getAncestorTerms(String theSystem, String theProperty, String theValue) {
        ArrayList<Term> retVal = new ArrayList<Term>();
        TermConcept code = this.findCode(theSystem, theValue).orElseThrow(() -> new InvalidRequestException("Invalid filter criteria - code does not exist: {" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "}" + theValue));
        retVal.add(new Term("myParentPids", "" + code.getId()));
        this.logFilteringValueOnProperty(theValue, theProperty);
        return retVal;
    }

    private void handleFilterLoincDescendant(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        switch (theFilter.getOp()) {
            case EQUAL: {
                this.addLoincFilterDescendantEqual(theSystem, f, b, theFilter);
                break;
            }
            case IN: {
                this.addLoincFilterDescendantIn(theSystem, f, b, theFilter);
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)896) + "Don't know how to handle op=" + theFilter.getOp() + " on property " + theFilter.getProperty());
            }
        }
    }

    private void addLoincFilterDescendantEqual(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        List<Long> parentPids = this.getCodeParentPids(theSystem, theFilter.getProperty(), theFilter.getValue());
        if (parentPids.isEmpty()) {
            b.mustNot((PredicateFinalStep)f.matchAll());
            return;
        }
        b.must(f.bool(innerB -> {
            innerB.minimumShouldMatchNumber(1);
            parentPids.forEach(pid -> innerB.should((PredicateFinalStep)f.match().field("myId").matching(pid)));
        }));
    }

    private void addLoincFilterDescendantIn(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        String[] values = theFilter.getValue().split(",");
        if (values.length == 0) {
            throw new InvalidRequestException(Msg.code((int)2062) + "Invalid filter criteria - no codes specified");
        }
        List<Long> descendantCodePidList = this.getMultipleCodeParentPids(theSystem, theFilter.getProperty(), values);
        b.must(f.bool(innerB -> descendantCodePidList.forEach(pId -> innerB.should((PredicateFinalStep)f.match().field("myId").matching(pId)))));
    }

    private List<Long> getCodeParentPids(String theSystem, String theProperty, String theValue) {
        TermConcept code = this.findCode(theSystem, theValue).orElseThrow(() -> new InvalidRequestException("Invalid filter criteria - code does not exist: {" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "}" + theValue));
        String[] parentPids = code.getParentPidsAsString().split(" ");
        List<Long> retVal = Arrays.stream(parentPids).filter(pid -> !StringUtils.equals((CharSequence)pid, (CharSequence)"NONE")).map(Long::parseLong).collect(Collectors.toList());
        this.logFilteringValueOnProperty(theValue, theProperty);
        return retVal;
    }

    private List<Long> getMultipleCodeParentPids(String theSystem, String theProperty, String[] theValues) {
        List<String> valuesList = Arrays.asList(theValues);
        List<TermConcept> termConcepts = this.findCodes(theSystem, valuesList);
        if (valuesList.size() != termConcepts.size()) {
            String exMsg = this.getTermConceptsFetchExceptionMsg(termConcepts, valuesList);
            throw new InvalidRequestException(Msg.code((int)2064) + "Invalid filter criteria - {" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "}: " + exMsg);
        }
        List<Long> retVal = termConcepts.stream().flatMap(tc -> Arrays.stream(tc.getParentPidsAsString().split(" "))).filter(pid -> !StringUtils.equals((CharSequence)pid, (CharSequence)"NONE")).map(Long::parseLong).collect(Collectors.toList());
        this.logFilteringValueOnProperties(valuesList, theProperty);
        return retVal;
    }

    private String getTermConceptsFetchExceptionMsg(List<TermConcept> theTermConcepts, List<String> theValues) {
        if (theTermConcepts.size() > theValues.size()) {
            return "Invalid filter criteria - More TermConcepts were found than indicated codes. Queried codes: [" + String.join((CharSequence)",", theValues + "]; Obtained TermConcept IDs, codes: [" + theTermConcepts.stream().map(tc -> tc.getId() + ", " + tc.getCode()).collect(Collectors.joining("; ")) + "]");
        }
        Set matchedCodes = theTermConcepts.stream().map(TermConcept::getCode).collect(Collectors.toSet());
        List notMatchedValues = theValues.stream().filter(v -> !matchedCodes.contains(v)).collect(Collectors.toList());
        return "Invalid filter criteria - No TermConcept(s) were found for the requested codes: [" + String.join((CharSequence)",", notMatchedValues + "]");
    }

    private void logFilteringValueOnProperty(String theValue, String theProperty) {
        ourLog.debug(" * Filtering with value={} on property {}", (Object)theValue, (Object)theProperty);
    }

    private void logFilteringValueOnProperties(List<String> theValues, String theProperty) {
        ourLog.debug(" * Filtering with values={} on property {}", (Object)String.join((CharSequence)", ", theValues), (Object)theProperty);
    }

    private void throwInvalidRequestForOpOnProperty(ValueSet.FilterOperator theOp, String theProperty) {
        throw new InvalidRequestException(Msg.code((int)897) + "Don't know how to handle op=" + theOp + " on property " + theProperty);
    }

    private void throwInvalidRequestForValueOnProperty(String theValue, String theProperty) {
        throw new InvalidRequestException(Msg.code((int)898) + "Don't know how to handle value=" + theValue + " on property " + theProperty);
    }

    private void expandWithoutHibernateSearch(IValueSetConceptAccumulator theValueSetCodeAccumulator, TermCodeSystemVersion theVersion, Set<String> theAddedCodes, ValueSet.ConceptSetComponent theInclude, String theSystem, boolean theAdd) {
        ourLog.trace("Hibernate search is not enabled");
        if (theValueSetCodeAccumulator instanceof ValueSetExpansionComponentWithConceptAccumulator) {
            Validate.isTrue((boolean)((ValueSetExpansionComponentWithConceptAccumulator)theValueSetCodeAccumulator).getParameter().isEmpty(), (String)"Can not expand ValueSet with parameters - Hibernate Search is not enabled on this server.", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)theSystem), (String)"Can not expand ValueSet without explicit system - Hibernate Search is not enabled on this server.", (Object[])new Object[0]);
        for (Object nextFilter : theInclude.getFilter()) {
            boolean handled = false;
            switch (nextFilter.getProperty().toLowerCase()) {
                case "concept": 
                case "code": {
                    if (nextFilter.getOp() != ValueSet.FilterOperator.ISA) break;
                    theValueSetCodeAccumulator.addMessage("Processing IS-A filter in database - Note that Hibernate Search is not enabled on this server, so this operation can be inefficient.");
                    TermConcept code = this.findCodeForFilterCriteriaCodeOrConcept(theSystem, (ValueSet.ConceptSetFilterComponent)nextFilter);
                    this.addConceptAndChildren(theValueSetCodeAccumulator, theAddedCodes, theInclude, theSystem, theAdd, code);
                    handled = true;
                    break;
                }
            }
            if (handled) continue;
            this.throwInvalidFilter((ValueSet.ConceptSetFilterComponent)nextFilter, " - Note that Hibernate Search is disabled on this server so not all ValueSet expansion functionality is available.");
        }
        if (theInclude.getFilter().isEmpty() && theInclude.getConcept().isEmpty()) {
            List<TermConcept> concepts = this.myConceptDao.fetchConceptsAndDesignationsByVersionPid(theVersion.getPid());
            for (TermConcept next : concepts) {
                this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, theAdd, theSystem, theInclude.getVersion(), next.getCode(), next.getDisplay(), next.getId(), next.getParentPidsAsString(), next.getDesignations());
            }
        }
        for (ValueSet.ConceptReferenceComponent next : theInclude.getConcept()) {
            if (!theSystem.equals(theInclude.getSystem()) && StringUtils.isNotBlank((CharSequence)theSystem)) continue;
            Collection designations = next.getDesignation().stream().map(t -> new TermConceptDesignation().setValue(t.getValue()).setLanguage(t.getLanguage()).setUseCode(t.getUse().getCode()).setUseSystem(t.getUse().getSystem()).setUseDisplay(t.getUse().getDisplay())).collect(Collectors.toList());
            this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, theAdd, theSystem, theInclude.getVersion(), next.getCode(), next.getDisplay(), null, null, designations);
        }
    }

    private void addConceptAndChildren(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, ValueSet.ConceptSetComponent theInclude, String theSystem, boolean theAdd, TermConcept theConcept) {
        for (TermConcept nextChild : theConcept.getChildCodes()) {
            boolean added = this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, theAdd, theSystem, theInclude.getVersion(), nextChild.getCode(), nextChild.getDisplay(), nextChild.getId(), nextChild.getParentPidsAsString(), nextChild.getDesignations());
            if (!added) continue;
            this.addConceptAndChildren(theValueSetCodeAccumulator, theAddedCodes, theInclude, theSystem, theAdd, nextChild);
        }
    }

    @Override
    @Transactional
    public String invalidatePreCalculatedExpansion(IIdType theValueSetId, RequestDetails theRequestDetails) {
        IBaseResource valueSet = this.myDaoRegistry.getResourceDao("ValueSet").read(theValueSetId, theRequestDetails);
        org.hl7.fhir.r4.model.ValueSet canonicalValueSet = this.myVersionCanonicalizer.valueSetToCanonical(valueSet);
        Optional<TermValueSet> optionalTermValueSet = this.fetchValueSetEntity(canonicalValueSet);
        if (optionalTermValueSet.isEmpty()) {
            return this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "valueSetNotFoundInTerminologyDatabase", new Object[]{theValueSetId});
        }
        ourLog.info("Invalidating pre-calculated expansion on ValueSet {} / {}", (Object)theValueSetId, (Object)canonicalValueSet.getUrl());
        TermValueSet termValueSet = optionalTermValueSet.get();
        if (termValueSet.getExpansionStatus() == TermValueSetPreExpansionStatusEnum.NOT_EXPANDED) {
            return this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "valueSetCantInvalidateNotYetPrecalculated", new Object[]{termValueSet.getUrl(), termValueSet.getExpansionStatus()});
        }
        Long totalConcepts = termValueSet.getTotalConcepts();
        this.deletePreCalculatedValueSetContents(termValueSet);
        termValueSet.setExpansionStatus(TermValueSetPreExpansionStatusEnum.NOT_EXPANDED);
        termValueSet.setExpansionTimestamp(null);
        this.myTermValueSetDao.save(termValueSet);
        this.afterValueSetExpansionStatusChange();
        return this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "valueSetPreExpansionInvalidated", new Object[]{termValueSet.getUrl(), totalConcepts});
    }

    @Override
    @Transactional
    public boolean isValueSetPreExpandedForCodeValidation(org.hl7.fhir.r4.model.ValueSet theValueSet) {
        Optional<TermValueSet> optionalTermValueSet = this.fetchValueSetEntity(theValueSet);
        if (optionalTermValueSet.isEmpty()) {
            ourLog.warn("ValueSet is not present in terminology tables. Will perform in-memory code validation. {}", (Object)this.getValueSetInfo(theValueSet));
            return false;
        }
        TermValueSet termValueSet = optionalTermValueSet.get();
        if (termValueSet.getExpansionStatus() != TermValueSetPreExpansionStatusEnum.EXPANDED) {
            ourLog.warn("{} is present in terminology tables but not ready for persistence-backed invocation of operation $validation-code. Will perform in-memory code validation. Current status: {} | {}", new Object[]{this.getValueSetInfo(theValueSet), termValueSet.getExpansionStatus().name(), termValueSet.getExpansionStatus().getDescription()});
            return false;
        }
        return true;
    }

    private Optional<TermValueSet> fetchValueSetEntity(org.hl7.fhir.r4.model.ValueSet theValueSet) {
        JpaPid valueSetResourcePid = this.getValueSetResourcePersistentId(theValueSet);
        return this.myTermValueSetDao.findByResourcePid(valueSetResourcePid.getId());
    }

    private JpaPid getValueSetResourcePersistentId(org.hl7.fhir.r4.model.ValueSet theValueSet) {
        return (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(RequestPartitionId.allPartitions(), theValueSet.getIdElement().getResourceType(), theValueSet.getIdElement().getIdPart());
    }

    protected IValidationSupport.CodeValidationResult validateCodeIsInPreExpandedValueSet(ConceptValidationOptions theValidationOptions, org.hl7.fhir.r4.model.ValueSet theValueSet, String theSystem, String theCode, String theDisplay, Coding theCoding, CodeableConcept theCodeableConcept) {
        String append;
        assert (TransactionSynchronizationManager.isSynchronizationActive());
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSet.hasId(), (String)"ValueSet.id is required", (Object[])new Object[0]);
        JpaPid valueSetResourcePid = this.getValueSetResourcePersistentId(theValueSet);
        ArrayList<TermValueSetConcept> concepts = new ArrayList<TermValueSetConcept>();
        if (StringUtils.isNotBlank((CharSequence)theCode)) {
            if (theValidationOptions.isInferSystem()) {
                concepts.addAll(this.myValueSetConceptDao.findByValueSetResourcePidAndCode(valueSetResourcePid.getId(), theCode));
            } else if (StringUtils.isNotBlank((CharSequence)theSystem)) {
                concepts.addAll(this.findByValueSetResourcePidSystemAndCode(valueSetResourcePid, theSystem, theCode));
            }
        } else if (theCoding != null) {
            if (theCoding.hasSystem() && theCoding.hasCode()) {
                concepts.addAll(this.findByValueSetResourcePidSystemAndCode(valueSetResourcePid, theCoding.getSystem(), theCoding.getCode()));
            }
        } else if (theCodeableConcept != null) {
            for (Coding coding : theCodeableConcept.getCoding()) {
                if (!coding.hasSystem() || !coding.hasCode()) continue;
                concepts.addAll(this.findByValueSetResourcePidSystemAndCode(valueSetResourcePid, coding.getSystem(), coding.getCode()));
                if (concepts.isEmpty()) continue;
                break;
            }
        } else {
            return null;
        }
        TermValueSet valueSetEntity = this.myTermValueSetDao.findByResourcePid(valueSetResourcePid.getId()).orElseThrow(IllegalStateException::new);
        String timingDescription = this.toHumanReadableExpansionTimestamp(valueSetEntity);
        String preExpansionMessage = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "validationPerformedAgainstPreExpansion", new Object[]{timingDescription});
        if (theValidationOptions.isValidateDisplay() && concepts.size() > 0) {
            String systemVersion = null;
            for (TermValueSetConcept concept : concepts) {
                systemVersion = concept.getSystemVersion();
                if (!StringUtils.isBlank((CharSequence)theDisplay) && !StringUtils.isBlank((CharSequence)concept.getDisplay()) && !theDisplay.equals(concept.getDisplay())) continue;
                return new IValidationSupport.CodeValidationResult().setCode(concept.getCode()).setDisplay(concept.getDisplay()).setCodeSystemVersion(concept.getSystemVersion()).setSourceDetails(preExpansionMessage);
            }
            String expectedDisplay = ((TermValueSetConcept)concepts.get(0)).getDisplay();
            return InMemoryTerminologyServerValidationSupport.createResultForDisplayMismatch((FhirContext)this.myContext, (String)theCode, (String)theDisplay, (String)expectedDisplay, (String)theSystem, (String)systemVersion, (IValidationSupport.IssueSeverity)this.myStorageSettings.getIssueSeverityForCodeDisplayMismatch());
        }
        if (!concepts.isEmpty()) {
            return new IValidationSupport.CodeValidationResult().setCode(((TermValueSetConcept)concepts.get(0)).getCode()).setDisplay(((TermValueSetConcept)concepts.get(0)).getDisplay()).setCodeSystemVersion(((TermValueSetConcept)concepts.get(0)).getSystemVersion()).setMessage(preExpansionMessage);
        }
        List<TermValueSetConcept> outcome = this.myValueSetConceptDao.findByTermValueSetIdSystemOnly(Pageable.ofSize((int)1), valueSetEntity.getId(), theSystem);
        if (outcome.size() == 0) {
            append = " - No codes in ValueSet belong to CodeSystem with URL " + theSystem;
        } else {
            String unknownCodeMessage = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "unknownCodeInSystem", new Object[]{theSystem, theCode});
            append = " - " + unknownCodeMessage + ". " + preExpansionMessage;
        }
        return this.createFailureCodeValidationResult(theSystem, theCode, null, append);
    }

    private IValidationSupport.CodeValidationResult createFailureCodeValidationResult(String theSystem, String theCode, String theCodeSystemVersion, String theAppend) {
        String theMessage = "Unable to validate code " + theSystem + "#" + theCode + theAppend;
        return new IValidationSupport.CodeValidationResult().setSeverity(IValidationSupport.IssueSeverity.ERROR).setCodeSystemVersion(theCodeSystemVersion).setMessage(theMessage).addCodeValidationIssue(new IValidationSupport.CodeValidationIssue(theMessage, IValidationSupport.IssueSeverity.ERROR, IValidationSupport.CodeValidationIssueCode.CODE_INVALID, IValidationSupport.CodeValidationIssueCoding.INVALID_CODE));
    }

    private List<TermValueSetConcept> findByValueSetResourcePidSystemAndCode(JpaPid theResourcePid, String theSystem, String theCode) {
        Optional<TermValueSetConcept> optionalTermValueSetConcept;
        assert (TransactionSynchronizationManager.isSynchronizationActive());
        ArrayList<TermValueSetConcept> retVal = new ArrayList<TermValueSetConcept>();
        int versionIndex = theSystem.indexOf(OUR_PIPE_CHARACTER);
        if (versionIndex >= 0) {
            String systemUrl = theSystem.substring(0, versionIndex);
            String systemVersion = theSystem.substring(versionIndex + 1);
            optionalTermValueSetConcept = this.myValueSetConceptDao.findByValueSetResourcePidSystemAndCodeWithVersion(theResourcePid.getId(), systemUrl, systemVersion, theCode);
        } else {
            optionalTermValueSetConcept = this.myValueSetConceptDao.findByValueSetResourcePidSystemAndCode(theResourcePid.getId(), theSystem, theCode);
        }
        optionalTermValueSetConcept.ifPresent(retVal::add);
        return retVal;
    }

    private void fetchChildren(TermConcept theConcept, Set<TermConcept> theSetToPopulate) {
        for (TermConceptParentChildLink nextChildLink : theConcept.getChildren()) {
            TermConcept nextChild = nextChildLink.getChild();
            if (!this.addToSet(theSetToPopulate, nextChild)) continue;
            this.fetchChildren(nextChild, theSetToPopulate);
        }
    }

    private Optional<TermConcept> fetchLoadedCode(Long theCodeSystemResourcePid, String theCode) {
        TermCodeSystemVersion codeSystem = this.myCodeSystemVersionDao.findCurrentVersionForCodeSystemResourcePid(theCodeSystemResourcePid);
        return this.myConceptDao.findByCodeSystemAndCode(codeSystem.getPid(), theCode);
    }

    private void fetchParents(TermConcept theConcept, Set<TermConcept> theSetToPopulate) {
        for (TermConceptParentChildLink nextChildLink : theConcept.getParents()) {
            TermConcept nextChild = nextChildLink.getParent();
            if (!this.addToSet(theSetToPopulate, nextChild)) continue;
            this.fetchParents(nextChild, theSetToPopulate);
        }
    }

    @Override
    public Optional<TermConcept> findCode(String theCodeSystem, String theCode) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
        txTemplate.setPropagationBehavior(2);
        txTemplate.setReadOnly(true);
        return (Optional)txTemplate.execute(t -> {
            TermCodeSystemVersionDetails csv = this.getCurrentCodeSystemVersion(theCodeSystem);
            if (csv == null) {
                return Optional.empty();
            }
            return this.myConceptDao.findByCodeSystemAndCode(csv.myPid, theCode);
        });
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY)
    public List<TermConcept> findCodes(String theCodeSystem, List<String> theCodeList) {
        TermCodeSystemVersionDetails csv = this.getCurrentCodeSystemVersion(theCodeSystem);
        if (csv == null) {
            return Collections.emptyList();
        }
        return this.myConceptDao.findByCodeSystemAndCodeList(csv.myPid, theCodeList);
    }

    @Nullable
    private TermCodeSystemVersionDetails getCurrentCodeSystemVersion(String theCodeSystemIdentifier) {
        String version = this.getVersionFromIdentifier(theCodeSystemIdentifier);
        TermCodeSystemVersionDetails retVal = (TermCodeSystemVersionDetails)this.myCodeSystemCurrentVersionCache.get((Object)theCodeSystemIdentifier, t -> (TermCodeSystemVersionDetails)this.myTxTemplate.execute(tx -> {
            TermCodeSystemVersion csv = null;
            TermCodeSystem cs = this.myCodeSystemDao.findByCodeSystemUri(this.getUrlFromIdentifier(theCodeSystemIdentifier));
            if (cs != null) {
                if (version != null) {
                    csv = this.myCodeSystemVersionDao.findByCodeSystemPidAndVersion(cs.getPid(), version);
                } else if (cs.getCurrentVersion() != null) {
                    csv = cs.getCurrentVersion();
                }
            }
            if (csv != null) {
                return new TermCodeSystemVersionDetails(csv.getPid(), csv.getCodeSystemVersionId());
            }
            return NO_CURRENT_VERSION;
        }));
        if (retVal == NO_CURRENT_VERSION) {
            return null;
        }
        return retVal;
    }

    private String getVersionFromIdentifier(String theUri) {
        int versionSeparator;
        String retVal = null;
        if (StringUtils.isNotEmpty((CharSequence)theUri) && (versionSeparator = theUri.lastIndexOf(124)) != -1) {
            retVal = theUri.substring(versionSeparator + 1);
        }
        return retVal;
    }

    private String getUrlFromIdentifier(String theUri) {
        int versionSeparator;
        String retVal = theUri;
        if (StringUtils.isNotEmpty((CharSequence)theUri) && (versionSeparator = theUri.lastIndexOf(124)) != -1) {
            retVal = theUri.substring(0, versionSeparator);
        }
        return retVal;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Set<TermConcept> findCodesAbove(Long theCodeSystemResourcePid, Long theCodeSystemVersionPid, String theCode) {
        StopWatch stopwatch = new StopWatch();
        Optional<TermConcept> concept = this.fetchLoadedCode(theCodeSystemResourcePid, theCode);
        if (concept.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TermConcept> retVal = new HashSet<TermConcept>();
        retVal.add(concept.get());
        this.fetchParents(concept.get(), retVal);
        ourLog.debug("Fetched {} codes above code {} in {}ms", new Object[]{retVal.size(), theCode, stopwatch.getMillis()});
        return retVal;
    }

    @Override
    @Transactional
    public List<FhirVersionIndependentConcept> findCodesAbove(String theSystem, String theCode) {
        TermCodeSystem cs = this.getCodeSystem(theSystem);
        if (cs == null) {
            return this.findCodesAboveUsingBuiltInSystems(theSystem, theCode);
        }
        TermCodeSystemVersion csv = cs.getCurrentVersion();
        Set<TermConcept> codes = this.findCodesAbove(cs.getResource().getId(), csv.getPid(), theCode);
        return this.toVersionIndependentConcepts(theSystem, codes);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Set<TermConcept> findCodesBelow(Long theCodeSystemResourcePid, Long theCodeSystemVersionPid, String theCode) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Optional<TermConcept> concept = this.fetchLoadedCode(theCodeSystemResourcePid, theCode);
        if (concept.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TermConcept> retVal = new HashSet<TermConcept>();
        retVal.add(concept.get());
        this.fetchChildren(concept.get(), retVal);
        ourLog.debug("Fetched {} codes below code {} in {}ms", new Object[]{retVal.size(), theCode, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return retVal;
    }

    @Override
    @Transactional
    public List<FhirVersionIndependentConcept> findCodesBelow(String theSystem, String theCode) {
        TermCodeSystem cs = this.getCodeSystem(theSystem);
        if (cs == null) {
            return this.findCodesBelowUsingBuiltInSystems(theSystem, theCode);
        }
        TermCodeSystemVersion csv = cs.getCurrentVersion();
        Set<TermConcept> codes = this.findCodesBelow(cs.getResource().getId(), csv.getPid(), theCode);
        return this.toVersionIndependentConcepts(theSystem, codes);
    }

    private TermCodeSystem getCodeSystem(String theSystem) {
        return this.myCodeSystemDao.findByCodeSystemUri(theSystem);
    }

    @PostConstruct
    public void start() {
        RuleBasedTransactionAttribute rules = new RuleBasedTransactionAttribute();
        rules.getRollbackRules().add(new NoRollbackRuleAttribute(ExpansionTooCostlyException.class));
        this.myTxTemplate = new TransactionTemplate(this.myTransactionManager, (TransactionDefinition)rules);
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition vsJobDefinition = new ScheduledJobDefinition();
        vsJobDefinition.setId(this.getClass().getName());
        vsJobDefinition.setJobClass(Job.class);
        theSchedulerService.scheduleClusteredJob(600000L, vsJobDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void preExpandDeferredValueSetsToTerminologyTables() {
        if (!this.myStorageSettings.isEnableTaskPreExpandValueSets()) {
            return;
        }
        if (this.isNotSafeToPreExpandValueSets()) {
            ourLog.info("Skipping scheduled pre-expansion of ValueSets while deferred entities are being loaded.");
            return;
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
        while (true) {
            StopWatch sw = new StopWatch();
            TermValueSet valueSetToExpand = (TermValueSet)txTemplate.execute(t -> {
                Optional<TermValueSet> optionalTermValueSet = this.getNextTermValueSetNotExpanded();
                if (optionalTermValueSet.isEmpty()) {
                    return null;
                }
                TermValueSet termValueSet = optionalTermValueSet.get();
                termValueSet.setTotalConcepts(0L);
                termValueSet.setTotalConceptDesignations(0L);
                termValueSet.setExpansionStatus(TermValueSetPreExpansionStatusEnum.EXPANSION_IN_PROGRESS);
                return (TermValueSet)this.myTermValueSetDao.saveAndFlush(termValueSet);
            });
            if (valueSetToExpand == null) {
                return;
            }
            this.setPreExpandingValueSets(true);
            try {
                org.hl7.fhir.r4.model.ValueSet valueSet = (org.hl7.fhir.r4.model.ValueSet)txTemplate.execute(t -> {
                    TermValueSet refreshedValueSetToExpand = (TermValueSet)this.myTermValueSetDao.findById(valueSetToExpand.getId()).orElseThrow(() -> new IllegalStateException("Unknown VS ID: " + valueSetToExpand.getId()));
                    return this.getValueSetFromResourceTable(refreshedValueSetToExpand.getResource());
                });
                assert (valueSet != null);
                ValueSetConceptAccumulator valueSetConceptAccumulator = this.myValueSetConceptAccumulatorFactory.create(valueSetToExpand);
                ValueSetExpansionOptions options = new ValueSetExpansionOptions();
                options.setIncludeHierarchy(true);
                this.expandValueSet(options, valueSet, (IValueSetConceptAccumulator)valueSetConceptAccumulator);
                txTemplate.executeWithoutResult(t -> {
                    valueSetToExpand.setExpansionStatus(TermValueSetPreExpansionStatusEnum.EXPANDED);
                    valueSetToExpand.setExpansionTimestamp(new Date());
                    this.myTermValueSetDao.saveAndFlush(valueSetToExpand);
                });
                this.afterValueSetExpansionStatusChange();
                ourLog.info("Pre-expanded ValueSet[{}] with URL[{}] - Saved {} concepts in {}", new Object[]{valueSet.getId(), valueSet.getUrl(), valueSetConceptAccumulator.getConceptsSaved(), sw});
                continue;
            }
            catch (Exception e) {
                ourLog.error("Failed to pre-expand ValueSet with URL[{}]: {}", new Object[]{valueSetToExpand.getUrl(), e.getMessage(), e});
                txTemplate.executeWithoutResult(t -> {
                    valueSetToExpand.setExpansionStatus(TermValueSetPreExpansionStatusEnum.FAILED_TO_EXPAND);
                    this.myTermValueSetDao.saveAndFlush(valueSetToExpand);
                });
                continue;
            }
            finally {
                this.setPreExpandingValueSets(false);
                continue;
            }
            break;
        }
    }

    private void afterValueSetExpansionStatusChange() {
        this.myCachingValidationSupport.invalidateCaches();
    }

    private synchronized boolean isPreExpandingValueSets() {
        return this.myPreExpandingValueSets;
    }

    private synchronized void setPreExpandingValueSets(boolean thePreExpandingValueSets) {
        this.myPreExpandingValueSets = thePreExpandingValueSets;
    }

    private boolean isNotSafeToPreExpandValueSets() {
        return this.myDeferredStorageSvc != null && !this.myDeferredStorageSvc.isStorageQueueEmpty(true);
    }

    private Optional<TermValueSet> getNextTermValueSetNotExpanded() {
        Optional<TermValueSet> retVal = Optional.empty();
        Slice<TermValueSet> page = this.myTermValueSetDao.findByExpansionStatus((Pageable)PageRequest.of((int)0, (int)1), TermValueSetPreExpansionStatusEnum.NOT_EXPANDED);
        if (!page.getContent().isEmpty()) {
            retVal = Optional.of((TermValueSet)page.getContent().get(0));
        }
        return retVal;
    }

    @Override
    @Transactional
    public void storeTermValueSet(ResourceTable theResourceTable, org.hl7.fhir.r4.model.ValueSet theValueSet) {
        ValidateUtil.isTrueOrThrowInvalidRequest((theResourceTable != null ? 1 : 0) != 0, (String)"No resource supplied", (Object[])new Object[0]);
        if (TermReadSvcImpl.isPlaceholder((DomainResource)theValueSet)) {
            ourLog.info("Not storing TermValueSet for placeholder {}", (Object)theValueSet.getIdElement().toVersionless().getValueAsString());
            return;
        }
        ValidateUtil.isNotBlankOrThrowUnprocessableEntity((String)theValueSet.getUrl(), (String)"ValueSet has no value for ValueSet.url");
        ourLog.info("Storing TermValueSet for {}", (Object)theValueSet.getIdElement().toVersionless().getValueAsString());
        TermValueSet termValueSet = new TermValueSet();
        termValueSet.setResource(theResourceTable);
        termValueSet.setUrl(theValueSet.getUrl());
        termValueSet.setVersion(theValueSet.getVersion());
        termValueSet.setName(theValueSet.hasName() ? theValueSet.getName() : null);
        this.deleteValueSetForResource(theResourceTable);
        String url = termValueSet.getUrl();
        String version = termValueSet.getVersion();
        Optional<TermValueSet> optionalExistingTermValueSetByUrl = version != null ? this.myTermValueSetDao.findTermValueSetByUrlAndVersion(url, version) : this.myTermValueSetDao.findTermValueSetByUrlAndNullVersion(url);
        if (!optionalExistingTermValueSetByUrl.isEmpty()) {
            TermValueSet existingTermValueSet = optionalExistingTermValueSetByUrl.get();
            String msg = version != null ? this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "cannotCreateDuplicateValueSetUrlAndVersion", new Object[]{url, version, existingTermValueSet.getResource().getIdDt().toUnqualifiedVersionless().getValue()}) : this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "cannotCreateDuplicateValueSetUrl", new Object[]{url, existingTermValueSet.getResource().getIdDt().toUnqualifiedVersionless().getValue()});
            throw new UnprocessableEntityException(Msg.code((int)902) + msg);
        }
        this.myTermValueSetDao.save(termValueSet);
    }

    @Override
    @Transactional
    public IFhirResourceDaoCodeSystem.SubsumesResult subsumes(IPrimitiveType<String> theCodeA, IPrimitiveType<String> theCodeB, IPrimitiveType<String> theSystem, IBaseCoding theCodingA, IBaseCoding theCodingB) {
        FhirVersionIndependentConcept conceptA = this.toConcept(theCodeA, theSystem, theCodingA);
        FhirVersionIndependentConcept conceptB = this.toConcept(theCodeB, theSystem, theCodingB);
        if (!StringUtils.equals((CharSequence)conceptA.getSystem(), (CharSequence)conceptB.getSystem())) {
            throw new InvalidRequestException(Msg.code((int)903) + "Unable to test subsumption across different code systems");
        }
        if (!StringUtils.equals((CharSequence)conceptA.getSystemVersion(), (CharSequence)conceptB.getSystemVersion())) {
            throw new InvalidRequestException(Msg.code((int)904) + "Unable to test subsumption across different code system versions");
        }
        Object codeASystemIdentifier = StringUtils.isNotEmpty((CharSequence)conceptA.getSystemVersion()) ? conceptA.getSystem() + OUR_PIPE_CHARACTER + conceptA.getSystemVersion() : conceptA.getSystem();
        TermConcept codeA = this.findCode((String)codeASystemIdentifier, conceptA.getCode()).orElseThrow(() -> new InvalidRequestException("Unknown code: " + conceptA));
        Object codeBSystemIdentifier = StringUtils.isNotEmpty((CharSequence)conceptB.getSystemVersion()) ? conceptB.getSystem() + OUR_PIPE_CHARACTER + conceptB.getSystemVersion() : conceptB.getSystem();
        TermConcept codeB = this.findCode((String)codeBSystemIdentifier, conceptB.getCode()).orElseThrow(() -> new InvalidRequestException("Unknown code: " + conceptB));
        SearchSession searchSession = Search.session((EntityManager)this.myEntityManager);
        ConceptSubsumptionOutcome subsumes = this.testForSubsumption(searchSession, codeA, codeB, ConceptSubsumptionOutcome.SUBSUMES);
        if (subsumes == null) {
            subsumes = this.testForSubsumption(searchSession, codeB, codeA, ConceptSubsumptionOutcome.SUBSUMEDBY);
        }
        if (subsumes == null) {
            subsumes = ConceptSubsumptionOutcome.NOTSUBSUMED;
        }
        return new IFhirResourceDaoCodeSystem.SubsumesResult(subsumes);
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, @Nonnull LookupCodeRequest theLookupCodeRequest) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
        return (IValidationSupport.LookupCodeResult)txTemplate.execute(t -> {
            String theCode;
            String theSystem = theLookupCodeRequest.getSystem();
            Optional<TermConcept> codeOpt = this.findCode(theSystem, theCode = theLookupCodeRequest.getCode());
            if (codeOpt.isPresent()) {
                TermConcept code = codeOpt.get();
                IValidationSupport.LookupCodeResult result = new IValidationSupport.LookupCodeResult();
                result.setCodeSystemDisplayName(code.getCodeSystemVersion().getCodeSystemDisplayName());
                result.setCodeSystemVersion(code.getCodeSystemVersion().getCodeSystemVersionId());
                result.setSearchedForSystem(theSystem);
                result.setSearchedForCode(theCode);
                result.setFound(true);
                result.setCodeDisplay(code.getDisplay());
                for (TermConceptDesignation next : code.getDesignations()) {
                    if (!TermReadSvcImpl.isDisplayLanguageMatch(theLookupCodeRequest.getDisplayLanguage(), next.getLanguage())) continue;
                    IValidationSupport.ConceptDesignation designation = new IValidationSupport.ConceptDesignation();
                    designation.setLanguage(next.getLanguage());
                    designation.setUseSystem(next.getUseSystem());
                    designation.setUseCode(next.getUseCode());
                    designation.setUseDisplay(next.getUseDisplay());
                    designation.setValue(next.getValue());
                    result.getDesignations().add(designation);
                }
                Collection propertyNames = theLookupCodeRequest.getPropertyNames();
                for (TermConceptProperty next : code.getProperties()) {
                    IValidationSupport.CodingConceptProperty property;
                    if (ObjectUtils.isNotEmpty((Object)propertyNames) && !propertyNames.contains(next.getKey())) continue;
                    if (next.getType() == TermConceptPropertyTypeEnum.CODING) {
                        property = new IValidationSupport.CodingConceptProperty(next.getKey(), next.getCodeSystem(), next.getValue(), next.getDisplay());
                        result.getProperties().add(property);
                        continue;
                    }
                    if (next.getType() == TermConceptPropertyTypeEnum.STRING) {
                        property = new IValidationSupport.StringConceptProperty(next.getKey(), next.getValue());
                        result.getProperties().add(property);
                        continue;
                    }
                    throw new InternalErrorException(Msg.code((int)905) + "Unknown type: " + next.getType());
                }
                return result;
            }
            return new IValidationSupport.LookupCodeResult().setFound(false);
        });
    }

    @Nullable
    private ConceptSubsumptionOutcome testForSubsumption(SearchSession theSearchSession, TermConcept theLeft, TermConcept theRight, ConceptSubsumptionOutcome theOutput) {
        List fetch = theSearchSession.search(TermConcept.class).where(f -> (PredicateFinalStep)((BooleanPredicateClausesStep)f.bool().must((PredicateFinalStep)f.match().field("myId").matching((Object)theRight.getId()))).must((PredicateFinalStep)f.match().field("myParentPids").matching((Object)Long.toString(theLeft.getId())))).fetchHits(Integer.valueOf(1));
        if (fetch.size() > 0) {
            return theOutput;
        }
        return null;
    }

    private ArrayList<FhirVersionIndependentConcept> toVersionIndependentConcepts(String theSystem, Set<TermConcept> codes) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>(codes.size());
        for (TermConcept next : codes) {
            retVal.add(new FhirVersionIndependentConcept(theSystem, next.getCode()));
        }
        return retVal;
    }

    @Transactional
    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        TermReadSvcImpl.invokeRunnableForUnitTest();
        IPrimitiveType urlPrimitive = theValueSet instanceof ValueSet ? (IPrimitiveType)FhirContext.forDstu2Hl7OrgCached().newTerser().getSingleValueOrNull((IBase)theValueSet, "url", IPrimitiveType.class) : (IPrimitiveType)this.myContext.newTerser().getSingleValueOrNull((IBase)theValueSet, "url", IPrimitiveType.class);
        String url = urlPrimitive.getValueAsString();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            return this.validateCode(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, url);
        }
        return null;
    }

    @CoverageIgnore
    public IValidationSupport.CodeValidationResult validateCode(@Nonnull ValidationSupportContext theValidationSupportContext, @Nonnull ConceptValidationOptions theOptions, String theCodeSystemUrl, String theCode, String theDisplay, String theValueSetUrl) {
        TermReadSvcImpl.invokeRunnableForUnitTest();
        theOptions.setValidateDisplay(StringUtils.isNotBlank((CharSequence)theDisplay));
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            return this.validateCodeInValueSet(theValidationSupportContext, theOptions, theValueSetUrl, theCodeSystemUrl, theCode, theDisplay);
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
        txTemplate.setPropagationBehavior(0);
        txTemplate.setReadOnly(true);
        Optional codeOpt = (Optional)txTemplate.execute(tx -> this.findCode(theCodeSystemUrl, theCode).map(c -> {
            String codeSystemVersionId = this.getCurrentCodeSystemVersion((String)theCodeSystemUrl).myCodeSystemVersionId;
            return new FhirVersionIndependentConcept(theCodeSystemUrl, c.getCode(), c.getDisplay(), codeSystemVersionId);
        }));
        if (codeOpt != null && codeOpt.isPresent()) {
            FhirVersionIndependentConcept code = (FhirVersionIndependentConcept)codeOpt.get();
            if (!theOptions.isValidateDisplay() || StringUtils.isBlank((CharSequence)code.getDisplay()) || StringUtils.isBlank((CharSequence)theDisplay) || code.getDisplay().equals(theDisplay)) {
                return new IValidationSupport.CodeValidationResult().setCode(code.getCode()).setDisplay(code.getDisplay());
            }
            return InMemoryTerminologyServerValidationSupport.createResultForDisplayMismatch((FhirContext)this.myContext, (String)theCode, (String)theDisplay, (String)code.getDisplay(), (String)code.getSystem(), (String)code.getSystemVersion(), (IValidationSupport.IssueSeverity)this.myStorageSettings.getIssueSeverityForCodeDisplayMismatch());
        }
        return this.createFailureCodeValidationResult(theCodeSystemUrl, theCode, null, TermReadSvcImpl.createMessageAppendForCodeNotFoundInCodeSystem(theCodeSystemUrl));
    }

    IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theValidationOptions, String theValueSetUrl, String theCodeSystem, String theCode, String theDisplay) {
        Long pid;
        IBaseResource valueSet = theValidationSupportContext.getRootValidationSupport().fetchValueSet(theValueSetUrl);
        IValidationSupport.CodeValidationResult retVal = null;
        if (valueSet instanceof IAnyResource && (pid = (Long)IDao.RESOURCE_PID.get((IBaseResource)((IAnyResource)valueSet))) != null) {
            TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
            retVal = (IValidationSupport.CodeValidationResult)txTemplate.execute(tx -> {
                if (this.isValueSetPreExpandedForCodeValidation(valueSet)) {
                    return this.validateCodeIsInPreExpandedValueSet(theValidationOptions, valueSet, theCodeSystem, theCode, theDisplay, null, null);
                }
                return null;
            });
        }
        if (retVal == null) {
            if (valueSet != null) {
                retVal = this.myInMemoryTerminologyServerValidationSupport.validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, valueSet);
            } else {
                String append = " - Unable to locate ValueSet[" + theValueSetUrl + "]";
                retVal = this.createFailureCodeValidationResult(theCodeSystem, theCode, null, append);
            }
        }
        if (retVal != null && retVal.getCode() == null && theCodeSystem != null && this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2) && this.isValueSetSupported(theValidationSupportContext, theCodeSystem) && !this.isCodeSystemSupported(theValidationSupportContext, theCodeSystem)) {
            String newMessage = "Unable to validate code " + theCodeSystem + "#" + theCode + " - Supplied system URL is a ValueSet URL and not a CodeSystem URL, check if it is correct: " + theCodeSystem;
            retVal.setMessage(newMessage);
        }
        return retVal;
    }

    @Override
    public CodeSystem fetchCanonicalCodeSystemFromCompleteContext(String theSystem) {
        IValidationSupport validationSupport = this.provideValidationSupport();
        IBaseResource codeSystem = validationSupport.fetchCodeSystem(theSystem);
        if (codeSystem != null) {
            codeSystem = this.myVersionCanonicalizer.codeSystemToCanonical(codeSystem);
        }
        return (CodeSystem)codeSystem;
    }

    @Nonnull
    private IValidationSupport provideJpaValidationSupport() {
        IValidationSupport jpaValidationSupport = this.myJpaValidationSupport;
        if (jpaValidationSupport == null) {
            this.myJpaValidationSupport = jpaValidationSupport = (IValidationSupport)this.myApplicationContext.getBean("myJpaValidationSupport", IValidationSupport.class);
        }
        return jpaValidationSupport;
    }

    @Nonnull
    protected IValidationSupport provideValidationSupport() {
        IValidationSupport validationSupport = this.myValidationSupport;
        if (validationSupport == null) {
            this.myValidationSupport = validationSupport = (IValidationSupport)this.myApplicationContext.getBean(IValidationSupport.class);
        }
        return validationSupport;
    }

    public org.hl7.fhir.r4.model.ValueSet fetchCanonicalValueSetFromCompleteContext(String theSystem) {
        IValidationSupport validationSupport = this.provideValidationSupport();
        IBaseResource valueSet = validationSupport.fetchValueSet(theSystem);
        if (valueSet != null) {
            valueSet = this.myVersionCanonicalizer.valueSetToCanonical(valueSet);
        }
        return (org.hl7.fhir.r4.model.ValueSet)valueSet;
    }

    public IBaseResource fetchValueSet(String theValueSetUrl) {
        return this.provideJpaValidationSupport().fetchValueSet(theValueSetUrl);
    }

    public FhirContext getFhirContext() {
        return this.myContext;
    }

    private void findCodesAbove(CodeSystem theSystem, String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        List conceptList = theSystem.getConcept();
        for (CodeSystem.ConceptDefinitionComponent next : conceptList) {
            this.addTreeIfItContainsCode(theSystemString, next, theCode, theListToPopulate);
        }
    }

    @Override
    public List<FhirVersionIndependentConcept> findCodesAboveUsingBuiltInSystems(String theSystem, String theCode) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        CodeSystem system = this.fetchCanonicalCodeSystemFromCompleteContext(theSystem);
        if (system != null) {
            this.findCodesAbove(system, theSystem, theCode, retVal);
        }
        return retVal;
    }

    private void findCodesBelow(CodeSystem theSystem, String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        List conceptList = theSystem.getConcept();
        this.findCodesBelow(theSystemString, theCode, theListToPopulate, conceptList);
    }

    private void findCodesBelow(String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate, List<CodeSystem.ConceptDefinitionComponent> conceptList) {
        for (CodeSystem.ConceptDefinitionComponent next : conceptList) {
            if (theCode.equals(next.getCode())) {
                this.addAllChildren(theSystemString, next, theListToPopulate);
                continue;
            }
            this.findCodesBelow(theSystemString, theCode, theListToPopulate, next.getConcept());
        }
    }

    @Override
    public List<FhirVersionIndependentConcept> findCodesBelowUsingBuiltInSystems(String theSystem, String theCode) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        CodeSystem system = this.fetchCanonicalCodeSystemFromCompleteContext(theSystem);
        if (system != null) {
            this.findCodesBelow(system, theSystem, theCode, retVal);
        }
        return retVal;
    }

    private void addAllChildren(String theSystemString, CodeSystem.ConceptDefinitionComponent theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        if (StringUtils.isNotBlank((CharSequence)theCode.getCode())) {
            theListToPopulate.add(new FhirVersionIndependentConcept(theSystemString, theCode.getCode()));
        }
        for (CodeSystem.ConceptDefinitionComponent nextChild : theCode.getConcept()) {
            this.addAllChildren(theSystemString, nextChild, theListToPopulate);
        }
    }

    private boolean addTreeIfItContainsCode(String theSystemString, CodeSystem.ConceptDefinitionComponent theNext, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        boolean foundCodeInChild = false;
        for (CodeSystem.ConceptDefinitionComponent nextChild : theNext.getConcept()) {
            foundCodeInChild |= this.addTreeIfItContainsCode(theSystemString, nextChild, theCode, theListToPopulate);
        }
        if (theCode.equals(theNext.getCode()) || foundCodeInChild) {
            theListToPopulate.add(new FhirVersionIndependentConcept(theSystemString, theNext.getCode()));
            return true;
        }
        return false;
    }

    @Nonnull
    private FhirVersionIndependentConcept toConcept(IPrimitiveType<String> theCodeType, IPrimitiveType<String> theCodeSystemIdentifierType, IBaseCoding theCodingType) {
        String systemVersion;
        String code = theCodeType != null ? theCodeType.getValueAsString() : null;
        String system = theCodeSystemIdentifierType != null ? this.getUrlFromIdentifier(theCodeSystemIdentifierType.getValueAsString()) : null;
        String string = systemVersion = theCodeSystemIdentifierType != null ? this.getVersionFromIdentifier(theCodeSystemIdentifierType.getValueAsString()) : null;
        if (theCodingType != null) {
            Coding canonicalizedCoding = this.myVersionCanonicalizer.codingToCanonical(theCodingType);
            assert (canonicalizedCoding != null);
            code = canonicalizedCoding.getCode();
            system = canonicalizedCoding.getSystem();
            systemVersion = canonicalizedCoding.getVersion();
        }
        return new FhirVersionIndependentConcept(system, code, null, systemVersion);
    }

    @Override
    public Optional<TermValueSet> findCurrentTermValueSet(String theUrl) {
        if (TermReadSvcUtil.isLoincUnversionedValueSet(theUrl)) {
            Optional<String> vsIdOpt = TermReadSvcUtil.getValueSetId(theUrl);
            if (vsIdOpt.isEmpty()) {
                return Optional.empty();
            }
            return this.myTermValueSetDao.findTermValueSetByForcedId(vsIdOpt.get());
        }
        List<TermValueSet> termValueSetList = this.myTermValueSetDao.findTermValueSetByUrl(Pageable.ofSize((int)1), theUrl);
        if (termValueSetList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(termValueSetList.get(0));
    }

    @Override
    public Optional<IBaseResource> readCodeSystemByForcedId(String theForcedId) {
        List resultList = this.myEntityManager.createQuery("select r from ResourceTable r where r.myResourceType = 'CodeSystem' and r.myFhirId = :fhirId").setParameter("fhirId", (Object)theForcedId).getResultList();
        if (resultList.isEmpty()) {
            return Optional.empty();
        }
        if (resultList.size() > 1) {
            throw new NonUniqueResultException(Msg.code((int)911) + "More than one CodeSystem is pointed by forcedId: " + theForcedId + ". Was constraint IDX_RES_TYPE_FHIR_ID removed?");
        }
        IFhirResourceDao csDao = this.myDaoRegistry.getResourceDao("CodeSystem");
        IBaseResource cs = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)resultList.get(0), false);
        return Optional.of(cs);
    }

    @Override
    @Transactional
    public ReindexTerminologyResult reindexTerminology() throws InterruptedException {
        if (this.myFulltextSearchSvc == null) {
            return ReindexTerminologyResult.SEARCH_SVC_DISABLED;
        }
        if (this.isBatchTerminologyTasksRunning()) {
            return ReindexTerminologyResult.OTHER_BATCH_TERMINOLOGY_TASKS_RUNNING;
        }
        this.myDeferredStorageSvc.setProcessDeferred(false);
        int objectLoadingThreadNumber = this.calculateObjectLoadingThreadNumber();
        ourLog.info("Using {} threads to load objects", (Object)objectLoadingThreadNumber);
        try {
            SearchSession searchSession = this.getSearchSession();
            searchSession.massIndexer(new Class[]{TermConcept.class}).dropAndCreateSchemaOnStart(true).purgeAllOnStart(false).batchSizeToLoadObjects(100).cacheMode(CacheMode.IGNORE).threadsToLoadObjects(6).transactionTimeout(3600).monitor((MassIndexingMonitor)new PojoMassIndexingLoggingMonitor(50000)).startAndWait();
        }
        finally {
            this.myDeferredStorageSvc.setProcessDeferred(true);
        }
        return ReindexTerminologyResult.SUCCESS;
    }

    @VisibleForTesting
    boolean isBatchTerminologyTasksRunning() {
        return this.isNotSafeToPreExpandValueSets() || this.isPreExpandingValueSets();
    }

    @VisibleForTesting
    int calculateObjectLoadingThreadNumber() {
        ConnectionPoolInfoProvider connectionPoolInfoProvider = new ConnectionPoolInfoProvider(this.myHibernatePropertiesProvider.getDataSource());
        Optional<Integer> maxConnectionsOpt = connectionPoolInfoProvider.getTotalConnectionSize();
        if (maxConnectionsOpt.isEmpty()) {
            return 2;
        }
        int maxConnections = maxConnectionsOpt.get();
        int usableThreads = maxConnections < 6 ? 1 : maxConnections - 5;
        int objectThreads = Math.min(usableThreads, 6);
        ourLog.debug("Data source connection pool has {} connections allocated, so reindexing will use {} object loading threads (each using a connection)", (Object)maxConnections, (Object)objectThreads);
        return objectThreads;
    }

    @VisibleForTesting
    SearchSession getSearchSession() {
        return Search.session((EntityManager)this.myEntityManager);
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        org.hl7.fhir.r4.model.ValueSet canonicalInput = this.myVersionCanonicalizer.valueSetToCanonical(theValueSetToExpand);
        org.hl7.fhir.r4.model.ValueSet expandedR4 = this.expandValueSet(theExpansionOptions, canonicalInput);
        return new IValidationSupport.ValueSetExpansionOutcome(this.myVersionCanonicalizer.valueSetFromCanonical(expandedR4));
    }

    @Override
    public IBaseResource expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theInput) {
        org.hl7.fhir.r4.model.ValueSet valueSetToExpand = this.myVersionCanonicalizer.valueSetToCanonical(theInput);
        org.hl7.fhir.r4.model.ValueSet valueSetR4 = this.expandValueSet(theExpansionOptions, valueSetToExpand);
        return this.myVersionCanonicalizer.valueSetFromCanonical(valueSetR4);
    }

    @Override
    public void expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator) {
        org.hl7.fhir.r4.model.ValueSet valueSetToExpand = this.myVersionCanonicalizer.valueSetToCanonical(theValueSetToExpand);
        this.expandValueSet(theExpansionOptions, valueSetToExpand, theValueSetCodeAccumulator);
    }

    private org.hl7.fhir.r4.model.ValueSet getValueSetFromResourceTable(ResourceTable theResourceTable) {
        Class type = this.getFhirContext().getResourceDefinition("ValueSet").getImplementingClass();
        Object valueSet = this.myJpaStorageResourceParser.toResource(type, (IBaseResourceEntity)theResourceTable, null, false);
        return this.myVersionCanonicalizer.valueSetToCanonical(valueSet);
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCodeIsInPreExpandedValueSet(ConceptValidationOptions theOptions, IBaseResource theValueSet, String theSystem, String theCode, String theDisplay, IBaseDatatype theCoding, IBaseDatatype theCodeableConcept) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSet, (String)"ValueSet must not be null", (Object[])new Object[0]);
        org.hl7.fhir.r4.model.ValueSet valueSetR4 = this.myVersionCanonicalizer.valueSetToCanonical(theValueSet);
        Coding codingR4 = this.myVersionCanonicalizer.codingToCanonical((IBaseCoding)theCoding);
        CodeableConcept codeableConcept = this.myVersionCanonicalizer.codeableConceptToCanonical(theCodeableConcept);
        return this.validateCodeIsInPreExpandedValueSet(theOptions, valueSetR4, theSystem, theCode, theDisplay, codingR4, codeableConcept);
    }

    @Override
    public boolean isValueSetPreExpandedForCodeValidation(IBaseResource theValueSet) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSet, (String)"ValueSet must not be null", (Object[])new Object[0]);
        org.hl7.fhir.r4.model.ValueSet valueSetR4 = this.myVersionCanonicalizer.valueSetToCanonical(theValueSet);
        return this.isValueSetPreExpandedForCodeValidation(valueSetR4);
    }

    static boolean isValueSetDisplayLanguageMatch(ValueSetExpansionOptions theExpansionOptions, String theStoredLang) {
        if (theExpansionOptions == null) {
            return true;
        }
        if (theExpansionOptions.getTheDisplayLanguage() == null || theStoredLang == null) {
            return true;
        }
        return theExpansionOptions.getTheDisplayLanguage().equalsIgnoreCase(theStoredLang);
    }

    @Nonnull
    private static String createMessageAppendForCodeNotFoundInCodeSystem(String theCodeSystemUrl) {
        return " - Code is not found in CodeSystem: " + theCodeSystemUrl;
    }

    @VisibleForTesting
    public static void setForceDisableHibernateSearchForUnitTest(boolean theForceDisableHibernateSearchForUnitTest) {
        ourForceDisableHibernateSearchForUnitTest = theForceDisableHibernateSearchForUnitTest;
    }

    static boolean isPlaceholder(DomainResource theResource) {
        boolean retVal = false;
        Extension extension = theResource.getExtensionByUrl("http://hapifhir.io/fhir/StructureDefinition/resource-placeholder");
        if (extension != null && extension.hasValue() && extension.getValue() instanceof BooleanType) {
            retVal = ((BooleanType)extension.getValue()).booleanValue();
        }
        return retVal;
    }

    static void invokeRunnableForUnitTest() {
        if (myInvokeOnNextCallForUnitTest != null) {
            Runnable invokeOnNextCallForUnitTest = myInvokeOnNextCallForUnitTest;
            myInvokeOnNextCallForUnitTest = null;
            invokeOnNextCallForUnitTest.run();
        }
    }

    @VisibleForTesting
    public static void setInvokeOnNextCallForUnitTest(Runnable theInvokeOnNextCallForUnitTest) {
        myInvokeOnNextCallForUnitTest = theInvokeOnNextCallForUnitTest;
    }

    static List<TermConcept> toPersistedConcepts(List<CodeSystem.ConceptDefinitionComponent> theConcept, TermCodeSystemVersion theCodeSystemVersion) {
        ArrayList<TermConcept> retVal = new ArrayList<TermConcept>();
        for (CodeSystem.ConceptDefinitionComponent next : theConcept) {
            if (!StringUtils.isNotBlank((CharSequence)next.getCode())) continue;
            TermConcept termConcept = TermReadSvcImpl.toTermConcept(next, theCodeSystemVersion);
            retVal.add(termConcept);
        }
        return retVal;
    }

    @Nonnull
    static TermConcept toTermConcept(CodeSystem.ConceptDefinitionComponent theConceptDefinition, TermCodeSystemVersion theCodeSystemVersion) {
        TermConcept termConcept = new TermConcept();
        termConcept.setCode(theConceptDefinition.getCode());
        termConcept.setCodeSystemVersion(theCodeSystemVersion);
        termConcept.setDisplay(theConceptDefinition.getDisplay());
        termConcept.addChildren(TermReadSvcImpl.toPersistedConcepts(theConceptDefinition.getConcept(), theCodeSystemVersion), TermConceptParentChildLink.RelationshipTypeEnum.ISA);
        for (CodeSystem.ConceptDefinitionDesignationComponent designationComponent : theConceptDefinition.getDesignation()) {
            if (!StringUtils.isNotBlank((CharSequence)designationComponent.getValue())) continue;
            TermConceptDesignation designation = termConcept.addDesignation();
            designation.setLanguage(designationComponent.hasLanguage() ? designationComponent.getLanguage() : null);
            if (designationComponent.hasUse()) {
                designation.setUseSystem(designationComponent.getUse().hasSystem() ? designationComponent.getUse().getSystem() : null);
                designation.setUseCode(designationComponent.getUse().hasCode() ? designationComponent.getUse().getCode() : null);
                designation.setUseDisplay(designationComponent.getUse().hasDisplay() ? designationComponent.getUse().getDisplay() : null);
            }
            designation.setValue(designationComponent.getValue());
        }
        for (CodeSystem.ConceptPropertyComponent next : theConceptDefinition.getProperty()) {
            TermConceptProperty property = new TermConceptProperty();
            property.setKey(next.getCode());
            property.setConcept(termConcept);
            property.setCodeSystemVersion(theCodeSystemVersion);
            if (next.getValue() instanceof StringType) {
                property.setType(TermConceptPropertyTypeEnum.STRING);
                property.setValue((String)next.getValueStringType().getValue());
            } else if (next.getValue() instanceof BooleanType) {
                property.setType(TermConceptPropertyTypeEnum.BOOLEAN);
                property.setValue(((BooleanType)next.getValue()).getValueAsString());
            } else if (next.getValue() instanceof IntegerType) {
                property.setType(TermConceptPropertyTypeEnum.INTEGER);
                property.setValue(((IntegerType)next.getValue()).getValueAsString());
            } else if (next.getValue() instanceof DecimalType) {
                property.setType(TermConceptPropertyTypeEnum.DECIMAL);
                property.setValue(((DecimalType)next.getValue()).getValueAsString());
            } else if (next.getValue() instanceof DateTimeType) {
                property.setType(TermConceptPropertyTypeEnum.DATETIME);
                property.setValue(((DateTimeType)next.getValue()).getValueAsString());
            } else if (next.getValue() instanceof Coding) {
                Coding nextCoding = next.getValueCoding();
                property.setType(TermConceptPropertyTypeEnum.CODING);
                property.setCodeSystem(nextCoding.getSystem());
                property.setValue(nextCoding.getCode());
                property.setDisplay(nextCoding.getDisplay());
            } else if (next.getValue() != null) {
                ourLog.warn("Don't know how to handle properties of type: " + next.getValue().getClass());
                continue;
            }
            termConcept.getProperties().add(property);
        }
        return termConcept;
    }

    static boolean isDisplayLanguageMatch(String theReqLang, String theStoredLang) {
        if (theReqLang == null || theStoredLang == null) {
            return true;
        }
        return theReqLang.equalsIgnoreCase(theStoredLang);
    }

    private static class TermCodeSystemVersionDetails {
        private final long myPid;
        private final String myCodeSystemVersionId;

        public TermCodeSystemVersionDetails(long thePid, String theCodeSystemVersionId) {
            this.myPid = thePid;
            this.myCodeSystemVersionId = theCodeSystemVersionId;
        }
    }

    private static final class SearchProperties {
        private List<Supplier<SearchScroll<EntityReference>>> mySearchScroll = new ArrayList<Supplier<SearchScroll<EntityReference>>>();
        private List<String> myIncludeOrExcludeCodes;

        private SearchProperties() {
        }

        public List<Supplier<SearchScroll<EntityReference>>> getSearchScroll() {
            return this.mySearchScroll;
        }

        public void addSearchScroll(Supplier<SearchScroll<EntityReference>> theSearchScrollSupplier) {
            this.mySearchScroll.add(theSearchScrollSupplier);
        }

        public List<String> getIncludeOrExcludeCodes() {
            return this.myIncludeOrExcludeCodes;
        }

        public void setIncludeOrExcludeCodes(List<String> theIncludeOrExcludeCodes) {
            this.myIncludeOrExcludeCodes = theIncludeOrExcludeCodes;
        }

        public boolean hasIncludeOrExcludeCodes() {
            return !this.myIncludeOrExcludeCodes.isEmpty();
        }
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private ITermReadSvc myTerminologySvc;

        public void execute(JobExecutionContext theContext) {
            this.myTerminologySvc.preExpandDeferredValueSetsToTerminologyTables();
        }
    }
}

