/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.api;

import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemDao;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemVersionDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDesignationDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptParentChildLinkDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptPropertyDao;
import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemDeleteJobSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.models.CodeSystemConceptsDeleteResult;
import com.fasterxml.jackson.databind.util.ArrayIterator;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TermCodeSystemDeleteJobSvc
implements ITermCodeSystemDeleteJobSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(TermCodeSystemDeleteJobSvc.class);
    private static final DecimalFormat ourDecimalFormat = new DecimalFormat("#,###");
    @Autowired
    private ITermConceptDao myConceptDao;
    @Autowired
    private ITermCodeSystemDao myCodeSystemDao;
    @Autowired
    private ITermCodeSystemVersionDao myTermCodeSystemVersionDao;
    @Autowired
    private ITermConceptParentChildLinkDao myConceptParentChildLinkDao;
    @Autowired
    private ITermConceptPropertyDao myConceptPropertyDao;
    @Autowired
    private ITermConceptDesignationDao myConceptDesignationDao;
    @Autowired
    private ITermCodeSystemDao myTermCodeSystemDao;
    @Autowired
    private ITermDeferredStorageSvc myDeferredStorageSvc;

    public Iterator<Long> getAllCodeSystemVersionForCodeSystemPid(long thePid) {
        List<Long> pids = this.myTermCodeSystemVersionDao.findSortedPidsByCodeSystemPid(thePid);
        if (pids == null) {
            return new ArrayIterator((Object[])new Long[0]);
        }
        return pids.iterator();
    }

    public CodeSystemConceptsDeleteResult deleteCodeSystemConceptsByCodeSystemVersionPid(long theCodeSystemVersionPid) {
        CodeSystemConceptsDeleteResult result = new CodeSystemConceptsDeleteResult();
        ourLog.info("Deleting term code links");
        int deletedLinks = this.myConceptParentChildLinkDao.deleteByCodeSystemVersion(theCodeSystemVersionPid);
        ourLog.info("Deleted {} term code links", (Object)ourDecimalFormat.format(deletedLinks));
        result.setDeletedLinks(deletedLinks);
        ourLog.info("Deleting term code properties");
        int deletedProperties = this.myConceptPropertyDao.deleteByCodeSystemVersion(theCodeSystemVersionPid);
        ourLog.info("Deleted {} term code properties", (Object)ourDecimalFormat.format(deletedProperties));
        result.setDeletedProperties(deletedProperties);
        ourLog.info("Deleting concept designations");
        int deletedDesignations = this.myConceptDesignationDao.deleteByCodeSystemVersion(theCodeSystemVersionPid);
        ourLog.info("Deleted {} concept designations", (Object)ourDecimalFormat.format(deletedDesignations));
        result.setDeletedDesignations(deletedDesignations);
        ourLog.info("Deleting concepts");
        int deletedConcepts = this.myConceptDao.deleteByCodeSystemVersion(theCodeSystemVersionPid);
        ourLog.info("Deleted {} concepts", (Object)ourDecimalFormat.format(deletedConcepts));
        result.setCodeSystemConceptDelete(deletedConcepts);
        return result;
    }

    public void deleteCodeSystemVersion(long theVersionPid) {
        ourLog.debug("Executing for codeSystemVersionId: {}", (Object)theVersionPid);
        Optional<TermCodeSystem> codeSystemOpt = this.myCodeSystemDao.findWithCodeSystemVersionAsCurrentVersion(theVersionPid);
        if (codeSystemOpt.isPresent()) {
            TermCodeSystem codeSystem = codeSystemOpt.get();
            ourLog.info("Removing code system version: {} as current version of code system: {}", (Object)theVersionPid, (Object)codeSystem.getPid());
            codeSystem.setCurrentVersion(null);
            this.myCodeSystemDao.save(codeSystem);
        }
        ourLog.info("Deleting code system version: {}", (Object)theVersionPid);
        Optional csv = this.myTermCodeSystemVersionDao.findById(theVersionPid);
        csv.ifPresent(theTermCodeSystemVersion -> {
            this.myTermCodeSystemVersionDao.delete(theTermCodeSystemVersion);
            ourLog.info("Code system version: {} deleted", (Object)theVersionPid);
        });
    }

    public void deleteCodeSystem(long thePid) {
        ourLog.info("Deleting code system by id : {}", (Object)thePid);
        Optional csop = this.myTermCodeSystemDao.findById(thePid);
        if (csop.isPresent()) {
            TermCodeSystem cs = (TermCodeSystem)csop.get();
            ourLog.info("Deleting code system {} / {}", (Object)thePid, (Object)cs.getCodeSystemUri());
            this.myTermCodeSystemDao.deleteById(thePid);
            ourLog.info("Code system {} deleted", (Object)thePid);
        }
    }

    public void notifyJobComplete(String theJobId) {
        this.myDeferredStorageSvc.notifyJobEnded(theJobId);
    }
}

