/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.BaseLoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoincDocumentOntologyHandler
extends BaseLoincHandler
implements IZipContentsHandlerCsv {
    private static final Logger ourLog = LoggerFactory.getLogger(LoincDocumentOntologyHandler.class);
    public static final String DOCUMENT_ONTOLOGY_CODES_VS_ID = "loinc-document-ontology";
    public static final String DOCUMENT_ONTOLOGY_CODES_VS_URI = "http://loinc.org/vs/loinc-document-ontology";
    public static final String DOCUMENT_ONTOLOGY_CODES_VS_NAME = "LOINC Document Ontology Codes";
    private final Map<String, TermConcept> myCode2Concept;

    public LoincDocumentOntologyHandler(Map<String, TermConcept> theCode2concept, Map<String, CodeSystem.PropertyType> thePropertyNames, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties, String theCopyrightStatement) {
        super(theCode2concept, theValueSets, theConceptMaps, theUploadProperties, theCopyrightStatement);
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String loincCodePropName;
        String loincNumber = StringUtils.trim((String)theRecord.get("LoincNumber"));
        String partNumber = StringUtils.trim((String)theRecord.get("PartNumber"));
        String partTypeName = StringUtils.trim((String)theRecord.get("PartTypeName"));
        String partSequenceOrder = StringUtils.trim((String)theRecord.get("PartSequenceOrder"));
        String partName = StringUtils.trim((String)theRecord.get("PartName"));
        String codeSystemVersionId = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        Object valueSetId = codeSystemVersionId != null ? "loinc-document-ontology-" + codeSystemVersionId : DOCUMENT_ONTOLOGY_CODES_VS_ID;
        ValueSet vs = this.getValueSet((String)valueSetId, DOCUMENT_ONTOLOGY_CODES_VS_URI, DOCUMENT_ONTOLOGY_CODES_VS_NAME, null);
        this.addCodeAsIncludeToValueSet(vs, "http://loinc.org", loincNumber, null);
        switch (partTypeName) {
            case "Document.Kind": {
                loincCodePropName = "document-kind";
                break;
            }
            case "Document.Role": {
                loincCodePropName = "document-role";
                break;
            }
            case "Document.Setting": {
                loincCodePropName = "document-setting";
                break;
            }
            case "Document.SubjectMatterDomain": {
                loincCodePropName = "document-subject-matter-domain";
                break;
            }
            case "Document.TypeOfService": {
                loincCodePropName = "document-type-of-service";
                break;
            }
            default: {
                throw new InternalErrorException(Msg.code((int)917) + "Unknown PartTypeName: " + partTypeName);
            }
        }
        TermConcept code = this.myCode2Concept.get(loincNumber);
        if (code != null) {
            code.addPropertyCoding(loincCodePropName, "http://loinc.org", partNumber, partName);
            ourLog.debug("Adding coding property: {} to concept.code {}", (Object)loincCodePropName, (Object)partNumber);
        }
    }
}

