/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchInclude;
import ca.uhn.fhir.jpa.entity.SearchTypeEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableBidiMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParameterUtils {
    private static final Logger ourLog = LoggerFactory.getLogger(QueryParameterUtils.class);
    public static final int DEFAULT_SYNC_SIZE = 250;
    private static final BidiMap<SearchFilterParser.CompareOperation, ParamPrefixEnum> ourCompareOperationToParamPrefix;
    public static final Condition[] EMPTY_CONDITION_ARRAY;

    @Nullable
    public static Condition toAndPredicate(List<Condition> theAndPredicates) {
        List<Condition> andPredicates = theAndPredicates.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (andPredicates.size() == 0) {
            return null;
        }
        if (andPredicates.size() == 1) {
            return (Condition)andPredicates.get(0);
        }
        return ComboCondition.and((Condition[])andPredicates.toArray(EMPTY_CONDITION_ARRAY));
    }

    @Nullable
    public static Condition toOrPredicate(List<Condition> theOrPredicates) {
        List<Condition> orPredicates = theOrPredicates.stream().filter(t -> t != null).collect(Collectors.toList());
        if (orPredicates.size() == 0) {
            return null;
        }
        if (orPredicates.size() == 1) {
            return (Condition)orPredicates.get(0);
        }
        return ComboCondition.or((Condition[])orPredicates.toArray(EMPTY_CONDITION_ARRAY));
    }

    @Nullable
    public static Condition toOrPredicate(Condition ... theOrPredicates) {
        return QueryParameterUtils.toOrPredicate(Arrays.asList(theOrPredicates));
    }

    @Nullable
    public static Condition toAndPredicate(Condition ... theAndPredicates) {
        return QueryParameterUtils.toAndPredicate(Arrays.asList(theAndPredicates));
    }

    @Nonnull
    public static Condition toEqualToOrInPredicate(DbColumn theColumn, List<String> theValuePlaceholders, boolean theInverse) {
        if (theInverse) {
            return QueryParameterUtils.toNotEqualToOrNotInPredicate(theColumn, theValuePlaceholders);
        }
        return QueryParameterUtils.toEqualToOrInPredicate(theColumn, theValuePlaceholders);
    }

    @Nonnull
    public static Condition toEqualToOrInPredicate(DbColumn theColumn, List<String> theValuePlaceholders) {
        if (theValuePlaceholders.size() == 1) {
            return BinaryCondition.equalTo((Object)theColumn, (Object)theValuePlaceholders.get(0));
        }
        return new InCondition((Object)theColumn, theValuePlaceholders);
    }

    @Nonnull
    public static Condition toNotEqualToOrNotInPredicate(DbColumn theColumn, List<String> theValuePlaceholders) {
        if (theValuePlaceholders.size() == 1) {
            return BinaryCondition.notEqualTo((Object)theColumn, (Object)theValuePlaceholders.get(0));
        }
        return new InCondition((Object)theColumn, theValuePlaceholders).setNegate(true);
    }

    public static SearchFilterParser.CompareOperation toOperation(ParamPrefixEnum thePrefix) {
        SearchFilterParser.CompareOperation retVal = null;
        if (thePrefix != null && ourCompareOperationToParamPrefix.containsValue((Object)thePrefix)) {
            retVal = (SearchFilterParser.CompareOperation)((Object)ourCompareOperationToParamPrefix.getKey((Object)thePrefix));
        }
        return (SearchFilterParser.CompareOperation)((Object)ObjectUtils.defaultIfNull(retVal, (Object)((Object)SearchFilterParser.CompareOperation.eq)));
    }

    public static ParamPrefixEnum fromOperation(SearchFilterParser.CompareOperation thePrefix) {
        ParamPrefixEnum retVal = null;
        if (thePrefix != null && ourCompareOperationToParamPrefix.containsKey((Object)thePrefix)) {
            retVal = (ParamPrefixEnum)ourCompareOperationToParamPrefix.get((Object)thePrefix);
        }
        return (ParamPrefixEnum)ObjectUtils.defaultIfNull(retVal, (Object)ParamPrefixEnum.EQUAL);
    }

    public static String getChainedPart(String parameter) {
        return parameter.substring(parameter.indexOf(".") + 1);
    }

    public static String getParamNameWithPrefix(String theSpnamePrefix, String theParamName) {
        if (StringUtils.isBlank((CharSequence)theSpnamePrefix)) {
            return theParamName;
        }
        return theSpnamePrefix + "." + theParamName;
    }

    public static Predicate[] toPredicateArray(List<Predicate> thePredicates) {
        return thePredicates.toArray(new Predicate[0]);
    }

    private static List<Predicate> createLastUpdatedPredicates(DateRangeParam theLastUpdated, CriteriaBuilder builder, From<?, ResourceTable> from) {
        ArrayList<Predicate> lastUpdatedPredicates = new ArrayList<Predicate>();
        if (theLastUpdated != null) {
            if (theLastUpdated.getLowerBoundAsInstant() != null) {
                ourLog.debug("LastUpdated lower bound: {}", (Object)new InstantDt(theLastUpdated.getLowerBoundAsInstant()));
                Predicate predicateLower = builder.greaterThanOrEqualTo((Expression)from.get("myUpdated"), (Comparable)theLastUpdated.getLowerBoundAsInstant());
                lastUpdatedPredicates.add(predicateLower);
            }
            if (theLastUpdated.getUpperBoundAsInstant() != null) {
                Predicate predicateUpper = builder.lessThanOrEqualTo((Expression)from.get("myUpdated"), (Comparable)theLastUpdated.getUpperBoundAsInstant());
                lastUpdatedPredicates.add(predicateUpper);
            }
        }
        return lastUpdatedPredicates;
    }

    public static void verifySearchHasntFailedOrThrowInternalErrorException(Search theSearch) {
        if (theSearch.getStatus() == SearchStatusEnum.FAILED) {
            Integer status = theSearch.getFailureCode();
            status = (Integer)ObjectUtils.defaultIfNull((Object)status, (Object)500);
            String message = theSearch.getFailureMessage();
            throw BaseServerResponseException.newInstance((int)status, (String)message);
        }
    }

    public static void populateSearchEntity(SearchParameterMap theParams, String theResourceType, String theSearchUuid, String theQueryString, Search theSearch, RequestPartitionId theRequestPartitionId) {
        theSearch.setDeleted(false);
        theSearch.setUuid(theSearchUuid);
        theSearch.setCreated(new Date());
        theSearch.setTotalCount(null);
        theSearch.setNumFound(0);
        theSearch.setPreferredPageSize(theParams.getCount());
        theSearch.setSearchType(theParams.getEverythingMode() != null ? SearchTypeEnum.EVERYTHING : SearchTypeEnum.SEARCH);
        theSearch.setLastUpdated(theParams.getLastUpdated());
        theSearch.setResourceType(theResourceType);
        theSearch.setStatus(SearchStatusEnum.LOADING);
        theSearch.setSearchQueryString(theQueryString, theRequestPartitionId);
        if (theParams.hasIncludes()) {
            for (Include next : theParams.getIncludes()) {
                theSearch.addInclude(new SearchInclude(theSearch, next.getValue(), false, next.isRecurse()));
            }
        }
        for (Include next : theParams.getRevIncludes()) {
            theSearch.addInclude(new SearchInclude(theSearch, next.getValue(), true, next.isRecurse()));
        }
    }

    static {
        EMPTY_CONDITION_ARRAY = new Condition[0];
        DualHashBidiMap compareOperationToParamPrefix = new DualHashBidiMap();
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ap, (Object)ParamPrefixEnum.APPROXIMATE);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.eq, (Object)ParamPrefixEnum.EQUAL);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.gt, (Object)ParamPrefixEnum.GREATERTHAN);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ge, (Object)ParamPrefixEnum.GREATERTHAN_OR_EQUALS);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.lt, (Object)ParamPrefixEnum.LESSTHAN);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.le, (Object)ParamPrefixEnum.LESSTHAN_OR_EQUALS);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ne, (Object)ParamPrefixEnum.NOT_EQUAL);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.eb, (Object)ParamPrefixEnum.ENDS_BEFORE);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.sa, (Object)ParamPrefixEnum.STARTS_AFTER);
        ourCompareOperationToParamPrefix = UnmodifiableBidiMap.unmodifiableBidiMap((BidiMap)compareOperationToParamPrefix);
    }
}

